/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.metadata.parse;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.RuleSet;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.vocabulary.MetadataType;
import org.gbif.registry.metadata.parse.DatasetWrapper;
import org.gbif.registry.metadata.parse.DublinCoreRuleSet;
import org.gbif.registry.metadata.parse.EMLRuleSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DatasetParser {
    private static final Logger LOG = LoggerFactory.getLogger(DatasetParser.class);

    public static MetadataType detectParserType(InputStream xml) {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            ParserDetectionHandler handler = new ParserDetectionHandler();
            xmlReader.setContentHandler(handler);
            InputSource inputSource = new InputSource(xml);
            xmlReader.parse(inputSource);
            if (handler.parserType != null) {
                return handler.parserType;
            }
        }
        catch (SAXException e) {
            LOG.error("Failed to SAX parse a document for parser type detection", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("Failed to read metadata document for parser type detection", (Throwable)e);
        }
        throw new IllegalArgumentException("No parser found for this metadata document. Only EML or DC supported");
    }

    public static Dataset build(InputStream xml) throws IOException {
        byte[] data = ByteStreams.toByteArray(xml);
        return DatasetParser.parse(DatasetParser.detectParserType(new ByteArrayInputStream(data)), new ByteArrayInputStream(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset parse(MetadataType type, InputStream xml) throws IOException {
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        switch (type) {
            case EML: {
                LOG.debug("Parsing EML document");
                digester.addRuleSet((RuleSet)new EMLRuleSet());
                break;
            }
            case DC: {
                LOG.debug("Parsing DC document");
                digester.addRuleSet((RuleSet)new DublinCoreRuleSet());
            }
        }
        DatasetWrapper delegator = new DatasetWrapper();
        digester.push((Object)delegator);
        try {
            digester.parse(xml);
        }
        catch (ConversionException conversionException) {
        }
        catch (SAXException e) {
            if (e.getException() == null || !e.getException().getClass().equals(ConversionException.class)) {
                throw new IllegalArgumentException("Invalid metadata xml document", e);
            }
        }
        finally {
            delegator.postProcess();
            Closeables.closeQuietly(xml);
        }
        return delegator.getTarget();
    }

    private static class ParserDetectionHandler
    extends DefaultHandler {
        private static final String DC_NAMESPACE = "http://purl.org/dc/terms/";
        private MetadataType parserType;
        private LinkedList<String> path = Lists.newLinkedList();

        private ParserDetectionHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.path.size() == 1 && this.path.get(0).equals("eml") && localName.equals("dataset")) {
                this.parserType = MetadataType.EML;
            }
            if (this.parserType == null && DC_NAMESPACE.equals(uri)) {
                this.parserType = MetadataType.DC;
            }
            this.path.add(localName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String last = this.path.removeLast();
            if (!last.equals(localName)) {
                LOG.warn("XML path broken. Got {} but path stack gave {}", (Object)localName, (Object)last);
            }
        }
    }
}

