/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class TaxonNameSoundEx {
    private static String translate(String source, String transSource, String transTarget) {
        String result = source;
        while (transSource.length() > transTarget.length()) {
            transTarget = transTarget + " ";
        }
        for (int i = 0; i < transSource.length(); ++i) {
            result = result.replace(transSource.charAt(i), transTarget.charAt(i));
        }
        return result;
    }

    public static String normalize(String str) {
        if (str == null) {
            return null;
        }
        String output = str;
        output = output.replace(" cf ", " ");
        output = output.replace(" cf. ", " ");
        output = output.replace(" near ", " ");
        output = output.replace(" aff. ", " ");
        output = output.replace(" sp.", " ");
        output = output.replace(" spp.", " ");
        output = output.replace(" spp ", " ");
        output = str.toUpperCase();
        output = output.replace(" &AMP; ", " & ");
        output = output.replaceAll("\\<.+?\\>", "");
        output = TaxonNameSoundEx.translate(output, "\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c4\u00cb\u00cf\u00d6\u00dc\u00c3\u00d1\u00d5\u00c5\u00c7\u00d8", "AEIOUAEIOUAEIOUAEIOUANOACO");
        output = output.replace("\u00c6", "AE");
        output = output.replaceAll("[^a-zA-Z .]", "");
        output = StringUtils.trimToNull((String)output);
        return output;
    }

    public static String treatWord(String str2, String wordType) {
        String temp = TaxonNameSoundEx.normalize(str2);
        if (StringUtils.isNotEmpty((CharSequence)temp)) {
            if (temp.startsWith("AE")) {
                temp = "E" + temp.substring(2);
            } else if (temp.startsWith("CN")) {
                temp = "N" + temp.substring(2);
            } else if (temp.startsWith("CT")) {
                temp = "T" + temp.substring(2);
            } else if (temp.startsWith("CZ")) {
                temp = "C" + temp.substring(2);
            } else if (temp.startsWith("DJ")) {
                temp = "J" + temp.substring(2);
            } else if (temp.startsWith("EA")) {
                temp = "E" + temp.substring(2);
            } else if (temp.startsWith("EU")) {
                temp = "U" + temp.substring(2);
            } else if (temp.startsWith("GN")) {
                temp = "N" + temp.substring(2);
            } else if (temp.startsWith("KN")) {
                temp = "N" + temp.substring(2);
            } else if (temp.startsWith("MC")) {
                temp = "MAC" + temp.substring(2);
            } else if (temp.startsWith("MN")) {
                temp = "N" + temp.substring(2);
            } else if (temp.startsWith("OE")) {
                temp = "E" + temp.substring(2);
            } else if (temp.startsWith("QU")) {
                temp = "Q" + temp.substring(2);
            } else if (temp.startsWith("PS")) {
                temp = "S" + temp.substring(2);
            } else if (temp.startsWith("PT")) {
                temp = "T" + temp.substring(2);
            } else if (temp.startsWith("TS")) {
                temp = "S" + temp.substring(2);
            } else if (temp.startsWith("WR")) {
                temp = "R" + temp.substring(2);
            } else if (temp.startsWith("X")) {
                temp = "Z" + temp.substring(2);
            }
            char startLetter = temp.charAt(0);
            temp = temp.substring(1);
            temp = temp.replaceAll("AE", "I");
            temp = temp.replaceAll("IA", "A");
            temp = temp.replaceAll("OE", "I");
            temp = temp.replaceAll("OI", "A");
            temp = temp.replaceAll("SC", "S");
            temp = temp.replaceAll("E", "I");
            temp = temp.replaceAll("O", "A");
            temp = temp.replaceAll("U", "I");
            temp = temp.replaceAll("Y", "I");
            temp = temp.replaceAll("K", "C");
            temp = temp.replaceAll("Z", "C");
            temp = temp.replaceAll("H", "");
            temp = startLetter + temp;
            temp = temp.replaceAll("(\\w)\\1+", "$1");
            if (wordType == "species") {
                if (temp.endsWith("IS")) {
                    temp = temp.substring(0, temp.length() - 2) + "A";
                } else if (temp.endsWith("IM")) {
                    temp = temp.substring(0, temp.length() - 2) + "A";
                } else if (temp.endsWith("AS")) {
                    temp = temp.substring(0, temp.length() - 2) + "A";
                }
            }
        }
        return temp;
    }

    public String soundEx(String source) {
        String temp = source.toUpperCase();
        temp = this.selectiveReplaceFirstChar(temp);
        temp = this.selectiveReplaceWithoutFirstChar(temp);
        temp = this.removeRepeatedChars(temp);
        temp = this.alphabetiseWordsIgnoringFirstLetter(temp);
        return temp;
    }

    String alphabetiseWordsIgnoringFirstLetter(String source) {
        StringTokenizer st = new StringTokenizer(source, " ");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            char[] chars = token.toCharArray();
            LinkedList<Character> charList = new LinkedList<Character>();
            for (int i = 1; i < chars.length; ++i) {
                charList.add(Character.valueOf(chars[i]));
            }
            Collections.sort(charList);
            sb.append(chars[0]);
            for (Character c : charList) {
                sb.append(c);
            }
            if (!st.hasMoreTokens()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    String removeRepeatedChars(String source) {
        StringBuffer sb = new StringBuffer();
        char c = ' ';
        for (int i = 0; i < source.length(); ++i) {
            char sourceC = source.charAt(i);
            if (sourceC != c) {
                sb.append(sourceC);
            }
            c = sourceC;
        }
        return sb.toString();
    }

    String selectiveReplaceWithoutFirstChar(String source) {
        if (source.length() > 1) {
            String temp = source.substring(1);
            temp = temp.replaceAll("AE", "I");
            temp = temp.replaceAll("IA", "A");
            temp = temp.replaceAll("OE", "I");
            temp = temp.replaceAll("OI", "A");
            temp = temp.replaceAll("MC", "MAC");
            temp = temp.replaceAll("SC", "S");
            temp = temp.replaceAll("EOUYKZH", "IAIICS");
            return source.substring(0, 1) + temp;
        }
        return source;
    }

    String selectiveReplaceFirstChar(String source) {
        if (source.startsWith("\u00c6")) {
            return source.replaceFirst("\u00c6", "E");
        }
        if (source.startsWith("AE")) {
            return source.replaceFirst("AE", "E");
        }
        if (source.startsWith("CN")) {
            return source.replaceFirst("CN", "N");
        }
        if (source.startsWith("CT")) {
            return source.replaceFirst("CT", "T");
        }
        if (source.startsWith("CZ")) {
            return source.replaceFirst("CZ", "C");
        }
        if (source.startsWith("DJ")) {
            return source.replaceFirst("DJ", "J");
        }
        if (source.startsWith("EA")) {
            return source.replaceFirst("EA", "E");
        }
        if (source.startsWith("EU")) {
            return source.replaceFirst("EU", "U");
        }
        if (source.startsWith("GN")) {
            return source.replaceFirst("GN", "N");
        }
        if (source.startsWith("KN")) {
            return source.replaceFirst("KN", "N");
        }
        if (source.startsWith("MN")) {
            return source.replaceFirst("MN", "N");
        }
        if (source.startsWith("OE")) {
            return source.replaceFirst("OE", "E");
        }
        if (source.startsWith("QU")) {
            return source.replaceFirst("QU", "Q");
        }
        if (source.startsWith("PS")) {
            return source.replaceFirst("PS", "S");
        }
        if (source.startsWith("PT")) {
            return source.replaceFirst("PT", "T");
        }
        if (source.startsWith("TS")) {
            return source.replaceFirst("TS", "S");
        }
        if (source.startsWith("X")) {
            return source.replaceFirst("X", "Z");
        }
        return source;
    }
}

