/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.search;

import au.org.ala.names.search.FieldType;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;

public enum NameIndexField {
    ID("id", FieldType.IDENTIFIER),
    GUID("guid", FieldType.IDENTIFIER),
    OTHER_GUID("otherGuid", FieldType.IDENTIFIER),
    LEFT("left", FieldType.INTEGER),
    RIGHT("right", FieldType.INTEGER),
    LSID("lsid", FieldType.IDENTIFIER),
    REAL_LSID("reallsid", FieldType.STORE),
    PARENT_ID("parent_id", FieldType.IDENTIFIER),
    DOCUMENT_TYPE("doctype", FieldType.IDENTIFIER),
    ACCEPTED("accepted_lsid", FieldType.IDENTIFIER),
    iS_SYNONYM("is_synonym", FieldType.IDENTIFIER),
    KINGDOM("kingdom", FieldType.TERM),
    KINGDOM_ID("kid", FieldType.STORE),
    PHYLUM("phylum", FieldType.TERM),
    PHYLUM_ID("pid", FieldType.STORE),
    CLASS("class", FieldType.TERM),
    CLASS_ID("cid", FieldType.STORE),
    ORDER("order", FieldType.TERM),
    ORDER_ID("oid", FieldType.STORE),
    FAMILY("family", FieldType.TERM),
    FAMILY_ID("fid", FieldType.STORE),
    GENUS("genus", FieldType.TERM),
    GENUS_ID("gid", FieldType.STORE),
    GENUS_EX("genus_ex", FieldType.TERM),
    SPECIES("species", FieldType.TERM),
    SPECIES_ID("sid", FieldType.STORE),
    SPECIES_EX("specific_ex", FieldType.TERM),
    INFRA_EX("infra_ex", FieldType.TERM),
    SPECIFIC("specific", FieldType.TERM),
    INFRA_SPECIFIC("infra", FieldType.TERM),
    NAME("name", FieldType.TEXT),
    OTHER_NAMES("other_names", FieldType.TEXT),
    NAME_CANONICAL("name_canonical", FieldType.TEXT),
    NAME_COMPLETE("name_complete", FieldType.TEXT),
    SEARCHABLE_COMMON_NAME("common", FieldType.COMMON),
    COMMON_NAME("common_orig", FieldType.TEXT),
    CONCAT_NAME("concat_name", FieldType.TERM),
    RANK_ID("rank_id", FieldType.INTEGER),
    RANK("rank", FieldType.TERM),
    AUTHOR("author", FieldType.TEXT),
    PHRASE("phrase", FieldType.TEXT),
    VOUCHER("voucher", FieldType.TEXT),
    ALA("ala", FieldType.IDENTIFIER),
    DATASET_ID("dataset_id", FieldType.IDENTIFIER),
    SYNONYM_TYPE("syn_type", FieldType.IDENTIFIER),
    HOMONYM("homonym", FieldType.IDENTIFIER),
    LANGUAGE("lang", FieldType.IDENTIFIER),
    PRIORITY("priority", FieldType.INTEGER);

    String name;
    FieldType type;

    private NameIndexField(String name, FieldType type) {
        this.name = name;
        this.type = type;
    }

    public String toString() {
        return this.name;
    }

    public <T> void store(T value, Document document) {
        if (value == null) {
            return;
        }
        this.type.store(value, this.name, document);
    }

    public <T> Query search(T value) {
        return this.type.search(value, this.name);
    }

    public <T> Query searchRange(T lower, T upper) {
        return this.type.searchRange(lower, upper, this.name);
    }

    public Query searchWildcard(String value) {
        return new WildcardQuery(new Term(this.name, value));
    }
}

