/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.search;

import au.org.ala.names.lucene.analyzer.LowerCaseKeywordAnalyzer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;

public abstract class FieldType<T> {
    protected static final ThreadLocal<Analyzer> ANALYZER = ThreadLocal.withInitial(() -> LowerCaseKeywordAnalyzer.newInstance());
    protected static final ThreadLocal<QueryBuilder> QUERY_BUILDER = ThreadLocal.withInitial(() -> new QueryBuilder(ANALYZER.get()));
    protected static final ThreadLocal<org.apache.lucene.document.FieldType> TERM_FIELD_TYPE = ThreadLocal.withInitial(() -> {
        org.apache.lucene.document.FieldType ft = new org.apache.lucene.document.FieldType((IndexableFieldType)TextField.TYPE_STORED);
        ft.setOmitNorms(true);
        return ft;
    });
    private Class<T> class_;
    private String name;
    public static final FieldType<String> STORE = new FieldType<String>(String.class, "store"){

        @Override
        public void store(String value, String name, Document document) {
            document.add((IndexableField)new StoredField(name, value));
        }

        @Override
        public Query search(String value, String name) {
            throw new UnsupportedOperationException("Store-only field");
        }
    };
    public static final FieldType<String> IDENTIFIER = new FieldType<String>(String.class, "identifier"){

        @Override
        public void store(String value, String name, Document document) {
            document.add((IndexableField)new StringField(name, value, Field.Store.YES));
        }

        @Override
        public Query search(String value, String name) {
            return new TermQuery(new Term(name, value));
        }
    };
    public static final FieldType<String> TERM = new FieldType<String>(String.class, "term"){

        @Override
        public void store(String value, String name, Document document) {
            Field field = new Field(name, (CharSequence)value, (IndexableFieldType)TERM_FIELD_TYPE.get());
            document.add((IndexableField)field);
        }

        @Override
        public Query search(String value, String name) {
            return ((QueryBuilder)QUERY_BUILDER.get()).createPhraseQuery(name, value);
        }
    };
    public static final FieldType<String> TEXT = new FieldType<String>(String.class, "text"){

        @Override
        public void store(String value, String name, Document document) {
            document.add((IndexableField)new TextField(name, value, Field.Store.YES));
        }

        @Override
        public Query search(String value, String name) {
            return ((QueryBuilder)QUERY_BUILDER.get()).createPhraseQuery(name, value);
        }
    };
    public static final FieldType<String> COMMON = new FieldType<String>(String.class, "common"){

        @Override
        public void store(String value, String name, Document document) {
            value = value.toUpperCase().replaceAll("[^A-Z0-9\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152]", "");
            document.add((IndexableField)new StringField(name, value, Field.Store.YES));
        }

        @Override
        public Query search(String value, String name) {
            value = value.toUpperCase().replaceAll("[^A-Z0-9\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152]", "");
            return new TermQuery(new Term(name, value));
        }
    };
    public static final FieldType<Integer> INTEGER = new FieldType<Integer>(Integer.class, "integer"){

        @Override
        public void store(Integer value, String name, Document document) {
            document.add((IndexableField)new IntPoint(name, new int[]{value}));
            document.add((IndexableField)new StoredField(name, value.intValue()));
        }

        @Override
        public Query search(Integer value, String name) {
            return IntPoint.newExactQuery((String)name, (int)value);
        }

        @Override
        public Query searchRange(Integer lower, Integer upper, String name) {
            return IntPoint.newRangeQuery((String)name, (int)lower, (int)upper);
        }
    };
    public static final FieldType<Double> DOUBLE = new FieldType<Double>(Double.class, "double"){

        @Override
        public void store(Double value, String name, Document document) {
            document.add((IndexableField)new DoublePoint(name, new double[]{value}));
            document.add((IndexableField)new StoredField(name, value.doubleValue()));
        }

        @Override
        public Query search(Double value, String name) {
            return DoublePoint.newExactQuery((String)name, (double)value);
        }

        @Override
        public Query searchRange(Double lower, Double upper, String name) {
            return DoublePoint.newRangeQuery((String)name, (double)lower, (double)upper);
        }
    };

    public FieldType(Class<T> class_, String name) {
        this.class_ = class_;
        this.name = name;
    }

    public abstract void store(T var1, String var2, Document var3);

    public abstract Query search(T var1, String var2);

    public Query searchRange(T lower, T upper, String name) {
        throw new UnsupportedOperationException("Field type " + this.name + " does not support ranges");
    }
}

