/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.search;

import au.org.ala.names.model.ALAParsedName;
import au.org.ala.names.model.ErrorType;
import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.MatchType;
import au.org.ala.names.model.MetricsResultDTO;
import au.org.ala.names.model.NameSearchResult;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.SynonymType;
import au.org.ala.names.search.ExcludedNameException;
import au.org.ala.names.search.HomonymException;
import au.org.ala.names.search.MisappliedException;
import au.org.ala.names.search.NameIndexField;
import au.org.ala.names.search.ParentSynonymChildException;
import au.org.ala.names.search.SPPException;
import au.org.ala.names.search.SearchResultException;
import au.org.ala.names.util.CleanedScientificName;
import au.org.ala.names.util.FileUtils;
import au.org.ala.names.util.TaxonNameSoundEx;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.gbif.api.exception.UnparsableException;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.Rank;
import org.gbif.nameparser.PhraseNameParser;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Levenshtein;
import uk.ac.shef.wit.simmetrics.similaritymetrics.SmithWatermanGotoh;

public class ALANameSearcher {
    public static float MATCH_LIMIT = 0.5f;
    protected Log log = LogFactory.getLog(ALANameSearcher.class);
    protected DirectoryReader cbReader;
    protected DirectoryReader irmngReader;
    protected DirectoryReader vernReader;
    protected IndexSearcher cbSearcher;
    protected IndexSearcher irmngSearcher;
    protected IndexSearcher vernSearcher;
    protected IndexSearcher idSearcher;
    protected TaxonNameSoundEx tnse;
    protected PhraseNameParser parser;
    public static final Pattern virusStopPattern = Pattern.compile(" virus| ictv| ICTV");
    public static final Pattern voucherRemovePattern = Pattern.compile(" |,|&|\\.");
    public static final Pattern affPattern = Pattern.compile("([\\x00-\\x7F\\s]*) aff[#!?\\\\. ]([\\x00-\\x7F\\s]*)");
    public static final Pattern cfPattern = Pattern.compile("([\\x00-\\x7F\\s]*) cf[#!?\\\\. ]([\\x00-\\x7F\\s]*)");
    public static final Pattern RANK_PATTERN = Pattern.compile("(?i:" + Arrays.stream(Rank.values()).map(Enum::name).collect(Collectors.joining("|")) + ")");
    private static Comparator<Map> AUTOCOMPLETE_COMPARATOR = new Comparator<Map>(){

        @Override
        public int compare(Map o1, Map o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return Integer.MAX_VALUE;
            }
            if (o2 == null) {
                return Integer.MIN_VALUE;
            }
            float score1 = o1.getOrDefault("score", Float.valueOf(1.0f)).floatValue();
            float score2 = o2.getOrDefault("score", Float.valueOf(1.0f)).floatValue();
            return -Float.compare(score1, score2);
        }
    };
    public static final Query PREFER_ACCEPTED = new BoostQuery(NameIndexField.iS_SYNONYM.search("F"), 20.0f);
    private Set crossRankHomonyms;

    public ALANameSearcher() {
    }

    public ALANameSearcher(String indexDirectory) throws IOException {
        this.log.debug((Object)"Creating the search object for the name matching api...");
        this.cbReader = DirectoryReader.open((Directory)FSDirectory.open((Path)this.findPath(indexDirectory + File.separator + "cb")));
        this.cbSearcher = new IndexSearcher((IndexReader)this.cbReader);
        this.irmngReader = DirectoryReader.open((Directory)FSDirectory.open((Path)this.findPath(indexDirectory + File.separator + "irmng")));
        this.irmngSearcher = new IndexSearcher((IndexReader)this.irmngReader);
        this.vernReader = DirectoryReader.open((Directory)FSDirectory.open((Path)this.findPath(indexDirectory + File.separator + "vernacular")));
        this.vernSearcher = new IndexSearcher((IndexReader)this.vernReader);
        this.idSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)FSDirectory.open((Path)this.findPath(indexDirectory + File.separator + "id"))));
        this.tnse = new TaxonNameSoundEx();
        this.parser = new PhraseNameParser();
        this.crossRankHomonyms = FileUtils.streamToSet(this.getClass().getClassLoader().getResourceAsStream("au/org/ala/homonyms/cross_rank_homonyms.txt"), new HashSet<String>(), true);
    }

    private Path findPath(String indexDirectory) throws IOException {
        File idxFile = new File(indexDirectory);
        if (!idxFile.exists()) {
            throw new FileNotFoundException(idxFile.toString());
        }
        Path path = Paths.get(indexDirectory, new String[0]);
        return path;
    }

    public void dumpSpecies() {
        try {
            OutputStreamWriter fileOut = new OutputStreamWriter((OutputStream)new FileOutputStream("/data/species.txt"), "UTF-8");
            TopDocs hits = this.cbSearcher.search(NameIndexField.RANK.search("species"), 2000000);
            for (ScoreDoc sdoc : hits.scoreDocs) {
                Document doc = this.cbReader.document(sdoc.doc);
                if (doc.getField("synonym") != null) continue;
                String lsid = StringUtils.trimToNull((String)doc.getField("lsid").stringValue());
                if (lsid == null) {
                    lsid = doc.getField("id").stringValue();
                }
                fileOut.write(lsid + "\n");
            }
            fileOut.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String searchForLSID(String name, boolean fuzzy) throws SearchResultException {
        return this.searchForLSID(name, null, fuzzy);
    }

    public String searchForLSID(String name, boolean fuzzy, boolean ignoreHomonyms) throws SearchResultException {
        return this.searchForLSID(name, null, fuzzy, ignoreHomonyms);
    }

    public String searchForLSID(String name) throws SearchResultException {
        return this.searchForLSID(name, false);
    }

    public String searchForLSID(String name, RankType rank, boolean fuzzy) throws SearchResultException {
        return this.searchForLSID(name, null, rank, fuzzy, false);
    }

    public String searchForLSID(String name, RankType rank, boolean fuzzy, boolean ignoreHomonyms) throws SearchResultException {
        return this.searchForLSID(name, null, rank, fuzzy, ignoreHomonyms);
    }

    public String searchForLSID(String name, RankType rank) throws SearchResultException {
        return this.searchForLSID(name, null, rank, false, false);
    }

    @Deprecated
    public String searchForLSID(String name, String kingdom, String scientificName, RankType rank) throws SearchResultException {
        LinnaeanRankClassification cl = new LinnaeanRankClassification(kingdom, scientificName);
        return this.searchForLSID(name, cl, rank, false, false);
    }

    public String searchForLSID(String name, LinnaeanRankClassification cl, RankType rank, boolean fuzzy, boolean ignoreHomonym) throws SearchResultException {
        String lsid = null;
        NameSearchResult result = this.searchForRecord(name, cl, rank, fuzzy, ignoreHomonym);
        if (result != null) {
            if (result.getAcceptedLsid() == null && result.getLsid() == null) {
                this.log.warn((Object)("LSID missing for [name=" + name + ", id=" + result.getId() + "]"));
            } else {
                lsid = result.getAcceptedLsid() != null ? result.getAcceptedLsid() : result.getLsid();
            }
        }
        return lsid;
    }

    public String searchForLSID(LinnaeanRankClassification cl, boolean recursiveMatching) throws SearchResultException {
        NameSearchResult nsr = this.searchForRecord(cl, recursiveMatching);
        if (nsr != null) {
            return nsr.getLsid();
        }
        return null;
    }

    public void updateClassificationWithGUID(LinnaeanRankClassification cl) {
        if (cl.getKid() != null) {
            cl.setKid(this.searchForLsidById(cl.getKid()));
        }
        if (cl.getPid() != null) {
            cl.setPid(this.searchForLsidById(cl.getPid()));
        }
        if (cl.getCid() != null) {
            cl.setCid(this.searchForLsidById(cl.getCid()));
        }
        if (cl.getOid() != null) {
            cl.setOid(this.searchForLsidById(cl.getOid()));
        }
        if (cl.getFid() != null) {
            cl.setFid(this.searchForLsidById(cl.getFid()));
        }
        if (cl.getGid() != null) {
            cl.setGid(this.searchForLsidById(cl.getGid()));
        }
        if (cl.getSid() != null) {
            cl.setSid(this.searchForLsidById(cl.getSid()));
        }
    }

    public NameSearchResult searchForRecord(LinnaeanRankClassification cl, boolean recursiveMatching) throws SearchResultException {
        return this.searchForRecord(cl, recursiveMatching, false, false);
    }

    public MetricsResultDTO searchForRecordMetrics(LinnaeanRankClassification cl, boolean recursiveMatching) throws SearchResultException {
        return this.searchForRecordMetrics(cl, recursiveMatching, false, false);
    }

    public MetricsResultDTO searchForRecordMetrics(LinnaeanRankClassification cl, boolean recursiveMatching, boolean fuzzy) throws SearchResultException {
        return this.searchForRecordMetrics(cl, recursiveMatching, false, fuzzy);
    }

    public NameSearchResult searchForRecord(LinnaeanRankClassification cl, boolean recursiveMatching, boolean fuzzy) throws SearchResultException {
        return this.searchForRecord(cl, recursiveMatching, false, fuzzy);
    }

    public NameSearchResult searchForRecord(LinnaeanRankClassification cl, boolean recursiveMatching, boolean addGuids, boolean fuzzy) throws SearchResultException {
        MetricsResultDTO res = this.searchForRecordMetrics(cl, recursiveMatching, addGuids, fuzzy);
        if (res.getLastException() != null) {
            throw res.getLastException();
        }
        return res.getResult();
    }

    public MetricsResultDTO searchForRecordMetrics(LinnaeanRankClassification cl, boolean recursiveMatching, boolean addGuids, boolean fuzzy) {
        return this.searchForRecordMetrics(cl, recursiveMatching, addGuids, fuzzy, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetricsResultDTO searchForRecordMetrics(LinnaeanRankClassification cl, boolean recursiveMatching, boolean addGuids, boolean fuzzy, boolean ignoreHomonym) {
        NameSearchResult nsr;
        String originalName;
        String name;
        RankType rank;
        MetricsResultDTO metrics;
        block71: {
            metrics = new MetricsResultDTO();
            rank = cl.getRank() != null ? RankType.getForStrRank((String)cl.getRank()) : null;
            originalName = name = cl.getScientificName();
            nsr = null;
            metrics.setErrors(new HashSet());
            if (name == null) {
                if (StringUtils.isNotEmpty((CharSequence)cl.getInfraspecificEpithet()) && !this.isInfraSpecificMarker(cl.getSubspecies())) {
                    rank = RankType.SUBSPECIES;
                    if (StringUtils.isNotEmpty((CharSequence)cl.getGenus()) && StringUtils.isNotEmpty((CharSequence)cl.getSpecificEpithet())) {
                        name = cl.getGenus() + " " + cl.getSpecificEpithet() + " " + cl.getInfraspecificEpithet();
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)cl.getSubspecies()) && !this.isInfraSpecificMarker(cl.getSubspecies())) {
                    rank = RankType.SUBSPECIES;
                    name = cl.getSubspecies();
                } else if (StringUtils.isNotEmpty((CharSequence)cl.getSpecificEpithet()) && !this.isSpecificMarker(cl.getSpecies())) {
                    rank = RankType.SPECIES;
                    if (StringUtils.isNotEmpty((CharSequence)cl.getGenus())) {
                        name = cl.getGenus() + " " + cl.getSpecificEpithet();
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)cl.getSpecies()) && !this.isSpecificMarker(cl.getSpecies())) {
                    rank = RankType.SPECIES;
                    name = cl.getSpecies();
                    if (!name.trim().contains(" ")) {
                        name = StringUtils.isNotEmpty((CharSequence)cl.getGenus()) ? cl.getGenus() + " " + cl.getSpecificEpithet() : null;
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)cl.getGenus())) {
                    rank = RankType.GENUS;
                    name = cl.getGenus();
                } else if (StringUtils.isNotEmpty((CharSequence)cl.getFamily())) {
                    rank = RankType.FAMILY;
                    name = cl.getFamily();
                } else if (StringUtils.isNotEmpty((CharSequence)cl.getOrder())) {
                    rank = RankType.ORDER;
                    name = cl.getOrder();
                } else if (StringUtils.isNotEmpty((CharSequence)cl.getKlass())) {
                    rank = RankType.CLASS;
                    name = cl.getKlass();
                } else if (StringUtils.isNotEmpty((CharSequence)cl.getPhylum())) {
                    rank = RankType.PHYLUM;
                    name = cl.getPhylum();
                } else if (StringUtils.isNotEmpty((CharSequence)cl.getKingdom())) {
                    rank = RankType.KINGDOM;
                    name = cl.getKingdom();
                }
                originalName = name;
            } else {
                if (rank == null && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)cl.getSubspecies())) {
                    rank = RankType.SUBSPECIES;
                } else if (rank == null && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)cl.getSpecies())) {
                    rank = RankType.SPECIES;
                } else if (rank == null && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)cl.getGenus())) {
                    rank = RankType.GENUS;
                } else if (rank == null && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)cl.getFamily())) {
                    rank = RankType.FAMILY;
                } else if (rank == null && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)cl.getOrder())) {
                    rank = RankType.ORDER;
                } else if (rank == null && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)cl.getKlass())) {
                    rank = RankType.CLASS;
                } else if (rank == null && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)cl.getPhylum())) {
                    rank = RankType.PHYLUM;
                } else if (rank == null && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)cl.getKingdom())) {
                    rank = RankType.KINGDOM;
                }
                if (rank == null) {
                    if (recursiveMatching && (name.endsWith(" sp") || name.endsWith(" sp."))) {
                        name = name.substring(0, name.lastIndexOf(" "));
                        cl.setGenus(name);
                    }
                    try {
                        ParsedName cn = this.parser.parse(name.replaceAll("\\?", ""));
                        if (cn != null && cn.getType() == NameType.DOUBTFUL) {
                            if (recursiveMatching) {
                                name = cn.getGenusOrAbove();
                                rank = RankType.GENUS;
                                metrics.setNameType(NameType.DOUBTFUL);
                            }
                            break block71;
                        }
                        if (cn == null || !cn.isBinomial()) break block71;
                        if (StringUtils.isEmpty((CharSequence)cl.getGenus())) {
                            cl.setGenus(cn.getGenusOrAbove());
                        }
                        if (cn.getRank() == null && cn.getCultivarEpithet() == null && cn.isParsableType()) {
                            if (cn.getInfraSpecificEpithet() != null) {
                                rank = RankType.SUBSPECIES;
                                if (StringUtils.isEmpty((CharSequence)cl.getSpecies())) {
                                    cl.setSpecies(cn.getGenusOrAbove() + " " + cn.getSpecificEpithet());
                                }
                                break block71;
                            }
                            rank = RankType.SPECIES;
                            break block71;
                        }
                        if (cn.getCultivarEpithet() != null) {
                            rank = RankType.CULTIVAR;
                        } else if (cn.getRank() == null) {
                            // empty if block
                        }
                    }
                    catch (UnparsableException e) {
                        metrics.setNameType(e.type);
                    }
                }
            }
        }
        nsr = this.performErrorCheckSearch(name.replaceAll("\\?", ""), cl, rank, fuzzy, ignoreHomonym, metrics);
        if (nsr == null && recursiveMatching) {
            String authorship = cl.getAuthorship();
            cl.setAuthorship(null);
            try {
                ParsedName pn = this.parser.parse(name);
                metrics.setNameType(pn.getType());
                if (pn.isBinomial() && pn.getType() != NameType.DOUBTFUL && (pn.getType() != NameType.INFORMAL || pn.getRank() != null && pn.getRank().isInfraspecific()) && (rank == null || rank.getId() >= 7000)) {
                    nsr = this.performErrorCheckSearch(pn.canonicalSpeciesName(), cl, null, fuzzy, ignoreHomonym, metrics);
                }
                if (nsr == null && !RANK_PATTERN.matcher(pn.getGenusOrAbove()).matches() && (pn.getType() == NameType.DOUBTFUL || rank != null && rank.getId() <= 7000 || rank == null)) {
                    nsr = this.performErrorCheckSearch(pn.getGenusOrAbove(), cl, null, fuzzy, ignoreHomonym, metrics);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nsr == null && rank != RankType.SPECIES && (StringUtils.isNotEmpty((CharSequence)cl.getSpecificEpithet()) && !this.isSpecificMarker(cl.getSpecificEpithet()) || StringUtils.isNotEmpty((CharSequence)cl.getSpecies()) && !this.isSpecificMarker(cl.getSpecies()))) {
                name = cl.getSpecies();
                if (StringUtils.isEmpty((CharSequence)name)) {
                    name = cl.getGenus() + " " + cl.getSpecificEpithet();
                }
                nsr = this.performErrorCheckSearch(name, cl, RankType.SPECIES, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getGenus() != null) {
                nsr = this.performErrorCheckSearch(cl.getGenus(), cl, RankType.GENUS, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getFamily() != null) {
                nsr = this.performErrorCheckSearch(cl.getFamily(), cl, RankType.FAMILY, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getOrder() != null) {
                nsr = this.performErrorCheckSearch(cl.getOrder(), cl, RankType.ORDER, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getKlass() != null) {
                nsr = this.performErrorCheckSearch(cl.getKlass(), cl, RankType.CLASS, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getPhylum() != null) {
                nsr = this.performErrorCheckSearch(cl.getPhylum(), cl, RankType.PHYLUM, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr == null && cl.getKingdom() != null) {
                nsr = this.performErrorCheckSearch(cl.getKingdom(), cl, RankType.KINGDOM, fuzzy, ignoreHomonym, metrics);
            }
            if (nsr != null) {
                nsr.setMatchType(MatchType.RECURSIVE);
            }
            cl.setAuthorship(authorship);
        }
        if (metrics.getNameType() == null) {
            try {
                ParsedName pn = this.parser.parse(originalName);
                metrics.setNameType(pn.getType());
            }
            catch (UnparsableException e) {
                metrics.setNameType(e.type);
            }
        }
        this.checkOtherIssues(originalName, metrics);
        if (nsr != null && addGuids) {
            this.updateClassificationWithGUID(nsr.getRankClassification());
        }
        if (metrics.getErrors().size() == 0) {
            metrics.getErrors().add(ErrorType.NONE);
        }
        metrics.setResult(nsr);
        return metrics;
    }

    private void checkOtherIssues(String originalName, MetricsResultDTO metrics) {
        if (originalName.contains("?")) {
            metrics.getErrors().add(ErrorType.QUESTION_SPECIES);
            metrics.setNameType(NameType.DOUBTFUL);
        }
        if (cfPattern.matcher(originalName).matches()) {
            metrics.getErrors().add(ErrorType.CONFER_SPECIES);
        }
        if (affPattern.matcher(originalName).matches()) {
            metrics.getErrors().add(ErrorType.AFFINITY_SPECIES);
        }
    }

    private NameSearchResult performErrorCheckSearch(String name, LinnaeanRankClassification cl, RankType rank, boolean fuzzy, boolean ignoreHomonym, MetricsResultDTO metrics) {
        NameSearchResult nsr = null;
        try {
            nsr = this.searchForRecord(name, cl, rank, fuzzy, ignoreHomonym);
        }
        catch (MisappliedException e) {
            metrics.setLastException((SearchResultException)((Object)e));
            metrics.getErrors().add(e.errorType);
            nsr = e.getMatchedResult();
        }
        catch (ParentSynonymChildException e) {
            metrics.setLastException((SearchResultException)((Object)e));
            metrics.getErrors().add(e.errorType);
            nsr = e.getParentResult();
        }
        catch (ExcludedNameException e) {
            metrics.setLastException((SearchResultException)((Object)e));
            metrics.getErrors().add(e.errorType);
            nsr = e.getNonExcludedName() != null ? e.getNonExcludedName() : e.getExcludedName();
        }
        catch (SearchResultException e) {
            metrics.setLastException(e);
            metrics.getErrors().add(e.errorType);
        }
        return nsr;
    }

    private boolean isInfraSpecificMarker(String subspecies) {
        String epithet = StringUtils.trimToNull((String)subspecies);
        return epithet != null && ("spp".equalsIgnoreCase(epithet) || "spp.".equalsIgnoreCase(epithet));
    }

    private boolean isSpecificMarker(String species) {
        String epithet = StringUtils.trimToNull((String)species);
        return epithet != null && ("sp".equalsIgnoreCase(epithet) || "sp.".equalsIgnoreCase(epithet) || "sp.nov.".equalsIgnoreCase(species.replaceAll(" ", "")));
    }

    public String searchForLSID(String name, LinnaeanRankClassification cl, RankType rank) throws SearchResultException {
        return this.searchForLSID(name, cl, rank, false, false);
    }

    public NameSearchResult searchForRecord(String name, RankType rank, boolean fuzzy) throws SearchResultException {
        return this.searchForRecord(name, null, rank, fuzzy);
    }

    public NameSearchResult searchForRecord(String name) throws SearchResultException {
        return this.searchForRecord(name, null, false);
    }

    public NameSearchResult searchForRecord(String name, RankType rank) throws SearchResultException {
        return this.searchForRecord(name, rank, false);
    }

    public String searchForAcceptedLsidDefaultHandling(LinnaeanRankClassification cl, boolean fuzzy) {
        return this.searchForAcceptedLsidDefaultHandling(cl, fuzzy, false);
    }

    public String searchForAcceptedLsidDefaultHandling(LinnaeanRankClassification cl, boolean fuzzy, boolean ignoreHomonyms) {
        NameSearchResult nsr = this.searchForAcceptedRecordDefaultHandling(cl, fuzzy, ignoreHomonyms);
        if (nsr == null) {
            return null;
        }
        return nsr.getLsid();
    }

    public NameSearchResult searchForAcceptedRecordDefaultHandling(LinnaeanRankClassification cl, boolean fuzzy) {
        return this.searchForAcceptedRecordDefaultHandling(cl, fuzzy, false);
    }

    public NameSearchResult searchForAcceptedRecordDefaultHandling(LinnaeanRankClassification cl, boolean fuzzy, boolean ignoreHomonym) {
        NameSearchResult nsr = null;
        try {
            nsr = this.searchForRecord(cl.getScientificName(), cl, null, fuzzy, ignoreHomonym);
        }
        catch (MisappliedException e) {
            nsr = e.getMatchedResult();
        }
        catch (ParentSynonymChildException e) {
            nsr = e.getParentResult();
        }
        catch (ExcludedNameException e) {
            nsr = e.getNonExcludedName() != null ? e.getNonExcludedName() : e.getExcludedName();
        }
        catch (SearchResultException searchResultException) {
            // empty catch block
        }
        if (nsr != null && nsr.isSynonym()) {
            nsr = this.searchForRecordByLsid(nsr.getAcceptedLsid());
        }
        return nsr;
    }

    @Deprecated
    public NameSearchResult searchForRecord(String name, String kingdom, String genus, RankType rank) throws SearchResultException {
        LinnaeanRankClassification cl = new LinnaeanRankClassification(kingdom, genus);
        return this.searchForRecord(name, cl, rank, false);
    }

    public NameSearchResult searchForRecord(String name, LinnaeanRankClassification cl, RankType rank, boolean fuzzy) throws SearchResultException {
        return this.searchForRecord(name, cl, rank, fuzzy, false);
    }

    public NameSearchResult searchForRecord(String name, LinnaeanRankClassification cl, RankType rank, boolean fuzzy, boolean ignoreHomonyms) throws SearchResultException {
        List<NameSearchResult> results = this.searchForRecords(name, rank, cl, 10, fuzzy, ignoreHomonyms);
        if (results != null && results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public NameSearchResult searchForRecord(String name, LinnaeanRankClassification cl, RankType rank) throws SearchResultException {
        return this.searchForRecord(name, cl, rank, false);
    }

    public NameSearchResult searchForRecordByID(String id) {
        try {
            List<NameSearchResult> results = this.performSearch(NameIndexField.ID, id, null, null, 1, null, false);
            if (results.size() > 0) {
                results.get(0).setMatchType(MatchType.TAXON_ID);
                return results.get(0);
            }
        }
        catch (SearchResultException searchResultException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String searchForLsidById(String id) {
        NameSearchResult result = this.searchForRecordByID(id);
        if (result != null) {
            return result.getAcceptedLsid() != null ? result.getAcceptedLsid() : result.getLsid();
        }
        return null;
    }

    public List<NameSearchResult> searchForRecords(String name, RankType rank, boolean fuzzy) throws SearchResultException {
        return this.searchForRecords(name, rank, null, 10, fuzzy);
    }

    public List<NameSearchResult> searchForRecords(String name, RankType rank, LinnaeanRankClassification cl, int max) throws SearchResultException {
        return this.searchForRecords(name, rank, cl, max, false);
    }

    public List<NameSearchResult> searchForRecords(String name, RankType rank, LinnaeanRankClassification cl, int max, boolean fuzzy) throws SearchResultException {
        return this.searchForRecords(name, rank, cl, max, fuzzy, true, false);
    }

    public List<NameSearchResult> searchForRecords(String name, RankType rank, LinnaeanRankClassification cl, int max, boolean fuzzy, boolean ignoreHomonyms) throws SearchResultException {
        return this.searchForRecords(name, rank, cl, max, fuzzy, true, ignoreHomonyms);
    }

    private List<NameSearchResult> searchForRecords(String name, RankType rank, LinnaeanRankClassification cl, int max, boolean fuzzy, boolean clean, boolean ignoreHomonym) throws SearchResultException {
        if (name == null) {
            throw new SearchResultException("Unable to perform search. Null value supplied for the name.");
        }
        if (PhraseNameParser.RANK_MARKER.matcher(name).matches()) {
            throw new SearchResultException("Supplied scientific name is a rank marker.");
        }
        if (name.contains("spp.")) {
            throw new SPPException();
        }
        try {
            String voucher;
            String phrase;
            String genus;
            CleanedScientificName cleaned = new CleanedScientificName(name);
            NameType nameType = null;
            ParsedName pn = null;
            try {
                pn = this.parser.parse(cleaned.getNormalised());
                nameType = pn != null ? pn.getType() : null;
            }
            catch (UnparsableException e) {
                this.log.warn((Object)("Unable to parse " + name + ". " + e.getMessage()));
            }
            List<NameSearchResult> hits = this.performSearch(NameIndexField.NAME, cleaned.getNormalised(), rank, cl, max, MatchType.EXACT, true);
            if (hits == null) {
                return null;
            }
            if (hits.size() > 0) {
                return hits;
            }
            if (pn instanceof ALAParsedName) {
                ALAParsedName alapn = (ALAParsedName)pn;
                genus = alapn.getGenusOrAbove();
                phrase = alapn.cleanPhrase;
                voucher = alapn.cleanVoucher;
                String specific = alapn.getRank() != null && alapn.getRank().equals((Object)Rank.SPECIES) ? null : alapn.getSpecificEpithet();
                List<Value> searchFields = Arrays.asList(Value.of(NameIndexField.GENUS, genus), Value.of(NameIndexField.PHRASE, phrase), Value.of(NameIndexField.VOUCHER, voucher), Value.of(NameIndexField.SPECIFIC, specific));
                hits = this.performSearch(searchFields, rank, cl, max, MatchType.PHRASE, false);
                if (hits.size() == 1) {
                    return hits;
                }
                if (hits.size() > 1) {
                    NameSearchResult commonAccepted = this.getCommonAcceptedConcept(hits);
                    if (commonAccepted != null) {
                        return Collections.singletonList(commonAccepted);
                    }
                    throw new HomonymException(hits);
                }
            } else if (pn != null && pn.isParsableType() && pn.getType() != NameType.INFORMAL && pn.getType() != NameType.DOUBTFUL) {
                String canonicalName = pn.canonicalName();
                if (cl == null) {
                    cl = new LinnaeanRankClassification();
                }
                if (cl.getAuthorship() == null && pn.isAuthorsParsed()) {
                    cl.setAuthorship(pn.authorshipComplete());
                }
                if ((hits = this.performSearch(NameIndexField.NAME, canonicalName, rank, cl, max, MatchType.CANONICAL, true)).size() > 0) {
                    return hits;
                }
                if (pn.getType() == NameType.CULTIVAR) {
                    genus = pn.getGenusOrAbove();
                    phrase = pn.getCultivarEpithet();
                    voucher = null;
                    String specific = pn.getRank() != null && pn.getRank().equals((Object)Rank.SPECIES) ? null : pn.getSpecificEpithet();
                    List<Value> searchFields = Arrays.asList(Value.of(NameIndexField.GENUS, genus), Value.of(NameIndexField.PHRASE, phrase), Value.of(NameIndexField.VOUCHER, voucher), Value.of(NameIndexField.SPECIFIC, specific));
                    hits = this.performSearch(searchFields, rank, cl, max, MatchType.PHRASE, false);
                    if (hits.size() > 0) {
                        return hits;
                    }
                }
            }
            if (pn != null && fuzzy && pn.isBinomial() && pn.getType() != NameType.INFORMAL && pn.getType() != NameType.DOUBTFUL) {
                String genus2 = TaxonNameSoundEx.treatWord(pn.getGenusOrAbove(), "genus");
                String specific = TaxonNameSoundEx.treatWord(pn.getSpecificEpithet(), "species");
                String infra = pn.getInfraSpecificEpithet() == null ? null : TaxonNameSoundEx.treatWord(pn.getInfraSpecificEpithet(), "species");
                List<Value> searchFields = Arrays.asList(Value.of(NameIndexField.GENUS_EX, genus2), Value.of(NameIndexField.SPECIES_EX, specific), Value.of(NameIndexField.INFRA_EX, StringUtils.isNotEmpty((CharSequence)infra) ? infra : "<null>"));
                hits = this.performSearch(searchFields, rank, cl, max, MatchType.SOUNDEX, false);
                if (hits.size() > 0) {
                    return hits;
                }
            }
            return null;
        }
        catch (HomonymException e) {
            if (ignoreHomonym && e.getResults().size() == 1) {
                return e.getResults();
            }
            throw e;
        }
        catch (IOException e) {
            this.log.warn((Object)e.getMessage());
            return null;
        }
    }

    private NameSearchResult getCommonAcceptedConcept(List<NameSearchResult> hits) {
        String acceptedLsid = null;
        for (NameSearchResult hit : hits) {
            if (acceptedLsid == null) {
                acceptedLsid = hit.getAcceptedLsid() != null ? hit.getAcceptedLsid() : hit.getLsid();
                continue;
            }
            if (!(hit.getAcceptedLsid() != null ? !acceptedLsid.equals(hit.getAcceptedLsid()) : !acceptedLsid.equals(hit.getLsid()))) continue;
            return null;
        }
        return acceptedLsid == null ? null : this.searchForRecordByLsid(acceptedLsid);
    }

    private List<NameSearchResult> performSearch(NameIndexField field, String value, RankType rank, LinnaeanRankClassification cl, int max, MatchType type, boolean checkHomo) throws IOException, SearchResultException {
        return this.performSearch(Arrays.asList(Value.of(field, value)), rank, cl, max, type, checkHomo);
    }

    private List<NameSearchResult> performSearch(List<Value> compulsoryValues, RankType rank, LinnaeanRankClassification cl, int max, MatchType type, boolean checkHomo) throws IOException, SearchResultException {
        if (this.cbSearcher != null) {
            String scientificName = null;
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (Value value : compulsoryValues) {
                if (value.value == null) continue;
                Query query = null;
                ScoreDoc[] field = value.field;
                if (field == NameIndexField.NAME) {
                    scientificName = value.value.toString();
                    Matcher virus = virusStopPattern.matcher(scientificName);
                    if (virus.find()) {
                        BooleanQuery.Builder virusBuilder = new BooleanQuery.Builder();
                        virusBuilder.add(field.search(scientificName), BooleanClause.Occur.SHOULD);
                        String removed = virus.replaceAll(" ");
                        virusBuilder.add(field.search(removed), BooleanClause.Occur.SHOULD);
                        virusBuilder.add(field.search(removed.trim()), BooleanClause.Occur.SHOULD);
                        query = virusBuilder.build();
                    } else {
                        query = field.search(value.value);
                    }
                } else {
                    query = field.search(value.value);
                }
                builder.add(query, BooleanClause.Occur.MUST);
            }
            if (rank != null) {
                int lower = rank.getId();
                int upper = rank.getId() >= RankType.SPECIES.getId() ? 9999 : rank.getId();
                BooleanQuery.Builder rankBuilder = new BooleanQuery.Builder();
                rankBuilder.add(NameIndexField.RANK_ID.searchRange(lower, upper), BooleanClause.Occur.SHOULD);
                rankBuilder.add(NameIndexField.iS_SYNONYM.search("T"), BooleanClause.Occur.SHOULD);
                rankBuilder.add(NameIndexField.ALA.search("T"), BooleanClause.Occur.SHOULD);
                builder.add((Query)rankBuilder.build(), BooleanClause.Occur.MUST);
            }
            if (cl != null) {
                this.appendLuceneQuery(cl, builder, true);
            }
            builder.add(PREFER_ACCEPTED, BooleanClause.Occur.SHOULD);
            BooleanQuery query = builder.build();
            TopDocs hits = this.cbSearcher.search((Query)query, max);
            List<Object> results = new ArrayList<NameSearchResult>();
            for (ScoreDoc sdoc : hits.scoreDocs) {
                NameSearchResult nameSearchResult = this.createResult(this.cbReader.document(sdoc.doc), type);
                nameSearchResult.computeMatch(cl);
                results.add(nameSearchResult);
            }
            results.sort(Comparator.comparing(NameSearchResult::getMatchMetrics).reversed());
            if (results.stream().filter(r -> r.getMatchMetrics().getMatch() > MATCH_LIMIT).count() > 0L) {
                results = results.stream().filter(r -> r.getMatchMetrics().getMatch() > MATCH_LIMIT).collect(Collectors.toList());
            }
            if (checkHomo) {
                RankType resRank;
                if (results.size() > 0) {
                    int exclCount = 0;
                    NameSearchResult notExcludedResult = null;
                    NameSearchResult excludedResult = null;
                    for (NameSearchResult nameSearchResult : results) {
                        if (nameSearchResult.getSynonymType() == SynonymType.EXCLUDES) {
                            ++exclCount;
                            excludedResult = nameSearchResult;
                            continue;
                        }
                        if (notExcludedResult != null) continue;
                        notExcludedResult = nameSearchResult;
                    }
                    if (exclCount > 0) {
                        if (exclCount == results.size()) {
                            throw new ExcludedNameException("The result is a name that has been excluded from the NSL", excludedResult);
                        }
                        if (notExcludedResult != null) {
                            throw new ExcludedNameException("One of the results was excluded.  Use the nonExcludedName for your match.", notExcludedResult, excludedResult);
                        }
                    }
                }
                this.checkForSpeciesSplit(results);
                this.checkForMisapplied(results);
                if (rank == null) {
                    this.checkForCrossRankHomonym(results);
                }
                if (results.size() > 0 && ((resRank = ((NameSearchResult)results.get(0)).getRank()) == RankType.GENUS || resRank == RankType.SPECIES || ((NameSearchResult)results.get(0)).isSynonym() && (rank == null || rank == RankType.GENUS || rank == RankType.SPECIES))) {
                    NameSearchResult result = cl != null && StringUtils.isNotBlank((CharSequence)cl.getAuthorship()) ? this.validateHomonymByAuthor(results, scientificName, cl) : this.validateHomonyms(results, scientificName, cl);
                    results.clear();
                    results.add(result);
                }
            }
            return results;
        }
        return null;
    }

    private void checkResultLevelHomonym(List<NameSearchResult> results) throws HomonymException {
        if (results.size() > 1) {
            String lastAcceptedLsid = "";
            String lastKingdom = "";
            boolean lastWasSyn = false;
            for (NameSearchResult result : results) {
                String kingdom;
                if (!result.isSynonym() && result.getRank().getId() < 7000) continue;
                String accepted = result.isSynonym() ? result.getAcceptedLsid() : result.getLsid();
                String string = kingdom = result.getRankClassification().getKingdom() == null ? "" : result.getRankClassification().getKingdom();
                if (lastAcceptedLsid.length() > 0 && !lastAcceptedLsid.equals(accepted) && (lastKingdom.equals(kingdom) || lastWasSyn || result.isSynonym())) {
                    throw new HomonymException(accepted, results);
                }
                lastAcceptedLsid = accepted;
                lastWasSyn = result.isSynonym();
            }
        }
    }

    private void checkForMisapplied(List<NameSearchResult> results) throws MisappliedException {
        if (results.size() >= 1 && results.stream().anyMatch(r -> r.getSynonymType() == SynonymType.MISAPPLIED)) {
            List accepted = results.stream().filter(r -> !r.isSynonym() || r.isSynonym() && r.getSynonymType() != SynonymType.MISAPPLIED && r.getSynonymType() != SynonymType.EXCLUDES).collect(Collectors.toList());
            List misapplied = results.stream().filter(r -> r.getSynonymType() == SynonymType.MISAPPLIED).collect(Collectors.toList());
            Set misAccepted = misapplied.stream().map(NameSearchResult::getAcceptedLsid).collect(Collectors.toSet());
            NameSearchResult matched = this.searchForRecordByLsid(((NameSearchResult)misapplied.get(0)).getAcceptedLsid());
            if (!accepted.isEmpty()) {
                throw new MisappliedException((NameSearchResult)accepted.get(0), matched);
            }
            if (misAccepted.size() == 1) {
                throw new MisappliedException(matched);
            }
            throw new MisappliedException(null);
        }
    }

    private void checkForSpeciesSplit(List<NameSearchResult> results) throws ParentSynonymChildException {
        if (results.size() == 2) {
            if (results.get(0).isSynonym() != results.get(1).isSynonym() && (!results.get(0).isSynonym() && results.get(0).getRank() == RankType.SPECIES || !results.get(1).isSynonym() && results.get(1).getRank() == RankType.SPECIES)) {
                int asyLeft;
                NameSearchResult synResult = results.get(0).isSynonym() ? results.get(0) : results.get(1);
                NameSearchResult accResult = results.get(0).isSynonym() ? results.get(1) : results.get(0);
                NameSearchResult accSynResult = this.searchForRecordByLsid(synResult.getAcceptedLsid());
                if (accSynResult != null && accResult.getLeft() != null && accSynResult.getLeft() != null && (asyLeft = Integer.parseInt(accSynResult.getLeft())) > Integer.parseInt(accResult.getLeft()) && asyLeft < Integer.parseInt(accResult.getRight())) {
                    throw new ParentSynonymChildException(accResult, accSynResult);
                }
            }
        } else if (results.size() > 2) {
            NameSearchResult accResult = null;
            String acceptedLsid = null;
            for (NameSearchResult nsr : results) {
                if (!nsr.isSynonym()) {
                    if (accResult == null) {
                        accResult = nsr;
                        continue;
                    }
                    return;
                }
                if (acceptedLsid != null) {
                    if (acceptedLsid.equals(nsr.getAcceptedLsid())) continue;
                    return;
                }
                acceptedLsid = nsr.getAcceptedLsid();
            }
            if (accResult != null && acceptedLsid != null) {
                int asyLeft;
                NameSearchResult accSynResult = this.searchForRecordByLsid(acceptedLsid);
                if (accResult != null && accResult.getLeft() != null && accSynResult.getLeft() != null && (asyLeft = Integer.parseInt(accSynResult.getLeft())) > Integer.parseInt(accResult.getLeft()) && asyLeft < Integer.parseInt(accResult.getRight())) {
                    throw new ParentSynonymChildException(accResult, accSynResult);
                }
            }
        }
    }

    private void checkForCrossRankHomonym(List<NameSearchResult> results) throws HomonymException {
        if (results != null && results.size() > 0 && this.crossRankHomonyms.contains(results.get(0).getRankClassification().getScientificName().toLowerCase())) {
            throw new HomonymException("Cross rank homonym detected.  Please repeat search with a rank specified.", results);
        }
    }

    public NameSearchResult validateHomonymByAuthor(List<NameSearchResult> result, String name, LinnaeanRankClassification cl) throws HomonymException {
        String suppliedAuthor = this.prepareAuthor(cl.getAuthorship());
        String resultAuthor = result.get(0).getRankClassification().getAuthorship();
        SmithWatermanGotoh similarity = new SmithWatermanGotoh();
        if (resultAuthor == null || (double)similarity.getSimilarity(suppliedAuthor, resultAuthor) < 0.8) {
            this.validateHomonyms(result, name, cl);
        }
        return result.get(0);
    }

    private String prepareAuthor(String author) {
        return author.replaceAll("\\p{P}", "").replaceAll("\\p{Z}", "");
    }

    public NameSearchResult validateHomonyms(List<NameSearchResult> results, String name, LinnaeanRankClassification cl) throws HomonymException {
        RankType rank = results.get(0).getRank();
        try {
            if (rank == null && results.get(0).isSynonym()) {
                cl = new LinnaeanRankClassification(null, null);
                String synName = results.get(0).getRankClassification().getScientificName();
                try {
                    ParsedName pn = this.parser.parse(synName);
                    if (pn.isBinomial()) {
                        cl.setSpecies(pn.canonicalName());
                        rank = RankType.SPECIES;
                    } else {
                        cl.setGenus(pn.getGenusOrAbove());
                        rank = RankType.GENUS;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cl == null) {
                if (rank == RankType.GENUS) {
                    cl = new LinnaeanRankClassification(null, name);
                } else if (rank == RankType.SPECIES) {
                    cl = new LinnaeanRankClassification(null, null);
                    cl.setSpecies(name);
                }
            }
            if (rank == RankType.GENUS && cl.getGenus() == null) {
                cl.setGenus(name);
            } else if (rank == RankType.SPECIES && cl.getSpecies() == null) {
                cl.setSpecies(name);
            }
            RankType resolveLevel = this.resolveIRMNGHomonym(cl, rank);
            if (resolveLevel == null) {
                return results.get(0);
            }
            this.log.debug((Object)("resolve the homonym at " + resolveLevel + " rank"));
            for (NameSearchResult result : results) {
                if (result.isSynonym() || !cl.hasIdenticalClassification(result.getRankClassification(), resolveLevel)) continue;
                return result;
            }
            throw new HomonymException(results);
        }
        catch (HomonymException e) {
            e.setResults(results);
            throw e;
        }
    }

    private boolean isHomonymResolvable(LinnaeanRankClassification cl) {
        TopDocs results = this.getIRMNGGenus(cl, RankType.GENUS);
        if (results != null) {
            return results.totalHits.value <= 1L;
        }
        return false;
    }

    public TopDocs getIRMNGGenus(LinnaeanRankClassification cl, RankType rank) {
        if (cl != null && (cl.getGenus() != null || cl.getSpecies() != null)) {
            try {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                builder.add(NameIndexField.RANK.search(rank.getRank()), BooleanClause.Occur.MUST);
                this.appendLuceneQuery(cl, builder, false);
                BooleanQuery query = builder.build();
                this.log.debug((Object)("getIRMNG query: " + query.toString()));
                return this.irmngSearcher.search((Query)query, 10);
            }
            catch (Exception e) {
                this.log.warn((Object)"Error searching IRMNG index.", (Throwable)e);
            }
        }
        return null;
    }

    public RankType resolveIRMNGHomonym(LinnaeanRankClassification cl, RankType rank) throws HomonymException {
        if (cl.getGenus() != null || cl.getSpecies() != null) {
            LinnaeanRankClassification newcl = new LinnaeanRankClassification(null, cl.getGenus());
            if (rank == RankType.SPECIES) {
                newcl.setSpecies(cl.getSpecies());
            }
            if (cl != null && (cl.getGenus() != null || cl.getSpecies() != null)) {
                TopDocs results = this.getIRMNGGenus(newcl, rank);
                if (results == null || results.totalHits.value <= 1L) {
                    return null;
                }
                if (cl != null && cl.getKingdom() != null) {
                    newcl.setKingdom(cl.getKingdom());
                    results = this.getIRMNGGenus(newcl, rank);
                    if (results.totalHits.value == 1L) {
                        return RankType.KINGDOM;
                    }
                }
                if (cl.getPhylum() != null && results.totalHits.value > 1L) {
                    newcl.setPhylum(cl.getPhylum());
                    results = this.getIRMNGGenus(newcl, rank);
                    if (results.totalHits.value == 1L) {
                        return RankType.PHYLUM;
                    }
                    if (results.totalHits.value == 0L) {
                        newcl.setPhylum(null);
                    }
                }
                if (cl.getKlass() != null) {
                    newcl.setKlass(cl.getKlass());
                    results = this.getIRMNGGenus(newcl, rank);
                    if (results.totalHits.value == 1L) {
                        return RankType.CLASS;
                    }
                }
                if (cl.getOrder() != null && results.totalHits.value > 1L) {
                    newcl.setOrder(cl.getOrder());
                    results = this.getIRMNGGenus(newcl, rank);
                    if (results.totalHits.value == 1L) {
                        return RankType.ORDER;
                    }
                }
                if (cl.getFamily() != null && results.totalHits.value > 1L) {
                    newcl.setFamily(cl.getFamily());
                    results = this.getIRMNGGenus(newcl, rank);
                    if (results.totalHits.value == 1L) {
                        return RankType.FAMILY;
                    }
                }
            }
        }
        throw new HomonymException("Problem resolving the classification: " + cl);
    }

    public String searchForLSIDCommonName(String commonName) {
        return this.getLSIDForUniqueCommonName(commonName);
    }

    public String getCommonNameForLSID(String lsid) {
        if (lsid != null) {
            Query query = NameIndexField.LSID.search(lsid);
            try {
                TopDocs results = this.vernSearcher.search(query, 1);
                this.log.debug((Object)("Number of matches for " + lsid + " " + results.totalHits));
                ScoreDoc[] scoreDocArray = results.scoreDocs;
                int n = scoreDocArray.length;
                int n2 = 0;
                if (n2 < n) {
                    ScoreDoc sdoc = scoreDocArray[n2];
                    Document doc = this.vernSearcher.doc(sdoc.doc);
                    return doc.get(NameIndexField.COMMON_NAME.toString());
                }
            }
            catch (IOException e) {
                this.log.debug((Object)"Unable to access document for common name.", (Throwable)e);
            }
        }
        return null;
    }

    public String getCommonNameForLSID(String lsid, String[] languages) {
        if (lsid != null) {
            for (String language : languages) {
                try {
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    builder.add(NameIndexField.LSID.search(lsid), BooleanClause.Occur.MUST);
                    builder.add(NameIndexField.LANGUAGE.search(language), BooleanClause.Occur.MUST);
                    TopDocs results = this.vernSearcher.search((Query)builder.build(), 1);
                    this.log.debug((Object)("Number of matches for " + lsid + " " + results.totalHits));
                    ScoreDoc[] scoreDocArray = results.scoreDocs;
                    int n = scoreDocArray.length;
                    int n2 = 0;
                    if (n2 < n) {
                        ScoreDoc sdoc = scoreDocArray[n2];
                        Document doc = this.vernSearcher.doc(sdoc.doc);
                        return doc.get(NameIndexField.COMMON_NAME.toString());
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)"Unable to access document for common name.", (Throwable)e);
                }
            }
        }
        return null;
    }

    public Set<String> getCommonNamesForLSID(String lsid, int maxNumberOfNames) {
        if (lsid != null) {
            Query query = NameIndexField.LSID.search(lsid);
            try {
                TopDocs results = this.vernSearcher.search(query, maxNumberOfNames);
                this.log.debug((Object)("Number of matches for " + lsid + " " + results.totalHits));
                HashSet<String> names = new HashSet<String>();
                HashSet<String> lowerCaseResults = new HashSet<String>();
                int idx = 0;
                for (ScoreDoc sdoc : results.scoreDocs) {
                    Document doc = this.vernSearcher.doc(sdoc.doc);
                    String name = doc.get(NameIndexField.COMMON_NAME.toString());
                    if (!lowerCaseResults.contains(name.toLowerCase())) {
                        lowerCaseResults.add(name.toLowerCase());
                        names.add(name);
                    }
                    ++idx;
                }
                return names;
            }
            catch (IOException e) {
                this.log.debug((Object)"Unable to access document for common name.", (Throwable)e);
            }
        }
        return new HashSet<String>();
    }

    private String getLSIDForUniqueCommonName(String name) {
        if (name != null) {
            Query query = NameIndexField.SEARCHABLE_COMMON_NAME.search(name);
            try {
                TopDocs results = this.vernSearcher.search(query, 10);
                NameSearchResult best = null;
                this.log.debug((Object)("Number of matches for " + name + " " + results.totalHits));
                for (ScoreDoc sdoc : results.scoreDocs) {
                    Document doc = this.vernSearcher.doc(sdoc.doc);
                    String lsid = doc.get(NameIndexField.LSID.toString());
                    NameSearchResult result = this.searchForRecordByLsid(lsid);
                    if (result.isSynonym()) {
                        result = this.searchForRecordByLsid(result.getAcceptedLsid());
                    }
                    if (best == null) {
                        best = result;
                        continue;
                    }
                    if ((best = this.doClassificationMatch(best, result)) != null) continue;
                    return null;
                }
                return best == null ? null : best.getLsid();
            }
            catch (IOException e) {
                this.log.debug((Object)"Unable to access document for common name.", (Throwable)e);
            }
        }
        return null;
    }

    protected NameSearchResult doClassificationMatch(NameSearchResult match1, NameSearchResult match2) {
        if (match1.getLsid().equals(match2.getLsid())) {
            return match1;
        }
        if (this.classificationContains(match2.getRankClassification(), match1.getLsid())) {
            return match1;
        }
        if (this.classificationContains(match1.getRankClassification(), match2.getLsid())) {
            return match2;
        }
        return null;
    }

    protected boolean classificationContains(LinnaeanRankClassification classification, String lsid) {
        if (lsid == null) {
            return false;
        }
        if (lsid.equals(classification.getSid())) {
            return true;
        }
        if (lsid.equals(classification.getGid())) {
            return true;
        }
        if (lsid.equals(classification.getFid())) {
            return true;
        }
        if (lsid.equals(classification.getOid())) {
            return true;
        }
        if (lsid.equals(classification.getCid())) {
            return true;
        }
        if (lsid.equals(classification.getPid())) {
            return true;
        }
        return lsid.equals(classification.getKid());
    }

    private boolean doSciNamesMatch(String n1, String n2) {
        try {
            ParsedName pn1 = this.parser.parse(n1);
            ParsedName pn2 = this.parser.parse(n2);
            if (pn1 != null && pn2 != null) {
                return pn1.canonicalName().equals(pn2.canonicalName());
            }
            return false;
        }
        catch (UnparsableException e) {
            return false;
        }
    }

    public NameSearchResult searchForCommonName(String name) {
        NameSearchResult result = null;
        String lsid = this.getLSIDForUniqueCommonName(name);
        if (lsid != null && (result = this.searchForRecordByLsid(lsid)) != null) {
            result.setMatchType(MatchType.VERNACULAR);
        }
        return result;
    }

    public String getPrimaryLsid(String lsid) {
        if (lsid != null) {
            Query tq = NameIndexField.LSID.search(lsid);
            try {
                TopDocs results = this.idSearcher.search(tq, 1);
                if (results.totalHits.value > 0L) {
                    return this.idSearcher.doc(results.scoreDocs[0].doc).get(NameIndexField.REAL_LSID.toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lsid;
    }

    public NameSearchResult searchForRecordByLsid(String lsid) {
        NameSearchResult result = null;
        try {
            Query query = NameIndexField.LSID.search(lsid);
            TopDocs hits = this.idSearcher.search(query, 1);
            if (hits.totalHits.value > 0L) {
                Document link = this.idSearcher.doc(hits.scoreDocs[0].doc);
                lsid = link.get(NameIndexField.REAL_LSID.name);
                query = NameIndexField.LSID.search(lsid);
            }
            hits = this.cbSearcher.search(query, 1);
            if (hits.totalHits.value > 0L) {
                result = this.createResult(this.cbSearcher.doc(hits.scoreDocs[0].doc), MatchType.TAXON_ID);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Unable to search for record by LSID " + lsid), (Throwable)ex);
        }
        return result;
    }

    public List<String> getGuidsForTaxa(List<String> taxaQueries) {
        ArrayList<String> guids = new ArrayList<String>();
        for (int i = 0; i < taxaQueries.size(); ++i) {
            String scientificName = taxaQueries.get(i);
            String lsid = this.getLsidByNameAndKingdom(scientificName);
            if (lsid != null && lsid.length() > 0) {
                String guid = null;
                try {
                    guid = this.getExtendedTaxonConceptByGuid(lsid, true, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                guids.add(guid);
            }
            if (guids.size() >= i + 1) continue;
            guids.add(null);
        }
        return guids;
    }

    private void appendAutocompleteResults(Map<String, Map> output, TopDocs results, boolean includeSynonyms, boolean commonNameResults, String q, AbstractStringMetric similarity) throws IOException {
        for (ScoreDoc i : results.scoreDocs) {
            NameSearchResult nsr;
            Document src = commonNameResults ? this.vernSearcher.doc(i.doc) : this.cbSearcher.doc(i.doc);
            NameSearchResult nameSearchResult = nsr = commonNameResults ? this.searchForRecordByLsid(src.get("lsid")) : this.createResult(src, null);
            if (nsr == null || nsr.getLeft() == null && !includeSynonyms) continue;
            String name = commonNameResults ? src.get("common_orig") : src.get("name");
            float score = similarity.getSimilarity(q, name);
            score *= i.score;
            if (!commonNameResults) {
                score *= 2.0f;
            }
            Map m = this.formatAutocompleteNsr(score, nsr);
            if (commonNameResults) {
                m.put("commonname", name);
                m.put("match", "commonName");
            } else {
                m.put("match", "scientificName");
            }
            while (includeSynonyms && nsr != null && m != null && nsr.getAcceptedLsid() != null) {
                ArrayList<Map> list;
                if (output.containsKey(nsr.getAcceptedLsid())) {
                    list = (ArrayList<Map>)output.get(nsr.getAcceptedLsid()).get("synonymMatch");
                    if (list == null) {
                        list = new ArrayList();
                    }
                    list.add(m);
                    output.get(nsr.getAcceptedLsid()).put("synonymMatch", list);
                    m = null;
                    nsr = null;
                    continue;
                }
                if ((nsr = this.searchForRecordByLsid(nsr.getAcceptedLsid())) == null) continue;
                list = new ArrayList<Map>();
                list.add(m);
                m = this.formatAutocompleteNsr(i.score, nsr);
                m.put("synonymMatch", list);
            }
            if ((nsr == null || nsr.getAcceptedLsid() != null) && !includeSynonyms || m == null) continue;
            Map existing = output.get(m.get("lsid").toString());
            if (existing == null) {
                output.put(m.get("lsid").toString(), m);
                continue;
            }
            if (!(((Float)m.get("score")).floatValue() > ((Float)existing.get("score")).floatValue())) continue;
            output.put(m.get("lsid").toString(), m);
        }
    }

    private Query buildAutocompleteQuery(NameIndexField field, String q, boolean allSearches) {
        BoostQuery fq1 = new BoostQuery(field.search(q), 12.0f);
        Query fq5 = field.searchWildcard(q + "*");
        Query fq6 = field.searchWildcard("* " + q + "*");
        Query fq7 = field.searchWildcard("*" + q + "*");
        BooleanQuery o = new BooleanQuery.Builder().add(new BooleanClause((Query)fq1, BooleanClause.Occur.SHOULD)).add(new BooleanClause(fq5, BooleanClause.Occur.SHOULD)).add(new BooleanClause(fq6, BooleanClause.Occur.SHOULD)).add(new BooleanClause(fq7, BooleanClause.Occur.SHOULD)).build();
        return o;
    }

    private String getPreferredGuid(String taxonConceptGuid) throws Exception {
        Query qGuid = NameIndexField.GUID.search(taxonConceptGuid);
        Query qOtherGuid = NameIndexField.OTHER_GUID.search(taxonConceptGuid);
        BooleanQuery fullQuery = new BooleanQuery.Builder().add(qGuid, BooleanClause.Occur.SHOULD).add(qOtherGuid, BooleanClause.Occur.SHOULD).build();
        TopDocs topDocs = this.cbSearcher.search((Query)fullQuery, 1);
        int n = 0;
        ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
        int n2 = scoreDocArray.length;
        if (n < n2) {
            ScoreDoc scoreDoc = scoreDocArray[n];
            Document doc = this.cbSearcher.doc(scoreDoc.doc);
            return doc.get(NameIndexField.GUID.toString());
        }
        return taxonConceptGuid;
    }

    private boolean isKingdom(String name) {
        try {
            LinnaeanRankClassification lc = new LinnaeanRankClassification(name, null);
            NameSearchResult nsr = this.searchForRecord(lc, false);
            return nsr != null && nsr.getRank() == RankType.KINGDOM;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String[] extractComponents(String in) {
        int lastClose;
        String[] retArray = new String[2];
        int lastOpen = in.lastIndexOf("(");
        if (lastOpen < (lastClose = in.lastIndexOf(")"))) {
            String potentialKingdom = in.substring(lastOpen + 1, lastClose);
            if (this.isKingdom(potentialKingdom)) {
                retArray[0] = in.substring(0, lastOpen);
                retArray[1] = potentialKingdom;
            } else {
                retArray[0] = in;
            }
        } else {
            retArray[0] = in;
        }
        return retArray;
    }

    private String getLsidByNameAndKingdom(String parameter) {
        String lsid = null;
        String name = null;
        String kingdom = null;
        String[] parts = this.extractComponents(parameter);
        name = parts[0];
        name = name.replaceAll("_", " ");
        name = name.replaceAll("\\+", " ");
        kingdom = parts[1];
        if (kingdom != null) {
            LinnaeanRankClassification cl = new LinnaeanRankClassification(kingdom, null);
            cl.setScientificName(name);
            try {
                lsid = this.searchForLSID(cl.getScientificName(), cl, null);
            }
            catch (ExcludedNameException e) {
                lsid = e.getNonExcludedName() != null ? e.getNonExcludedName().getLsid() : e.getExcludedName().getLsid();
            }
            catch (ParentSynonymChildException e) {
                lsid = e.getParentResult().getLsid();
            }
            catch (MisappliedException e) {
                if (e.getMatchedResult() != null) {
                    lsid = e.getMatchedResult().getLsid();
                }
            }
            catch (SearchResultException searchResultException) {
                // empty catch block
            }
        }
        if (lsid == null || lsid.length() < 1) {
            try {
                lsid = this.searchForLSID(name, true, true);
            }
            catch (ExcludedNameException e) {
                lsid = e.getNonExcludedName() != null ? e.getNonExcludedName().getLsid() : e.getExcludedName().getLsid();
            }
            catch (ParentSynonymChildException e) {
                lsid = e.getParentResult().getLsid();
            }
            catch (MisappliedException e) {
                if (e.getMatchedResult() != null) {
                    lsid = e.getMatchedResult().getLsid();
                }
            }
            catch (SearchResultException searchResultException) {
                // empty catch block
            }
        }
        if (lsid == null || lsid.length() < 1) {
            lsid = this.searchForLSIDCommonName(name);
        }
        if (lsid == null || lsid.length() < 1) {
            lsid = this.findLSIDByConcatName(name);
        }
        return lsid;
    }

    private String concatName(String name) {
        String patternA = "[^a-zA-Z]";
        String patternB = "\\b\\s{2,}\\b";
        String cleanQuery = "";
        if (name != null) {
            cleanQuery = this.escapeQueryChars(name);
            cleanQuery = cleanQuery.toLowerCase();
            cleanQuery = cleanQuery.replaceAll(patternA, "");
            cleanQuery = cleanQuery.replaceAll(patternB, "");
            cleanQuery = cleanQuery.trim();
        }
        return cleanQuery;
    }

    private String findLSIDByConcatName(String name) {
        try {
            ScoreDoc[] scoreDocArray;
            int n;
            int n2;
            String concatName = this.concatName(name);
            Query query = NameIndexField.CONCAT_NAME.search(concatName);
            TopDocs topDocs = this.cbSearcher.search(query, 2);
            if (topDocs != null && topDocs.totalHits.value == 1L && (n2 = 0) < (n = (scoreDocArray = topDocs.scoreDocs).length)) {
                ScoreDoc scoreDoc = scoreDocArray[n2];
                Document doc = this.cbSearcher.doc(scoreDoc.doc);
                return doc.get("guid");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getExtendedTaxonConceptByGuid(String guid, boolean checkPreferred, boolean checkSynonym) throws Exception {
        boolean hasAccepted;
        NameSearchResult nsr = this.searchForRecordByLsid(guid);
        boolean bl = hasAccepted = nsr != null && nsr.getAcceptedLsid() == null;
        if (checkPreferred && !hasAccepted) {
            guid = this.getPreferredGuid(guid);
        }
        if (checkSynonym && !hasAccepted && nsr != null && nsr.isSynonym()) {
            guid = nsr.getAcceptedLsid();
        }
        return guid;
    }

    public List<Map> autocomplete(String q, int max, boolean includeSynonyms) {
        try {
            Levenshtein similarity = new Levenshtein();
            HashMap<String, Map> output = new HashMap<String, Map>();
            String lq = q.toLowerCase();
            String uq = q.toUpperCase();
            Query fq = this.buildAutocompleteQuery(NameIndexField.NAME, lq, false);
            BooleanQuery.Builder bb = new BooleanQuery.Builder();
            bb.add(fq, BooleanClause.Occur.MUST);
            if (!includeSynonyms) {
                bb.add(NameIndexField.iS_SYNONYM.search("T"), BooleanClause.Occur.MUST_NOT);
            }
            BooleanQuery b = bb.build();
            TopDocs results = this.cbSearcher.search((Query)b, max);
            this.appendAutocompleteResults(output, results, includeSynonyms, false, q, (AbstractStringMetric)similarity);
            uq = this.concatName(uq).toUpperCase();
            fq = this.buildAutocompleteQuery(NameIndexField.SEARCHABLE_COMMON_NAME, uq, true);
            results = this.vernSearcher.search(fq, max);
            this.appendAutocompleteResults(output, results, includeSynonyms, true, q, (AbstractStringMetric)similarity);
            ArrayList<Map> matches = new ArrayList<Map>(output.values());
            matches.sort(AUTOCOMPLETE_COMPARATOR);
            return matches;
        }
        catch (Exception e) {
            this.log.error((Object)"Autocomplete error.", (Throwable)e);
            return null;
        }
    }

    private Map formatAutocompleteNsr(float score, NameSearchResult nsr) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("score", Float.valueOf(score));
        m.put("lsid", nsr.getLsid());
        m.put("left", nsr.getLeft());
        m.put("right", nsr.getRight());
        m.put("rank", nsr.getRank());
        m.put("rankId", nsr.getRank() != null ? nsr.getRank().getId() : 10000);
        m.put("cl", nsr.getRankClassification());
        m.put("name", nsr.getRankClassification() != null ? nsr.getRankClassification().getScientificName() : null);
        m.put("acceptedLsid", nsr.getAcceptedLsid());
        m.put("commonname", this.getCommonNameForLSID(nsr.getLsid()));
        m.put("commonnames", this.getCommonNamesForLSID(nsr.getLsid(), 1000));
        return m;
    }

    private String escapeQueryChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == ';' || c == '/' || Character.isWhitespace(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected NameSearchResult createResult(Document doc, MatchType type) {
        String name = doc.get(NameIndexField.NAME_CANONICAL.toString());
        if (name == null) {
            name = doc.get(NameIndexField.NAME.toString());
        }
        if (name == null) {
            name = doc.get(NameIndexField.NAME_COMPLETE.toString());
        }
        LinnaeanRankClassification rankClass = new LinnaeanRankClassification(doc.get(RankType.KINGDOM.getRank()), doc.get(RankType.PHYLUM.getRank()), doc.get(RankType.CLASS.getRank()), doc.get(RankType.ORDER.getRank()), doc.get(RankType.FAMILY.getRank()), doc.get(RankType.GENUS.getRank()), name);
        rankClass.setSpecies(doc.get(RankType.SPECIES.getRank()));
        rankClass.setKid(doc.get("kid"));
        rankClass.setPid(doc.get("pid"));
        rankClass.setCid(doc.get("cid"));
        rankClass.setOid(doc.get("oid"));
        rankClass.setFid(doc.get("fid"));
        rankClass.setGid(doc.get("gid"));
        rankClass.setSid(doc.get("sid"));
        rankClass.setAuthorship(doc.get(NameIndexField.AUTHOR.toString()));
        String id = doc.get(NameIndexField.ID.toString());
        String lsid = doc.get(NameIndexField.LSID.toString());
        String kingdom = doc.get(RankType.KINGDOM.getRank());
        RankType rank = null;
        try {
            rank = RankType.getForId((Integer)Integer.parseInt(doc.get(NameIndexField.RANK_ID.toString())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String left = doc.get("left");
        String right = doc.get("right");
        SynonymType synonymType = SynonymType.getTypeFor((String)doc.get(NameIndexField.SYNONYM_TYPE.toString()));
        String acceptedLsid = doc.get(NameIndexField.ACCEPTED.toString());
        IndexableField pf = doc.getField(NameIndexField.PRIORITY.toString());
        Integer priority = pf == null ? null : Integer.valueOf(pf.numericValue().intValue());
        NameSearchResult result = new NameSearchResult(id, lsid, acceptedLsid, left, right, rankClass, rank, type, synonymType, priority);
        result.setRank(rank);
        result.setLeft(left);
        result.setRight(right);
        return result;
    }

    public void appendLuceneQuery(LinnaeanRankClassification classification, BooleanQuery.Builder builder, boolean optional) {
        BooleanClause.Occur occurs = optional ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.FILTER;
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)classification.getKingdom())) {
            builder.add(NameIndexField.KINGDOM.search(classification.getKingdom()), occurs);
        }
        if (StringUtils.isNotEmpty((CharSequence)classification.getPhylum())) {
            builder.add(NameIndexField.PHYLUM.search(classification.getPhylum()), occurs);
        }
        if (StringUtils.isNotEmpty((CharSequence)classification.getKlass())) {
            builder.add(NameIndexField.CLASS.search(classification.getKlass()), occurs);
        }
        if (StringUtils.isNotEmpty((CharSequence)classification.getOrder())) {
            builder.add(NameIndexField.ORDER.search(classification.getOrder()), occurs);
        }
        if (StringUtils.isNotEmpty((CharSequence)classification.getFamily())) {
            builder.add(NameIndexField.FAMILY.search(classification.getFamily()), occurs);
        }
        if (StringUtils.isNotEmpty((CharSequence)classification.getGenus())) {
            builder.add(NameIndexField.GENUS.search(classification.getGenus()), occurs);
        }
        if (StringUtils.isNotEmpty((CharSequence)classification.getSpecies())) {
            builder.add(NameIndexField.SPECIES.search(classification.getSpecies()), occurs);
        }
        if (StringUtils.isNotEmpty((CharSequence)classification.getAuthorship())) {
            builder.add(NameIndexField.AUTHOR.search(classification.getAuthorship()), BooleanClause.Occur.SHOULD);
        }
    }

    public static void main(String[] args) throws IOException {
        ALANameSearcher nameindex = new ALANameSearcher(args[0]);
        String name = nameindex.getCommonNameForLSID("urn:lsid:biodiversity.org.au:afd.taxon:31a9b8b8-4e8f-4343-a15f-2ed24e0bf1ae");
        System.out.println(name);
        Set<String> names = nameindex.getCommonNamesForLSID("urn:lsid:biodiversity.org.au:apni.taxon:295861", 100);
        for (String commonName : names) {
            System.out.println(commonName);
        }
    }

    private static class Value<T> {
        public NameIndexField field;
        public T value;

        private Value(NameIndexField field, T value) {
            this.field = field;
            this.value = value;
        }

        public static <T> Value<T> of(NameIndexField field, T value) {
            return new Value<T>(field, value);
        }
    }
}

