/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file.properties;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Closer;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class PropertiesUtil {
    public static final String UTF8_ENCODING = "UTF-8";

    private PropertiesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String propertiesFile) throws IOException, IllegalArgumentException {
        Properties tempProperties = new Properties();
        try (Closer closer = Closer.create();){
            File file = new File(propertiesFile);
            if (file.exists()) {
                tempProperties.load(closer.register(new FileInputStream(file)));
            } else {
                URL configFileURL = Resources.getResource(propertiesFile);
                tempProperties.load(closer.register(Resources.asByteSource(configFileURL).openStream()));
            }
        }
        return tempProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readFromFile(String filepath) throws IOException, IllegalArgumentException {
        if (Strings.isNullOrEmpty(filepath)) {
            throw new IllegalArgumentException("No properties file given");
        }
        File pf = new File(filepath);
        if (!pf.exists()) {
            throw new IllegalArgumentException("Cannot find properties file " + filepath);
        }
        Properties properties = new Properties();
        try (Closer closer = Closer.create();){
            FileReader reader = closer.register(new FileReader(pf));
            properties.load(reader);
        }
        return properties;
    }

    public static Double propertyAsDouble(Properties p, String key, boolean exceptionForNull, Double defaultValue) throws IllegalArgumentException {
        String v = p.getProperty(key);
        if (v != null) {
            try {
                return Double.parseDouble(v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid value[" + v + "] supplied for " + key);
            }
        }
        if (exceptionForNull) {
            throw new IllegalArgumentException("Missing property for " + key);
        }
        return defaultValue;
    }

    public static Float propertyAsFloat(Properties p, String key, boolean exceptionForNull, Float defaultValue) throws IllegalArgumentException {
        String v = p.getProperty(key);
        if (v != null) {
            try {
                return Float.valueOf(Float.parseFloat(v));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid value[" + v + "] supplied for " + key);
            }
        }
        if (exceptionForNull) {
            throw new IllegalArgumentException("Missing property for " + key);
        }
        return defaultValue;
    }

    public static Integer propertyAsInt(Properties p, String key, boolean exceptionForNull, Integer defaultValue) throws IllegalArgumentException {
        String v = p.getProperty(key);
        if (v != null) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid value[" + v + "] supplied for " + key);
            }
        }
        if (exceptionForNull) {
            throw new IllegalArgumentException("Missing property for " + key);
        }
        return defaultValue;
    }

    public static boolean propertyAsBool(Properties p, String key, boolean defaultValue) {
        Boolean val = BooleanUtils.toBooleanObject((String)p.getProperty(key, null));
        return val == null ? defaultValue : val;
    }

    public static byte[] propertyAsUTF8Bytes(Properties p, String key, boolean exceptionForNull, byte[] defaultValue) throws IllegalArgumentException {
        String v = p.getProperty(key);
        if (v != null) {
            try {
                return v.getBytes(UTF8_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("System does not support UTF-8 encoding");
            }
        }
        if (exceptionForNull) {
            throw new IllegalArgumentException("Missing property for " + key);
        }
        return defaultValue;
    }

    public static Properties filterProperties(Properties properties, String prefix) {
        Preconditions.checkNotNull(properties, "Can't filter a null Properties");
        Preconditions.checkState(StringUtils.isNotBlank((CharSequence)prefix), "Can't filter using a blank prefix", properties);
        Properties filtered = new Properties();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            filtered.setProperty(key.substring(prefix.length()), properties.getProperty(key));
        }
        return filtered;
    }

    public static Properties subsetProperties(Properties original, String prefix) {
        return PropertiesUtil.propertiesByPrefix(original, prefix, false);
    }

    public static Properties removeProperties(Properties original, String prefix) {
        return PropertiesUtil.propertiesByPrefix(original, prefix, true);
    }

    private static Properties propertiesByPrefix(Properties original, String prefix, boolean remove) {
        Preconditions.checkNotNull(original, "Can't filter a null Properties");
        Preconditions.checkState(StringUtils.isNotBlank((CharSequence)prefix), "Can't filter using a blank prefix", original);
        Properties filtered = new Properties();
        if (original.isEmpty()) {
            return filtered;
        }
        Iterator<Object> keysIt = original.keySet().iterator();
        while (keysIt.hasNext()) {
            String key = String.valueOf(keysIt.next());
            if (!key.startsWith(prefix)) continue;
            filtered.setProperty(key, original.getProperty(key));
            if (!remove) continue;
            keysIt.remove();
        }
        return filtered;
    }
}

