/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file;

import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesUtil.class);

    private ResourcesUtil() {
    }

    public static void copy(File folder, String classpathPrefix, boolean ignoreMissingResources, String ... classpathResources) throws IOException {
        for (String classpathResource : classpathResources) {
            String res = classpathPrefix + classpathResource;
            URL url = null;
            try {
                url = Resources.getResource(res);
                if (url == null) {
                    throw new IllegalArgumentException("Classpath resource " + res + " not existing");
                }
            }
            catch (IllegalArgumentException e) {
                if (ignoreMissingResources) {
                    LOG.debug("Resource {} not found", (Object)res);
                    continue;
                }
                throw new IOException(e);
            }
            try (Closer closer = Closer.create();){
                File f = new File(folder, classpathResource);
                Files.createParentDirs(f);
                OutputStream out = closer.register(new FileOutputStream(f));
                Resources.copy(url, out);
            }
        }
    }

    public static String[] list(Class clazz, String path) throws IOException {
        URL dirURL;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((dirURL = clazz.getClassLoader().getResource(path)) != null && dirURL.getProtocol().equals("file")) {
            try {
                return new File(dirURL.toURI()).list();
            }
            catch (URISyntaxException e) {
                throw new IOException("Bad URI. Cannot list files for path " + path + " in class " + clazz, e);
            }
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String entry;
                String name = entries.nextElement().getName();
                if (!name.startsWith(path) || StringUtils.isBlank((CharSequence)(entry = name.substring(path.length())))) continue;
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[0];
    }
}

