/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.shaded.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;
import org.gbif.common.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.JavaType;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.JsonSerializable;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.jsonschema.JsonSerializableSchema;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.gbif.common.shaded.com.fasterxml.jackson.databind.type.TypeFactory;

@JacksonStdImpl
public class SerializableSerializer
extends StdSerializer<JsonSerializable> {
    public static final SerializableSerializer instance = new SerializableSerializer();
    private static final AtomicReference<ObjectMapper> _mapperReference = new AtomicReference();

    protected SerializableSerializer() {
        super(JsonSerializable.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers, JsonSerializable value) {
        if (value instanceof JsonSerializable.Base) {
            return ((JsonSerializable.Base)value).isEmpty(serializers);
        }
        return false;
    }

    @Override
    public void serialize(JsonSerializable value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        value.serialize(gen, serializers);
    }

    @Override
    public final void serializeWithType(JsonSerializable value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        value.serializeWithType(gen, serializers, typeSer);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        Class<?> rawClass;
        ObjectNode objectNode = this.createObjectNode();
        String schemaType = "any";
        String objectProperties = null;
        String itemDefinition = null;
        if (typeHint != null && (rawClass = TypeFactory.rawClass(typeHint)).isAnnotationPresent(JsonSerializableSchema.class)) {
            JsonSerializableSchema schemaInfo = rawClass.getAnnotation(JsonSerializableSchema.class);
            schemaType = schemaInfo.schemaType();
            if (!"##irrelevant".equals(schemaInfo.schemaObjectPropertiesDefinition())) {
                objectProperties = schemaInfo.schemaObjectPropertiesDefinition();
            }
            if (!"##irrelevant".equals(schemaInfo.schemaItemDefinition())) {
                itemDefinition = schemaInfo.schemaItemDefinition();
            }
        }
        objectNode.put("type", schemaType);
        if (objectProperties != null) {
            try {
                objectNode.set("properties", SerializableSerializer._getObjectMapper().readTree(objectProperties));
            }
            catch (IOException e) {
                provider.reportMappingProblem("Failed to parse @JsonSerializableSchema.schemaObjectPropertiesDefinition value", new Object[0]);
            }
        }
        if (itemDefinition != null) {
            try {
                objectNode.set("items", SerializableSerializer._getObjectMapper().readTree(itemDefinition));
            }
            catch (IOException e) {
                provider.reportMappingProblem("Failed to parse @JsonSerializableSchema.schemaItemDefinition value", new Object[0]);
            }
        }
        return objectNode;
    }

    private static final synchronized ObjectMapper _getObjectMapper() {
        ObjectMapper mapper = _mapperReference.get();
        if (mapper == null) {
            mapper = new ObjectMapper();
            _mapperReference.set(mapper);
        }
        return mapper;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }
}

