/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.tabular;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.dwca.io.ArchiveField;
import org.gbif.tabular.TermTabularDataFileReader;
import org.gbif.tabular.TermTabularDataLine;
import org.gbif.utils.file.tabular.TabularDataFileReader;

public class DwcTabularDataFileReader
extends TermTabularDataFileReader {
    public static Term DEFAULT_ID_TERM = TermFactory.instance().findTerm("dwcaId");
    private Map<Term, String> defaultValues = Maps.newHashMap();

    public DwcTabularDataFileReader(TabularDataFileReader<List<String>> tabularDataFileReader, ArchiveField idField, List<ArchiveField> fields) {
        super(tabularDataFileReader, DwcTabularDataFileReader.buildColumnMapping(idField, fields));
        for (ArchiveField af : fields) {
            if (Strings.isNullOrEmpty((String)af.getDefaultValue())) continue;
            this.defaultValues.put(af.getTerm(), af.getDefaultValue());
        }
    }

    private static Term[] buildColumnMapping(ArchiveField idField, List<ArchiveField> dwcTerms) {
        TreeMap columnMapping = Maps.newTreeMap();
        columnMapping.put(idField.getIndex(), idField.getTerm() != null ? idField.getTerm() : DEFAULT_ID_TERM);
        for (ArchiveField af : dwcTerms) {
            if (af.getIndex() == null || af.getIndex() < 0) continue;
            columnMapping.put(af.getIndex(), af.getTerm());
        }
        return columnMapping.values().toArray(new Term[0]);
    }

    @Override
    public TermTabularDataLine read() throws IOException {
        TermTabularDataLine line = super.read();
        if (line == null) {
            return null;
        }
        if (this.defaultValues.isEmpty()) {
            return line;
        }
        HashMap mappedData = Maps.newHashMap(line.getMappedData());
        int numberOfColumn = line.getNumberOfColumn();
        for (Term term : this.defaultValues.keySet()) {
            if (mappedData.containsKey(term)) {
                if (!Strings.isNullOrEmpty((String)((String)mappedData.get(term)))) continue;
                mappedData.put(term, this.defaultValues.get(term));
                continue;
            }
            mappedData.put(term, this.defaultValues.get(term));
            ++numberOfColumn;
        }
        return new TermTabularDataLine(line.getLineNumber(), mappedData, numberOfColumn);
    }
}

