/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwca.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.gbif.api.model.registry.Dataset;
import org.gbif.dwc.terms.Term;
import org.gbif.dwca.io.Archive;
import org.gbif.dwca.io.ArchiveField;
import org.gbif.dwca.io.ArchiveFile;
import org.gbif.dwca.io.DwcaWriter;
import org.gbif.dwca.io.MetaDescriptorWriter;
import org.gbif.io.TabWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwcaStreamWriter
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DwcaStreamWriter.class);
    private final File dir;
    private final Term core;
    private final Term coreIdTerm;
    private final boolean useHeaders;
    private final Archive archive = new Archive();
    private Dataset metadata;
    private Map<String, Dataset> constituents = Maps.newHashMap();

    public DwcaStreamWriter(File dir, Term coreRowType, @Nullable Term coreIdTerm, boolean useHeaders) {
        this.dir = dir;
        this.core = coreRowType;
        this.coreIdTerm = coreIdTerm;
        this.useHeaders = useHeaders;
        this.archive.setLocation(dir);
    }

    private File dataFile(Term rowType) {
        return new File(this.dir, rowType.simpleName() + ".tsv");
    }

    private static ArchiveField idField(int column) {
        ArchiveField field = new ArchiveField();
        field.setIndex(column);
        return field;
    }

    public void write(Term rowType, int coreIdColumn, Map<Term, Integer> mapping, Iterable<String[]> rows) {
        Preconditions.checkNotNull(rows);
        int maxMapping = this.maxMappingColumn(mapping);
        try (TabWriter writer = this.addArchiveFile(rowType, coreIdColumn, mapping, maxMapping);){
            for (String[] row : rows) {
                DwcaStreamWriter.write(writer, row, maxMapping);
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private static void write(TabWriter writer, String[] row, int maxMapping) throws IOException {
        if (row != null && row.length < maxMapping) {
            throw new IllegalArgumentException("Input rows are smaller than the defined mapping of " + maxMapping + " columns.");
        }
        writer.write(row);
    }

    private int maxMappingColumn(Map<Term, Integer> mapping) {
        return mapping.values().stream().max(Integer::compareTo).get();
    }

    private TabWriter addArchiveFile(Term rowType, int coreIdColumn, Map<Term, Integer> mapping, int maxMapping) throws IOException {
        Preconditions.checkNotNull((Object)rowType);
        Preconditions.checkNotNull(mapping);
        Preconditions.checkArgument((!mapping.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((coreIdColumn >= 0 ? 1 : 0) != 0);
        File dataFile = this.dataFile(rowType);
        ArchiveFile af = ArchiveFile.buildTabFile();
        af.setEncoding("UTF8");
        af.setRowType(rowType);
        af.addLocation(dataFile.getName());
        af.setIgnoreHeaderLines(this.useHeaders ? 1 : 0);
        af.setId(DwcaStreamWriter.idField(coreIdColumn));
        for (Map.Entry<Term, Integer> entry : mapping.entrySet()) {
            ArchiveField field = new ArchiveField();
            field.setTerm(entry.getKey());
            field.setIndex(entry.getValue());
            af.addField(field);
        }
        if (this.core.equals(rowType)) {
            if (this.coreIdTerm != null) {
                af.getId().setTerm(this.coreIdTerm);
            }
            this.archive.setCore(af);
        } else {
            this.archive.addExtension(af);
        }
        TabWriter writer = TabWriter.fromFile(dataFile);
        if (this.useHeaders) {
            String[] header = new String[maxMapping + 1];
            mapping.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(e -> {
                header[((Integer)e.getValue()).intValue()] = ((Term)e.getKey()).simpleName();
            });
            if (this.coreIdTerm != null) {
                header[0] = this.coreIdTerm.simpleName();
            }
            writer.write(header);
        }
        return writer;
    }

    public RowWriteHandler writeHandler(Term rowType, int coreIdColumn, Map<Term, Integer> mapping) {
        try {
            int maxMapping = this.maxMappingColumn(mapping);
            TabWriter writer = this.addArchiveFile(rowType, coreIdColumn, mapping, maxMapping);
            return new RowWriteHandlerImpl(writer, maxMapping);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setMetadata(Dataset d) {
        this.metadata = d;
    }

    public void addConstituent(Dataset eml) {
        this.addConstituent(eml.getKey().toString(), eml);
    }

    public void addConstituent(String datasetID, Dataset eml) {
        this.constituents.put(datasetID, eml);
    }

    @Override
    public void close() throws IOException {
        this.checkCoreRowType();
        this.addEml();
        this.addConstituents();
        MetaDescriptorWriter.writeMetaFile(this.archive);
        LOG.info("Wrote archive to {}", (Object)this.archive.getLocation().getAbsolutePath());
    }

    private void checkCoreRowType() {
        if (this.archive.getCore() == null) {
            throw new IllegalStateException("The core data file has not yet been written for " + this.core.qualifiedName());
        }
    }

    private void addEml() throws IOException {
        if (this.metadata != null) {
            DwcaWriter.writeEml(this.metadata, new File(this.dir, "eml.xml"));
            this.archive.setMetadataLocation("eml.xml");
        }
    }

    private void addConstituents() throws IOException {
        if (!this.constituents.isEmpty()) {
            File ddir = new File(this.dir, "dataset");
            ddir.mkdirs();
            for (Map.Entry<String, Dataset> de : this.constituents.entrySet()) {
                DwcaWriter.writeEml(de.getValue(), new File(ddir, de.getKey() + ".xml"));
            }
        }
    }

    private class RowWriteHandlerImpl
    implements RowWriteHandler {
        private final TabWriter writer;
        private final int minColumns;

        RowWriteHandlerImpl(TabWriter writer, int minColumns) {
            this.writer = writer;
            this.minColumns = minColumns;
        }

        @Override
        public void write(String[] row) {
            if (row != null && row.length < this.minColumns) {
                throw new IllegalArgumentException("Input rows are smaller than the defined mapping of " + this.minColumns + " columns.");
            }
            try {
                this.writer.write(row);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    public static interface RowWriteHandler
    extends AutoCloseable {
        public void write(String[] var1);
    }
}

