/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.meta;

import com.google.common.base.Strings;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.dwca.io.Archive;
import org.gbif.dwca.io.ArchiveField;
import org.gbif.dwca.io.ArchiveFile;
import org.gbif.dwca.io.SimpleSaxHandler;
import org.gbif.dwca.io.UnsupportedArchiveException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class MetaXMLSaxHandler
extends SimpleSaxHandler {
    private static final TermFactory TERM_FACTORY = TermFactory.instance();
    private static final String NS_DWCA = "http://rs.tdwg.org/dwc/text/";
    private final Archive archive;
    private ArchiveFile af;

    MetaXMLSaxHandler(Archive archive) {
        this.archive = archive;
    }

    private static Character getFirstChar(String x) throws UnsupportedArchiveException {
        if (x == null || x.length() == 0) {
            return null;
        }
        if (x.length() == 1) {
            return Character.valueOf(x.charAt(0));
        }
        if (x.equalsIgnoreCase("\\t")) {
            return Character.valueOf('\t');
        }
        if (x.equalsIgnoreCase("\\n")) {
            return Character.valueOf('\n');
        }
        if (x.equalsIgnoreCase("\\r")) {
            return Character.valueOf('\r');
        }
        if (x.length() > 1) {
            throw new UnsupportedArchiveException("Only darwin core archives with a single quotation character are supported, but found >>>" + x + "<<<");
        }
        return Character.valueOf(' ');
    }

    private static String unescapeBackslash(String x) {
        if (x == null || x.length() == 0) {
            return null;
        }
        return x.replaceAll("\\\\t", String.valueOf('\t')).replaceAll("\\\\n", String.valueOf('\n')).replaceAll("\\\\r", String.valueOf('\r')).replaceAll("\\\\f", String.valueOf('\f'));
    }

    private ArchiveFile buildArchiveFile(Attributes attr) throws UnsupportedArchiveException {
        ArchiveFile dwcFile = new ArchiveFile();
        if (MetaXMLSaxHandler.getAttr(attr, "encoding") != null) {
            dwcFile.setEncoding(MetaXMLSaxHandler.getAttr(attr, "encoding"));
        }
        if (MetaXMLSaxHandler.getAttr(attr, "fieldsTerminatedBy") != null) {
            dwcFile.setFieldsTerminatedBy(MetaXMLSaxHandler.unescapeBackslash(MetaXMLSaxHandler.getAttr(attr, "fieldsTerminatedBy")));
        }
        if (MetaXMLSaxHandler.getAttr(attr, "fieldsEnclosedBy") != null) {
            dwcFile.setFieldsEnclosedBy(MetaXMLSaxHandler.getFirstChar(MetaXMLSaxHandler.getAttr(attr, "fieldsEnclosedBy")));
        } else if (MetaXMLSaxHandler.getAttrRaw(attr, "fieldsEnclosedBy") != null) {
            dwcFile.setFieldsEnclosedBy(null);
        }
        if (MetaXMLSaxHandler.getAttr(attr, "linesTerminatedBy") != null) {
            dwcFile.setLinesTerminatedBy(MetaXMLSaxHandler.unescapeBackslash(MetaXMLSaxHandler.getAttr(attr, "linesTerminatedBy")));
        }
        if (MetaXMLSaxHandler.getAttr(attr, "rowType") != null) {
            dwcFile.setRowType(TERM_FACTORY.findTerm(MetaXMLSaxHandler.getAttr(attr, "rowType")));
        }
        String ignoreHeaderLines = MetaXMLSaxHandler.getAttr(attr, "ignoreHeaderLines");
        try {
            dwcFile.setIgnoreHeaderLines(Integer.parseInt(ignoreHeaderLines));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return dwcFile;
    }

    private ArchiveField buildField(Attributes attributes) {
        Term term = TERM_FACTORY.findTerm(MetaXMLSaxHandler.getAttr(attributes, "term"));
        String defaultValue = MetaXMLSaxHandler.getAttr(attributes, "default");
        String vocabulary = MetaXMLSaxHandler.getAttr(attributes, "vocabulary");
        ArchiveField.DataType type = ArchiveField.DataType.findByXmlSchemaType(MetaXMLSaxHandler.getAttr(attributes, "type"));
        if (type == null) {
            type = ArchiveField.DataType.string;
        }
        String indexAsString = MetaXMLSaxHandler.getAttr(attributes, "index");
        Integer index = null;
        if (indexAsString != null) {
            try {
                index = Integer.parseInt(indexAsString);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedArchiveException(e);
            }
        }
        String delimiter = MetaXMLSaxHandler.getAttr(attributes, "delimitedBy");
        return new ArchiveField(index, term, defaultValue, type, delimiter, vocabulary);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (!localName.equalsIgnoreCase("archive")) {
            if (localName.equalsIgnoreCase("core")) {
                this.archive.setCore(this.af);
            } else if (localName.equalsIgnoreCase("extension")) {
                if (this.af.getId() != null && this.af.getId().getIndex() != null) {
                    this.archive.addExtension(this.af);
                } else {
                    this.log.warn("Skipping extension [" + this.af.getRowType() + "] with no index attribute");
                }
            } else if (localName.equalsIgnoreCase("location")) {
                this.af.addLocation(this.content);
            }
        }
    }

    private static String getAttr(Attributes attributes, String key) {
        return Strings.emptyToNull((String)MetaXMLSaxHandler.getAttrRaw(attributes, key));
    }

    private static String getAttrRaw(Attributes attributes, String key) {
        String val = null;
        if (attributes != null && (val = attributes.getValue("", key)) == null) {
            val = attributes.getValue(NS_DWCA, key);
        }
        return val;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (localName.equalsIgnoreCase("archive") || localName.equalsIgnoreCase("stararchive")) {
            this.archive.setMetadataLocation(MetaXMLSaxHandler.getAttr(attributes, "metadata"));
        } else if (localName.equalsIgnoreCase("core") || localName.equalsIgnoreCase("extension")) {
            this.af = new ArchiveFile();
            if (localName.equalsIgnoreCase("core") || localName.equalsIgnoreCase("extension")) {
                this.af = this.buildArchiveFile(attributes);
            }
        } else if (localName.equalsIgnoreCase("coreid") || localName.equalsIgnoreCase("id")) {
            ArchiveField field = this.buildField(attributes);
            if (this.af != null) {
                this.af.setId(field);
            } else {
                this.log.warn(localName + " field found outside of an archive file");
            }
        } else if (localName.equalsIgnoreCase("field")) {
            ArchiveField field = this.buildField(attributes);
            if (this.af != null) {
                this.af.addField(field);
            } else {
                this.log.warn("field found outside of an archive file");
            }
        }
    }
}

