/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.meta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.input.BOMInputStream;
import org.gbif.dwc.meta.MetaXMLSaxHandler;
import org.gbif.dwca.io.Archive;
import org.gbif.dwca.io.UnsupportedArchiveException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DwcMetaFiles {
    private static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();
    private static final List<String> POSSIBLE_METADATA_FILE;

    private DwcMetaFiles() {
    }

    public static Archive fromMetaDescriptor(InputStream metaDescriptor) throws SAXException, IOException, UnsupportedArchiveException {
        Archive archive = new Archive();
        try (BOMInputStream bomInputStream = new BOMInputStream(metaDescriptor);){
            SAXParser p = SAX_FACTORY.newSAXParser();
            MetaXMLSaxHandler mh = new MetaXMLSaxHandler(archive);
            p.parse((InputStream)bomInputStream, (DefaultHandler)mh);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        return archive;
    }

    public static Optional<String> discoverMetadataFile(Path dwcLocation) {
        if (Files.isRegularFile(dwcLocation, new LinkOption[0])) {
            String possibleEml = dwcLocation.getFileName().toString();
            return POSSIBLE_METADATA_FILE.contains(possibleEml) ? Optional.of(possibleEml) : Optional.empty();
        }
        for (String metadataFN : POSSIBLE_METADATA_FILE) {
            File emlFile = new File(dwcLocation.toFile(), metadataFN);
            if (!emlFile.exists()) continue;
            return Optional.of(metadataFN);
        }
        return Optional.empty();
    }

    static {
        SAX_FACTORY.setNamespaceAware(true);
        SAX_FACTORY.setValidating(false);
        POSSIBLE_METADATA_FILE = Collections.unmodifiableList(Arrays.asList("eml.xml", "metadata.xml"));
    }
}

