/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gbif.dwc.DwcRecordIterator;
import org.gbif.dwc.InternalDwcFileFactory;
import org.gbif.dwc.NormalizedDwcArchive;
import org.gbif.dwc.terms.Term;
import org.gbif.dwca.io.Archive;
import org.gbif.dwca.io.ArchiveFile;
import org.gbif.dwca.io.UnsupportedArchiveException;
import org.gbif.dwca.record.Record;
import org.gbif.utils.file.ClosableIterator;
import org.gbif.utils.file.FileUtils;
import org.gbif.utils.file.tabular.TabularDataFileReader;
import org.gbif.utils.file.tabular.TabularFileNormalizer;
import org.gbif.utils.file.tabular.TabularFiles;

public class DwcFiles {
    private static final FileUtils F_UTILS = new FileUtils();

    private DwcFiles() {
    }

    public static Archive fromLocation(Path dwcLocation) throws IOException, UnsupportedArchiveException {
        return InternalDwcFileFactory.fromLocation(dwcLocation);
    }

    public static Archive fromCompressed(Path dwcaLocation, Path destination) throws IOException, UnsupportedArchiveException {
        return InternalDwcFileFactory.fromCompressed(dwcaLocation, destination);
    }

    public static ClosableIterator<Record> iterator(ArchiveFile source) throws IOException {
        return DwcFiles.iterator(source, true, true);
    }

    public static ClosableIterator<Record> iterator(ArchiveFile source, boolean replaceNulls, boolean replaceEntities) throws IOException {
        Objects.requireNonNull(source, "source ArchiveFile shall be provided");
        TabularDataFileReader tabularFileReader = TabularFiles.newTabularFileReader((Reader)Files.newBufferedReader(source.getLocationFile() != null ? source.getLocationFile().toPath() : source.getArchive().getLocation().toPath()), (char)DwcFiles.getFieldsTerminatedBy(source.getFieldsTerminatedBy()), (String)source.getLinesTerminatedBy(), (Character)source.getFieldsEnclosedBy(), (boolean)DwcFiles.isHeaderLineIncluded(source.getIgnoreHeaderLines()), (Integer)DwcFiles.getLineToSkipBeforeHeader(source.getIgnoreHeaderLines()));
        return new DwcRecordIterator((TabularDataFileReader<List<String>>)tabularFileReader, source.getId(), source.getFields(), source.getRowType(), replaceNulls, replaceEntities);
    }

    private static char getFieldsTerminatedBy(String fieldsTerminatedBy) {
        Objects.requireNonNull(fieldsTerminatedBy, "fieldsTerminatedBy shall be provided");
        if (fieldsTerminatedBy.length() != 1) {
            throw new IllegalArgumentException();
        }
        return fieldsTerminatedBy.charAt(0);
    }

    private static boolean isHeaderLineIncluded(Integer ignoreHeaderLines) {
        return ignoreHeaderLines != null && ignoreHeaderLines > 0;
    }

    private static Integer getLineToSkipBeforeHeader(Integer ignoreHeaderLines) {
        if (ignoreHeaderLines != null && ignoreHeaderLines > 1) {
            return ignoreHeaderLines - 1;
        }
        return null;
    }

    public static NormalizedDwcArchive prepareArchive(Archive archive) throws IOException {
        return DwcFiles.prepareArchive(archive, true, true);
    }

    public static NormalizedDwcArchive prepareArchive(Archive archive, boolean replaceNulls, boolean replaceEntities) throws IOException {
        Objects.requireNonNull(archive, "archive shall be provided");
        Objects.requireNonNull(archive.getCore(), "The archive shall have a core");
        if (archive.getExtensions().isEmpty()) {
            return new NormalizedDwcArchive(() -> DwcFiles.iterator(archive.getCore(), replaceNulls, replaceEntities));
        }
        DwcFiles.normalizeAndSortArchiveFiles(archive);
        return new NormalizedDwcArchive(() -> DwcFiles.buildSortedIterator(archive.getCore(), replaceNulls, replaceEntities), () -> DwcFiles.buildSortedIteratorExt(archive, replaceNulls, replaceEntities));
    }

    private static void normalizeAndSortArchiveFiles(Archive archive) throws IOException {
        DwcFiles.normalizeAndSort(archive.getCore());
        for (ArchiveFile archiveFile : archive.getExtensions()) {
            DwcFiles.normalizeAndSort(archiveFile);
        }
    }

    @VisibleForTesting
    protected static boolean normalizeAndSort(ArchiveFile archiveFile) throws IOException {
        File fileToSort = archiveFile.getLocationFile();
        File sortedFile = ArchiveFile.getLocationFileSorted(archiveFile.getLocationFile());
        if (sortedFile.exists() && Files.getLastModifiedTime(sortedFile.toPath(), new LinkOption[0]).toInstant().isAfter(Files.getLastModifiedTime(fileToSort.toPath(), new LinkOption[0]).toInstant())) {
            return false;
        }
        File normalizedFile = DwcFiles.normalizeIfRequired(archiveFile);
        if (normalizedFile != null) {
            fileToSort = normalizedFile;
        }
        F_UTILS.sort(fileToSort, ArchiveFile.getLocationFileSorted(archiveFile.getLocationFile()), archiveFile.getEncoding(), archiveFile.getId().getIndex().intValue(), archiveFile.getFieldsTerminatedBy(), archiveFile.getFieldsEnclosedBy(), TabularFileNormalizer.NORMALIZED_END_OF_LINE, archiveFile.getIgnoreHeaderLines().intValue());
        if (normalizedFile != null) {
            Files.deleteIfExists(normalizedFile.toPath());
        }
        return true;
    }

    @VisibleForTesting
    protected static File normalizeIfRequired(ArchiveFile archiveFile) throws IOException {
        boolean normalizationRequired;
        boolean bl = normalizationRequired = !TabularFileNormalizer.NORMALIZED_END_OF_LINE.equals(archiveFile.getLinesTerminatedBy()) || archiveFile.getFieldsEnclosedBy() != null;
        if (normalizationRequired) {
            File normalizedFile = DwcFiles.getLocationFileNormalized(archiveFile.getLocationFile());
            TabularFileNormalizer.normalizeFile((Path)archiveFile.getLocationFile().toPath(), (Path)normalizedFile.toPath(), (Charset)Charset.forName(archiveFile.getEncoding()), (char)DwcFiles.getFieldsTerminatedBy(archiveFile.getFieldsTerminatedBy()), (String)archiveFile.getLinesTerminatedBy(), (Character)archiveFile.getFieldsEnclosedBy());
            return normalizedFile;
        }
        return null;
    }

    private static File getLocationFileNormalized(File location) {
        return new File(location.getParentFile(), location.getName() + "-normalized");
    }

    private static Map<Term, ClosableIterator<Record>> buildSortedIteratorExt(Archive archive, boolean replaceNulls, boolean replaceEntities) throws IOException {
        HashMap<Term, ClosableIterator<Record>> extensionIts = new HashMap<Term, ClosableIterator<Record>>();
        for (ArchiveFile ext : archive.getExtensions()) {
            extensionIts.put(ext.getRowType(), DwcFiles.buildSortedIterator(ext, replaceNulls, replaceEntities));
        }
        return extensionIts;
    }

    private static ClosableIterator<Record> buildSortedIterator(ArchiveFile af, boolean replaceNulls, boolean replaceEntities) throws IOException {
        TabularDataFileReader tabularFileReader = TabularFiles.newTabularFileReader((Reader)Files.newBufferedReader(ArchiveFile.getLocationFileSorted(af.getLocationFile()).toPath()), (char)DwcFiles.getFieldsTerminatedBy(af.getFieldsTerminatedBy()), (String)TabularFileNormalizer.NORMALIZED_END_OF_LINE, (Character)af.getFieldsEnclosedBy(), (boolean)DwcFiles.isHeaderLineIncluded(af.getIgnoreHeaderLines()), (Integer)DwcFiles.getLineToSkipBeforeHeader(af.getIgnoreHeaderLines()));
        return new DwcRecordIterator((TabularDataFileReader<List<String>>)tabularFileReader, af.getId(), af.getFields(), af.getRowType(), replaceNulls, replaceEntities);
    }
}

