/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.search;

import au.org.ala.names.lucene.analyzer.LowerCaseKeywordAnalyzer;
import au.org.ala.names.model.ALAParsedName;
import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.SynonymType;
import au.org.ala.names.search.ALANameSearcher;
import au.org.ala.names.search.NameIndexField;
import au.org.ala.names.util.CleanedScientificName;
import au.org.ala.names.util.TaxonNameSoundEx;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.gbif.api.exception.UnparsableException;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.Rank;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwca.io.Archive;
import org.gbif.dwca.io.ArchiveFactory;
import org.gbif.dwca.record.Record;
import org.gbif.nameparser.PhraseNameParser;

public class ALANameIndexer {
    private String extraALAConcepts = "/data/bie-staging/ala-names/ala-extra.txt";
    private String alaConcepts = "/data/bie-staging/ala-names/ala_accepted_concepts_dump.txt";
    private String alaSynonyms = "/data/bie-staging/ala-names/ala_synonyms_dump.txt";
    private String irmngDwcaDirectory = "/data/bie-staging/irmng/IRMNG_DWC_HOMONYMS";
    private String colFile = "/data/bie-staging/ala-names/col_common_names.txt";
    private String afdFile = "/data/bie-staging/anbg/AFD-common-names.csv";
    private String apniFile = "/data/bie-staging/anbg/APNI-common-names.csv";
    private Log log = LogFactory.getLog(ALANameIndexer.class);
    private IndexSearcher idSearcher;
    private final int POS_ID = 0;
    private final int POS_PARENT_ID = 1;
    private final int POS_LSID = 2;
    private final int POS_PARETN_LSID = 3;
    private final int POS_ACC_LSID = 4;
    private final int POS_NAME_LSID = 5;
    private final int POS_SCI_NAME = 6;
    private final int POS_GENUS_OR_HIGHER = 7;
    private final int POS_SP_EPITHET = 8;
    private final int POS_INFRA_EPITHET = 9;
    private final int POS_AUTHOR = 10;
    private final int POS_AUTHOR_YEAR = 11;
    private final int POS_RANK_ID = 12;
    private final int POS_RANK = 13;
    private final int POS_LFT = 14;
    private final int POS_RGT = 15;
    private final int POS_KID = 16;
    private final int POS_K = 17;
    private final int POS_PID = 18;
    private final int POS_P = 19;
    private final int POS_CID = 20;
    private final int POS_C = 21;
    private final int POS_OID = 22;
    private final int POS_O = 23;
    private final int POS_FID = 24;
    private final int POS_F = 25;
    private final int POS_GID = 26;
    private final int POS_G = 27;
    private final int POS_SID = 28;
    private final int POS_S = 29;
    private final int POS_SRC = 30;
    private final int POS_EXCLUDED = 36;
    private String indexDirectory;
    private IndexWriter cbIndexWriter;
    PhraseNameParser parser = new PhraseNameParser();
    Set<String> knownHomonyms = new HashSet<String>();
    Set<String> blacklist = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        LineIterator lines = new LineIterator((Reader)new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResource("au/org/ala/propertystore/known_homonyms.txt").openStream(), "ISO-8859-1")));
        LineIterator blines = new LineIterator((Reader)new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResource("blacklist.txt").openStream())));
        try {
            String line;
            while (lines.hasNext()) {
                line = lines.nextLine().trim();
                this.knownHomonyms.add(line.toUpperCase());
            }
            while (blines.hasNext()) {
                line = blines.nextLine().trim();
                if (line.startsWith("#") || !StringUtils.isNotBlank((CharSequence)line)) continue;
                this.blacklist.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            lines.close();
            blines.close();
        }
    }

    public void createIndex(String exportsDir, String indexDir, boolean generateSciNames, boolean generateCommonNames) throws Exception {
        this.createIndex(exportsDir, indexDir, this.alaConcepts, this.alaSynonyms, this.irmngDwcaDirectory, generateSciNames, generateCommonNames);
    }

    public void createIrmngIndex(String exportsDir, String indexDir) throws Exception {
        Analyzer analyzer = LowerCaseKeywordAnalyzer.newInstance();
        IndexWriter irmngWriter = this.createIndexWriter(new File(indexDir + File.separator + "irmng"), analyzer, true);
        this.indexIrmngDwcA(irmngWriter, this.irmngDwcaDirectory);
        this.indexIRMNG(irmngWriter, exportsDir + File.separator + "ala-species-homonyms.txt", RankType.SPECIES);
        irmngWriter.forceMerge(1);
        irmngWriter.close();
    }

    public void createIndex(String exportsDir, String indexDir, String acceptedFile, String synonymFile, String irmngDwca, boolean generateSciNames, boolean generateCommonNames) throws Exception {
        Analyzer analyzer = LowerCaseKeywordAnalyzer.newInstance();
        this.createExtraIdIndex(indexDir + File.separator + "id", new File(exportsDir + File.separator + "identifiers.txt"));
        if (generateSciNames) {
            this.indexALA(this.createIndexWriter(new File(indexDir + File.separator + "cb"), analyzer, true), acceptedFile, synonymFile);
            IndexWriter irmngWriter = this.createIndexWriter(new File(indexDir + File.separator + "irmng"), analyzer, true);
            this.indexIrmngDwcA(irmngWriter, irmngDwca);
            this.indexIRMNG(irmngWriter, exportsDir + File.separator + "ala-species-homonyms.txt", RankType.SPECIES);
            irmngWriter.forceMerge(1);
            irmngWriter.close();
        }
        if (generateCommonNames) {
            this.indexCommonNames(this.createIndexWriter(new File(indexDir + File.separator + "vernacular"), (Analyzer)new KeywordAnalyzer(), true), exportsDir, indexDir);
        }
    }

    private IndexSearcher createTmpGuidIndex(String cbExportFile) throws Exception {
        System.out.println("Starting to create the tmp guid index...");
        IndexWriter iw = this.createIndexWriter(new File("/data/tmp/guid"), (Analyzer)new KeywordAnalyzer(), true);
        CSVReader cbreader = this.buildCSVReader(cbExportFile, '\t', '\\', '\"', 1);
        String[] values = cbreader.readNext();
        while (values != null) {
            Document doc = new Document();
            String id = values[0];
            String guid = values[2];
            NameIndexField.ID.store((Object)id, doc);
            if (StringUtils.isEmpty((CharSequence)id)) {
                guid = id;
            }
            NameIndexField.GUID.store((Object)guid, doc);
            iw.addDocument((Iterable)doc);
            values = cbreader.readNext();
        }
        System.out.println("Finished writing the tmp guid index...");
        iw.commit();
        iw.forceMerge(1);
        iw.close();
        return new IndexSearcher((IndexReader)DirectoryReader.open((Directory)FSDirectory.open((Path)new File("/data/tmp/guid").toPath())));
    }

    protected IndexWriter createIndexWriter(File directory, Analyzer analyzer, boolean replace) throws Exception {
        IndexWriterConfig conf = new IndexWriterConfig(analyzer);
        if (replace) {
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        if (directory.exists() && replace) {
            FileUtils.forceDelete((File)directory);
        }
        FileUtils.forceMkdir((File)directory);
        return new IndexWriter((Directory)FSDirectory.open((Path)directory.toPath()), conf);
    }

    private void addExtraALAConcept(IndexWriter iw, String file) throws Exception {
        if (new File(file).exists()) {
            CSVReader reader = this.buildCSVReader(file, ',', '\"', '\\', 1);
            String[] values = reader.readNext();
            while (values != null) {
                String lsid = values[0];
                String scientificName = values[1];
                String authority = values[2];
                Document doc = this.createALAIndexDocument(scientificName, "-1", lsid, authority, null);
                iw.addDocument((Iterable)doc);
                values = reader.readNext();
            }
        }
    }

    private void addALASyonyms(IndexWriter iw, String file) throws Exception {
        CSVReader reader = this.buildCSVReader(file, '\t', '\"', '\\', 1);
        String[] values = reader.readNext();
        while (values != null) {
            String source = values[11];
            int priority = source.trim().equals("") || source.equalsIgnoreCase("CoL") ? 750 : 1000;
            Document doc = this.createALASynonymDocument(values[5], values[6], null, null, values[0], values[1], values[2], values[3], values[4], priority, values[9]);
            if (doc != null) {
                iw.addDocument((Iterable)doc);
            }
            values = reader.readNext();
        }
    }

    private void indexALA(IndexWriter iw, String file, String synonymFile) throws Exception {
        int records = 0;
        long time = System.currentTimeMillis();
        CSVReader reader = this.buildCSVReader(file, '\t', '\"', '\\', 1);
        String[] values = reader.readNext();
        while (values != null) {
            String source;
            String lsid = values[2];
            String id = values[0];
            int rankId = -1;
            try {
                rankId = Integer.parseInt(values[12]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String acceptedValues = values[4];
            float boost = 1.0f;
            if (rankId % 1000 != 0) {
                boost *= 0.2f;
            }
            if ((source = values[30]).trim().equals("") || source.equalsIgnoreCase("CoL")) {
                boost *= 0.5f;
            }
            int priority = Math.round(boost * 1000.0f);
            Document doc = this.createALAIndexDocument(values[6], id, lsid, values[12], values[13], values[17], values[16], values[19], values[18], values[21], values[20], values[23], values[22], values[25], values[24], values[27], values[26], values[29], values[28], Integer.parseInt(values[14]), Integer.parseInt(values[15]), acceptedValues, values[8], values[9], values[10], null, null, priority);
            if ("T".equals(values[36]) || "Y".equals(values[36])) {
                NameIndexField.SYNONYM_TYPE.store((Object)SynonymType.EXCLUDES.getId().toString(), doc);
            }
            if (doc != null) {
                iw.addDocument((Iterable)doc);
                if (++records % 100000 == 0) {
                    this.log.info((Object)("Processed " + records + " in " + (System.currentTimeMillis() - time) + " msecs"));
                }
            }
            values = reader.readNext();
        }
        this.addExtraALAConcept(iw, this.extraALAConcepts);
        this.addALASyonyms(iw, synonymFile);
        iw.commit();
        iw.forceMerge(1);
        iw.close();
        this.log.info((Object)("Lucene index created - processed a total of " + records + " records in " + (System.currentTimeMillis() - time) + " msecs "));
    }

    public void addAdditionalName(String lsid, String scientificName, String author, LinnaeanRankClassification cl) throws Exception {
        if (this.cbIndexWriter == null) {
            this.cbIndexWriter = this.createIndexWriter(new File(this.indexDirectory + File.separator + "cb"), LowerCaseKeywordAnalyzer.newInstance(), false);
        }
        Document doc = this.createALAIndexDocument(scientificName, "-1", lsid, author, cl);
        this.cbIndexWriter.addDocument((Iterable)doc);
    }

    public void deleteName(String lsid) throws Exception {
        if (this.cbIndexWriter == null) {
            this.cbIndexWriter = this.createIndexWriter(new File(this.indexDirectory + File.separator + "cb"), LowerCaseKeywordAnalyzer.newInstance(), false);
        }
        Term term = new Term("lsid", lsid);
        this.cbIndexWriter.deleteDocuments(new Query[]{new TermQuery(term)});
        term = new Term("accepted_lsid", lsid);
        this.cbIndexWriter.deleteDocuments(new Query[]{new TermQuery(term)});
    }

    public void commit() throws Exception {
        this.commit(false, false);
    }

    public void commit(boolean close, boolean merge) throws Exception {
        if (this.cbIndexWriter != null) {
            this.cbIndexWriter.commit();
            if (merge) {
                this.cbIndexWriter.forceMerge(1);
            }
            if (close) {
                this.cbIndexWriter.close();
            }
        }
    }

    protected void indexIrmngDwcA(IndexWriter iw, String archiveDirectory) throws Exception {
        this.log.info((Object)("Creating the IRMNG index from the DWCA " + archiveDirectory));
        Archive archive = ArchiveFactory.openArchive((File)new File(archiveDirectory));
        for (Record dwcr : archive.getCore()) {
            String rank;
            String family;
            String order;
            String classs;
            String phylum;
            String taxonomicStatus = dwcr.value((org.gbif.dwc.terms.Term)DwcTerm.taxonomicStatus);
            if (taxonomicStatus == null || !taxonomicStatus.equalsIgnoreCase("accepted")) continue;
            Document doc = new Document();
            String kingdom = dwcr.value((org.gbif.dwc.terms.Term)DwcTerm.kingdom);
            if (StringUtils.isNotEmpty((CharSequence)kingdom)) {
                NameIndexField.KINGDOM.store((Object)kingdom, doc);
            }
            if (StringUtils.isNotEmpty((CharSequence)(phylum = dwcr.value((org.gbif.dwc.terms.Term)DwcTerm.phylum)))) {
                NameIndexField.PHYLUM.store((Object)phylum, doc);
            }
            if (StringUtils.isNotEmpty((CharSequence)(classs = dwcr.value((org.gbif.dwc.terms.Term)DwcTerm.class_)))) {
                NameIndexField.CLASS.store((Object)classs, doc);
            }
            if (StringUtils.isNotEmpty((CharSequence)(order = dwcr.value((org.gbif.dwc.terms.Term)DwcTerm.order)))) {
                NameIndexField.ORDER.store((Object)order, doc);
            }
            if (StringUtils.isNotEmpty((CharSequence)(family = dwcr.value((org.gbif.dwc.terms.Term)DwcTerm.family)))) {
                NameIndexField.FAMILY.store((Object)kingdom, doc);
            }
            String genus = dwcr.value((org.gbif.dwc.terms.Term)DwcTerm.genus);
            String calculatedRank = "genus";
            if (StringUtils.isNotEmpty((CharSequence)genus)) {
                NameIndexField.GENUS.store((Object)genus, doc);
                String specificEpithet = dwcr.value((org.gbif.dwc.terms.Term)DwcTerm.specificEpithet);
                if (StringUtils.isNotEmpty((CharSequence)specificEpithet)) {
                    calculatedRank = "species";
                    NameIndexField.SPECIES.store((Object)(genus + " " + specificEpithet), doc);
                }
            }
            if (StringUtils.isEmpty((CharSequence)(rank = dwcr.value((org.gbif.dwc.terms.Term)DwcTerm.taxonRank)))) {
                rank = calculatedRank;
            }
            NameIndexField.RANK.store((Object)rank, doc);
            String author = dwcr.value((org.gbif.dwc.terms.Term)DwcTerm.scientificNameAuthorship);
            if (StringUtils.isNotEmpty((CharSequence)author)) {
                NameIndexField.AUTHOR.store((Object)author, doc);
            }
            iw.addDocument((Iterable)doc);
        }
    }

    void indexIRMNG(IndexWriter iw, String irmngExport, RankType rank) throws Exception {
        this.log.info((Object)"Creating IRMNG index ...");
        File file = new File(irmngExport);
        if (file.exists()) {
            CSVReader reader = this.buildCSVReader(irmngExport, '\t', '\"', '~', 0);
            int count = 0;
            String[] values = null;
            while ((values = reader.readNext()) != null) {
                Document doc = new Document();
                if (values == null || values.length < 7) continue;
                NameIndexField.KINGDOM.store((Object)values[0], doc);
                NameIndexField.PHYLUM.store((Object)values[1], doc);
                NameIndexField.CLASS.store((Object)values[2], doc);
                NameIndexField.ORDER.store((Object)values[3], doc);
                NameIndexField.FAMILY.store((Object)values[4], doc);
                NameIndexField.GENUS.store((Object)values[5], doc);
                if (rank == RankType.GENUS) {
                    NameIndexField.ID.store((Object)values[6], doc);
                    NameIndexField.ACCEPTED.store((Object)values[8], doc);
                    NameIndexField.HOMONYM.store((Object)values[10], doc);
                } else if (rank == RankType.SPECIES) {
                    NameIndexField.SPECIES.store((Object)values[6], doc);
                }
                NameIndexField.RANK.store((Object)rank.getRank(), doc);
                iw.addDocument((Iterable)doc);
                ++count;
            }
            iw.commit();
            this.log.info((Object)("Finished indexing " + count + " IRMNG " + rank + " taxa."));
        } else {
            this.log.warn((Object)("Unable to create IRMNG index.  Can't locate " + irmngExport));
        }
    }

    private void indexCommonNames(IndexWriter iw, String exportDir, String indexDir) throws Exception {
        this.log.info((Object)"Creating Common Names Index ...");
        IndexSearcher currentNameSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)FSDirectory.open((Path)new File(indexDir + File.separator + "cb").toPath())));
        IndexSearcher extraSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)FSDirectory.open((Path)new File(indexDir + File.separator + "id").toPath())));
        this.addCoLCommonNames(iw, currentNameSearcher);
        this.addAnbgCommonNames(this.afdFile, iw, currentNameSearcher, extraSearcher, '\t');
        this.addAnbgCommonNames(this.apniFile, iw, currentNameSearcher, extraSearcher, ',');
        iw.commit();
        iw.forceMerge(1);
        iw.close();
    }

    private void addCoLCommonNames(IndexWriter iw, IndexSearcher currentSearcher) throws Exception {
        File fileCol = new File(this.colFile);
        if (fileCol.exists()) {
            CSVReader reader = this.buildCSVReader(this.colFile, ',', '\"', '~', 0);
            int count = 0;
            String[] values = null;
            while ((values = reader.readNext()) != null) {
                if (values.length != 3) continue;
                if (this.doesTaxonConceptExist(currentSearcher, values[2])) {
                    iw.addDocument((Iterable)this.createCommonNameDocument(values[0], values[1], values[2], null));
                    ++count;
                    continue;
                }
                System.out.println("Unable to locate LSID " + values[2] + " in current dump");
            }
            this.log.info((Object)("Finished indexing " + count + " common names from " + fileCol));
        } else {
            this.log.warn((Object)("Unable to index common names. Unable to locate : " + fileCol));
        }
    }

    private void addAnbgCommonNames(String fileName, IndexWriter iw, IndexSearcher currentSearcher, IndexSearcher idSearcher, char recordSep) throws Exception {
        File namesFile = new File(fileName);
        Pattern p = Pattern.compile(",");
        if (namesFile.exists()) {
            CSVReader reader = this.buildCSVReader(fileName, recordSep, '\"', '\\', 0);
            int count = 0;
            String[] values = reader.readNext();
            while ((values = reader.readNext()) != null) {
                if (values == null || values.length < 4) continue;
                if (this.doesTaxonConceptExist(currentSearcher, values[3]) || this.doesTaxonConceptExist(idSearcher, values[3])) {
                    String[] names;
                    if (!values[2].contains(",") || values[2].toLowerCase().contains(" and ")) {
                        iw.addDocument((Iterable)this.createCommonNameDocument(values[2], null, values[3], null));
                        ++count;
                        continue;
                    }
                    for (String name : names = p.split(values[2])) {
                        iw.addDocument((Iterable)this.createCommonNameDocument(name, null, values[3], null));
                        ++count;
                    }
                    continue;
                }
                System.out.println("Unable to locate LSID " + values[3] + " in current dump");
            }
            this.log.info((Object)("Finished indexing " + count + " common names from " + fileName));
        } else {
            this.log.warn((Object)("Unable to index common names. Unable to locate : " + fileName));
        }
    }

    protected void createExtraIdIndex(IndexWriter iw, File idFile) throws Exception {
        String[] values = null;
        if (idFile.exists()) {
            CSVReader reader = this.buildCSVReader(idFile.getPath(), '\t', '\"', '~', 0);
            while ((values = reader.readNext()) != null) {
                if (values == null || values.length < 3) continue;
                Document doc = this.createIdentifierDocument(values[2], null, values[1]);
                iw.addDocument((Iterable)doc);
            }
        }
        iw.flush();
        iw.commit();
        iw.forceMerge(1);
        this.idSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)iw.getDirectory()));
    }

    protected void createExtraIdIndex(String idxLocation, File idFile) throws Exception {
        File indexDir = new File(idxLocation);
        IndexWriter iw = this.createIndexWriter(indexDir, (Analyzer)new KeywordAnalyzer(), true);
        this.createExtraIdIndex(iw, idFile);
        iw.close();
    }

    private IndexSearcher createTmpIndex(String tcFileName) throws Exception {
        CSVReader reader = this.buildCSVReader(tcFileName, '\t', '\"', '~', 0);
        File indexDir = new File("/tmp/taxonConcept");
        IndexWriter iw = this.createIndexWriter(indexDir, (Analyzer)new KeywordAnalyzer(), true);
        String[] values = null;
        while ((values = reader.readNext()) != null) {
            if (values == null || values.length <= 1) continue;
            Document doc = new Document();
            NameIndexField.LSID.store((Object)values[0], doc);
            iw.addDocument((Iterable)doc);
        }
        iw.commit();
        iw.forceMerge(1);
        iw.close();
        return new IndexSearcher((IndexReader)DirectoryReader.open((Directory)FSDirectory.open((Path)indexDir.toPath())));
    }

    private boolean doesTaxonConceptExist(IndexSearcher is, String lsid) {
        TermQuery query = new TermQuery(new Term("lsid", lsid));
        try {
            TopDocs results = is.search((Query)query, 1);
            return results.totalHits.value > 0L;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String getAcceptedLSID(String value) {
        if (this.idSearcher != null) {
            try {
                TermQuery tq = new TermQuery(new Term("lsid", value));
                TopDocs results = this.idSearcher.search((Query)tq, 1);
                if (results.totalHits.value > 0L) {
                    return this.idSearcher.doc(results.scoreDocs[0].doc).get("reallsid");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return value;
    }

    protected Document createCommonNameDocument(String cn, String sn, String lsid, String language) {
        return this.createCommonNameDocument(cn, sn, lsid, language, true);
    }

    protected Document createCommonNameDocument(String cn, String sn, String lsid, String language, boolean checkAccepted) {
        Document doc = new Document();
        NameIndexField.SEARCHABLE_COMMON_NAME.store((Object)cn, doc);
        if (sn != null) {
            NameIndexField.NAME.store((Object)sn, doc);
        }
        String newLsid = this.getAcceptedLSID(lsid);
        NameIndexField.COMMON_NAME.store((Object)cn, doc);
        NameIndexField.LSID.store((Object)newLsid, doc);
        if (language != null) {
            NameIndexField.LANGUAGE.store((Object)language.toLowerCase().trim(), doc);
        }
        return doc;
    }

    protected Document createIdentifierDocument(String id, String sn, String lsid) {
        Document doc = new Document();
        if (sn != null) {
            NameIndexField.NAME.store((Object)sn, doc);
        }
        NameIndexField.LSID.store((Object)id, doc);
        NameIndexField.REAL_LSID.store((Object)lsid, doc);
        return doc;
    }

    public Document createALAIndexDocument(String name, String id, String lsid, String author, LinnaeanRankClassification cl) {
        return this.createALAIndexDocument(name, id, lsid, author, null, null, 0, 0, cl, null, null, 1000);
    }

    public Document createALAIndexDocument(String name, String id, String lsid, String author, String rank, String rankId, int left, int right, LinnaeanRankClassification cl, String nameComplete, Collection<String> otherNames, int priority) {
        if (cl == null) {
            cl = new LinnaeanRankClassification();
        }
        return this.createALAIndexDocument(name, id, lsid, rankId, rank, cl.getKingdom(), cl.getKid(), cl.getPhylum(), cl.getPid(), cl.getKlass(), cl.getCid(), cl.getOrder(), cl.getOid(), cl.getFamily(), cl.getFid(), cl.getGenus(), cl.getGid(), cl.getSpecies(), cl.getSid(), left, right, null, null, null, author, nameComplete, otherNames, priority);
    }

    protected Document createALASynonymDocument(String scientificName, String author, String nameComplete, Collection<String> otherNames, String id, String lsid, String nameLsid, String acceptedLsid, String acceptedId, int priority, String synonymType) {
        Document doc = this.createALAIndexDocument(scientificName, id, lsid = StringUtils.isBlank((CharSequence)lsid) ? nameLsid : lsid, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0, 0, acceptedLsid, null, null, author, nameComplete, otherNames, priority);
        if (doc != null && synonymType != null) {
            try {
                NameIndexField.SYNONYM_TYPE.store((Object)synonymType, doc);
            }
            catch (Exception e) {
                System.out.println("Error on " + scientificName + " " + author + " " + id + ".  " + e.getMessage());
            }
        }
        return doc;
    }

    private boolean isBlacklisted(String scientificName) {
        return scientificName == null || this.blacklist.contains(scientificName.trim());
    }

    protected Document createALAIndexDocument(String name, String id, String lsid, String rank, String rankString, String kingdom, String kid, String phylum, String pid, String clazz, String cid, String order, String oid, String family, String fid, String genus, String gid, String species, String sid, int left, int right, String acceptedConcept, String specificEpithet, String infraspecificEpithet, String author, String nameComplete, Collection<String> otherNames, int priority) {
        if (this.isBlacklisted(name)) {
            System.out.println(name + " has been blacklisted");
            return null;
        }
        int rankIndex = rank == null || rankString.isEmpty() ? -1 : Integer.parseInt(rank);
        nameComplete = this.buildNameComplete(name, author, nameComplete);
        CleanedScientificName cname = new CleanedScientificName(name);
        CleanedScientificName cnameComplete = new CleanedScientificName(nameComplete);
        Document doc = new Document();
        String soundexGenus = genus;
        NameIndexField.ID.store((Object)id, doc);
        NameIndexField.LSID.store((Object)lsid, doc);
        if (lsid.startsWith("ALA")) {
            NameIndexField.ALA.store((Object)"T", doc);
        }
        HashSet<String> nameSet = otherNames != null ? new HashSet<String>(otherNames) : new HashSet();
        nameSet.add(cname.getName());
        nameSet.add(cname.getNormalised());
        nameSet.add(cname.getBasic());
        nameSet.add(cnameComplete.getName());
        nameSet.add(cnameComplete.getNormalised());
        nameSet.add(cnameComplete.getBasic());
        for (String n : nameSet) {
            NameIndexField.NAME.store((Object)n, doc);
        }
        NameIndexField.NAME_CANONICAL.store((Object)cname.getNormalised(), doc);
        NameIndexField.NAME_COMPLETE.store((Object)cnameComplete.getNormalised(), doc);
        if (rankIndex >= 0) {
            NameIndexField.RANK_ID.store((Object)rankIndex, doc);
        }
        if (StringUtils.isNotEmpty((CharSequence)rankString)) {
            NameIndexField.RANK.store((Object)rankString, doc);
        }
        if (StringUtils.isNotEmpty((CharSequence)acceptedConcept)) {
            NameIndexField.ACCEPTED.store((Object)acceptedConcept, doc);
            NameIndexField.iS_SYNONYM.store((Object)"T", doc);
        } else {
            NameIndexField.iS_SYNONYM.store((Object)"F", doc);
        }
        if (StringUtils.trimToNull((String)kingdom) != null) {
            NameIndexField.KINGDOM.store((Object)kingdom, doc);
            if (StringUtils.isNotBlank((CharSequence)kid)) {
                NameIndexField.KINGDOM_ID.store((Object)kid, doc);
            }
        }
        if (StringUtils.trimToNull((String)phylum) != null) {
            NameIndexField.PHYLUM.store((Object)phylum, doc);
            if (StringUtils.isNotBlank((CharSequence)pid)) {
                NameIndexField.PHYLUM_ID.store((Object)pid, doc);
            }
        }
        if (StringUtils.trimToNull((String)clazz) != null) {
            NameIndexField.CLASS.store((Object)clazz, doc);
            if (StringUtils.isNotBlank((CharSequence)cid)) {
                NameIndexField.CLASS_ID.store((Object)cid, doc);
            }
        }
        if (StringUtils.trimToNull((String)order) != null) {
            NameIndexField.ORDER.store((Object)order, doc);
            if (StringUtils.isNotBlank((CharSequence)oid)) {
                NameIndexField.ORDER_ID.store((Object)oid, doc);
            }
        }
        if (StringUtils.trimToNull((String)family) != null) {
            NameIndexField.FAMILY.store((Object)family, doc);
            if (StringUtils.isNotBlank((CharSequence)fid)) {
                NameIndexField.FAMILY_ID.store((Object)fid, doc);
            }
        }
        if (StringUtils.trimToNull((String)genus) != null) {
            NameIndexField.GENUS.store((Object)genus, doc);
            if (StringUtils.isNotBlank((CharSequence)gid)) {
                NameIndexField.GENUS_ID.store((Object)gid, doc);
            }
        }
        if (StringUtils.trimToNull((String)species) != null) {
            NameIndexField.SPECIES.store((Object)species, doc);
            if (StringUtils.isNotBlank((CharSequence)sid)) {
                NameIndexField.SPECIES_ID.store((Object)sid, doc);
            }
        }
        if (left > 0) {
            NameIndexField.LEFT.store((Object)left, doc);
        }
        if (right > 0) {
            NameIndexField.RIGHT.store((Object)right, doc);
        }
        NameIndexField.PRIORITY.store((Object)priority, doc);
        if (StringUtils.isNotEmpty((CharSequence)author)) {
            NameIndexField.AUTHOR.store((Object)author, doc);
        }
        try {
            ParsedName cn = this.parser.parse(cname.getNormalised());
            if (cn != null && cn.isParsableType() && !cn.isIndetermined() && cn.getType() != NameType.INFORMAL && !"6500".equals(rank) && cn.getType() != NameType.DOUBTFUL) {
                if (!nameSet.contains(cn.canonicalName())) {
                    NameIndexField.NAME.store((Object)cn.canonicalName(), doc);
                }
                if (specificEpithet == null && cn.isBinomial()) {
                    soundexGenus = cn.getGenusOrAbove();
                    if (specificEpithet == null) {
                        specificEpithet = cn.getSpecificEpithet();
                    }
                    if (infraspecificEpithet == null) {
                        infraspecificEpithet = cn.getInfraSpecificEpithet();
                    }
                }
            }
            if (cn != null && cn instanceof ALAParsedName) {
                ALAParsedName alapn = (ALAParsedName)cn;
                if (alapn.getRank() != Rank.SPECIES && alapn.getSpecificEpithet() != null) {
                    NameIndexField.SPECIFIC.store((Object)alapn.getSpecificEpithet(), doc);
                } else if (alapn.getRank() != Rank.SPECIES && alapn.getSpecificEpithet() == null) {
                    this.log.warn((Object)(lsid + " " + name + " has an empty specific for non sp. phrase"));
                }
                if (StringUtils.trimToNull((String)alapn.getLocationPhraseDescription()) != null) {
                    NameIndexField.PHRASE.store((Object)alapn.cleanPhrase, doc);
                }
                if (alapn.getPhraseVoucher() != null) {
                    NameIndexField.VOUCHER.store((Object)alapn.cleanVoucher, doc);
                }
                if (StringUtils.isBlank((CharSequence)genus) && StringUtils.isNotBlank((CharSequence)alapn.getGenusOrAbove())) {
                    NameIndexField.GENUS.store((Object)alapn.getGenusOrAbove(), doc);
                }
            }
        }
        catch (UnparsableException e) {
            if (e.type == NameType.VIRUS) {
                NameIndexField.NAME.store((Object)ALANameSearcher.virusStopPattern.matcher(name).replaceAll(" ").trim(), doc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String soundex;
            if (StringUtils.isNotBlank((CharSequence)soundexGenus)) {
                NameIndexField.GENUS_EX.store((Object)TaxonNameSoundEx.treatWord((String)soundexGenus, (String)"genus"), doc);
            }
            if (StringUtils.isNotBlank((CharSequence)specificEpithet)) {
                soundex = TaxonNameSoundEx.treatWord((String)specificEpithet, (String)"species");
                if (soundex == null) {
                    soundex = "<null>";
                }
                NameIndexField.SPECIES_EX.store((Object)soundex, doc);
            } else if (StringUtils.isNotBlank((CharSequence)soundexGenus)) {
                NameIndexField.SPECIES_EX.store((Object)"<null>", doc);
            }
            if (StringUtils.isNotBlank((CharSequence)infraspecificEpithet)) {
                soundex = TaxonNameSoundEx.treatWord((String)infraspecificEpithet, (String)"species");
                if (soundex == null) {
                    soundex = "<null>";
                }
                NameIndexField.INFRA_EX.store((Object)soundex, doc);
            } else if (StringUtils.isNotBlank((CharSequence)specificEpithet)) {
                NameIndexField.INFRA_EX.store((Object)"<null>", doc);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)(lsid + " " + name + " has issues creating a soundex: " + e.getMessage()));
        }
        return doc;
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(String indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    protected String buildNameComplete(String name, String author, String nameComplete) {
        if (StringUtils.isNotBlank((CharSequence)nameComplete)) {
            return nameComplete;
        }
        if (name != null && author != null) {
            if (name.endsWith(author)) {
                return name;
            }
            if (author.startsWith(name)) {
                return author;
            }
        }
        StringBuilder ncb = new StringBuilder(64);
        if (name != null) {
            ncb.append(name);
        }
        ncb.append(" ");
        if (author != null) {
            ncb.append(author);
        }
        return ncb.toString().trim();
    }

    protected CSVReader buildCSVReader(String file, char separator, char escape, char quote, int skipLines) throws IOException {
        CSVParser parser = new CSVParserBuilder().withSeparator(separator).withEscapeChar(escape).withQuoteChar(quote).build();
        CSVReader reader = new CSVReaderBuilder((Reader)new FileReader(file)).withCSVParser((ICSVParser)parser).withSkipLines(skipLines).build();
        return reader;
    }

    public static void main(String[] args) throws Exception {
        ALANameIndexer indexer = new ALANameIndexer();
        indexer.init();
        for (String arg : args) {
            System.out.println(arg);
        }
        if (args.length >= 2) {
            boolean sn = true;
            boolean cn = true;
            if (args.length == 3) {
                sn = args[2].equals("-sn");
                cn = args[2].equals("-cn");
            }
            if (args.length == 5) {
                indexer.createIndex(args[0], args[1], args[2], args[3], args[4], sn, cn);
            } else {
                indexer.createIndex(args[0], args[1], sn, cn);
            }
        } else {
            System.out.println("au.org.ala.names.search.ALANameIndexer <directory with export files> <directory in which to create indexes> [<accepted name file>] [<synonym name file>][-cn OR -sn]");
        }
    }
}

