/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index.provider;

import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonomicType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum UnrankedStrategy {
    ALL_INFER(true, TaxonomicType.values()),
    ALL(false, TaxonomicType.values()),
    INFERRED_AND_SYNONYMS_INFER(true, TaxonomicType.INFERRED_UNPLACED, TaxonomicType.INFERRED_SYNONYM, TaxonomicType.INFERRED_ACCEPTED, TaxonomicType.HOMOTYPIC_SYNONYM, TaxonomicType.SYNONYM, TaxonomicType.HETEROTYPIC_SYNONYM, TaxonomicType.OBJECTIVE_SYNONYM, TaxonomicType.PRO_PARTE_SYNONYM, TaxonomicType.SUBJECTIVE_SYNONYM),
    INFERRED_AND_SYNONYMS(false, TaxonomicType.INFERRED_UNPLACED, TaxonomicType.INFERRED_SYNONYM, TaxonomicType.INFERRED_ACCEPTED, TaxonomicType.HOMOTYPIC_SYNONYM, TaxonomicType.SYNONYM, TaxonomicType.HETEROTYPIC_SYNONYM, TaxonomicType.OBJECTIVE_SYNONYM, TaxonomicType.PRO_PARTE_SYNONYM, TaxonomicType.SUBJECTIVE_SYNONYM),
    SYNONYMS_INFER(true, TaxonomicType.HOMOTYPIC_SYNONYM, TaxonomicType.INFERRED_SYNONYM, TaxonomicType.SYNONYM, TaxonomicType.HETEROTYPIC_SYNONYM, TaxonomicType.OBJECTIVE_SYNONYM, TaxonomicType.PRO_PARTE_SYNONYM, TaxonomicType.SUBJECTIVE_SYNONYM),
    SYNONYMS(false, TaxonomicType.HOMOTYPIC_SYNONYM, TaxonomicType.INFERRED_SYNONYM, TaxonomicType.SYNONYM, TaxonomicType.HETEROTYPIC_SYNONYM, TaxonomicType.OBJECTIVE_SYNONYM, TaxonomicType.PRO_PARTE_SYNONYM, TaxonomicType.SUBJECTIVE_SYNONYM),
    NONE(false, new TaxonomicType[0]);

    private Set<TaxonomicType> reassign;
    private boolean inferRank;

    private UnrankedStrategy(boolean inferRank, TaxonomicType ... types) {
        this.inferRank = inferRank;
        this.reassign = new HashSet<TaxonomicType>(Arrays.asList(types));
    }

    public boolean isInferRank() {
        return this.inferRank;
    }

    public boolean isReassignable(TaxonConceptInstance tci) {
        return !tci.isForbidden() && (tci.getRank() == null || tci.getRank() == RankType.UNRANKED) && this.reassign.contains(tci.getTaxonomicStatus());
    }
}

