/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index.provider;

import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.NomenclaturalClassifier;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.provider.NameMatchType;
import au.org.ala.names.index.provider.TaxonCondition;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonFlag;
import au.org.ala.names.model.TaxonomicType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.regex.Pattern;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.checklistbank.authorship.AuthorComparator;
import org.gbif.checklistbank.model.Equality;
import org.gbif.checklistbank.utils.SciNameNormalizer;

public class MatchTaxonCondition
extends TaxonCondition {
    private static AuthorComparator AUTHOR_COMPARATOR = AuthorComparator.createWithAuthormap();
    private NomenclaturalClassifier nomenclaturalCode;
    private String datasetID;
    private String scientificName;
    @JsonIgnore
    private String matchScientificName;
    @JsonIgnore
    private Pattern patternScientificName;
    private String scientificNameAuthorship;
    @JsonIgnore
    private String matchScientificNameAuthorship;
    @JsonIgnore
    private Pattern patternScientificNameAuthorship;
    private NameMatchType matchType;
    private TaxonomicType taxonomicStatus;
    private NomenclaturalStatus nomenclaturalStatus;
    private NameType nameType;
    private RankType taxonRank;
    private String year;
    private TaxonFlag taxonomicFlag;

    public NomenclaturalClassifier getNomenclaturalCode() {
        return this.nomenclaturalCode;
    }

    public void setNomenclaturalCode(NomenclaturalClassifier nomenclaturalCode) {
        this.nomenclaturalCode = nomenclaturalCode;
    }

    public String getDatasetID() {
        return this.datasetID;
    }

    public void setDatasetID(String datasetID) {
        this.datasetID = datasetID;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
        this.matchScientificName = null;
        this.patternScientificName = null;
    }

    public String getScientificNameAuthorship() {
        return this.scientificNameAuthorship;
    }

    public void setScientificNameAuthorship(String scientificNameAuthorship) {
        this.scientificNameAuthorship = scientificNameAuthorship;
        this.matchScientificNameAuthorship = null;
        this.patternScientificNameAuthorship = null;
    }

    public NameMatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(NameMatchType matchType) {
        this.matchType = matchType;
        this.matchScientificName = null;
        this.patternScientificName = null;
        this.matchScientificNameAuthorship = null;
        this.patternScientificNameAuthorship = null;
    }

    public TaxonomicType getTaxonomicStatus() {
        return this.taxonomicStatus;
    }

    public void setTaxonomicStatus(TaxonomicType taxonomicStatus) {
        this.taxonomicStatus = taxonomicStatus;
    }

    public NomenclaturalStatus getNomenclaturalStatus() {
        return this.nomenclaturalStatus;
    }

    public void setNomenclaturalStatus(NomenclaturalStatus nomenclaturalStatus) {
        this.nomenclaturalStatus = nomenclaturalStatus;
    }

    public NameType getNameType() {
        return this.nameType;
    }

    public void setNameType(NameType nameType) {
        this.nameType = nameType;
    }

    public RankType getTaxonRank() {
        return this.taxonRank;
    }

    public void setTaxonRank(RankType taxonRank) {
        this.taxonRank = taxonRank;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public TaxonFlag getTaxonomicFlag() {
        return this.taxonomicFlag;
    }

    public void setTaxonomicFlag(TaxonFlag taxonomicFlag) {
        this.taxonomicFlag = taxonomicFlag;
    }

    @Override
    public boolean match(TaxonConceptInstance instance, NameKey key) {
        if (this.nomenclaturalCode != null && this.nomenclaturalCode != instance.getCode()) {
            return false;
        }
        if (!(this.datasetID == null || instance.getProvider() != null && this.datasetID.equals(instance.getProvider().getId()))) {
            return false;
        }
        if (!this.matchScientificName(instance.getScientificName())) {
            return false;
        }
        if (!this.matchScientificNameAuthorship(instance.getScientificNameAuthorship())) {
            return false;
        }
        if (this.taxonomicStatus != null && this.taxonomicStatus != instance.getTaxonomicStatus()) {
            return false;
        }
        if (!(this.nomenclaturalStatus == null || instance.getStatus() != null && instance.getStatus().contains(this.nomenclaturalStatus))) {
            return false;
        }
        if (this.nameType != null && key != null && this.nameType != key.getType()) {
            return false;
        }
        if (this.taxonRank != null && this.taxonRank != instance.getRank()) {
            return false;
        }
        if (this.year != null && !this.year.equals(instance.getYear())) {
            return false;
        }
        return this.taxonomicFlag == null || instance.hasFlag(this.taxonomicFlag);
    }

    private boolean matchScientificName(String name) {
        if (this.scientificName == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        name = name.trim();
        NameMatchType type = this.matchType != null ? this.matchType : NameMatchType.EXACT;
        switch (type) {
            case INSENSITIVE: {
                name = name.toUpperCase().replaceAll("\\s+", " ");
                if (this.matchScientificName == null) {
                    this.matchScientificName = this.scientificName.toUpperCase().replaceAll("\\s+", " ").trim();
                }
                return this.matchScientificName.equals(name);
            }
            case NORMALISED: {
                name = SciNameNormalizer.normalizeAll((String)name).toUpperCase();
                if (this.matchScientificName == null) {
                    this.matchScientificName = SciNameNormalizer.normalizeAll((String)this.scientificName).toUpperCase();
                }
                return this.matchScientificName.equals(name);
            }
            case REGEX: {
                if (this.patternScientificName == null) {
                    this.patternScientificName = Pattern.compile(this.scientificName, 2);
                }
                return this.patternScientificName.matcher(name).matches();
            }
        }
        if (this.matchScientificName == null) {
            this.matchScientificName = this.scientificName.trim();
        }
        return this.matchScientificName.equals(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchScientificNameAuthorship(String author) {
        if (this.scientificNameAuthorship == null) {
            return true;
        }
        if (author == null) {
            return false;
        }
        author = author.trim();
        NameMatchType type = this.matchType != null ? this.matchType : NameMatchType.EXACT;
        switch (type) {
            case INSENSITIVE: {
                author = author.toUpperCase().replaceAll("\\s+", " ");
                if (this.matchScientificNameAuthorship == null) {
                    this.matchScientificNameAuthorship = this.scientificNameAuthorship.toUpperCase().replaceAll("\\s+", " ").trim();
                }
                return this.matchScientificNameAuthorship.equals(author);
            }
            case NORMALISED: {
                AuthorComparator authorComparator = AUTHOR_COMPARATOR;
                synchronized (authorComparator) {
                    if (this.matchScientificNameAuthorship == null) {
                        this.matchScientificNameAuthorship = this.scientificNameAuthorship.trim();
                    }
                    return AUTHOR_COMPARATOR.compare(this.matchScientificNameAuthorship, null, author, null) == Equality.EQUAL;
                }
            }
            case REGEX: {
                if (this.patternScientificNameAuthorship == null) {
                    this.patternScientificNameAuthorship = Pattern.compile(this.scientificNameAuthorship);
                }
                return this.patternScientificNameAuthorship.matcher(author).matches();
            }
        }
        if (this.matchScientificNameAuthorship == null) {
            this.matchScientificNameAuthorship = this.scientificNameAuthorship.trim();
        }
        return this.matchScientificNameAuthorship.equals(author);
    }

    @Override
    public String explain() {
        StringBuilder builder = new StringBuilder();
        this.explain(builder, "nomenclaturalCode", this.nomenclaturalCode);
        this.explain(builder, "datasetID", this.datasetID);
        this.explain(builder, "scientificName", new Object[]{this.scientificName, this.matchType});
        this.explain(builder, "scientificNameAuthorship", new Object[]{this.scientificNameAuthorship, this.matchType});
        this.explain(builder, "taxonomicStatus", this.taxonomicStatus);
        this.explain(builder, "nomenclaturalStatus", this.nomenclaturalStatus);
        this.explain(builder, "nameType", this.nameType);
        this.explain(builder, "taxonRank", this.taxonRank);
        this.explain(builder, "year", this.year);
        this.explain(builder, "taxonomicFlag", this.taxonomicFlag);
        return builder.toString();
    }

    private void explain(StringBuilder builder, String label, Object ... elements) {
        if (elements.length == 0 || elements[0] == null) {
            return;
        }
        if (builder.length() > 0) {
            builder.append(" ");
        }
        builder.append(label);
        builder.append(":");
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(elements[i]);
        }
    }
}

