/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.BareName;
import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.Name;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.ScientificName;
import au.org.ala.names.index.TaxonConcept;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.RankType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class UnrankedScientificName
extends Name<UnrankedScientificName, BareName, ScientificName> {
    public UnrankedScientificName(BareName container, NameKey key) {
        super(container, key);
    }

    @Override
    ScientificName createConcept(NameKey stageKey) {
        return new ScientificName(this, stageKey);
    }

    @Override
    NameKey buildStageKey(NameKey instanceKey) {
        return instanceKey.toNameKey();
    }

    @Override
    protected void reallocateDanglingConcepts(Taxonomy taxonomy, ScientificName principal) {
        if (principal == null) {
            return;
        }
        ArrayList<ScientificName> reallocated = new ArrayList<ScientificName>();
        for (ScientificName name : this.getConcepts()) {
            if (name == principal || !name.getKey().isUnranked()) continue;
            principal.reallocate(name, taxonomy, "unrankedScientificName.reallocated.provenance");
            reallocated.add(name);
        }
        this.removeConcepts(reallocated);
        taxonomy.count("count.resolve.unrankedScientificName.principal");
    }

    @Override
    protected ScientificName findPrincipal(Taxonomy taxonomy) {
        List names = this.getConcepts();
        if (names.isEmpty()) {
            return null;
        }
        if (names.size() == 1) {
            return (ScientificName)names.get(0);
        }
        names.sort(REVERSE_PROVIDER_SCORE_COMPARATOR);
        int cutoff = taxonomy.getAcceptedCutoff();
        List ranked = names.stream().filter(sn -> !sn.getKey().isUnranked() && sn.getPrincipal() != null && sn.getPrincipalScore() > cutoff).collect(Collectors.toList());
        Set acceptedRanks = ranked.stream().filter(sn -> ((TaxonConcept)sn.getPrincipal()).getRepresentative().isAccepted()).map(Name::getRank).collect(Collectors.toSet());
        if (acceptedRanks.size() > 1) {
            taxonomy.report(IssueType.PROBLEM, "unrankedScientificName.rankCollision", this, ranked);
        }
        if (ranked.size() == 0) {
            return (ScientificName)names.get(0);
        }
        if (ranked.size() == 1) {
            return (ScientificName)ranked.get(0);
        }
        taxonomy.report(IssueType.COLLISION, "unrankedScientificName.collision", this, ranked);
        int score = ranked.stream().mapToInt(Name::getPrincipalScore).max().orElse(-1000000);
        List candidates = ranked.stream().filter(sn -> sn.getPrincipalScore() == score).collect(Collectors.toList());
        if (candidates.size() > 1) {
            taxonomy.report(IssueType.PROBLEM, "unrankedScientificName.collision.warn", this, candidates);
        }
        return (ScientificName)candidates.get(0);
    }

    @Override
    public void reallocate(UnrankedScientificName element, Taxonomy taxonomy, String reason) {
        ScientificName principal = (ScientificName)this.getPrincipal();
        taxonomy.report(IssueType.NOTE, "unrankedScientificName.reallocated", element, Arrays.asList(this));
        taxonomy.count("count.reallocate.unrankedScientificName");
        if (principal == null) {
            throw new IndexBuilderException("Unable to reallocate " + element + " to " + this + " without principal");
        }
        for (ScientificName name : element.getConcepts()) {
            principal.reallocate(name, taxonomy, reason);
        }
        element.clear(principal);
    }

    public void resolveUnranked(boolean accepted, Taxonomy taxonomy) throws IndexBuilderException {
        ArrayList names = new ArrayList(this.getConcepts());
        for (ScientificName name : names) {
            if (!name.getKey().isUnranked()) continue;
            name.resolveUnranked(accepted, taxonomy, this);
        }
    }

    public TaxonConcept findRankedConcept(NameKey key, RankType rank, Taxonomy taxonomy) {
        List<TaxonConcept> candidates;
        ArrayList<TaxonConcept> available = new ArrayList<TaxonConcept>();
        for (ScientificName name : this.getConcepts()) {
            name.findRankedConcepts(key, taxonomy, available);
        }
        if (available.isEmpty()) {
            return null;
        }
        if (available.size() == 1) {
            return (TaxonConcept)available.get(0);
        }
        if (rank == null) {
            candidates = available;
        } else {
            int rid = rank.getId();
            TaxonConcept closest = (TaxonConcept)available.stream().min((tc1, tc2) -> Math.abs(rid - tc1.getRank().getId()) - Math.abs(rid - tc2.getRank().getId())).get();
            int range = Math.abs(rid - closest.getRank().getId());
            candidates = available.stream().filter(tc -> Math.abs(rid - tc.getRank().getId()) <= range).collect(Collectors.toList());
            if (candidates.isEmpty()) {
                throw new IllegalStateException("Candidate list can't be empty.");
            }
        }
        Collections.sort(candidates, Comparator.comparingInt(tci -> -tci.getPrincipalScore()));
        return (TaxonConcept)candidates.get(0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        ScientificName principal = (ScientificName)this.getPrincipal();
        TaxonConceptInstance representative = this.getRepresentative();
        builder.append("UN[");
        builder.append(this.getKey().getCode() == null ? "no code" : this.getKey().getCode().getAcronym());
        builder.append(", ");
        builder.append(this.getKey().getScientificName());
        if (principal != null) {
            builder.append(" = ");
            builder.append(principal.getKey());
        }
        if (representative != null) {
            builder.append(" = ");
            builder.append(representative.getLocator());
        }
        builder.append("]");
        return builder.toString();
    }
}

