/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.ALANameAnalyser;
import au.org.ala.names.index.ALATaxonResolver;
import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.NameAnalyser;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.TaxonResolver;
import au.org.ala.names.util.GbifModule;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.gbif.api.model.registry.Contact;
import org.gbif.checklistbank.authorship.AuthorComparator;
import org.gbif.utils.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaxonomyConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TaxonomyConfiguration.class);
    public static final String AUTHOR_MAP_FILENAME = "/authorship/authormap.txt";
    public String id = UUID.randomUUID().toString();
    public String name = "New taxonomy configuration";
    public String description;
    public URI uri;
    public Contact contact;
    public Class<? extends NameAnalyser> nameAnalyserClass = ALANameAnalyser.class;
    public Class<? extends TaxonResolver> resolverClass = ALATaxonResolver.class;
    public List<NameProvider> providers = new ArrayList<NameProvider>();
    public NameProvider defaultProvider;
    public NameProvider inferenceProvider;
    public int acceptedCutoff = 0;
    public Map<String, String> authorMap = new HashMap<String, String>();

    public void write(Writer writer) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.writeValue(writer, (Object)this);
    }

    public static TaxonomyConfiguration read(Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new GbifModule());
        return (TaxonomyConfiguration)mapper.readValue(reader, TaxonomyConfiguration.class);
    }

    public static TaxonomyConfiguration read(InputStream stream) throws IOException {
        return TaxonomyConfiguration.read(new InputStreamReader(stream, "UTF-8"));
    }

    public void validate() throws IndexBuilderException {
        if (!this.providers.stream().anyMatch(p -> p == this.defaultProvider)) {
            throw new IndexBuilderException("Default provider not in provider list");
        }
        if (this.inferenceProvider != null && !this.providers.stream().anyMatch(p -> p == this.inferenceProvider)) {
            throw new IndexBuilderException("Inference provider not in provider list");
        }
    }

    @JsonIgnore
    public String getContactName() {
        if (this.contact == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(32);
        if (this.contact.getFirstName() != null) {
            sb.append(this.contact.getFirstName());
        }
        if (this.contact.getLastName() != null) {
            sb.append(" ");
            sb.append(this.contact.getLastName());
        }
        if (this.contact.getOrganization() != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.contact.getOrganization());
        }
        return sb.toString().trim();
    }

    @JsonIgnore
    public Properties getPriorities() {
        int max = this.providers.stream().mapToInt(NameProvider::getDefaultScore).max().orElse(1);
        double scale = 2.0 / (double)max;
        Properties properties = new Properties();
        for (NameProvider p : this.providers) {
            properties.setProperty(p.getId(), Double.toString(Math.max(0.25, (double)p.getDefaultScore() * scale)));
        }
        return properties;
    }

    public AuthorComparator newAuthorComparator() throws IOException {
        Map authors = FileUtils.streamToMap((InputStream)Resources.asByteSource((URL)AuthorComparator.class.getResource(AUTHOR_MAP_FILENAME)).openStream(), (Map)Maps.newHashMap(), (int)0, (int)2, (boolean)true);
        for (String key : this.authorMap.keySet()) {
            if (!authors.containsKey(key)) continue;
            logger.warn("Collision in author key " + key + " overriding");
        }
        authors.putAll(this.authorMap);
        return AuthorComparator.createWithAuthormap((Map)authors);
    }
}

