/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.NameSource;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.index.TaxonomyConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxonomyBuilder {
    private static Logger logger = LoggerFactory.getLogger(TaxonomyBuilder.class);

    protected static List<NameSource> findSources(File path) {
        ArrayList<NameSource> sources = new ArrayList<NameSource>();
        try {
            File meta;
            if (!path.exists()) {
                logger.info("Path does not exist " + path);
                return sources;
            }
            if (path.isFile()) {
                logger.info("Adding source file at " + path);
                sources.add(NameSource.create(path));
                return sources;
            }
            if (!path.isDirectory()) {
                logger.info("Unknown file type for " + path);
            }
            if ((meta = new File(path, "meta.xml")).exists()) {
                logger.info("Adding DwCA at " + path);
                sources.add(NameSource.create(path));
                return sources;
            }
            for (File f : path.listFiles()) {
                if (!f.isDirectory() && !f.getName().endsWith(".csv")) continue;
                sources.addAll(TaxonomyBuilder.findSources(f));
            }
        }
        catch (Exception ex) {
            logger.error("Unable to get sources for " + path, (Throwable)ex);
        }
        return sources;
    }

    public static void main(String[] args) {
        try {
            Options options = new Options();
            boolean cleanup = true;
            File work = new File(System.getProperty("user.dir"));
            File output = new File(work, "combined");
            Integer samples = null;
            TaxonomyConfiguration config = null;
            OptionBuilder.withLongOpt((String)"output");
            OptionBuilder.withDescription((String)"Output directory - defaults to 'combined' in the current directory");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"DIR");
            OptionBuilder.withType(File.class);
            Option o = OptionBuilder.create((char)'o');
            OptionBuilder.withLongOpt((String)"work");
            OptionBuilder.withDescription((String)"Working directory - defaults to the current directory");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"DIR");
            OptionBuilder.withType(File.class);
            Option w = OptionBuilder.create((char)'w');
            OptionBuilder.withLongOpt((String)"config");
            OptionBuilder.withDescription((String)"Configuration file");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"FILE");
            OptionBuilder.withType(File.class);
            Option c = OptionBuilder.create((char)'c');
            OptionBuilder.withLongOpt((String)"report");
            OptionBuilder.withDescription((String)"Report file");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"FILE");
            OptionBuilder.withType(File.class);
            Option r = OptionBuilder.create((char)'r');
            OptionBuilder.withLongOpt((String)"previous");
            OptionBuilder.withDescription((String)"Previous taxonomy DwCA");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"DIR");
            OptionBuilder.withType(File.class);
            Option p = OptionBuilder.create((char)'p');
            OptionBuilder.withLongOpt((String)"recurse");
            OptionBuilder.withDescription((String)"Input file is a directory, recurse through subdirectories");
            Option recurse = OptionBuilder.create((char)'R');
            OptionBuilder.withLongOpt((String)"noclean");
            OptionBuilder.withDescription((String)"Don't clean up work area");
            Option ncl = OptionBuilder.create();
            OptionBuilder.withLongOpt((String)"nocreate");
            OptionBuilder.withDescription((String)"Don't create an output taxonomy");
            Option nc = OptionBuilder.create();
            OptionBuilder.withLongOpt((String)"sample");
            OptionBuilder.withDescription((String)"Output a sample taxonomy, consisting of n concepts plus their parents/accepted");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"N");
            OptionBuilder.withType(Integer.class);
            Option s = OptionBuilder.create();
            options.addOption(o);
            options.addOption(w);
            options.addOption(c);
            options.addOption(r);
            options.addOption(p);
            options.addOption(recurse);
            options.addOption(ncl);
            options.addOption(nc);
            options.addOption(s);
            BasicParser parser = new BasicParser();
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("noclean")) {
                cleanup = false;
            }
            if (cmd.hasOption('o')) {
                output = (File)cmd.getOptionObject('o');
            }
            if (cmd.hasOption('w')) {
                work = (File)cmd.getOptionObject('w');
            }
            if (cmd.hasOption('c')) {
                File cf = (File)cmd.getOptionObject('c');
                if (!cf.exists()) {
                    throw new IllegalArgumentException("Configuration file " + cf + " does not exist");
                }
                config = TaxonomyConfiguration.read(new FileInputStream(cf));
            }
            File report = cmd.hasOption('r') ? (File)cmd.getOptionObject('r') : new File(work, "taxonomy_report.csv");
            if (cmd.hasOption("nocreate")) {
                output = null;
            }
            if (cmd.hasOption("previous")) {
                cmd.getOptionValues("previous");
            }
            if (cmd.hasOption("sample")) {
                samples = Integer.parseInt(cmd.getOptionValue("sample"));
            }
            List<NameSource> sources = cmd.hasOption("recurse") ? Arrays.asList(cmd.getArgs()).stream().map(File::new).map(f -> TaxonomyBuilder.findSources(f)).flatMap(Collection::stream).collect(Collectors.toList()) : Arrays.asList(cmd.getArgs()).stream().map(File::new).map(f -> NameSource.create(f)).collect(Collectors.toList());
            Taxonomy taxonomy = new Taxonomy(config, work);
            taxonomy.begin();
            taxonomy.load(sources);
            taxonomy.resolve();
            taxonomy.createWorkingIndex();
            taxonomy.resolveUnplacedVernacular();
            taxonomy.resolveUnplacedReferences();
            if (samples != null) {
                taxonomy.sample(samples);
            }
            if (output != null) {
                output.mkdirs();
                taxonomy.createDwCA(output);
            }
            if (report != null) {
                taxonomy.createReport(report);
            }
            taxonomy.close();
            if (cleanup) {
                taxonomy.clean();
            }
        }
        catch (Exception ex) {
            logger.error("Unable to combine taxa", (Throwable)ex);
            System.out.println(ex.getMessage());
            System.exit(1);
        }
    }
}

