/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.Distribution;
import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.NomenclaturalClassifier;
import au.org.ala.names.index.ResolutionException;
import au.org.ala.names.index.TaxonConcept;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonFlag;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.vocab.ALATerm;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxonConceptInstance
extends TaxonomicElement<TaxonConceptInstance, TaxonConcept> {
    private static final Logger logger = LoggerFactory.getLogger(TaxonConceptInstance.class);
    public static Comparator<TaxonConceptInstance> PROVIDER_SCORE_COMPARATOR = new Comparator<TaxonConceptInstance>(){

        @Override
        public int compare(TaxonConceptInstance e1, TaxonConceptInstance e2) {
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null && e2 != null) {
                return -1000000;
            }
            if (e1 != null && e2 == null) {
                return 1000000;
            }
            int o1 = e1.getProviderScore();
            int o2 = e2.getProviderScore();
            try {
                return Math.subtractExact(o1, o2);
            }
            catch (Exception ex) {
                if (o1 > o2) {
                    return 1000000;
                }
                if (o2 > o1) {
                    return -1000000;
                }
                return 0;
            }
        }
    };
    public static Comparator<TaxonConceptInstance> SCORE_COMPARATOR = new Comparator<TaxonConceptInstance>(){

        @Override
        public int compare(TaxonConceptInstance e1, TaxonConceptInstance e2) {
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null && e2 != null) {
                return -1000000;
            }
            if (e1 != null && e2 == null) {
                return 1000000;
            }
            int o1 = e1.getScore();
            int o2 = e2.getScore();
            try {
                return Math.subtractExact(o1, o2);
            }
            catch (Exception ex) {
                if (o1 > o2) {
                    return 1000000;
                }
                if (o2 > o1) {
                    return -1000000;
                }
                return 0;
            }
        }
    };
    public static Comparator<TaxonConceptInstance> INVERSE_SCORE_COMPARATOR = SCORE_COMPARATOR.reversed();
    public static final int MAX_RESOLUTION_STEPS = 40;
    protected static final List<Term> CLASSIFICATION_FIELDS = Arrays.asList(DwcTerm.kingdom, DwcTerm.phylum, DwcTerm.class_, DwcTerm.order, DwcTerm.family, DwcTerm.genus, DwcTerm.specificEpithet, DwcTerm.infraspecificEpithet);
    protected static final List<RankType> CLASSIFICATION_RANKS = Arrays.asList(RankType.KINGDOM, RankType.PHYLUM, RankType.CLASS, RankType.ORDER, RankType.FAMILY, RankType.GENUS, RankType.SPECIES, RankType.SUBSPECIES);
    private String taxonID;
    private NomenclaturalClassifier code;
    private String verbatimNomenclaturalCode;
    private NameProvider provider;
    private String scientificName;
    private String scientificNameAuthorship;
    @Nullable
    private String nameComplete;
    private String year;
    private TaxonomicType taxonomicStatus;
    private String verbatimTaxonomicStatus;
    private RankType rank;
    private String verbatimTaxonRank;
    private Set<NomenclaturalStatus> status;
    private String verbatimNomenclaturalStatus;
    private String parentNameUsage;
    private String parentNameUsageID;
    private TaxonomicElement parent;
    private String acceptedNameUsage;
    private String acceptedNameUsageID;
    private List<String> taxonRemarks;
    private String verbatimTaxonRemarks;
    private List<String> provenance;
    private TaxonomicElement accepted;
    private Map<Term, Optional<String>> classification;
    private Set<TaxonFlag> flags;
    private List<Distribution> distribution;
    private Integer baseScore;
    private Integer score;
    private boolean forbidden;

    public TaxonConceptInstance(String taxonID, NomenclaturalClassifier code, String verbatimNomenclaturalCode, NameProvider provider, String scientificName, String scientificNameAuthorship, @Nullable String nameComplete, String year, TaxonomicType taxonomicStatus, String verbatimTaxonomicStatus, RankType rank, String verbatimTaxonRank, Set<NomenclaturalStatus> status, String verbatimNomenclaturalStatus, String parentNameUsage, String parentNameUsageID, String acceptedNameUsage, String acceptedNameUsageID, @Nullable List<String> taxonRemarks, @Nullable String verbatimTaxonRemarks, @Nullable List<String> provenance, @Nullable Map<Term, Optional<String>> classification, @Nullable Set<TaxonFlag> flags, @Nullable List<Distribution> distribution) {
        this.taxonID = taxonID;
        this.code = code;
        this.verbatimNomenclaturalCode = verbatimNomenclaturalCode;
        this.provider = Objects.requireNonNull(provider);
        this.scientificName = scientificName;
        this.scientificNameAuthorship = scientificNameAuthorship;
        this.nameComplete = nameComplete;
        this.year = year;
        this.taxonomicStatus = taxonomicStatus;
        this.verbatimTaxonomicStatus = verbatimTaxonomicStatus;
        this.rank = rank;
        this.verbatimTaxonRank = verbatimTaxonRank;
        this.status = status;
        this.verbatimNomenclaturalStatus = verbatimNomenclaturalStatus;
        this.parentNameUsage = parentNameUsage;
        this.parentNameUsageID = parentNameUsageID;
        this.acceptedNameUsage = acceptedNameUsage;
        this.acceptedNameUsageID = acceptedNameUsageID;
        this.taxonRemarks = taxonRemarks == null ? null : new ArrayList<String>(taxonRemarks);
        this.verbatimTaxonRemarks = verbatimTaxonRemarks;
        this.provenance = provenance == null ? null : new ArrayList<String>(provenance);
        this.classification = classification;
        this.flags = flags;
        this.distribution = distribution;
    }

    public NomenclaturalClassifier getCode() {
        return this.code;
    }

    @Override
    public String getTaxonID() {
        return this.taxonID;
    }

    @Override
    public String getId() {
        return this.taxonID;
    }

    public NameProvider getProvider() {
        return this.provider;
    }

    public NameProvider getAuthority() {
        return this.provider == null ? null : this.provider.getAuthority();
    }

    @Override
    public String getScientificName() {
        return this.scientificName;
    }

    @Override
    public String getScientificNameAuthorship() {
        return this.scientificNameAuthorship;
    }

    @Override
    @Nullable
    public String getNameComplete() {
        return this.nameComplete;
    }

    @Override
    public TaxonConceptInstance getRepresentative() {
        return this;
    }

    @Override
    public int getPrincipalScore() {
        return this.getScore();
    }

    @Override
    public int getProviderScore() {
        return this.provider.getDefaultScore();
    }

    @Override
    public TaxonConceptInstance addInstance(NameKey instanceKey, TaxonConceptInstance instance) {
        throw new UnsupportedOperationException("Unable to add taxon concept instance " + instance + " to taxon concept instance " + this);
    }

    @Override
    public void reallocate(TaxonConceptInstance element, Taxonomy taxonomy, String reason) {
        throw new UnsupportedOperationException("Unable to reallocate taxon concept instance " + element + " to taxon concept instance " + this);
    }

    public String getYear() {
        return this.year;
    }

    public TaxonomicType getTaxonomicStatus() {
        return this.taxonomicStatus;
    }

    @Override
    public RankType getRank() {
        return this.rank;
    }

    public Set<NomenclaturalStatus> getStatus() {
        return this.status;
    }

    public String getParentNameUsage() {
        return this.parentNameUsage;
    }

    public String getParentNameUsageID() {
        return this.parentNameUsageID;
    }

    public TaxonomicElement getParent() {
        return this.parent;
    }

    public String getAcceptedNameUsage() {
        return this.acceptedNameUsage;
    }

    public String getAcceptedNameUsageID() {
        return this.acceptedNameUsageID;
    }

    public TaxonomicElement getAccepted() {
        return this.accepted;
    }

    public String getVerbatimNomenclaturalClassifier() {
        return this.verbatimNomenclaturalCode;
    }

    public String getVerbatimTaxonomicStatus() {
        return this.verbatimTaxonomicStatus;
    }

    public String getVerbatimTaxonRank() {
        return this.verbatimTaxonRank;
    }

    public String getVerbatimNomenclaturalStatus() {
        return this.verbatimNomenclaturalStatus;
    }

    public List<String> getTaxonRemarks() {
        return this.taxonRemarks;
    }

    public String getTaxonRemarkString() {
        return this.taxonRemarks == null || this.taxonRemarks.isEmpty() ? null : (String)this.taxonRemarks.stream().reduce(null, (a, b) -> a == null ? b : a + " | " + b);
    }

    public void addTaxonRemark(String remark) {
        if (this.taxonRemarks == null) {
            this.taxonRemarks = new ArrayList<String>();
        }
        this.taxonRemarks.add(remark);
    }

    public String getVerbatimTaxonRemarks() {
        return this.verbatimTaxonRemarks;
    }

    public List<String> getProvenance() {
        return this.provenance;
    }

    public String getProvenanceString() {
        return this.provenance == null || this.provenance.isEmpty() ? null : (String)this.provenance.stream().reduce(null, (a, b) -> a == null ? b : a + " | " + b);
    }

    public void addProvenance(String statement) {
        if (this.provenance == null) {
            this.provenance = new ArrayList<String>();
        }
        this.provenance.add(statement);
    }

    public int getBaseScore() {
        if (this.baseScore == null) {
            this.baseScore = this.provider.computeBaseScore(this, this);
        }
        return this.baseScore;
    }

    public int getBaseScore(TaxonConceptInstance original) {
        if (original == this) {
            throw new IllegalStateException("Uncaught loop in score computation from " + original);
        }
        if (this.baseScore == null) {
            this.baseScore = this.provider.computeBaseScore(original, this);
        }
        return this.baseScore;
    }

    public int getScore() {
        if (this.score == null) {
            this.score = this.provider.computeScore(this);
        }
        return this.score;
    }

    public boolean isForbidden() {
        return this.forbidden;
    }

    public Set<TaxonFlag> getFlags() {
        return this.flags;
    }

    public boolean hasFlag(TaxonFlag flag) {
        return this.flags != null && this.flags.contains(flag);
    }

    public List<Distribution> getDistribution() {
        return this.distribution;
    }

    public void setForbidden(boolean forbidden) {
        this.forbidden = forbidden;
    }

    public boolean isOutput() {
        return !this.isForbidden() && this.getTaxonomicStatus().isOutput();
    }

    public Map<Term, Optional<String>> getClassification() {
        return this.classification;
    }

    public void addClassificationHint(Term term, @Nullable String value) {
        if (value == null || this.classification != null && this.classification.containsKey(term) && this.classification.get(term).isPresent()) {
            return;
        }
        if (this.classification == null) {
            this.classification = new HashMap<Term, Optional<String>>();
        }
        this.classification.put(term, Optional.of(value));
    }

    public String getLocator() {
        if (this.provider == null) {
            return this.taxonID;
        }
        return this.provider.getId() + ":" + this.taxonID;
    }

    public TaxonConceptInstance getResolved() {
        if (this.getContainer() == null) {
            throw new IllegalStateException("Not taxon concept. Unable to resolve " + this);
        }
        return ((TaxonConcept)this.getContainer()).getResolved(this);
    }

    public TaxonConceptInstance getResolvedParent() {
        return this.getResolvedParent(this, 40, null, true);
    }

    private List<TaxonomicElement> traceParent() {
        ArrayList<TaxonomicElement> trace = new ArrayList<TaxonomicElement>();
        trace.add(this);
        this.getResolvedParent(this, 40, trace, false);
        return trace;
    }

    public TaxonConceptInstance findSimpleSynonymLoop() {
        List trace = new ArrayList<TaxonConceptInstance>();
        TaxonConceptInstance tci = this;
        for (int steps = 40; tci != null && steps > 0; --steps) {
            if (trace.contains(tci)) {
                int index = trace.indexOf(tci);
                trace = trace.subList(index, trace.size());
                trace.sort((tci1, tci2) -> tci1.getTaxonID().compareTo(tci2.getTaxonID()));
                trace.sort((tci1, tci2) -> tci1.getScore() - tci2.getScore());
                return trace.isEmpty() ? tci : (TaxonConceptInstance)trace.get(0);
            }
            trace.add(tci);
            TaxonomicElement a = tci.getAccepted();
            tci = a != null && a instanceof TaxonConceptInstance ? (TaxonConceptInstance)a : null;
        }
        return tci;
    }

    public void resolveSynonymLoop(Taxonomy taxonomy) {
        TaxonConceptInstance breakPoint = this.findSimpleSynonymLoop();
        if (breakPoint == null) {
            return;
        }
        if (breakPoint != this) {
            breakPoint.resolveSynonymLoop(taxonomy);
            return;
        }
        taxonomy.report(IssueType.PROBLEM, "instance.accepted.resolve.loop", this, this.traceAccepted());
        this.taxonomicStatus = TaxonomicType.INFERRED_UNPLACED;
        this.accepted = null;
        this.acceptedNameUsage = null;
        this.acceptedNameUsageID = null;
        this.score = null;
        if (this.parent == null) {
            String unknownTaxonID = this.getProvider().getUnknownTaxonID();
            TaxonConceptInstance unknownTaxon = taxonomy.getInstance(unknownTaxonID);
            this.parentNameUsage = null;
            this.parentNameUsageID = unknownTaxonID;
            this.parent = unknownTaxon;
        }
        String provenance = taxonomy.getResources().getString("instance.accepted.resolve.loop.provenance");
        this.addProvenance(provenance);
    }

    public TaxonConceptInstance findSimpleParentLoop() {
        ArrayList<TaxonConceptInstance> trace = new ArrayList<TaxonConceptInstance>();
        TaxonConceptInstance tci = this;
        for (int steps = 40; tci != null && steps > 0; --steps) {
            if (trace.contains(tci)) {
                return trace.stream().min((tci1, tci2) -> tci1.getRank().getId() - tci2.getRank().getId()).orElse(tci);
            }
            trace.add(tci);
            TaxonomicElement p = tci.getParent();
            tci = p != null && p instanceof TaxonConceptInstance ? (TaxonConceptInstance)p : null;
        }
        return tci;
    }

    public void resolveParentLoop(Taxonomy taxonomy) {
        TaxonConceptInstance breakPoint = this.findSimpleParentLoop();
        if (breakPoint == null) {
            return;
        }
        if (breakPoint != this) {
            breakPoint.resolveParentLoop(taxonomy);
            return;
        }
        this.taxonomicStatus = TaxonomicType.INFERRED_UNPLACED;
        String unknownTaxonID = this.getProvider().getUnknownTaxonID();
        TaxonConceptInstance unknownTaxon = taxonomy.getInstance(unknownTaxonID);
        taxonomy.report(IssueType.PROBLEM, "instance.parent.resolve.loop", this, this.traceParent());
        this.parent = unknownTaxon;
        this.parentNameUsage = null;
        this.parentNameUsageID = unknownTaxonID;
        this.score = null;
        String provenance = taxonomy.getResources().getString("instance.parent.resolve.loop.provenance");
        this.addProvenance(provenance);
    }

    public void resolveInvalidParent(Taxonomy taxonomy) {
        this.taxonomicStatus = TaxonomicType.INFERRED_UNPLACED;
        String unknownTaxonID = this.getProvider().getUnknownTaxonID();
        TaxonConceptInstance unknownTaxon = taxonomy.getInstance(unknownTaxonID);
        taxonomy.report(IssueType.PROBLEM, "instance.parent.resolve.invalid", this, this.traceParent());
        this.parent = unknownTaxon;
        this.parentNameUsage = null;
        this.parentNameUsageID = unknownTaxonID;
        this.score = null;
        String provenance = taxonomy.getResources().getString("instance.parent.resolve.invalid.provenance");
        this.addProvenance(provenance);
    }

    private boolean validateParent(Taxonomy taxonomy) {
        if (this.parent == null) {
            return true;
        }
        TaxonConceptInstance loop = this.findSimpleParentLoop();
        if (loop != null) {
            taxonomy.report(IssueType.VALIDATION, "instance.validation.parent.loop", this, this.traceParent());
            return false;
        }
        return true;
    }

    private TaxonConceptInstance getResolvedParent(TaxonConceptInstance original, int steps, @Nullable List<TaxonomicElement> trace, boolean exception) {
        if (steps <= 0) {
            if (original.isForbidden() || this.isForbidden()) {
                return null;
            }
            if (exception) {
                throw new ResolutionException("Detected possible loop resolving parent " + original, trace);
            }
            return null;
        }
        TaxonConceptInstance resolved = this.getResolvedAccepted(original, steps - 1, trace, exception);
        if (resolved == null) {
            return null;
        }
        TaxonomicElement pe = resolved.getParent();
        if (pe == null) {
            return null;
        }
        TaxonConceptInstance parent = pe.getRepresentative();
        if (parent == null) {
            return null;
        }
        if ((parent = parent.getResolvedAccepted(original, steps - 1, trace, exception)) == null) {
            return null;
        }
        if (trace != null && trace.contains(parent)) {
            trace.add(parent);
            if (exception) {
                throw new ResolutionException("Detected possible loop resolving parent " + original, trace);
            }
            return null;
        }
        if (trace != null) {
            trace.add(parent);
        }
        if (parent == null || !parent.isForbidden()) {
            return parent;
        }
        return parent.getResolvedParent(original, steps - 1, trace, exception);
    }

    public TaxonConceptInstance getResolvedAccepted() {
        return this.getResolvedAccepted(this, 40, null, true);
    }

    private List<TaxonomicElement> traceAccepted() {
        ArrayList<TaxonomicElement> trace = new ArrayList<TaxonomicElement>();
        trace.add(this);
        this.getResolvedAccepted(this, 40, trace, false);
        return trace;
    }

    private TaxonConceptInstance getResolvedAccepted(TaxonConceptInstance original, int steps, @Nullable List<TaxonomicElement> trace, boolean exception) {
        TaxonConceptInstance accepted;
        if (steps <= 0) {
            if (original.isForbidden() || this.isForbidden()) {
                return null;
            }
            if (exception) {
                throw new ResolutionException("Detected possible loop resolving accepted " + original, trace);
            }
            return original;
        }
        TaxonConceptInstance resolved = this.getResolved(original, steps - 1);
        if (resolved == null) {
            if (original.isForbidden() || this.isForbidden()) {
                return null;
            }
            if (exception) {
                throw new ResolutionException("Detected dangling resolution resolving accepted " + original, trace);
            }
            return original;
        }
        TaxonomicElement ae = resolved.getAccepted();
        if (ae == null || ae == resolved) {
            return resolved;
        }
        if (trace != null && trace.contains(ae)) {
            trace.add(ae);
            if (exception) {
                throw new ResolutionException("Detected possible loop resolving accepted " + original, trace);
            }
            return original;
        }
        if (trace != null) {
            trace.add(ae);
        }
        if ((accepted = ae.getRepresentative()) == null) {
            logger.warn("Null representative instance for " + ae + " when resolving " + this);
            return resolved;
        }
        if (!(accepted = accepted.getResolvedAccepted(original, steps - 1, trace, exception)).isForbidden()) {
            return accepted;
        }
        return accepted.getResolvedParent(original, steps - 1, trace, exception);
    }

    private TaxonConceptInstance getResolved(TaxonConceptInstance original, int steps) {
        if (steps <= 0) {
            if (this.isForbidden()) {
                return null;
            }
            throw new ResolutionException("Detected possible loop resolving " + original);
        }
        TaxonConceptInstance resolved = this.getResolved();
        if (resolved != null && this != resolved) {
            return resolved.getResolved(original, steps - 1);
        }
        return resolved;
    }

    public boolean isResolved() {
        return this.getResolved() != null;
    }

    public boolean isPrimary() {
        return this.taxonomicStatus != null && this.taxonomicStatus.isPrimary() && !this.hasFlag(TaxonFlag.SYNTHETIC);
    }

    public boolean isGeographic() {
        return this.taxonomicStatus != null && this.taxonomicStatus.isGeographic() && !this.hasFlag(TaxonFlag.SYNTHETIC);
    }

    public void normalise() throws IndexBuilderException {
        int pos;
        if (this.acceptedNameUsageID != null && this.acceptedNameUsageID.equals(this.taxonID)) {
            this.acceptedNameUsageID = null;
        }
        if (this.scientificNameAuthorship != null && (pos = this.scientificName.indexOf(this.scientificNameAuthorship)) >= 0) {
            this.scientificName = this.scientificName.substring(0, pos) + this.scientificName.substring(pos + this.scientificNameAuthorship.length());
            this.scientificName = this.scientificName.trim();
        }
    }

    public boolean resolveLinks(Taxonomy taxonomy) throws IndexBuilderException {
        StringBuilder name;
        if (this.parentNameUsageID != null) {
            this.parent = taxonomy.getInstance(this.parentNameUsageID);
        }
        if (this.parentNameUsage != null && this.parent == null) {
            this.parent = taxonomy.findElement(this.code, this.parentNameUsage, this.provider, null);
        }
        if (this.parent == null && (this.parentNameUsage != null || this.parentNameUsageID != null)) {
            name = new StringBuilder();
            if (this.parentNameUsageID != null) {
                name.append(this.parentNameUsageID);
            }
            if (this.parentNameUsage != null) {
                if (name.length() > 0) {
                    name.append(" - ");
                }
                name.append(this.parentNameUsage);
            }
            taxonomy.report(IssueType.ERROR, "instance.parent.invalidLink", this.taxonID, this.scientificName, "Unable to find parent taxon for " + this + " from " + name);
            if (this.acceptedNameUsageID == null && this.acceptedNameUsage == null && this.classification == null) {
                return false;
            }
            this.addProvenance("Unable to find supplied parent taxon " + name);
        }
        if (this.acceptedNameUsageID != null) {
            this.accepted = taxonomy.getInstance(this.acceptedNameUsageID);
        }
        if (this.acceptedNameUsage != null && this.accepted == null) {
            this.accepted = taxonomy.findElement(this.code, this.acceptedNameUsage, this.provider, null);
        }
        if (this.accepted == null && (this.acceptedNameUsage != null || this.acceptedNameUsageID != null)) {
            name = new StringBuilder();
            if (this.acceptedNameUsageID != null) {
                name.append(this.acceptedNameUsageID);
            }
            if (this.acceptedNameUsage != null) {
                if (name.length() > 0) {
                    name.append(" - ");
                }
                name.append(this.acceptedNameUsage);
            }
            taxonomy.report(IssueType.ERROR, "instance.accepted.invalidLink", this.taxonID, this.scientificName, "Unable to find accepted taxon for " + this + " from " + name);
            if (this.classification == null) {
                return false;
            }
            this.addProvenance("Unable to find accepted taxon " + name);
        }
        if (this.parent == null && this.accepted == null && this.classification != null) {
            String genus = "";
            String specificEpithet = "sp.";
            for (int i = 0; i < CLASSIFICATION_FIELDS.size(); ++i) {
                RankType pr;
                Optional<String> name2;
                Term cls = CLASSIFICATION_FIELDS.get(i);
                RankType clr = CLASSIFICATION_RANKS.get(i);
                if (!this.rank.isLoose() && !clr.isHigherThan(this.rank) || (name2 = this.classification.get(cls)) == null || !name2.isPresent()) continue;
                String n = name2.get();
                if (cls.equals(DwcTerm.genus)) {
                    genus = n;
                }
                if (cls.equals(DwcTerm.specificEpithet)) {
                    specificEpithet = n;
                    n = (genus + " " + n).trim();
                }
                if (cls.equals(DwcTerm.infraspecificEpithet)) {
                    n = (genus + " " + specificEpithet + " " + n).trim();
                }
                if (n.equalsIgnoreCase(this.scientificName)) continue;
                TaxonomicElement p = taxonomy.findElement(this.code, n, this.provider, clr);
                RankType rankType = pr = p != null ? p.getRank() : null;
                if (p == null || p == this || !this.rank.isLoose() && !pr.isLoose() && pr != null && !pr.isHigherThan(this.rank)) continue;
                this.parent = p;
            }
        }
        if (this.parent == null && this.accepted == null && !this.rank.isHigherThan(RankType.PHYLUM)) {
            taxonomy.count("count.resolve.instance.defaultParent");
            this.parent = this.provider.findDefaultParent(taxonomy, this);
            this.addProvenance("Assigned to default parent taxon");
        }
        if (this.parent != null && this.accepted == null && this.isSynonym()) {
            this.taxonomicStatus = TaxonomicType.INFERRED_ACCEPTED;
            this.addProvenance("Synonym without accepted taxon treated as accepted");
        }
        taxonomy.count("count.resolve.instance.links");
        return true;
    }

    public void detectDiscard(Taxonomy taxonomy, Collection<TaxonConceptInstance> allInstances) throws IndexBuilderException {
        if (!this.hasFlag(TaxonFlag.SYNTHETIC) || this.isForbidden()) {
            return;
        }
        boolean required = allInstances.stream().anyMatch(tci -> !tci.isForbidden() && tci.getResolvedParent() == this);
        if (!required) {
            this.setForbidden(true);
            taxonomy.count("count.resolve.synthetic.discarded");
            taxonomy.report(IssueType.NOTE, "instance.discarded.synthetic", this, null);
        }
    }

    public void resolveDiscarded(Taxonomy taxonomy) throws IndexBuilderException {
        if (!this.isForbidden()) {
            return;
        }
        TaxonConceptInstance parent = this.getResolvedParent();
        if (parent == null) {
            return;
        }
        switch (this.getProvider().getDiscardStrategy()) {
            case IDENTIFIER_TO_PARENT: {
                Document doc = new Document();
                doc.add((IndexableField)new StringField("type", GbifTerm.Identifier.qualifiedName(), Field.Store.YES));
                doc.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
                doc.add((IndexableField)new StringField(Taxonomy.fieldName((Term)DwcTerm.taxonID), parent.getTaxonID(), Field.Store.YES));
                doc.add((IndexableField)new StringField(Taxonomy.fieldName((Term)DcTerm.identifier), this.getTaxonID(), Field.Store.YES));
                doc.add((IndexableField)new StringField(Taxonomy.fieldName((Term)DwcTerm.datasetID), taxonomy.getInferenceProvider().getId(), Field.Store.YES));
                doc.add((IndexableField)new StringField(Taxonomy.fieldName((Term)DcTerm.title), taxonomy.getResources().getString("instance.discarded.identifier.title"), Field.Store.YES));
                doc.add((IndexableField)new StringField(Taxonomy.fieldName((Term)ALATerm.status), "discarded", Field.Store.YES));
                if (this.taxonRemarks != null) {
                    doc.add((IndexableField)new StringField(Taxonomy.fieldName((Term)DcTerm.description), this.getTaxonRemarkString(), Field.Store.YES));
                }
                String provenance = taxonomy.getResources().getString("instance.discarded.identifier.provenance");
                provenance = MessageFormat.format(provenance, this.getScientificName());
                doc.add((IndexableField)new StringField(Taxonomy.fieldName((Term)DcTerm.provenance), provenance, Field.Store.YES));
                taxonomy.addProvenanceToOutput();
                try {
                    taxonomy.addRecords(Collections.singletonList(doc));
                    break;
                }
                catch (IOException ex) {
                    throw new IndexBuilderException("Unable to process discard", ex);
                }
            }
            case SYNONYMISE_TO_PARENT: {
                this.provider = taxonomy.getInferenceProvider();
                this.forbidden = false;
                this.taxonomicStatus = TaxonomicType.INFERRED_SYNONYM;
                this.parent = null;
                this.parentNameUsage = null;
                this.parentNameUsageID = null;
                this.accepted = parent;
                this.acceptedNameUsage = null;
                this.acceptedNameUsageID = parent.getTaxonID();
                this.score = this.provider.getDefaultScore();
                String provenance = taxonomy.getResources().getString("instance.discarded.synonym.provenance");
                provenance = MessageFormat.format(provenance, this.getTaxonID());
                this.addProvenance(provenance);
                taxonomy.addProvenanceToOutput();
                ((TaxonConcept)this.getContainer()).resolveTaxon(taxonomy, true);
                break;
            }
        }
    }

    public boolean isAccepted() {
        return this.taxonomicStatus.isAccepted();
    }

    public boolean isSynonym() {
        return this.taxonomicStatus.isSynonym();
    }

    public boolean isInferredSynonym() {
        return this.taxonomicStatus == TaxonomicType.INFERRED_SYNONYM;
    }

    public Map<Term, String> getTaxonMap(Taxonomy taxonomy, boolean strict) throws IOException {
        Map<Object, Object> values;
        List<Map<Term, String>> valuesList = taxonomy.getIndexValues((Term)DwcTerm.Taxon, this.taxonID);
        if (valuesList.isEmpty()) {
            if (this.provider != taxonomy.getInferenceProvider()) {
                taxonomy.report(IssueType.NOTE, "instance.noIndex", this, null);
            }
            values = new HashMap();
        } else {
            if (valuesList.size() > 1) {
                taxonomy.report(IssueType.ERROR, "instance.multiIndex", this, null);
            }
            values = valuesList.get(0);
        }
        values.put(DwcTerm.taxonID, this.taxonID);
        values.put(DwcTerm.nomenclaturalCode, this.code == null ? null : this.code.getAcronym());
        values.put(ALATerm.verbatimNomenclaturalCode, this.verbatimNomenclaturalCode);
        values.put(DwcTerm.datasetID, this.provider.getId());
        values.put(DwcTerm.scientificName, this.scientificName);
        values.put(DwcTerm.scientificNameAuthorship, this.scientificNameAuthorship);
        values.put(DwcTerm.namePublishedInYear, this.year);
        values.put(DwcTerm.taxonomicStatus, this.taxonomicStatus.getTerm());
        values.put(ALATerm.verbatimTaxonomicStatus, this.verbatimTaxonomicStatus);
        values.put(DwcTerm.nomenclaturalStatus, this.status == null ? null : this.status.stream().map(NomenclaturalStatus::getAbbreviatedLabel).collect(Collectors.joining(", ")));
        values.put(ALATerm.verbatimNomenclaturalStatus, this.verbatimNomenclaturalStatus);
        values.put(DwcTerm.taxonRank, this.rank.getRank());
        values.put(DwcTerm.verbatimTaxonRank, this.verbatimTaxonRank);
        values.put(ALATerm.priority, Integer.toString(this.getScore()));
        if (this.taxonRemarks != null) {
            values.put(DwcTerm.taxonRemarks, this.getTaxonRemarkString());
        }
        if (this.verbatimTaxonRemarks != null) {
            values.put(ALATerm.verbatimTaxonRemarks, this.verbatimTaxonRemarks);
        }
        if (this.provenance != null) {
            values.put(DcTerm.provenance, this.getProvenanceString());
        }
        if (this.parent == null || !this.isAccepted() && strict) {
            values.remove(DwcTerm.parentNameUsageID);
            values.remove(DwcTerm.parentNameUsage);
        } else {
            String pid = null;
            try {
                TaxonConceptInstance rp = this.getResolvedParent();
                if (rp == this) {
                    throw new ResolutionException("Hidden loop in parent");
                }
                pid = rp == null ? null : rp.getTaxonID();
            }
            catch (ResolutionException ex) {
                pid = this.provider.getUnknownTaxonID();
                taxonomy.report(IssueType.ERROR, "instance.parent.resolve.loop", this, this.traceParent());
            }
            values.put(DwcTerm.parentNameUsageID, pid);
        }
        if (this.accepted == null || !this.isSynonym() && strict) {
            values.remove(DwcTerm.acceptedNameUsageID);
            values.remove(DwcTerm.acceptedNameUsage);
        } else {
            String aid = null;
            try {
                TaxonConceptInstance ra = this.getResolvedAccepted();
                if (ra == this) {
                    throw new ResolutionException("Hidden loop in accepted");
                }
                aid = ra == null || ra == this ? null : ra.getTaxonID();
            }
            catch (ResolutionException ex) {
                aid = this.provider.getUnknownTaxonID();
                taxonomy.report(IssueType.ERROR, "instance.accepted.resolve.loop", this, this.traceAccepted());
            }
            values.put(DwcTerm.acceptedNameUsageID, aid);
        }
        return values;
    }

    public List<Map<Term, String>> getIdentifierMaps(Taxonomy taxonomy) throws IOException {
        HashMap<Object, String> values2;
        Map<Term, String> taxon = this.getTaxonMap(taxonomy, true);
        String scientificNameID = taxon.get(DwcTerm.scientificNameID);
        String taxonConceptID = taxon.get(DwcTerm.taxonConceptID);
        String source = taxon.get(DcTerm.source);
        List<Map<Term, String>> valuesList = taxonomy.getIndexValues((Term)GbifTerm.Identifier, this.taxonID);
        Set identifiers = valuesList.stream().map(values -> (String)values.get(DcTerm.identifier)).collect(Collectors.toSet());
        if (!identifiers.contains(this.taxonID)) {
            values2 = new HashMap<Object, String>();
            values2.put(DcTerm.identifier, this.taxonID);
            values2.put(DwcTerm.datasetID, this.provider.getId());
            values2.put(DcTerm.title, "Taxon");
            values2.put(ALATerm.status, "current");
            if (source != null) {
                values2.put(DcTerm.source, source);
            }
            valuesList.add(values2);
        }
        if (scientificNameID != null && !identifiers.contains(scientificNameID)) {
            values2 = new HashMap();
            values2.put(DcTerm.identifier, scientificNameID);
            values2.put(DwcTerm.datasetID, this.provider.getId());
            values2.put(DcTerm.title, "Scientific Name");
            values2.put(ALATerm.status, "current");
            if (source != null) {
                values2.put(DcTerm.source, source);
            }
            valuesList.add(values2);
        }
        if (taxonConceptID != null && !identifiers.contains(taxonConceptID)) {
            values2 = new HashMap();
            values2.put(DcTerm.identifier, taxonConceptID);
            values2.put(DwcTerm.datasetID, this.provider.getId());
            values2.put(DcTerm.title, "Taxon Concept");
            values2.put(ALATerm.status, "current");
            if (source != null) {
                values2.put(DcTerm.source, source);
            }
            valuesList.add(values2);
        }
        return valuesList;
    }

    public List<Map<Term, String>> getVernacularMaps(Taxonomy taxonomy) throws IOException {
        List<Map<Term, String>> valuesList = taxonomy.getIndexValues((Term)GbifTerm.VernacularName, this.taxonID);
        return valuesList;
    }

    public List<Map<Term, String>> getReferenceMaps(Taxonomy taxonomy) throws IOException {
        List<Map<Term, String>> valuesList = taxonomy.getIndexValues((Term)GbifTerm.Reference, this.taxonID);
        return valuesList;
    }

    public List<Map<Term, String>> getDistributionMaps(Taxonomy taxonomy) throws IOException {
        List<Map<Term, String>> valuesList = taxonomy.getIndexValues((Term)GbifTerm.Distribution, this.taxonID);
        return valuesList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append("TCI[");
        builder.append(this.getProvider().getId());
        builder.append(":");
        builder.append(this.getTaxonID());
        builder.append(", ");
        builder.append(this.getCode());
        builder.append(", ");
        if (this.nameComplete != null) {
            builder.append(this.nameComplete);
        } else {
            builder.append(this.getScientificName());
            builder.append(", ");
            builder.append(this.getScientificNameAuthorship());
        }
        builder.append(", ");
        builder.append(this.getRank());
        builder.append(", ");
        builder.append(this.getTaxonomicStatus());
        builder.append("]");
        return builder.toString();
    }

    public boolean isOwned() {
        return this.provider.owns(this.scientificName);
    }

    public TaxonConceptInstance createInferredSynonym(TaxonConcept concept, String scientificName, String scientificNameAuthorship, String nameComplete, String year, Taxonomy taxonomy) {
        TaxonConceptInstance synonym = new TaxonConceptInstance(UUID.randomUUID().toString(), this.code, this.verbatimNomenclaturalCode, taxonomy.getInferenceProvider(), scientificName, scientificNameAuthorship, nameComplete, year, TaxonomicType.INFERRED_SYNONYM, this.verbatimTaxonomicStatus, this.rank, this.verbatimTaxonRank, this.status, this.verbatimNomenclaturalStatus, null, null, null, this.getTaxonID(), this.taxonRemarks == null ? null : new ArrayList<String>(this.taxonRemarks), this.verbatimTaxonRemarks, this.provenance == null ? null : new ArrayList<String>(this.provenance), this.classification, this.flags, this.distribution);
        synonym.setContainer(concept);
        synonym.accepted = this;
        synonym.baseScore = null;
        synonym.score = null;
        synonym.forbidden = false;
        String provenance = taxonomy.getResources().getString("instance.inferredSynonym.provenance");
        provenance = MessageFormat.format(provenance, this.getTaxonID(), this.provider.getId());
        synonym.addProvenance(provenance);
        taxonomy.addProvenanceToOutput();
        taxonomy.addInferredInstance(synonym);
        return synonym;
    }

    public TaxonConceptInstance createRankedInstance(RankType newRank, Taxonomy taxonomy) {
        TaxonConceptInstance instance = new TaxonConceptInstance(this.taxonID, this.code, this.verbatimNomenclaturalCode, this.provider, this.scientificName, this.scientificNameAuthorship, this.nameComplete, this.year, this.taxonomicStatus, this.verbatimTaxonomicStatus, newRank, this.verbatimTaxonRank, this.status, this.verbatimNomenclaturalStatus, this.parentNameUsage, this.parentNameUsageID, this.acceptedNameUsage, this.acceptedNameUsageID, this.taxonRemarks == null ? null : new ArrayList<String>(this.taxonRemarks), this.verbatimTaxonRemarks, this.provenance == null ? null : new ArrayList<String>(this.provenance), this.classification, this.flags, this.distribution);
        instance.setContainer(null);
        instance.accepted = this.accepted;
        instance.parent = this.parent;
        instance.baseScore = null;
        instance.score = null;
        instance.forbidden = false;
        String provenance = taxonomy.getResources().getString("taxonConcept.unranked.reallocate.provenance");
        provenance = MessageFormat.format(provenance, newRank.getRank());
        instance.addProvenance(provenance);
        taxonomy.report(IssueType.NOTE, "taxonConcept.unranked.reallocate", this, Arrays.asList(instance));
        taxonomy.count("count.resolve.unrankedTaxonConcept");
        taxonomy.addProvenanceToOutput();
        taxonomy.insertInstance(instance.getTaxonID(), ((TaxonConcept)this.getContainer()).getKey().toRankedNameKey(newRank), instance);
        return instance;
    }

    public void forwardTo(TaxonConceptInstance other, Taxonomy taxonomy) {
        if (other.getTaxonID().equals(this.taxonID)) {
            this.taxonID = UUID.randomUUID().toString();
            taxonomy.addInferredInstance(this);
        }
        this.setForbidden(true);
        this.provider = taxonomy.getInferenceProvider();
        this.taxonomicStatus = TaxonomicType.INFERRED_SYNONYM;
        this.acceptedNameUsage = null;
        this.acceptedNameUsageID = other.getTaxonID();
        this.accepted = other;
        this.parentNameUsage = null;
        this.parentNameUsageID = null;
        this.parent = null;
        this.classification = null;
    }

    public boolean hasInvalidParent() {
        if (this.parent != null) {
            return false;
        }
        boolean check = this.parentNameUsageID != null;
        boolean bl = check = check || this.parentNameUsage != null;
        if (this.isAccepted() && this.classification != null && !this.rank.isHigherThan(RankType.PHYLUM)) {
            check = check || this.classification.values().stream().anyMatch(v -> v.isPresent() && !((String)v.get()).equals(this.scientificName));
        }
        return check;
    }

    @Override
    public boolean validate(Taxonomy taxonomy) {
        boolean valid = true;
        if (this.hasInvalidParent()) {
            if (this.provider.isLoose()) {
                taxonomy.report(IssueType.NOTE, "instance.validation.noParent.loose", this, null);
            } else {
                taxonomy.report(IssueType.VALIDATION, "instance.validation.noParent", this, null);
                valid = false;
            }
        }
        if ((this.acceptedNameUsageID != null || this.acceptedNameUsage != null) && this.accepted == null) {
            if (this.provider.isLoose()) {
                taxonomy.report(IssueType.NOTE, "instance.validation.noAccepted.loose", this, null);
            } else {
                taxonomy.report(IssueType.VALIDATION, "instance.validation.noAccepted", this, null);
                valid = false;
            }
        }
        if (this.parent != null && this.isSynonym()) {
            taxonomy.report(IssueType.VALIDATION, "instance.validation.synonymWithParent", this, null);
            valid = false;
        }
        if (this.accepted != null && this.isAccepted()) {
            taxonomy.report(IssueType.VALIDATION, "instance.validation.acceptedWithAccepted", this, null);
            valid = false;
        }
        if (this.getContainer() == null) {
            taxonomy.report(IssueType.VALIDATION, "instance.validation.noTaxonConcept", this, null);
            valid = false;
        } else if (((TaxonConcept)this.getContainer()).getContainer() == null) {
            taxonomy.report(IssueType.VALIDATION, "instance.validation.noScientificName", this, null);
            valid = false;
        }
        valid = valid && this.validateParent(taxonomy);
        return valid;
    }
}

