/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.Distribution;
import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.Reporter;
import au.org.ala.names.index.ScientificName;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.TaxonResolution;
import au.org.ala.names.index.TaxonResolver;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.index.UnrankedScientificName;
import au.org.ala.names.model.RankType;
import au.org.ala.names.util.DwcaWriter;
import au.org.ala.vocab.ALATerm;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;

public class TaxonConcept
extends TaxonomicElement<TaxonConcept, ScientificName> {
    private NameKey key;
    private List<TaxonConceptInstance> instances;
    private TaxonResolution resolution;
    private boolean cleared;

    public TaxonConcept(ScientificName name, NameKey key) {
        super(name);
        this.key = key;
        this.instances = new ArrayList<TaxonConceptInstance>();
        this.resolution = null;
        this.cleared = false;
    }

    public NameKey getKey() {
        return this.key;
    }

    public List<TaxonConceptInstance> getInstances() {
        return Collections.unmodifiableList(this.instances);
    }

    public boolean isResolved() {
        return this.resolution != null;
    }

    public TaxonConceptInstance getResolved(TaxonConceptInstance instance) {
        if (this.resolution == null) {
            return instance;
        }
        TaxonConceptInstance resolved = this.resolution.getResolved(instance);
        if (resolved == null) {
            throw new IllegalStateException("Unable to get resolution for " + this);
        }
        return resolved;
    }

    public List<Distribution> getDistribution(TaxonConceptInstance instance) {
        TaxonConceptInstance resolved = this.resolution.getResolved(instance);
        if (resolved.getContainer() == this) {
            instance = resolved;
        }
        return this.resolution.getDistribution(instance);
    }

    @Override
    public TaxonConceptInstance addInstance(NameKey instanceKey, TaxonConceptInstance instance) {
        instance.setContainer(this);
        this.instances.removeIf(tci -> tci.getTaxonID().equals(instance.getTaxonID()));
        this.instances.add(instance);
        return instance;
    }

    public TaxonConceptInstance findInstance(NameProvider provider, boolean acceptedOnly) {
        for (TaxonConceptInstance instance : this.instances) {
            if (!instance.getProvider().equals(provider) || instance.isForbidden() || acceptedOnly && !instance.isAccepted()) continue;
            return instance;
        }
        return null;
    }

    public void resolveTaxon(Taxonomy taxonomy, boolean reset) throws IndexBuilderException {
        if (this.resolution != null && !reset) {
            return;
        }
        TaxonResolver resolver = taxonomy.getResolver();
        List<TaxonConceptInstance> principals = resolver.principals(this, this.instances);
        this.resolution = resolver.resolve(this, principals, this.instances);
        taxonomy.count("count.resolve.taxonConcept");
        taxonomy.count("count.resolve.taxonConceptInstance", this.instances.size());
    }

    @Override
    public void reallocate(TaxonConcept element, Taxonomy taxonomy, String reason) {
        taxonomy.report(IssueType.NOTE, "taxonConcept.reallocated", element, Arrays.asList(this));
        taxonomy.count("count.reallocate.taxonConcept");
        TaxonConceptInstance representative = this.getRepresentative();
        if (representative == null || this.resolution == null) {
            throw new IndexBuilderException("Unable to reallocate " + element + " to " + this + " without representative and resolution");
        }
        String reallocated = taxonomy.getResources().getString(reason);
        reallocated = MessageFormat.format(reallocated, representative.getTaxonID(), representative.getDisplayName());
        taxonomy.addProvenanceToOutput();
        element.resolution = new TaxonResolution();
        for (TaxonConceptInstance tci : element.instances) {
            tci.setContainer(this);
            tci.addProvenance(reallocated);
            this.instances.add(tci);
            this.resolution.addExternal(tci, representative, taxonomy);
            element.resolution.addExternal(tci, representative, taxonomy);
        }
        element.instances.clear();
        element.cleared = true;
    }

    public void resolveDistribution(Taxonomy taxonomy) {
        if (this.cleared) {
            return;
        }
        taxonomy.getResolver().resolveDistribution(this, this.resolution, taxonomy);
    }

    public void write(Taxonomy taxonomy, DwcaWriter writer) throws IOException {
        if (this.cleared) {
            return;
        }
        if (!taxonomy.isWritable(this)) {
            return;
        }
        HashSet<String> seen = new HashSet<String>();
        for (TaxonConceptInstance tci : this.getUsed()) {
            if (!tci.isOutput()) continue;
            if (seen.contains(tci.getTaxonID())) {
                taxonomy.report(IssueType.PROBLEM, "taxonConcept.duplicate.used", tci, null);
                continue;
            }
            List<TaxonConceptInstance> allocated = this.resolution.getChildren(tci);
            if (allocated == null || allocated.isEmpty()) {
                taxonomy.report(IssueType.NOTE, "taxonConcept.noInstances", tci, null);
                continue;
            }
            seen.add(tci.getTaxonID());
            writer.newRecord(tci.getTaxonID());
            taxonomy.count("count.write.taxonConcept");
            Map<Term, String> values = tci.getTaxonMap(taxonomy, true);
            for (Term term : taxonomy.outputTerms((Term)DwcTerm.Taxon)) {
                if (term == DwcTerm.taxonID) continue;
                writer.addCoreColumn(term, values.get(term));
            }
            List<Distribution> distribution = this.resolution.getDistribution(tci);
            if (distribution != null) {
                for (Distribution dist : distribution) {
                    dist.writeExtension(taxonomy, writer);
                }
            }
            for (TaxonConceptInstance sub : allocated) {
                if (!sub.isOutput()) continue;
                this.writeExtension((Term)ALATerm.TaxonVariant, sub == tci ? values : sub.getTaxonMap(taxonomy, false), taxonomy, writer);
                taxonomy.count("count.write.taxonConceptInstance");
                for (Map<Term, String> id : sub.getIdentifierMaps(taxonomy)) {
                    this.writeExtension((Term)GbifTerm.Identifier, id, taxonomy, writer);
                }
                for (Map<Term, String> vn : sub.getVernacularMaps(taxonomy)) {
                    this.writeExtension((Term)GbifTerm.VernacularName, vn, taxonomy, writer);
                }
                for (Map<Term, String> vn : sub.getReferenceMaps(taxonomy)) {
                    this.writeExtension((Term)GbifTerm.Reference, vn, taxonomy, writer);
                }
            }
        }
        taxonomy.count("count.write.taxonConcept.base");
    }

    private void writeExtension(Term type, Map<Term, String> values, Taxonomy taxonomy, DwcaWriter writer) throws IOException {
        LinkedHashMap<Term, String> ext = new LinkedHashMap<Term, String>();
        List<Term> terms = taxonomy.outputTerms(type);
        for (Term term : terms) {
            String value = values.get(term);
            ext.put(term, value);
        }
        if (!ext.isEmpty()) {
            writer.addExtensionRecord(type, ext);
        }
    }

    @Override
    public RankType getRank() {
        return this.resolution == null ? this.key.getRank() : this.resolution.getRank();
    }

    public boolean hasAccepted() {
        return this.resolution != null ? this.resolution.hasAccepted() : this.instances.stream().anyMatch(tci -> tci.isAccepted() && !tci.isForbidden());
    }

    public boolean isFormal() {
        return this.key.isFormal();
    }

    public boolean isAuthored() {
        return !this.key.isUnauthored();
    }

    public boolean isAutonym() {
        return this.key.isAutonym();
    }

    public void addInferredSynonym(TaxonConcept principal, Taxonomy taxonomy) {
        TaxonResolver resolver = taxonomy.getResolver();
        TaxonConceptInstance representative = principal.getRepresentative();
        if (representative == null) {
            taxonomy.report(IssueType.ERROR, "taxonConcept.representative", principal, Arrays.asList(this));
            return;
        }
        List inferred = this.resolution.getUsed().stream().filter(tci -> tci.isAccepted()).map(tci -> representative.createInferredSynonym(this, tci.getScientificName(), tci.getScientificNameAuthorship(), tci.getNameComplete(), tci.getYear(), taxonomy)).collect(Collectors.toList());
        if (inferred.isEmpty()) {
            taxonomy.report(IssueType.ERROR, "taxonConcept.inferredSynonyms", principal, Arrays.asList(this));
            return;
        }
        this.instances.addAll(inferred);
        List<TaxonConceptInstance> used = this.instances.stream().filter(tci -> tci.isInferredSynonym()).collect(Collectors.toList());
        if (used.size() > 1) {
            taxonomy.report(IssueType.NOTE, "taxonConcept.multipleInferredSynonyms", this, used);
        }
        this.resolution = resolver.resolve(this, used, this.instances);
        taxonomy.count("count.resolve.inferredSynonym");
    }

    public List<TaxonConceptInstance> getPrincipals() {
        return this.resolution == null ? null : this.resolution.getPrincipal();
    }

    public List<TaxonConceptInstance> getUsed() {
        return this.resolution == null ? this.getInstances() : this.resolution.getUsed();
    }

    @Override
    public TaxonConceptInstance getRepresentative() {
        if (this.resolution == null) {
            return this.instances.isEmpty() ? null : this.instances.get(0);
        }
        return this.resolution.getUsed().isEmpty() ? null : this.resolution.getUsed().get(0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        TaxonConceptInstance representative = this.getRepresentative();
        builder.append("TC[");
        builder.append(this.key.getCode() == null ? "no code" : this.key.getCode().getAcronym());
        builder.append(", ");
        builder.append(this.key.getScientificName());
        builder.append(", ");
        builder.append(this.key.getScientificNameAuthorship());
        builder.append(", ");
        builder.append(this.key.getRank());
        if (representative != null) {
            builder.append(" = ");
            builder.append(representative.getLocator());
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean isOwned() {
        TaxonConceptInstance accepted = this.getRepresentative();
        return accepted != null && accepted.getContainer() == this && accepted.isOwned();
    }

    @Override
    public String getTaxonID() {
        return this.getRepresentative() == null ? null : this.getRepresentative().getTaxonID();
    }

    @Override
    public String getId() {
        TaxonConceptInstance rep;
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.key.getScientificName());
        if (this.key.getScientificNameAuthorship() != null) {
            sb.append(" ");
            sb.append(this.key.getScientificNameAuthorship());
        }
        if ((rep = this.getRepresentative()) != null) {
            sb.append(" [");
            sb.append(rep.getLocator());
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public String getScientificName() {
        return this.key.getScientificName();
    }

    @Override
    public String getScientificNameAuthorship() {
        return this.key.getScientificNameAuthorship();
    }

    @Override
    public String getNameComplete() {
        TaxonConceptInstance representative = this.getRepresentative();
        return representative != null ? representative.getNameComplete() : null;
    }

    @Override
    public int getPrincipalScore() {
        TaxonConceptInstance representative = this.getRepresentative();
        return representative != null ? representative.getPrincipalScore() : -1000000;
    }

    @Override
    public int getProviderScore() {
        TaxonConceptInstance representative = this.getRepresentative();
        return representative != null ? representative.getProviderScore() : -1000000;
    }

    @Override
    public boolean validate(Taxonomy taxonomy) {
        boolean valid = true;
        if (!this.cleared && this.instances.isEmpty()) {
            taxonomy.report(IssueType.VALIDATION, "taxonConcept.validation.noInstances", this, null);
            valid = false;
        }
        for (TaxonConceptInstance tci : this.instances) {
            if (tci.getContainer() != this) {
                taxonomy.report(IssueType.VALIDATION, "taxonConcept.validation.instanceParent", tci, Arrays.asList(this));
                valid = false;
            }
            if (tci.isForbidden() || taxonomy.getInstance(tci.getTaxonID()) == tci) continue;
            taxonomy.report(IssueType.VALIDATION, "taxonConcept.validation.instanceTaxonomy", tci, Arrays.asList(this));
            valid = false;
        }
        if (this.isResolved() && !this.resolution.validate(this.instances, (Reporter)taxonomy)) {
            valid = false;
        }
        return valid;
    }

    public void resolveUnranked(boolean accepted, Taxonomy taxonomy, UnrankedScientificName parent) throws IndexBuilderException {
        if (!this.getKey().isUnranked()) {
            throw new IndexBuilderException("Expecting unranked taxon concept " + this);
        }
        TaxonResolver resolver = taxonomy.getResolver();
        List reassign = this.instances.stream().filter(tci -> (accepted && tci.isAccepted() || !accepted && !tci.isAccepted()) && tci.getProvider().getUnrankedStrategy().isReassignable((TaxonConceptInstance)tci)).collect(Collectors.toList());
        if (!reassign.isEmpty()) {
            HashSet<Object> resolve = new HashSet<Object>();
            for (TaxonConceptInstance taxonConceptInstance : reassign) {
                RankType acceptedRank = resolver.estimateRank(taxonConceptInstance, parent);
                if (acceptedRank == null || acceptedRank == RankType.UNRANKED) continue;
                TaxonConceptInstance newTci = taxonConceptInstance.createRankedInstance(acceptedRank, taxonomy);
                taxonConceptInstance.forwardTo(newTci, taxonomy);
                resolve.add(newTci.getContainer());
                resolve.add(this);
            }
            for (TaxonConcept taxonConcept : resolve) {
                taxonConcept.resolveTaxon(taxonomy, true);
            }
        }
    }
}

