/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.Name;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.TaxonConcept;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.index.UnrankedScientificName;
import au.org.ala.names.model.RankType;
import au.org.ala.names.util.DwcaWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScientificName
extends Name<ScientificName, UnrankedScientificName, TaxonConcept>
implements Comparable<ScientificName> {
    private static final Logger logger = LoggerFactory.getLogger(ScientificName.class);

    public ScientificName(UnrankedScientificName container, NameKey key) {
        super(container, key);
    }

    @Override
    TaxonConcept createConcept(NameKey stageKey) {
        return new TaxonConcept(this, stageKey);
    }

    @Override
    NameKey buildStageKey(NameKey instanceKey) {
        return instanceKey;
    }

    public TaxonomicElement findElement(Taxonomy taxonomy, NameProvider provider) {
        TaxonConceptInstance instance;
        for (TaxonConcept tc : this.getConcepts()) {
            instance = tc.findInstance(provider, true);
            if (instance == null) continue;
            return instance;
        }
        for (TaxonConcept tc : this.getConcepts()) {
            instance = tc.findInstance(provider, false);
            if (instance == null) continue;
            return instance;
        }
        return this;
    }

    @Override
    protected TaxonConcept findPrincipal(Taxonomy taxonomy) {
        try {
            TaxonConcept principal = this.findBasePrincipal(taxonomy);
            TaxonConceptInstance representative = principal.getRepresentative();
            TaxonConceptInstance resolved = representative.getResolvedAccepted();
            if (resolved == null) {
                return principal;
            }
            if (resolved != representative && ((TaxonConcept)resolved.getContainer()).getContainer() == this) {
                principal = (TaxonConcept)resolved.getContainer();
            }
            return principal;
        }
        catch (RuntimeException ex) {
            logger.error("Unable to find principal for " + this);
            throw ex;
        }
    }

    private TaxonConcept findBasePrincipal(Taxonomy taxonomy) {
        List concepts = this.getConcepts();
        if (concepts.isEmpty()) {
            return null;
        }
        if (concepts.size() == 1) {
            return (TaxonConcept)concepts.get(0);
        }
        concepts.sort(REVERSE_PROVIDER_SCORE_COMPARATOR);
        int cutoff = taxonomy.getAcceptedCutoff();
        List accepted = concepts.stream().filter(tc -> tc.isFormal() && tc.hasAccepted() && tc.getPrincipalScore() > cutoff).collect(Collectors.toList());
        if (accepted.size() == 0) {
            return (TaxonConcept)concepts.get(0);
        }
        if (accepted.size() == 1) {
            return (TaxonConcept)accepted.get(0);
        }
        int score = accepted.stream().mapToInt(TaxonConcept::getPrincipalScore).max().orElse(-1000000);
        List candidates = accepted.stream().filter(tc -> tc.getPrincipalScore() == score).collect(Collectors.toList());
        if (candidates.size() == 1) {
            return (TaxonConcept)candidates.get(0);
        }
        candidates.sort(REVERSE_PRINCIPAL_SCORE_COMPARATOR);
        List authored = candidates.stream().filter(tc -> tc.isAuthored() || tc.isAutonym()).collect(Collectors.toList());
        if (authored.size() == 1) {
            return (TaxonConcept)authored.get(0);
        }
        taxonomy.report(IssueType.COLLISION, "scientificName.collision", this, candidates);
        taxonomy.report(IssueType.PROBLEM, "scientificName.collision.warn", this, candidates);
        return (TaxonConcept)candidates.get(0);
    }

    @Override
    protected void reallocateDanglingConcepts(Taxonomy taxonomy, TaxonConcept principal) {
        if (principal != null) {
            List accepted = this.getConcepts().stream().filter(tc -> tc.isFormal() && tc.hasAccepted()).collect(Collectors.toList());
            ArrayList<TaxonConcept> reallocated = new ArrayList<TaxonConcept>();
            boolean owned = principal.isOwned();
            for (TaxonConcept tc2 : accepted) {
                if (tc2 == principal || tc2.isOwned() || !owned && (tc2.isAuthored() || tc2.isAutonym())) continue;
                if (tc2.isAuthored() || tc2.isAutonym()) {
                    tc2.addInferredSynonym(principal, taxonomy);
                    continue;
                }
                principal.reallocate(tc2, taxonomy, "scientificName.reallocated.provenance");
                reallocated.add(tc2);
            }
            this.removeConcepts(reallocated);
            taxonomy.count("count.resolve.scientificName.principal");
        }
    }

    @Override
    public void reallocate(ScientificName element, Taxonomy taxonomy, String reason) {
        TaxonConcept principal = (TaxonConcept)this.getPrincipal();
        taxonomy.report(IssueType.NOTE, "scientificName.reallocated", element, Arrays.asList(this));
        taxonomy.count("count.reallocate.scientificName");
        if (principal == null) {
            throw new IndexBuilderException("Unable to reallocate " + element + " to " + this + " without principal");
        }
        for (TaxonConcept tc : element.getConcepts()) {
            principal.reallocate(tc, taxonomy, reason);
        }
        element.clear(principal);
    }

    public void resolveUnranked(boolean accepted, Taxonomy taxonomy, UnrankedScientificName parent) throws IndexBuilderException {
        if (!this.getKey().isUnranked()) {
            throw new IndexBuilderException("Expecting unranked scientific name " + this);
        }
        ArrayList tcs = new ArrayList(this.getConcepts());
        for (TaxonConcept tc : tcs) {
            tc.resolveUnranked(accepted, taxonomy, parent);
        }
    }

    public void findRankedConcepts(NameKey key, Taxonomy taxonomy, Collection<TaxonConcept> candidates) {
        key = key.toUnrankedNameKey();
        for (TaxonConcept tc : this.getConcepts()) {
            NameKey tck = tc.getKey();
            if (tck.isUnranked() || key.compareTo(tck.toUnrankedNameKey()) != 0) continue;
            candidates.add(tc);
        }
    }

    @Override
    public int compareTo(ScientificName o) {
        RankType r2;
        TaxonConcept p1 = (TaxonConcept)this.getPrincipal();
        TaxonConcept p2 = (TaxonConcept)o.getPrincipal();
        RankType r1 = p1 == null ? null : p1.getRank();
        RankType rankType = r2 = p2 == null ? null : p2.getRank();
        if (r1 == null && r2 != null) {
            return 1;
        }
        if (r1 != null && r2 == null) {
            return -1;
        }
        if (r1 != null && r2 != null && r1 != r2) {
            return r1.getSortOrder() - r2.getSortOrder();
        }
        return this.getKey().compareTo(o.getKey());
    }

    public void write(Taxonomy taxonomy, DwcaWriter writer) throws IOException {
        boolean written = false;
        TaxonConcept principal = (TaxonConcept)this.getPrincipal();
        if (principal != null && this.getConcepts().contains(principal)) {
            principal.write(taxonomy, writer);
            written = true;
        }
        for (TaxonConcept concept : this.getConcepts()) {
            if (concept == principal) continue;
            concept.write(taxonomy, writer);
            written = true;
        }
        if (written) {
            taxonomy.count("count.write.scientificName");
        }
    }

    public String toString() {
        NameKey key = this.getKey();
        TaxonConcept principal = (TaxonConcept)this.getPrincipal();
        TaxonConceptInstance representative = this.getRepresentative();
        StringBuilder builder = new StringBuilder(64);
        builder.append("SN[");
        builder.append(key.getCode() == null ? "no code" : key.getCode().getAcronym());
        builder.append(", ");
        builder.append(this.getKey().getScientificName());
        builder.append(", ");
        builder.append(this.getKey().getRank().getRank());
        if (principal != null) {
            builder.append(" = ");
            builder.append(principal.getKey());
        }
        if (representative != null) {
            builder.append(" = ");
            builder.append(representative.getLocator());
        }
        builder.append("]");
        return builder.toString();
    }
}

