/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.model.RankType;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.gbif.checklistbank.model.Equality;

public class RankComparator {
    private static final RankType[][] RANK_RANGES = new RankType[][]{{RankType.DOMAIN, RankType.DOMAIN, RankType.KINGDOM}, {RankType.KINGDOM, RankType.DOMAIN, RankType.INFRAKINGDOM}, {RankType.SUBKINGDOM, RankType.KINGDOM, RankType.SUPERPHYLUM}, {RankType.INFRAKINGDOM, RankType.KINGDOM, RankType.SUPERPHYLUM}, {RankType.SUPERPHYLUM, RankType.INFRAKINGDOM, RankType.INFRAPHYLUM}, {RankType.PHYLUM, RankType.INFRAKINGDOM, RankType.SUPERCLASS}, {RankType.SUBPHYLUM, RankType.INFRAKINGDOM, RankType.CLASS}, {RankType.INFRAPHYLUM, RankType.PHYLUM, RankType.CLASS}, {RankType.SUPERCLASS, RankType.INFRAPHYLUM, RankType.INFRACLASS}, {RankType.CLASS, RankType.SUBPHYLUM, RankType.SUPERORDER}, {RankType.SUBCLASS, RankType.INFRAPHYLUM, RankType.ORDER}, {RankType.INFRACLASS, RankType.CLASS, RankType.ORDER}, {RankType.SUBINFRACLASS, RankType.SUBCLASS, RankType.ORDER}, {RankType.SUPERDIVISION_ZOOLOGY, RankType.SUBCLASS, RankType.ORDER}, {RankType.DIVISION_ZOOLOGY, RankType.SUBCLASS, RankType.ORDER}, {RankType.SUBDIVISION_ZOOLOGY, RankType.SUBCLASS, RankType.ORDER}, {RankType.SUPERCOHORT, RankType.SUBCLASS, RankType.ORDER}, {RankType.COHORT, RankType.SUBCLASS, RankType.ORDER}, {RankType.SUBCOHORT, RankType.SUBCLASS, RankType.ORDER}, {RankType.SUPERORDER, RankType.INFRACLASS, RankType.INFRAORDER}, {RankType.ORDER, RankType.SUBCLASS, RankType.SUPERFAMILY}, {RankType.SUBORDER, RankType.INFRACLASS, RankType.FAMILY}, {RankType.INFRAORDER, RankType.ORDER, RankType.FAMILY}, {RankType.PARVORDER, RankType.SUBORDER, RankType.FAMILY}, {RankType.SUPERSERIES_ZOOLOGY, RankType.SUBORDER, RankType.FAMILY}, {RankType.SERIES_ZOOLOGY, RankType.SUBORDER, RankType.FAMILY}, {RankType.SUBSERIES_ZOOLOGY, RankType.SUBORDER, RankType.FAMILY}, {RankType.SUPERSECTION_ZOOLOGY, RankType.SUBORDER, RankType.FAMILY}, {RankType.SECTION_ZOOLOGY, RankType.SUBORDER, RankType.FAMILY}, {RankType.SUBSECTION_ZOOLOGY, RankType.SUBORDER, RankType.FAMILY}, {RankType.FAMILY, RankType.SUBORDER, RankType.INFRAFAMILY}, {RankType.SUBFAMILY, RankType.INFRAORDER, RankType.GENUS}, {RankType.INFRAFAMILY, RankType.FAMILY, RankType.GENUS}, {RankType.SUPERTRIBE, RankType.SUBFAMILY, RankType.GENUS}, {RankType.TRIBE, RankType.SUBFAMILY, RankType.GENUS}, {RankType.SUBTRIBE, RankType.SUBFAMILY, RankType.GENUS}, {RankType.SUPERGENUS, RankType.INFRAFAMILY, RankType.INFRAGENUS}, {RankType.GENUS_GROUP, RankType.INFRAFAMILY, RankType.INFRAGENUS}, {RankType.GENUS, RankType.INFRAFAMILY, RankType.SUPERSPECIES}, {RankType.SUBGENUS, RankType.INFRAFAMILY, RankType.SUPERSPECIES}, {RankType.INFRAGENUS, RankType.INFRAFAMILY, RankType.SUPERSPECIES}, {RankType.SUPERSECTION_BOTANY, RankType.GENUS, RankType.SPECIES_SUBGROUP}, {RankType.SECTION_BOTANY, RankType.GENUS, RankType.SPECIES_SUBGROUP}, {RankType.SUBSECTION_BOTANY, RankType.GENUS, RankType.SPECIES_SUBGROUP}, {RankType.SUPERSERIES_BOTANY, RankType.GENUS, RankType.SPECIES_SUBGROUP}, {RankType.SERIES_BOTANY, RankType.SUBGENUS, RankType.SPECIES_SUBGROUP}, {RankType.SUBSERIES_BOTANY, RankType.SUBGENUS, RankType.SPECIES_SUBGROUP}, {RankType.INFRAGENERICNAME, RankType.SUBGENUS, RankType.SPECIES_SUBGROUP}, {RankType.SPECIES_GROUP, RankType.SUBGENUS, RankType.SPECIES_SUBGROUP}, {RankType.SUPERSPECIES, RankType.SUBGENUS, RankType.SPECIES_SUBGROUP}, {RankType.SPECIES_SUBGROUP, RankType.SUBGENUS, RankType.SPECIES_SUBGROUP}, {RankType.SPECIES, RankType.SPECIES, RankType.TELEOMORPH}, {RankType.NOTHOSPECIES, RankType.SPECIES, RankType.SUBSPECIES}, {RankType.HOLOMORPH, RankType.SPECIES, RankType.SUBSPECIES}, {RankType.ANAMORPH, RankType.SPECIES, RankType.SUBSPECIES}, {RankType.TELEOMORPH, RankType.SPECIES, RankType.SUBSPECIES}, {RankType.SUBSPECIES, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.NOTHOSUBSPECIES, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.INFRASPECIFICNAME, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.INFRASUBSPECIESNAME, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.VARIETY, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.NOTHOVARIETY, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.SUBVARIETY, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.FORM, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.NOTHOFORM, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.SUBFORM, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.BIOVAR, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.SEROVAR, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.FORMASPECIALIS, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.CULTIVARGROUP, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.CULTIVAR, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.PATHOVAR, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.HYBRID, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}, {RankType.SUPRAGENERICNAME, RankType.NOTHOSPECIES, RankType.SUPRAGENERICNAME}};
    private static final Map<RankType, RankType> UPPER_BOUND = Arrays.stream(RANK_RANGES).collect(Collectors.toMap(r -> r[0], r -> r[1]));
    private static final Map<RankType, RankType> LOWER_BOUND = Arrays.stream(RANK_RANGES).collect(Collectors.toMap(r -> r[0], r -> r[2]));

    public Equality compare(RankType rank1, RankType rank2) {
        if (rank1 == rank2) {
            return Equality.EQUAL;
        }
        if (rank1.getId() <= 0 && rank2.getId() <= 0) {
            return Equality.EQUAL;
        }
        if (rank1 == RankType.UNRANKED || rank2 == RankType.UNRANKED || rank1 == RankType.INFORMAL || rank2 == RankType.INFORMAL) {
            return Equality.EQUAL;
        }
        if (rank1.getId() <= 0 && rank2.getId() <= 0) {
            return Equality.UNKNOWN;
        }
        RankType r1u = UPPER_BOUND.get(rank1);
        RankType r1l = LOWER_BOUND.get(rank1);
        if (r1u != null && rank2.compareTo((Enum)r1u) >= 0 && r1l != null && rank2.compareTo((Enum)r1l) <= 0) {
            return Equality.EQUAL;
        }
        RankType r2u = UPPER_BOUND.get(rank2);
        RankType r2l = LOWER_BOUND.get(rank2);
        if (r2u != null && rank1.compareTo((Enum)r2u) >= 0 && r2l != null && rank1.compareTo((Enum)r2l) <= 0) {
            return Equality.EQUAL;
        }
        return Equality.DIFFERENT;
    }
}

