/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.gbif.api.vocabulary.NomenclaturalCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class NomenclaturalClassifier
implements Comparable<NomenclaturalClassifier> {
    private static final Logger logger = LoggerFactory.getLogger(NomenclaturalClassifier.class);
    private String acronym;
    private String title;
    private URL source;
    private NomenclaturalClassifier parent;
    private NomenclaturalCode code;
    private Set<String> aliases;
    private static final List<NomenclaturalClassifier> CLASSIFIERS = NomenclaturalClassifier.buildInstances();
    private static final Map<String, NomenclaturalClassifier> NAMES = NomenclaturalClassifier.buildNames(CLASSIFIERS);
    private static final Map<NomenclaturalCode, NomenclaturalClassifier> CODES = CLASSIFIERS.stream().filter(c -> c.getCode() != null).collect(Collectors.toMap(NomenclaturalClassifier::getCode, c -> c));
    public static final NomenclaturalClassifier BACTERIAL = NomenclaturalClassifier.find(NomenclaturalCode.BACTERIAL);
    public static final NomenclaturalClassifier BOTANICAL = NomenclaturalClassifier.find(NomenclaturalCode.BOTANICAL);
    public static final NomenclaturalClassifier CULTIVARS = NomenclaturalClassifier.find(NomenclaturalCode.CULTIVARS);
    public static final NomenclaturalClassifier VIRUS = NomenclaturalClassifier.find(NomenclaturalCode.VIRUS);
    public static final NomenclaturalClassifier ZOOLOGICAL = NomenclaturalClassifier.find(NomenclaturalCode.ZOOLOGICAL);

    private static List<NomenclaturalClassifier> buildInstances() {
        try {
            InputStreamReader r = new InputStreamReader(NomenclaturalClassifier.class.getResourceAsStream("nomenclatural_classifiers.csv"), "UTF-8");
            CSVReader reader = new CSVReaderBuilder((Reader)r).withSkipLines(1).build();
            ArrayList<NomenclaturalClassifier> classifiers = new ArrayList<NomenclaturalClassifier>();
            for (String[] row : reader) {
                String acronym = row[0];
                String p = StringUtils.trimToNull((String)row[1]);
                NomenclaturalClassifier parent = p == null ? null : classifiers.stream().filter(c -> c.getAcronym().equals(p)).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't find parent " + p));
                String title = row[2];
                String s = StringUtils.trimToNull((String)row[3]);
                URL source = s == null ? null : new URL(s);
                String c2 = StringUtils.trimToNull((String)row[4]);
                NomenclaturalCode code = c2 == null ? null : NomenclaturalCode.valueOf((String)c2);
                Set<String> aliases = IntStream.range(5, row.length).mapToObj(i -> row[i]).collect(Collectors.toSet());
                classifiers.add(new NomenclaturalClassifier(acronym, parent, title, source, code, aliases));
            }
            return classifiers;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to read nomenclatural codes", ex);
        }
    }

    private static Map<String, NomenclaturalClassifier> buildNames(List<NomenclaturalClassifier> classifiers) {
        HashMap<String, NomenclaturalClassifier> map = new HashMap<String, NomenclaturalClassifier>();
        for (NomenclaturalClassifier classifier : classifiers) {
            map.put(classifier.getAcronym(), classifier);
            if (classifier.getCode() != null) {
                map.put(classifier.getCode().name(), classifier);
            }
            for (String alias : classifier.getAliases()) {
                map.put(alias, classifier);
            }
        }
        return map;
    }

    public static NomenclaturalClassifier find(String code) {
        return NAMES.get(code);
    }

    public static NomenclaturalClassifier find(NomenclaturalCode code) {
        return CODES.get(code);
    }

    protected NomenclaturalClassifier(String acronym, NomenclaturalClassifier parent, String title, URL source, NomenclaturalCode code, Set<String> aliases) {
        this.acronym = acronym;
        this.parent = parent;
        this.title = title;
        this.source = source;
        this.code = code;
        this.aliases = aliases;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public String getTitle() {
        return this.title;
    }

    public URL getSource() {
        return this.source;
    }

    public NomenclaturalClassifier getParent() {
        return this.parent;
    }

    public NomenclaturalCode getCode() {
        return this.code;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NomenclaturalClassifier that = (NomenclaturalClassifier)o;
        return this.acronym.equals(that.acronym);
    }

    public int hashCode() {
        return Objects.hash(this.acronym);
    }

    public String toString() {
        return this.acronym;
    }

    @Override
    public int compareTo(NomenclaturalClassifier o) {
        return this.acronym.compareTo(o.acronym);
    }

    public static class Deserializer
    extends StdDeserializer<NomenclaturalClassifier> {
        public Deserializer() {
            super(NomenclaturalClassifier.class);
        }

        public NomenclaturalClassifier deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String code = p.getValueAsString();
            NomenclaturalClassifier classifier = NomenclaturalClassifier.find(code);
            if (classifier == null) {
                throw new IllegalArgumentException("Unrecognised nomenclatural code " + code);
            }
            return classifier;
        }
    }

    public static class Serializer
    extends StdSerializer<NomenclaturalClassifier> {
        public Serializer() {
            super(NomenclaturalClassifier.class);
        }

        public void serialize(NomenclaturalClassifier value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value != null) {
                gen.writeString(value.getAcronym());
            }
        }
    }
}

