/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.LogReporter;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.NomenclaturalClassifier;
import au.org.ala.names.index.Reporter;
import au.org.ala.names.index.TaxonConcept;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.index.provider.ConceptResolutionPriority;
import au.org.ala.names.index.provider.DiscardStrategy;
import au.org.ala.names.index.provider.KeyAdjuster;
import au.org.ala.names.index.provider.ScoreAdjuster;
import au.org.ala.names.index.provider.UnrankedStrategy;
import au.org.ala.names.model.RankType;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.gbif.api.model.registry.Citation;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NameProvider {
    public static final int DEFAULT_SCORE = 100;
    public static final String DEFAULT_UNKNOWN_TAXON_ID = "ALA_The_Unknown_Taxon";
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private String rightsHolder;
    @JsonProperty
    private String licence;
    @JsonProperty
    private NameProvider parent;
    @JsonProperty
    private Integer defaultScore;
    @JsonProperty
    private Map<String, Integer> scores;
    @JsonProperty
    private Set<String> owner;
    @JsonProperty
    private ScoreAdjuster adjuster;
    @JsonProperty
    private KeyAdjuster keyAdjuster;
    @JsonProperty
    private NomenclaturalClassifier defaultNomenclaturalCode;
    @JsonProperty
    private boolean loose;
    @JsonProperty
    private boolean external;
    @JsonProperty
    private boolean authority;
    @JsonProperty
    private DiscardStrategy discardStrategy;
    @JsonProperty
    private UnrankedStrategy unrankedStrategy;
    @JsonProperty
    private ConceptResolutionPriority conceptResolutionPriority;
    @JsonProperty
    private String unknownTaxonID;
    @JsonProperty
    private String defaultParentTaxon;
    @JsonProperty
    private Map<String, String> scientificNameChanges;
    @JsonProperty
    private Map<String, String> scientificNameAuthorshipChanges;
    @JsonProperty
    private RankType distributionCutoff;
    @JsonIgnore
    private Reporter reporter;

    public NameProvider() {
        this.name = this.id = UUID.randomUUID().toString();
        this.description = null;
        this.rightsHolder = null;
        this.licence = null;
        this.parent = null;
        this.defaultScore = null;
        this.defaultNomenclaturalCode = null;
        this.scores = new HashMap<String, Integer>();
        this.owner = new HashSet<String>();
        this.adjuster = new ScoreAdjuster();
        this.keyAdjuster = new KeyAdjuster();
        this.loose = false;
        this.external = true;
        this.authority = true;
        this.scientificNameChanges = new HashMap<String, String>();
        this.scientificNameAuthorshipChanges = new HashMap<String, String>();
        this.distributionCutoff = null;
        this.reporter = new LogReporter();
    }

    public NameProvider(String id, Integer defaultScore, String unknownTaxonID, Map<String, Integer> scores) {
        this.name = this.id = id;
        this.description = null;
        this.rightsHolder = null;
        this.licence = null;
        this.parent = null;
        this.defaultScore = defaultScore;
        this.defaultNomenclaturalCode = null;
        this.scores = scores;
        this.owner = new HashSet<String>();
        this.adjuster = new ScoreAdjuster();
        this.keyAdjuster = new KeyAdjuster();
        this.loose = false;
        this.external = true;
        this.authority = true;
        this.unknownTaxonID = unknownTaxonID;
        this.scientificNameChanges = new HashMap<String, String>();
        this.scientificNameAuthorshipChanges = new HashMap<String, String>();
        this.distributionCutoff = null;
        this.reporter = new LogReporter();
    }

    public NameProvider(String id, String name, NameProvider parent, boolean loose) {
        if (parent == this) {
            throw new IllegalArgumentException("Parent same as child for " + id);
        }
        this.id = id;
        this.name = name;
        this.description = null;
        this.rightsHolder = null;
        this.licence = null;
        this.parent = parent;
        this.defaultScore = parent.getDefaultScore();
        this.defaultNomenclaturalCode = null;
        this.scores = new HashMap<String, Integer>();
        this.owner = new HashSet<String>();
        this.adjuster = new ScoreAdjuster();
        this.keyAdjuster = new KeyAdjuster();
        this.loose = loose;
        this.external = true;
        this.authority = true;
        this.scientificNameChanges = new HashMap<String, String>();
        this.scientificNameAuthorshipChanges = new HashMap<String, String>();
        this.distributionCutoff = null;
        this.reporter = new LogReporter();
    }

    public NameProvider(String id, int defaultScore) {
        this(id, defaultScore, DEFAULT_UNKNOWN_TAXON_ID, Collections.EMPTY_MAP);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRightsHolder() {
        if (this.rightsHolder == null && this.parent != null) {
            return this.parent.getRightsHolder();
        }
        return this.rightsHolder;
    }

    public String getLicence() {
        if (this.licence == null && this.parent != null) {
            return this.parent.getLicence();
        }
        return this.licence;
    }

    public NameProvider getParent() {
        return this.parent;
    }

    public boolean isLoose() {
        return this.loose;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isAuthority() {
        return this.authority;
    }

    public NameProvider getAuthority() {
        if (this.authority) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getAuthority();
        }
        return null;
    }

    public DiscardStrategy getDiscardStrategy() {
        if (this.discardStrategy != null) {
            return this.discardStrategy;
        }
        DiscardStrategy ds = this.parent != null ? this.parent.getDiscardStrategy() : null;
        return ds == null ? DiscardStrategy.IGNORE : ds;
    }

    public UnrankedStrategy getUnrankedStrategy() {
        if (this.unrankedStrategy != null) {
            return this.unrankedStrategy;
        }
        UnrankedStrategy us = this.parent != null ? this.parent.getUnrankedStrategy() : null;
        return us == null ? UnrankedStrategy.NONE : us;
    }

    public ConceptResolutionPriority getConceptResolutionPriority() {
        if (this.conceptResolutionPriority != null) {
            return this.conceptResolutionPriority;
        }
        ConceptResolutionPriority cs = this.parent != null ? this.parent.getConceptResolutionPriority() : null;
        return cs == null ? ConceptResolutionPriority.AUTHORATATIVE : cs;
    }

    public String getUnknownTaxonID() throws IndexBuilderException {
        String utid;
        if (this.unknownTaxonID != null) {
            return this.unknownTaxonID;
        }
        String string = utid = this.parent != null ? this.parent.getUnknownTaxonID() : null;
        if (utid == null) {
            throw new IndexBuilderException("Unable to find unknown taxon identifier for " + this.getId());
        }
        return utid;
    }

    @Nullable
    public String getDefaultParentTaxon() {
        if (this.defaultParentTaxon == null && this.parent != null) {
            return this.parent.getDefaultParentTaxon();
        }
        return this.defaultParentTaxon;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public String forbid(TaxonConceptInstance instance, NameKey key) {
        String explain;
        if (this.parent != null && (explain = this.parent.forbid(instance, key)) != null) {
            return explain;
        }
        return this.adjuster.forbid(instance, key);
    }

    public boolean owns(String name) {
        return this.owner.contains(name);
    }

    @JsonIgnore
    public int getDefaultScore() {
        if (this.defaultScore != null) {
            return this.defaultScore;
        }
        if (this.parent != null) {
            return this.parent.getDefaultScore();
        }
        return 100;
    }

    @JsonIgnore
    public NomenclaturalClassifier getDefaultNomenclaturalCode() {
        if (this.defaultNomenclaturalCode != null) {
            return this.defaultNomenclaturalCode;
        }
        if (this.parent != null) {
            return this.parent.getDefaultNomenclaturalCode();
        }
        return null;
    }

    public Integer getSpecificScore(String name) {
        Integer specific = this.scores.get(name);
        if (specific != null) {
            return specific;
        }
        if (this.parent != null) {
            specific = this.parent.getSpecificScore(name);
        }
        return specific == null ? null : Integer.valueOf(Math.max(-1000000, Math.min(1000000, specific)));
    }

    public int computeBaseScore(TaxonConceptInstance original, TaxonConceptInstance instance) {
        TaxonConceptInstance p;
        Integer specific = this.getSpecificScore(instance.getScientificName());
        if (specific != null) {
            return specific;
        }
        TaxonConceptInstance taxonConceptInstance = p = instance.getParent() == null ? null : instance.getParent().getRepresentative();
        if (p == original || p == instance) {
            this.reporter.report(IssueType.PROBLEM, "instance.parent.resolve.loop", original, Collections.singletonList(instance));
            p = instance.getResolvedParent();
            p = p == null ? null : p.getRepresentative();
        }
        int score = p != null && p.getProvider() == this ? p.getBaseScore(original) : this.getDefaultScore();
        return Math.max(-1000000, Math.min(1000000, score));
    }

    public int computeScore(TaxonConceptInstance instance) {
        if (this.owns(instance.getScientificName())) {
            return 1000000;
        }
        if (instance.isForbidden()) {
            return -1000000;
        }
        int score = instance.getBaseScore();
        score = this.adjustScore(score, instance);
        return Math.max(-1000000, Math.min(1000000, score));
    }

    public int adjustScore(int score, TaxonConceptInstance instance) {
        if (this.parent != null) {
            score = this.parent.adjustScore(score, instance);
        }
        return this.adjuster == null ? score : this.adjuster.score(score, instance, instance.getContainer() == null ? null : ((TaxonConcept)instance.getContainer()).getKey());
    }

    public NameKey adjustKey(NameKey key, TaxonConceptInstance instance) {
        if (this.parent != null) {
            key = this.parent.adjustKey(key, instance);
        }
        return this.keyAdjuster == null ? key : this.keyAdjuster.adjustKey(key, instance);
    }

    public String correctScientificName(String scientificName) {
        String name = this.scientificNameChanges.get(scientificName);
        if (name == null && this.parent != null) {
            name = this.parent.correctScientificName(scientificName);
        }
        return name == null ? scientificName : name;
    }

    public String correctScientificNameAuthorship(String scientificNameAuthorship) {
        String author = this.scientificNameAuthorshipChanges.get(scientificNameAuthorship);
        if (author == null && this.parent != null) {
            author = this.parent.correctScientificName(scientificNameAuthorship);
        }
        return author == null ? scientificNameAuthorship : author;
    }

    public boolean validate(Taxonomy taxonomy) {
        try {
            String utid = this.getUnknownTaxonID();
            if (taxonomy != null && taxonomy.getInstance(utid) == null) {
                taxonomy.report(IssueType.ERROR, "provider.validation.unknownTaxonID.notFound", utid, null, new String[0]);
                return false;
            }
        }
        catch (IndexBuilderException ex) {
            taxonomy.report(IssueType.ERROR, "provider.validation.unknownTaxonID.noID", null, null);
            return false;
        }
        return true;
    }

    @JsonIgnore
    public Citation getCitation() throws IndexBuilderException {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null) {
            sb.append(this.getName());
        }
        if (this.getRightsHolder() != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.getRightsHolder());
        }
        return new Citation(sb.toString(), this.getId());
    }

    @JsonIgnore
    public Map<Term, String> getProviderMap() {
        LinkedHashMap<Term, String> map = new LinkedHashMap<Term, String>();
        map.put((Term)DwcTerm.datasetID, this.getId());
        map.put((Term)DwcTerm.datasetName, this.getName());
        map.put((Term)DcTerm.description, this.getDescription());
        map.put((Term)DcTerm.rightsHolder, this.getRightsHolder());
        map.put((Term)DcTerm.license, this.getLicence());
        return map;
    }

    @JsonIgnore
    public RankType getDistributionCutoff() {
        if (this.distributionCutoff != null) {
            return this.distributionCutoff;
        }
        if (this.parent != null) {
            return this.parent.getDistributionCutoff();
        }
        return null;
    }

    public TaxonomicElement findDefaultParent(Taxonomy taxonomy, TaxonConceptInstance instance) throws IndexBuilderException {
        NomenclaturalClassifier code = instance.getCode();
        String dp = this.getDefaultParentTaxon();
        if (code == null || dp == null) {
            return null;
        }
        return taxonomy.findElement(code, dp, this, null);
    }
}

