/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.NameAnalyser;
import au.org.ala.names.index.NomenclaturalClassifier;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonFlag;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gbif.api.vocabulary.NameType;

public class NameKey
implements Comparable<NameKey> {
    private NameAnalyser analyser;
    private NomenclaturalClassifier code;
    private String scientificName;
    private String scientificNameAuthorship;
    private RankType rank;
    private NameType type;
    @Nullable
    private Set<TaxonFlag> flags;

    public NameKey(NameAnalyser analyser, NomenclaturalClassifier code, String scientificName, String scientificNameAuthorship, RankType rank, NameType type, @Nullable Set<TaxonFlag> flags) {
        this.analyser = analyser;
        this.code = code;
        this.scientificName = scientificName;
        this.scientificNameAuthorship = scientificNameAuthorship;
        this.rank = rank;
        this.type = type;
        this.flags = flags;
    }

    public NameAnalyser getAnalyser() {
        return this.analyser;
    }

    public NomenclaturalClassifier getCode() {
        return this.code;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public String getScientificNameAuthorship() {
        return this.scientificNameAuthorship;
    }

    public RankType getRank() {
        return this.rank;
    }

    public NameType getType() {
        return this.type;
    }

    @Nullable
    public Set<TaxonFlag> getFlags() {
        return this.flags;
    }

    public boolean hasFlag(TaxonFlag flag) {
        return this.flags != null && this.flags.contains(flag);
    }

    public boolean isAutonym() {
        return this.hasFlag(TaxonFlag.AUTONYM);
    }

    public boolean isUnauthored() {
        return this.scientificNameAuthorship == null;
    }

    public boolean isUncoded() {
        return this.code == null;
    }

    public boolean isUnranked() {
        return this.rank == null || this.rank == RankType.UNRANKED;
    }

    public boolean isFormal() {
        return this.code != null && this.type != null && (this.type == NameType.SCIENTIFIC || this.type == NameType.HYBRID || this.type == NameType.CULTIVAR || this.type == NameType.VIRUS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameKey nameKey = (NameKey)o;
        return this.analyser.compare(this, nameKey) == 0;
    }

    public int hashCode() {
        return this.analyser.hashCode(this);
    }

    public NameKey toNameKey() {
        if (this.scientificNameAuthorship == null) {
            return this;
        }
        Set<TaxonFlag> fl = this.flags;
        if (fl != null && fl.contains(TaxonFlag.AUTONYM)) {
            fl = new HashSet<TaxonFlag>(this.flags);
            fl.remove(TaxonFlag.AUTONYM);
            fl = fl.isEmpty() ? null : fl;
        }
        return new NameKey(this.analyser, this.code, this.scientificName, null, this.rank, this.type, fl);
    }

    public NameKey toUnrankedNameKey() {
        if (this.scientificNameAuthorship == null && this.rank == RankType.UNRANKED) {
            return this;
        }
        Set<TaxonFlag> fl = this.flags;
        if (fl != null && fl.contains(TaxonFlag.AUTONYM)) {
            fl = new HashSet<TaxonFlag>(this.flags);
            fl.remove(TaxonFlag.AUTONYM);
            fl = fl.isEmpty() ? null : fl;
        }
        return new NameKey(this.analyser, this.code, this.scientificName, null, RankType.UNRANKED, this.type, fl);
    }

    public NameKey toRankedNameKey(RankType rank) {
        if (this.rank == rank) {
            return this;
        }
        return new NameKey(this.analyser, this.code, this.scientificName, this.scientificNameAuthorship, rank, this.type, this.flags);
    }

    public NameKey toUncodedNameKey() {
        if (this.scientificNameAuthorship == null && this.rank == RankType.UNRANKED && this.code == null) {
            return this;
        }
        Set<TaxonFlag> fl = this.flags;
        if (fl != null && fl.contains(TaxonFlag.AUTONYM)) {
            fl = new HashSet<TaxonFlag>(this.flags);
            fl.remove(TaxonFlag.AUTONYM);
            fl = fl.isEmpty() ? null : fl;
        }
        return new NameKey(this.analyser, null, this.scientificName, null, RankType.UNRANKED, this.type, fl);
    }

    public String toString() {
        return "[" + (this.code != null ? this.code.getAcronym() : "") + ":" + this.scientificName + (this.scientificNameAuthorship != null ? "," + this.scientificNameAuthorship : "") + ":" + this.rank.getRank() + (this.flags != null ? ":" + this.flags : "") + ']';
    }

    @Override
    public int compareTo(NameKey o) {
        return this.analyser.compare(this, o);
    }

    public int compareAuthor(String author) {
        return this.analyser.compareAuthor(this.scientificNameAuthorship, author);
    }
}

