/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.NomenclaturalClassifier;
import au.org.ala.names.index.Reporter;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonFlag;
import au.org.ala.names.model.TaxonomicType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gbif.api.vocabulary.LifeStage;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.api.vocabulary.OccurrenceStatus;
import org.gbif.checklistbank.authorship.AuthorComparator;
import org.gbif.checklistbank.model.Equality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NameAnalyser
implements Comparator<NameKey>,
Reporter {
    private static final Logger logger = LoggerFactory.getLogger(NameAnalyser.class);
    protected static final boolean REPORT_INFORMAL = true;
    private Reporter reporter;
    private AuthorComparator authorComparator;

    public NameAnalyser(AuthorComparator authorComparator, Reporter reporter) {
        this.authorComparator = authorComparator;
        this.reporter = reporter;
    }

    public AnalysisResult analyse(TaxonConceptInstance instance) {
        return this.analyse(instance.getCode(), instance.getScientificName(), instance.getScientificNameAuthorship(), instance.getRank(), instance.getTaxonomicStatus(), instance.getFlags(), false);
    }

    public AnalysisResult analyse(String code, String scientificName, String scientificNameAuthorship, String rank) {
        NomenclaturalClassifier canonicalCode = this.canonicaliseCode(code);
        RankType rankType = this.canonicaliseRank(rank);
        return this.analyse(canonicalCode, scientificName, scientificNameAuthorship, rankType, null, null, false);
    }

    public abstract AnalysisResult analyse(@Nullable NomenclaturalClassifier var1, String var2, @Nullable String var3, @Nullable RankType var4, @Nullable TaxonomicType var5, @Nullable Set<TaxonFlag> var6, boolean var7);

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public abstract NomenclaturalClassifier canonicaliseCode(String var1);

    public abstract TaxonomicType canonicaliseTaxonomicType(String var1);

    public abstract RankType canonicaliseRank(String var1);

    public abstract NomenclaturalStatus canonicaliseNomenclaturalStatus(String var1);

    public abstract LifeStage canonicaliseLifeStage(String var1);

    public abstract OccurrenceStatus canonicaliseOccurrenceStatus(String var1);

    public abstract TaxonFlag canonicaliseFlag(String var1);

    public abstract boolean isInformal(String var1);

    @Override
    public int compare(NameKey key1, NameKey key2) {
        int cmp;
        if (key1.getCode() == null && key2.getCode() != null) {
            return -1;
        }
        if (key1.getCode() != null && key2.getCode() == null) {
            return 1;
        }
        if (key1.getCode() != null && key2.getCode() != null && (cmp = key1.getCode().compareTo(key2.getCode())) != 0) {
            return cmp;
        }
        cmp = key1.getScientificName().compareTo(key2.getScientificName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = key1.getRank().compareTo((Enum)key2.getRank());
        if (cmp != 0) {
            return cmp;
        }
        return this.compareAuthor(key1.getScientificNameAuthorship(), key2.getScientificNameAuthorship());
    }

    public int compareAuthor(String author1, String author2) {
        if (author1 == null && author2 == null) {
            return 0;
        }
        if (author1 == null && author2 != null) {
            return -1;
        }
        if (author1 != null && author2 == null) {
            return 1;
        }
        if (this.authorComparator.compare(author1, null, author2, null) == Equality.EQUAL) {
            return 0;
        }
        return author1.compareTo(author2);
    }

    public int hashCode(NameKey key1) {
        int hash = key1.getCode() != null ? key1.getCode().hashCode() : 1181;
        hash = hash * 31 + key1.getScientificName().hashCode();
        hash = hash * 31 + (key1.getScientificNameAuthorship() == null ? 0 : 5659);
        return hash;
    }

    @Override
    public void report(IssueType type, String code, String taxonID, String name, String ... args) {
        if (this.reporter != null) {
            this.reporter.report(type, code, taxonID, name, args);
        } else {
            logger.warn("Report " + type.name() + " code=" + code + " args=" + Arrays.toString(args));
        }
    }

    @Override
    public void report(IssueType type, String code, TaxonomicElement main, List<? extends TaxonomicElement> associated) {
        if (this.reporter != null) {
            this.reporter.report(type, code, main, associated);
        } else {
            logger.warn("Report " + type.name() + " code=" + code + " main=" + main.toString() + " associated=" + associated);
        }
    }

    public static class AnalysisResult {
        private NameKey nameKey;
        @Nullable
        private String mononomial;
        @Nullable
        private String genus;
        @Nullable
        private String specificEpithet;
        @Nullable
        private String infraspecificEpithet;
        @Nullable
        private String cultivarEpithet;

        public AnalysisResult(NameKey nameKey, @Nullable String mononomial, @Nullable String genus, @Nullable String specificEpithet, @Nullable String infraspecificEpithet, @Nullable String cultivarEpithet) {
            this.nameKey = nameKey;
            this.mononomial = mononomial;
            this.genus = genus;
            this.specificEpithet = specificEpithet;
            this.infraspecificEpithet = infraspecificEpithet;
            this.cultivarEpithet = cultivarEpithet;
        }

        public NameKey getNameKey() {
            return this.nameKey;
        }

        @Nullable
        public String getMononomial() {
            return this.mononomial;
        }

        @Nullable
        public String getGenus() {
            return this.genus;
        }

        @Nullable
        public String getSpecificEpithet() {
            return this.specificEpithet;
        }

        @Nullable
        public String getInfraspecificEpithet() {
            return this.infraspecificEpithet;
        }

        @Nullable
        public String getCultivarEpithet() {
            return this.cultivarEpithet;
        }
    }
}

