/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.Reporter;
import au.org.ala.names.index.TaxonomicElement;
import java.text.MessageFormat;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReporter
implements Reporter {
    private static final Logger logger = LoggerFactory.getLogger(LogReporter.class);
    private static final ResourceBundle resources = ResourceBundle.getBundle("taxonomy");

    @Override
    public void report(IssueType type, String code, String taxonID, String name, String ... args) {
        String message = this.format(code, taxonID, name, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : "", args.length > 2 ? args[2] : "");
        this.report(type, message);
        switch (type) {
            case ERROR: 
            case VALIDATION: {
                logger.error(message);
                break;
            }
            case PROBLEM: {
                logger.warn(message);
                break;
            }
            case COLLISION: {
                logger.info(message);
                break;
            }
            case NOTE: 
            case COUNT: {
                logger.debug(message);
                break;
            }
            default: {
                logger.warn("Unknown message type " + (Object)((Object)type) + ": " + message);
            }
        }
    }

    @Override
    public void report(IssueType type, String code, TaxonomicElement main, List<? extends TaxonomicElement> associated) {
        String taxonID = null;
        String associatedTaxa = "";
        String associatedDesc = "";
        String name = "";
        if (main != null) {
            taxonID = main.getTaxonID();
            if (main.getDisplayName() != null) {
                name = main.getDisplayName();
            }
        }
        if (taxonID == null) {
            taxonID = "";
        }
        if (associated != null && !associated.isEmpty()) {
            StringBuilder ab = new StringBuilder();
            StringBuilder as = new StringBuilder();
            for (TaxonomicElement taxonomicElement : associated) {
                if (ab.length() > 0) {
                    ab.append("|");
                    as.append(", ");
                }
                ab.append(taxonomicElement.getTaxonID());
                as.append(taxonomicElement.toString());
            }
            associatedTaxa = ab.toString();
            associatedDesc = as.toString();
        }
        String message = this.format(code, taxonID, name, associatedTaxa, main.toString(), associatedDesc);
        this.report(type, message);
    }

    protected String format(String code, String taxonID, String name, String associatedTaxa, String main, String associatedDescription) {
        String message;
        Object[] args = new String[]{taxonID, name, associatedTaxa, main, associatedDescription};
        try {
            message = resources.getString(code);
            message = MessageFormat.format(message == null ? code : message, args);
        }
        catch (MissingResourceException ex) {
            logger.error("Can't find resource for " + code + " defaulting to code");
            message = code + " " + args;
        }
        return message;
    }

    protected void report(IssueType type, String message) {
        switch (type) {
            case ERROR: 
            case VALIDATION: {
                logger.error(message);
                break;
            }
            case PROBLEM: {
                logger.warn(message);
                break;
            }
            case COLLISION: {
                logger.debug(message);
                break;
            }
            case NOTE: 
            case COUNT: {
                logger.debug(message);
                break;
            }
            default: {
                logger.warn("Unknown message type " + (Object)((Object)type) + ": " + message);
            }
        }
    }
}

