/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import java.util.Map;

public class Location {
    private String locationID;
    private String parentLocationID;
    private Location parent;
    private String locality;
    private String geographyType;

    protected Location() {
    }

    public Location(String locationID, String parentLocationID, String locality, String geographyType) {
        this.locationID = locationID;
        this.parentLocationID = parentLocationID;
        this.locality = locality;
        this.geographyType = geographyType;
    }

    public String getLocationID() {
        return this.locationID;
    }

    public String getParentLocationID() {
        return this.parentLocationID;
    }

    public Location getParent() {
        return this.parent;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getGeographyType() {
        return this.geographyType;
    }

    public void resolve(Map<String, Location> locations) {
        if (this.parentLocationID == null) {
            this.parent = null;
            return;
        }
        this.parent = locations.get(this.parentLocationID);
        if (this.parent == null) {
            throw new IllegalStateException("Can't find parent location " + this.parentLocationID);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return this.locationID.equals(location.locationID);
    }

    public int hashCode() {
        return this.locationID.hashCode();
    }

    public String toString() {
        return "Location{" + this.locationID + ", " + this.locality + "}";
    }

    public boolean covers(Location other) {
        while (other != null) {
            if (this == other) {
                return true;
            }
            other = other.parent;
        }
        return false;
    }
}

