/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.Distribution;
import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.Location;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.NameSource;
import au.org.ala.names.index.NomenclaturalClassifier;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonFlag;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.names.model.VernacularType;
import au.org.ala.vocab.ALATerm;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.gbif.api.model.registry.Citation;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.vocabulary.ContactType;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwca.io.Archive;
import org.gbif.dwca.io.ArchiveFactory;
import org.gbif.dwca.io.ArchiveFile;
import org.gbif.dwca.io.MetadataException;
import org.gbif.dwca.record.Record;
import org.gbif.dwca.record.StarRecord;

public class DwcaNameSource
extends NameSource {
    private Archive archive;

    public DwcaNameSource(Archive archive) {
        this.archive = archive;
    }

    public DwcaNameSource(File archiveDir) throws IOException {
        this(ArchiveFactory.openArchive((File)archiveDir));
    }

    @Override
    public String getName() {
        try {
            return this.archive.getLocation().getCanonicalPath();
        }
        catch (IOException e) {
            return "Unreadable archive";
        }
    }

    @Override
    public Term getCoreType() {
        return this.archive.getCore().getRowType();
    }

    @Override
    public Citation getCitation() {
        try {
            Dataset dataset = this.archive.getMetadata();
            if (dataset != null) {
                return dataset.getCitation();
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return new Citation(this.getName(), this.archive.toString());
    }

    @Override
    public Collection<Country> getCountries() {
        try {
            Dataset dataset = this.archive.getMetadata();
            if (dataset != null) {
                return dataset.getCountryCoverage();
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<Contact> getContacts() {
        try {
            Dataset dataset = this.archive.getMetadata();
            if (dataset != null) {
                ArrayList<Contact> contacts = new ArrayList<Contact>();
                for (Contact contact : dataset.getContacts()) {
                    if (!contact.isPrimary() && contact.getType() != ContactType.ORIGINATOR) continue;
                    contact = (Contact)BeanUtils.cloneBean((Object)contact);
                    contact.setPrimary(false);
                    contact.setType(ContactType.CONTENT_PROVIDER);
                    contacts.add(contact);
                }
                return contacts;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    @Override
    public void validate() throws IndexBuilderException {
        this.checkStructure(this.archive.getCore());
        for (ArchiveFile ext : this.archive.getExtensions()) {
            this.checkStructure(ext);
        }
    }

    protected void checkStructure(ArchiveFile af) throws IndexBuilderException {
        List required = (List)REQUIRED_TERMS.get(af.getRowType());
        if (required != null) {
            for (Term term : required) {
                if (af.hasTerm(term)) continue;
                throw new IndexBuilderException("File " + af.getTitle() + " from " + this.archive.getLocation() + " is of type " + af.getRowType() + " and is missing " + term);
            }
        }
    }

    @Override
    public void loadIntoTaxonomy(Taxonomy taxonomy) throws IndexBuilderException {
        Term coreType = this.getCoreType();
        if (coreType == DwcTerm.Taxon) {
            this.loadTaxonDwCA(taxonomy);
        } else if (coreType == GbifTerm.VernacularName) {
            this.loadNonTaxonDwCA(taxonomy, (Term)ALATerm.UnplacedVernacularName);
        } else if (coreType == GbifTerm.Reference) {
            this.loadNonTaxonDwCA(taxonomy, (Term)ALATerm.UnplacedReference);
        } else if (coreType == ALATerm.Location) {
            this.loadLocationDwCA(taxonomy);
        } else {
            taxonomy.report(IssueType.PROBLEM, "taxonomy.load.rowType.discard", coreType.qualifiedName(), this.archive.getLocation().getPath(), new String[0]);
        }
    }

    public void loadNonTaxonDwCA(Taxonomy taxonomy, Term unplacedClass) throws IndexBuilderException {
        taxonomy.addOutputTerms(this.archive.getCore().getRowType(), this.archive.getCore().getTerms());
        String taxonID = null;
        Term type = null;
        for (ArchiveFile ext : this.archive.getExtensions()) {
            taxonomy.addOutputTerms(ext.getRowType(), ext.getTerms());
        }
        try {
            for (StarRecord record : this.archive) {
                Record core = record.core();
                taxonID = core.value((Term)DwcTerm.taxonID);
                type = core.rowType();
                if (taxonID == null) {
                    taxonID = UUID.randomUUID().toString();
                    type = unplacedClass;
                }
                ArrayList<Document> docs = new ArrayList<Document>();
                docs.add(this.makeDocument(taxonomy, type, core, taxonID));
                if (type != unplacedClass) {
                    this.addPseudoTaxon(taxonomy, core, taxonID, null);
                }
                for (List ext : record.extensions().values()) {
                    for (Record er : ext) {
                        docs.add(this.makeDocument(taxonomy, er.rowType(), er, taxonID));
                    }
                }
                taxonomy.addRecords(docs);
            }
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to load archive " + this.archive.getLocation() + " at taxon " + taxonID, ex);
        }
    }

    protected void loadTaxonDwCA(Taxonomy taxonomy) throws IndexBuilderException {
        Term coreType = this.getCoreType();
        String defaultDatasetName = null;
        int line = 0;
        try {
            defaultDatasetName = this.archive.getMetadata().getTitle();
        }
        catch (MetadataException e) {
            taxonomy.report(IssueType.PROBLEM, "provider.archive.noMetadata", null, null, new String[0]);
        }
        if (coreType != DwcTerm.Taxon) {
            throw new IndexBuilderException("Expecting a core row type of " + DwcTerm.Taxon);
        }
        List classifiers = TaxonConceptInstance.CLASSIFICATION_FIELDS.stream().filter(t -> this.archive.getCore().hasTerm(t)).collect(Collectors.toList());
        taxonomy.addOutputTerms(coreType, this.archive.getCore().getTerms());
        taxonomy.addOutputTerms((Term)ALATerm.TaxonVariant, this.archive.getCore().getTerms());
        String taxonID = null;
        for (ArchiveFile ext : this.archive.getExtensions()) {
            taxonomy.addOutputTerms(ext.getRowType(), ext.getTerms());
        }
        try {
            for (StarRecord record : this.archive) {
                Record core = record.core();
                taxonID = core.value((Term)DwcTerm.taxonID);
                String verbatimNomenclaturalCode = core.value((Term)DwcTerm.nomenclaturalCode);
                String datasetName = core.value((Term)DwcTerm.datasetName);
                if (datasetName == null) {
                    datasetName = defaultDatasetName;
                }
                NameProvider provider = taxonomy.resolveProvider(core.value((Term)DwcTerm.datasetID), datasetName);
                NomenclaturalClassifier code = taxonomy.resolveCode(verbatimNomenclaturalCode);
                String scientificName = core.value((Term)DwcTerm.scientificName);
                String scientificNameAuthorship = core.value((Term)DwcTerm.scientificNameAuthorship);
                String nameComplete = core.value((Term)ALATerm.nameComplete);
                if (code == null) {
                    code = provider.getDefaultNomenclaturalCode();
                    if (code == null && !provider.isLoose()) {
                        throw new IllegalStateException("No nomenclatural code for " + taxonID + " and code " + verbatimNomenclaturalCode);
                    }
                    if (code != null) {
                        taxonomy.report(IssueType.PROBLEM, "taxonomy.load.nullCode", taxonID, nameComplete, verbatimNomenclaturalCode);
                        taxonomy.count("count.load.problem");
                    }
                }
                String year = core.value((Term)DwcTerm.namePublishedInYear);
                String verbatimTaxonomicStatus = core.value((Term)DwcTerm.taxonomicStatus);
                TaxonomicType taxonomicStatus = taxonomy.resolveTaxonomicType(verbatimTaxonomicStatus);
                String verbatimTaxonRank = core.value((Term)DwcTerm.taxonRank);
                RankType rank = taxonomy.resolveRank(verbatimTaxonRank);
                String verbatimNomenclaturalStatus = core.value((Term)DwcTerm.nomenclaturalStatus);
                Set<NomenclaturalStatus> nomenclaturalStatus = taxonomy.resolveNomenclaturalStatus(verbatimNomenclaturalStatus);
                String parentNameUsage = core.value((Term)DwcTerm.parentNameUsage);
                String parentNameUsageID = core.value((Term)DwcTerm.parentNameUsageID);
                String acceptedNameUsage = core.value((Term)DwcTerm.acceptedNameUsage);
                String acceptedNameUsageID = core.value((Term)DwcTerm.acceptedNameUsageID);
                String verbatimTaxonRemarks = core.value((Term)DwcTerm.taxonRemarks);
                String verbatimProvenance = core.value((Term)DcTerm.provenance);
                String taxonomicFlags = core.value((Term)ALATerm.taxonomicFlags);
                List<String> taxonRemarks = verbatimTaxonRemarks == null || verbatimTaxonRemarks.isEmpty() ? null : Arrays.stream(verbatimTaxonRemarks.split("\\|")).map(s -> s.trim()).collect(Collectors.toList());
                List<String> provenance = verbatimProvenance == null || verbatimProvenance.isEmpty() ? null : Arrays.stream(verbatimProvenance.split("\\|")).map(s -> s.trim()).collect(Collectors.toList());
                Set<TaxonFlag> flags = taxonomy.resolveTaxonomicFlags(taxonomicFlags);
                Map<Term, Optional<String>> classification = classifiers.stream().collect(Collectors.toMap(t -> t, t -> Optional.ofNullable(core.value(t))));
                List<Distribution> distribution = null;
                if (record.hasExtension((Term)GbifTerm.Distribution)) {
                    distribution = record.extension((Term)GbifTerm.Distribution).stream().map(r -> new Distribution(taxonomy, (Record)r)).collect(Collectors.toList());
                }
                TaxonConceptInstance instance = new TaxonConceptInstance(taxonID, code, verbatimNomenclaturalCode, provider, scientificName, scientificNameAuthorship, nameComplete, year, taxonomicStatus, verbatimTaxonomicStatus, rank, verbatimTaxonRank, nomenclaturalStatus, verbatimNomenclaturalStatus, parentNameUsage, parentNameUsageID, acceptedNameUsage, acceptedNameUsageID, taxonRemarks, verbatimTaxonRemarks, provenance, classification, flags, distribution);
                instance = taxonomy.addInstance(instance);
                ArrayList<Document> docs = new ArrayList<Document>();
                docs.add(this.makeDocument(taxonomy, core.rowType(), core, instance.getTaxonID()));
                for (List ext : record.extensions().values()) {
                    for (Record er : ext) {
                        if (this.acceptExtensionRecord(instance, er)) {
                            this.addPseudoTaxon(taxonomy, er, instance.getTaxonID(), code);
                            docs.add(this.makeDocument(taxonomy, er.rowType(), er, instance.getTaxonID()));
                            continue;
                        }
                        taxonomy.report(IssueType.NOTE, "taxonomy.load.extension.discard", taxonID, scientificName, er.rowType().simpleName());
                        taxonomy.count("count.load.extension." + er.rowType().simpleName() + ".discarded");
                    }
                }
                taxonomy.addRecords(docs);
                ++line;
            }
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to load archive " + this.archive.getLocation() + " at taxon " + taxonID + " line " + line, ex);
        }
    }

    private void addPseudoTaxon(Taxonomy taxonomy, Record record, String taxonID, NomenclaturalClassifier code) throws Exception {
        if (record.rowType().equals(GbifTerm.VernacularName)) {
            String vernacularName = record.value((Term)DwcTerm.vernacularName);
            String status = record.value((Term)ALATerm.status);
            VernacularType type = VernacularType.forTerm((String)status, (VernacularType)VernacularType.COMMON);
            if (type.isPseudoScientific()) {
                NameProvider provider = taxonomy.resolveProvider(record.value((Term)DwcTerm.datasetID), record.value((Term)DwcTerm.datasetName));
                String nameID = UUID.randomUUID().toString();
                TaxonConceptInstance psuedo = new TaxonConceptInstance(nameID, code, null, provider, vernacularName, null, null, null, TaxonomicType.PSEUDO_TAXON, status, RankType.UNRANKED, null, null, null, null, null, null, taxonID, null, null, null, null, null, null);
                taxonomy.addInstance(psuedo);
            }
        }
    }

    public void loadLocationDwCA(Taxonomy taxonomy) throws IndexBuilderException {
        Term coreType = this.getCoreType();
        taxonomy.addOutputTerms(coreType, this.archive.getCore().getTerms());
        String taxonID = null;
        try {
            for (StarRecord record : this.archive) {
                Record core = record.core();
                String locationID = core.value((Term)DwcTerm.locationID);
                String parentLocationID = core.value((Term)ALATerm.parentLocationID);
                String locality = core.value((Term)DwcTerm.locality);
                String geographyType = core.value((Term)ALATerm.geographyType);
                Location location = new Location(locationID, parentLocationID, locality, parentLocationID);
                taxonomy.addLocation(location);
            }
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to load archive " + this.archive.getLocation() + " at taxon " + taxonID, ex);
        }
    }

    protected boolean acceptExtensionRecord(TaxonConceptInstance instance, Record er) {
        return er.rowType() != GbifTerm.Distribution;
    }

    private Document makeDocument(Taxonomy taxonomy, Term type, Record record, String taxonID) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("type", type.qualifiedName(), Field.Store.YES));
        doc.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((Term)DwcTerm.taxonID), taxonID, Field.Store.YES));
        for (Term term : record.terms()) {
            if (term == DwcTerm.taxonID) continue;
            String value = record.value(term);
            if (term == null || value == null || value.isEmpty()) continue;
            doc.add((IndexableField)new StringField(Taxonomy.fieldName(term), value, Field.Store.YES));
        }
        return doc;
    }
}

