/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.Location;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.util.DwcaWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gbif.api.vocabulary.LifeStage;
import org.gbif.api.vocabulary.OccurrenceStatus;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwca.record.Record;

public class Distribution {
    private static final Set<Term> PARSED_TERMS = new HashSet<DwcTerm>(Arrays.asList(DwcTerm.datasetID, DwcTerm.datasetName, DwcTerm.locationID, DwcTerm.locality, DwcTerm.lifeStage, DwcTerm.occurrenceStatus));
    private NameProvider provider;
    private Location location;
    private LifeStage lifeStage;
    private OccurrenceStatus occurrenceStatus;
    private Map<Term, String> additional;

    public Distribution(NameProvider provider, Location location, LifeStage lifeStage, OccurrenceStatus occurrenceStatus, Map<Term, String> additional) {
        this.provider = provider;
        this.location = location;
        this.lifeStage = lifeStage;
        this.occurrenceStatus = occurrenceStatus;
        this.additional = additional;
    }

    public Distribution(Taxonomy taxonomy, Record record) {
        String datasetID = record.value((Term)DwcTerm.datasetID);
        String datasetName = record.value((Term)DwcTerm.datasetName);
        this.provider = taxonomy.resolveProvider(datasetID, datasetName);
        String locationID = record.value((Term)DwcTerm.locationID);
        if (locationID != null) {
            this.location = taxonomy.resolveLocation(locationID);
        }
        String locality = record.value((Term)DwcTerm.locality);
        if (this.location == null && locality != null) {
            this.location = taxonomy.resolveLocation(locality);
        }
        if (this.location == null) {
            throw new IllegalArgumentException("Unrecognised locality " + locationID + "/" + locality);
        }
        String lifeStage = record.value((Term)DwcTerm.lifeStage);
        this.lifeStage = taxonomy.resolveLifeStage(lifeStage);
        String occurrenceStatus = record.value((Term)DwcTerm.occurrenceStatus);
        this.occurrenceStatus = taxonomy.resolveOccurrenceStatus(occurrenceStatus);
        this.additional = record.terms().stream().filter(t -> !PARSED_TERMS.contains(t) && record.value(t) != null).collect(Collectors.toMap(t -> t, t -> record.value(t)));
    }

    public NameProvider getProvider() {
        return this.provider;
    }

    public Location getLocation() {
        return this.location;
    }

    public LifeStage getLifeStage() {
        return this.lifeStage;
    }

    public OccurrenceStatus getOccurrenceStatus() {
        return this.occurrenceStatus;
    }

    public Map<Term, String> getAdditional() {
        return this.additional;
    }

    public void writeExtension(Taxonomy taxonomy, DwcaWriter writer) throws IOException {
        LinkedHashMap<Term, String> ext = new LinkedHashMap<Term, String>();
        ext.put((Term)DwcTerm.locationID, this.location.getLocationID());
        ext.put((Term)DwcTerm.locality, this.location.getLocality());
        ext.put((Term)DwcTerm.lifeStage, this.lifeStage == null ? null : this.lifeStage.name());
        ext.put((Term)DwcTerm.occurrenceStatus, this.occurrenceStatus == null ? null : this.occurrenceStatus.name());
        List<Term> terms = taxonomy.outputTerms((Term)GbifTerm.Distribution);
        for (Term term : terms) {
            if (ext.containsKey(term)) continue;
            ext.put(term, this.additional == null ? null : this.additional.get(term));
        }
        if (!ext.isEmpty()) {
            writer.addExtensionRecord((Term)GbifTerm.Distribution, ext);
        }
    }

    public boolean covers(Distribution other) {
        if (!this.location.covers(other.location)) {
            return false;
        }
        if (this.lifeStage != null && other.lifeStage == null) {
            return false;
        }
        if (this.lifeStage != null && other.lifeStage != this.lifeStage) {
            return false;
        }
        if (this.occurrenceStatus != null && other.occurrenceStatus == null) {
            return false;
        }
        return this.occurrenceStatus == null || other.occurrenceStatus == this.occurrenceStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Distribution that = (Distribution)o;
        if (!this.provider.equals(that.provider)) {
            return false;
        }
        if (!this.location.equals(that.location)) {
            return false;
        }
        if (this.lifeStage != that.lifeStage) {
            return false;
        }
        return this.occurrenceStatus == that.occurrenceStatus;
    }

    public int hashCode() {
        int result = this.provider.hashCode();
        result = 31 * result + this.location.hashCode();
        result = 31 * result + (this.lifeStage != null ? this.lifeStage.hashCode() : 0);
        result = 31 * result + (this.occurrenceStatus != null ? this.occurrenceStatus.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Distribution{" + this.provider.getId() + ", " + this.location + ", " + this.lifeStage + ", " + this.occurrenceStatus + '}';
    }
}

