/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.Distribution;
import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.Location;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.NameSource;
import au.org.ala.names.index.NomenclaturalClassifier;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonFlag;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.vocab.ALATerm;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.gbif.api.model.registry.Citation;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVNameSource
extends NameSource {
    private static final Logger logger = LoggerFactory.getLogger(CSVNameSource.class);
    private String name;
    private CSVReader reader;
    private Term rowType;
    private List<Term> terms;
    private Map<Term, Integer> termLocations;

    public CSVNameSource(Reader reader, Term rowType) throws IOException, CsvValidationException {
        this.name = "Reader " + System.identityHashCode(reader) + " - " + rowType;
        this.reader = new CSVReaderBuilder(reader).build();
        this.rowType = rowType;
        this.collectColumns();
    }

    public CSVNameSource(Path path, String encoding, Term rowType) throws IOException, CsvValidationException {
        this(Files.newBufferedReader(path, Charset.forName(encoding)), rowType);
        this.name = path.toUri().toASCIIString();
    }

    @Override
    public Term getCoreType() {
        return this.rowType;
    }

    protected void collectColumns() throws IOException, CsvValidationException {
        TermFactory factory = TermFactory.instance();
        int index = 0;
        String[] header = this.reader.readNext();
        if (header == null || header.length == 0) {
            throw new IndexBuilderException("No header in CSV file");
        }
        this.termLocations = new LinkedHashMap<Term, Integer>(header.length);
        this.terms = new ArrayList<Term>(header.length);
        for (String heading : header) {
            Term term = factory.findTerm(heading = heading.trim());
            if (term == null) {
                term = ALATerm.valueOf((String)heading);
            }
            if (term != null) {
                this.termLocations.put(term, index);
            } else {
                logger.warn("Unable to map " + heading + " onto a term");
            }
            this.terms.add(term);
            ++index;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Citation getCitation() throws IndexBuilderException {
        return new Citation(this.getName(), null);
    }

    @Override
    public Collection<Country> getCountries() {
        return Collections.emptySet();
    }

    @Override
    public Collection<Contact> getContacts() {
        return Collections.emptySet();
    }

    @Override
    public void validate() throws IndexBuilderException {
        List required = (List)REQUIRED_TERMS.get(this.rowType);
        if (required == null) {
            throw new IndexBuilderException("Unable to support row type " + this.rowType);
        }
        for (Term term : required) {
            if (this.termLocations.containsKey(term)) continue;
            throw new IndexBuilderException("CSV file does not contain required term " + term);
        }
    }

    @Override
    public void loadIntoTaxonomy(Taxonomy taxonomy) throws IndexBuilderException {
        if (this.rowType == DwcTerm.Taxon) {
            this.loadTaxon(taxonomy);
        } else if (this.rowType == GbifTerm.VernacularName) {
            this.loadVernacular(taxonomy);
        } else if (this.rowType == ALATerm.Location) {
            this.loadLocation(taxonomy);
        } else if (this.rowType == GbifTerm.Reference) {
            this.loadReference(taxonomy);
        } else {
            throw new IndexBuilderException("Unable to support row type " + this.rowType);
        }
    }

    protected void loadTaxon(Taxonomy taxonomy) throws IndexBuilderException {
        Map<Term, Integer> termLocations = this.termLocations;
        taxonomy.addOutputTerms((Term)DwcTerm.Taxon, this.terms);
        taxonomy.addOutputTerms((Term)ALATerm.TaxonVariant, this.terms);
        Integer taxonIDIndex = termLocations.get(DwcTerm.taxonID);
        Integer nomenclaturalCodeIndex = termLocations.get(DwcTerm.nomenclaturalCode);
        Integer datasetIDIndex = termLocations.get(DwcTerm.datasetID);
        Integer datasetNameIndex = termLocations.get(DwcTerm.datasetName);
        Integer scientificNameIndex = termLocations.get(DwcTerm.scientificName);
        Integer scientificNameAuthorshipIndex = termLocations.get(DwcTerm.scientificNameAuthorship);
        Integer nameCompleteIndex = termLocations.get(ALATerm.nameComplete);
        Integer namePublishedInYearIndex = termLocations.get(DwcTerm.namePublishedInYear);
        Integer taxonomicStatusIndex = termLocations.get(DwcTerm.taxonomicStatus);
        Integer taxonRankIndex = termLocations.get(DwcTerm.taxonRank);
        Integer nomenclaturalStatusIndex = termLocations.get(DwcTerm.nomenclaturalStatus);
        Integer parentNameUsageIndex = termLocations.get(DwcTerm.parentNameUsage);
        Integer parentNameUsageIDIndex = termLocations.get(DwcTerm.parentNameUsageID);
        Integer acceptedNameUsageIndex = termLocations.get(DwcTerm.acceptedNameUsage);
        Integer acceptedNameUsageIDIndex = termLocations.get(DwcTerm.acceptedNameUsageID);
        Integer taxonRemarksIndex = termLocations.get(DwcTerm.taxonRemarks);
        Integer provenanceIndex = termLocations.get(DcTerm.provenance);
        Integer taxonomicFlagsIndex = termLocations.get(ALATerm.taxonomicFlags);
        Integer distributionIndex = termLocations.get(ALATerm.distribution);
        Set classifications = TaxonConceptInstance.CLASSIFICATION_FIELDS.stream().filter(t -> termLocations.containsKey(t)).collect(Collectors.toSet());
        try {
            String[] r;
            while ((r = this.reader.readNext()) != null) {
                String[] record = r;
                String taxonID = this.get(record, taxonIDIndex);
                String verbatimNomenclautralCode = this.get(record, nomenclaturalCodeIndex);
                NomenclaturalClassifier code = taxonomy.resolveCode(verbatimNomenclautralCode);
                NameProvider provider = taxonomy.resolveProvider(this.get(record, datasetIDIndex), this.get(record, datasetNameIndex));
                String scientificName = this.get(record, scientificNameIndex);
                String scientificNameAuthorship = this.get(record, scientificNameAuthorshipIndex);
                String nameComplete = this.get(record, nameCompleteIndex);
                String year = this.get(record, namePublishedInYearIndex);
                String verbatimTaxonomicStatus = this.get(record, taxonomicStatusIndex);
                TaxonomicType taxonomicStatus = taxonomy.resolveTaxonomicType(verbatimTaxonomicStatus);
                String verbatimTaxonRank = this.get(record, taxonRankIndex);
                RankType rank = taxonomy.resolveRank(verbatimTaxonRank);
                String verbatimNomenclaturalStatus = this.get(record, nomenclaturalStatusIndex);
                Set<NomenclaturalStatus> nomenclaturalStatus = taxonomy.resolveNomenclaturalStatus(verbatimNomenclaturalStatus);
                String verbatimTaxonomicFlags = this.get(record, taxonomicFlagsIndex);
                Set<TaxonFlag> flags = taxonomy.resolveTaxonomicFlags(verbatimTaxonomicFlags);
                String parentNameUsage = this.get(record, parentNameUsageIndex);
                String parentNameUsageID = this.get(record, parentNameUsageIDIndex);
                String acceptedNameUsage = this.get(record, acceptedNameUsageIndex);
                String acceptedNameUsageID = this.get(record, acceptedNameUsageIDIndex);
                String verbatimTaxonRemarks = this.get(record, taxonRemarksIndex);
                String verbatimProvenance = this.get(record, provenanceIndex);
                List<String> taxonRemarks = verbatimTaxonRemarks == null || verbatimTaxonRemarks.isEmpty() ? null : Arrays.stream(verbatimTaxonRemarks.split("\\|")).map(s -> s.trim()).collect(Collectors.toList());
                List<String> provenance = verbatimProvenance == null || verbatimProvenance.isEmpty() ? null : Arrays.stream(verbatimProvenance.split("\\|")).map(s -> s.trim()).collect(Collectors.toList());
                Map<Term, Optional<String>> classification = null;
                if (!classifications.isEmpty()) {
                    classification = classifications.stream().collect(Collectors.toMap(t -> t, t -> Optional.ofNullable(this.get(record, (Integer)termLocations.get(t)))));
                }
                List<Distribution> distribution = null;
                String dist = this.get(record, distributionIndex);
                if (dist != null) {
                    distribution = Arrays.stream(dist.split("\\|")).map(id -> taxonomy.resolveLocation((String)id)).filter(Objects::nonNull).map(l -> new Distribution(provider, (Location)l, null, null, null)).collect(Collectors.toList());
                }
                TaxonConceptInstance instance = new TaxonConceptInstance(taxonID, code, verbatimNomenclautralCode, provider, scientificName, scientificNameAuthorship, nameComplete, year, taxonomicStatus, verbatimTaxonomicStatus, rank, verbatimTaxonRank, nomenclaturalStatus, verbatimNomenclaturalStatus, parentNameUsage, parentNameUsageID, acceptedNameUsage, acceptedNameUsageID, taxonRemarks, verbatimTaxonRemarks, provenance, classification, flags, distribution);
                instance.normalise();
                instance = taxonomy.addInstance(instance);
                Document doc = new Document();
                doc.add((IndexableField)new StringField("type", DwcTerm.Taxon.qualifiedName(), Field.Store.YES));
                doc.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
                for (int i = 0; i < record.length; ++i) {
                    String value;
                    Term term = this.terms.get(i);
                    String string = value = term == DwcTerm.taxonID ? instance.getTaxonID() : record[i];
                    if (term == null || value == null || value.isEmpty()) continue;
                    doc.add((IndexableField)new StringField(Taxonomy.fieldName(term), value, Field.Store.YES));
                }
                taxonomy.addRecords(Collections.singletonList(doc));
            }
        }
        catch (IndexBuilderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to load CSV file", ex);
        }
    }

    public void loadVernacular(Taxonomy taxonomy) throws IndexBuilderException {
        Map<Term, Integer> termLocations = this.termLocations;
        taxonomy.addOutputTerms((Term)GbifTerm.VernacularName, this.terms);
        try {
            String[] r;
            while ((r = this.reader.readNext()) != null) {
                String[] record = r;
                Document doc = new Document();
                doc.add((IndexableField)new StringField("type", ALATerm.UnplacedVernacularName.qualifiedName(), Field.Store.YES));
                doc.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
                for (int i = 0; i < record.length; ++i) {
                    Term term = this.terms.get(i);
                    String value = record[i];
                    if (term == null || value == null || value.isEmpty()) continue;
                    doc.add((IndexableField)new StringField(Taxonomy.fieldName(term), value, Field.Store.YES));
                }
                taxonomy.addRecords(Collections.singletonList(doc));
            }
        }
        catch (IndexBuilderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to load CSV file", ex);
        }
    }

    protected void loadLocation(Taxonomy taxonomy) throws IndexBuilderException {
        Map<Term, Integer> termLocations = this.termLocations;
        taxonomy.addOutputTerms((Term)ALATerm.Location, this.terms);
        Integer locationIDIndex = termLocations.get(DwcTerm.locationID);
        Integer parentLocationIDIndex = termLocations.get(ALATerm.parentLocationID);
        Integer localityIndex = termLocations.get(DwcTerm.locality);
        Integer geographyTypeIndex = termLocations.get(ALATerm.geographyType);
        try {
            String[] r;
            while ((r = this.reader.readNext()) != null) {
                String[] record = r;
                String locationID = this.get(record, locationIDIndex);
                String parentLocationID = this.get(record, parentLocationIDIndex);
                String locality = this.get(record, localityIndex);
                String geographyType = this.get(record, geographyTypeIndex);
                Location location = new Location(locationID, parentLocationID, locality, geographyType);
                taxonomy.addLocation(location);
            }
        }
        catch (IndexBuilderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to load CSV file", ex);
        }
    }

    public void loadReference(Taxonomy taxonomy) throws IndexBuilderException {
        Map<Term, Integer> termLocations = this.termLocations;
        taxonomy.addOutputTerms((Term)GbifTerm.Reference, this.terms);
        try {
            String[] r;
            while ((r = this.reader.readNext()) != null) {
                String[] record = r;
                Document doc = new Document();
                doc.add((IndexableField)new StringField("type", ALATerm.UnplacedReference.qualifiedName(), Field.Store.YES));
                doc.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
                for (int i = 0; i < record.length; ++i) {
                    Term term = this.terms.get(i);
                    String value = record[i];
                    if (term == null || value == null || value.isEmpty()) continue;
                    doc.add((IndexableField)new StringField(Taxonomy.fieldName(term), value, Field.Store.YES));
                }
                taxonomy.addRecords(Collections.singletonList(doc));
            }
        }
        catch (IndexBuilderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to load CSV file", ex);
        }
    }

    private String get(String[] record, Integer index) {
        if (index == null || index < 0 || index >= record.length) {
            return null;
        }
        String s = record[index];
        if (s == null) {
            return null;
        }
        return (s = s.trim()).isEmpty() ? null : s;
    }
}

