/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.Distribution;
import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.ScientificName;
import au.org.ala.names.index.TaxonConcept;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.TaxonResolution;
import au.org.ala.names.index.TaxonResolver;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.index.UnrankedScientificName;
import au.org.ala.names.index.provider.ConceptResolutionPriority;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonFlag;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.names.model.TaxonomicTypeGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gbif.api.exception.UnparsableException;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.api.vocabulary.Rank;
import org.gbif.nameparser.PhraseNameParser;

public class ALATaxonResolver
implements TaxonResolver {
    private Taxonomy taxonomy;

    public ALATaxonResolver(Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
    }

    @Override
    public List<TaxonConceptInstance> principals(TaxonConcept concept, Collection<TaxonConceptInstance> instances) throws IndexBuilderException {
        Optional<TaxonConceptInstance> max;
        Optional<NameProvider> authority;
        int cutoff = this.taxonomy.getAcceptedCutoff();
        List geographic = instances.stream().filter(tci -> tci.isGeographic() && tci.getScore() > cutoff).collect(Collectors.toList());
        List<TaxonConceptInstance> principals = instances.stream().filter(tci -> tci.isPrimary() && !tci.isGeographic() && tci.getScore() > cutoff).collect(Collectors.toList());
        if (principals.isEmpty()) {
            this.taxonomy.report(IssueType.NOTE, "taxonResolver.noPrincipals", concept, null);
            principals = instances.stream().filter(tci -> !tci.isGeographic()).collect(Collectors.toList());
        }
        if (!(authority = (max = principals.stream().max(TaxonConceptInstance.SCORE_COMPARATOR)).map(TaxonConceptInstance::getAuthority)).isPresent()) {
            this.taxonomy.report(IssueType.NOTE, "taxonResolver.noProvider", concept, null);
            max = instances.stream().max(TaxonConceptInstance.SCORE_COMPARATOR);
            authority = max.map(TaxonConceptInstance::getAuthority);
            principals = new ArrayList<TaxonConceptInstance>(instances);
        }
        NameProvider source = authority.orElse(this.taxonomy.getInferenceProvider());
        principals = principals.stream().filter(instance -> instance.getAuthority() == source).collect(Collectors.toList());
        principals.sort(TaxonConceptInstance.INVERSE_SCORE_COMPARATOR);
        geographic.sort(TaxonConceptInstance.INVERSE_SCORE_COMPARATOR);
        principals.addAll(geographic);
        return principals;
    }

    @Override
    public TaxonResolution resolve(TaxonConcept concept, List<TaxonConceptInstance> principals, Collection<TaxonConceptInstance> instances) throws IndexBuilderException {
        TaxonResolution resolution = new TaxonResolution(principals);
        for (TaxonConceptInstance instance : instances) {
            this.resolve(instance, resolution);
        }
        return resolution;
    }

    protected void resolve(TaxonConceptInstance instance, TaxonResolution resolution) throws IndexBuilderException {
        Optional<TaxonConceptInstance> resolved;
        ScientificName acceptedScientificName;
        TaxonomicType taxonomicStatus = instance.getTaxonomicStatus();
        TaxonomicTypeGroup taxonomicGroup = taxonomicStatus.getGroup();
        TaxonConcept taxonConcept = (TaxonConcept)instance.getContainer();
        ScientificName scientificName = taxonConcept == null ? null : (ScientificName)taxonConcept.getContainer();
        TaxonConceptInstance accepted = instance.getAccepted() == null ? null : instance.getAccepted().getRepresentative();
        TaxonConcept acceptedTaxonConcept = accepted == null ? null : (TaxonConcept)accepted.getContainer();
        ScientificName scientificName2 = acceptedScientificName = acceptedTaxonConcept == null ? null : (ScientificName)acceptedTaxonConcept.getContainer();
        if (resolution.getPrincipal().contains(instance)) {
            resolution.addInternal(instance, instance, this.taxonomy);
            return;
        }
        if (instance.hasFlag(TaxonFlag.SYNTHETIC)) {
            resolved = resolution.getPrincipal().stream().filter(tci -> tci.isPrimary()).findFirst();
            if (resolved.isPresent()) {
                this.taxonomy.report(IssueType.NOTE, "taxonResolver.synthetic.removed", instance, null);
                this.taxonomy.count("count.resolve.synthetic.removed");
                instance.setForbidden(true);
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            instance.setForbidden(true);
        }
        if (instance.isAccepted() && instance.isPrimary()) {
            TaxonConceptInstance r;
            resolved = resolution.getUsed().stream().filter(tci -> tci.isAccepted() && tci.getContainer() == taxonConcept).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.isAccepted() && ((TaxonConcept)tci.getContainer()).getContainer() == scientificName).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.isAccepted()).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            List<TaxonConceptInstance> synonyms = resolution.getUsed().stream().filter(tci -> tci.isSynonym() && !tci.isForbidden()).collect(Collectors.toList());
            if (!synonyms.isEmpty() && (r = this.lub(synonyms)) != null) {
                this.taxonomy.report(IssueType.NOTE, "taxonResolver.synonyms", instance, Arrays.asList(r));
                resolution.addExternal(instance, r, this.taxonomy);
                return;
            }
            resolution.addInternal(instance, instance, this.taxonomy);
            return;
        }
        if (instance.isSynonym() && instance.isPrimary() && accepted != null) {
            resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus() == taxonomicStatus && tci.getAccepted() != null && tci.getAccepted().getContainer() == acceptedTaxonConcept).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus().getGroup() == taxonomicGroup && tci.getAccepted() != null && tci.getAccepted().getContainer() == acceptedTaxonConcept).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus() == taxonomicStatus && tci.getAccepted() != null && ((TaxonomicElement)tci.getAccepted().getContainer()).getContainer() == acceptedScientificName).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus().getGroup() == taxonomicGroup && tci.getAccepted() != null && ((TaxonomicElement)tci.getAccepted().getContainer()).getContainer() == acceptedScientificName).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            List<TaxonConceptInstance> synonyms = resolution.getUsed().stream().filter(tci -> tci.isSynonym() && !tci.isForbidden()).collect(Collectors.toList());
            if (!synonyms.isEmpty()) {
                TaxonConceptInstance r;
                TaxonConceptInstance taxonConceptInstance = r = synonyms.size() == 1 ? (TaxonConceptInstance)synonyms.get(0) : this.lub(synonyms);
                if (r != null) {
                    this.taxonomy.report(IssueType.NOTE, "taxonResolver.synonyms", instance, Arrays.asList(r));
                    resolution.addExternal(instance, r, this.taxonomy);
                    return;
                }
            }
            resolution.addInternal(instance, instance, this.taxonomy);
            return;
        }
        if (instance.getAccepted() != null) {
            resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus() == taxonomicStatus && tci.getAccepted() != null && tci.getAccepted().getContainer() == acceptedTaxonConcept).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus() == taxonomicStatus && tci.getAccepted() != null && ((TaxonomicElement)tci.getAccepted().getContainer()).getContainer() == acceptedScientificName).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolution.addInternal(instance, instance, this.taxonomy);
            return;
        }
        if (taxonomicStatus.isPlaceholder() || taxonomicStatus.isUnplaced()) {
            resolved = resolution.getUsed().stream().filter(tci -> tci.getContainer() == taxonConcept).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> ((TaxonConcept)tci.getContainer()).getContainer() == acceptedScientificName).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolution.addInternal(instance, instance, this.taxonomy);
            return;
        }
        resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus() == taxonomicStatus).findFirst();
        if (resolved.isPresent()) {
            resolution.addInternal(instance, resolved.get(), this.taxonomy);
            return;
        }
        resolution.addInternal(instance, instance, this.taxonomy);
    }

    @Override
    public RankType estimateRank(TaxonConceptInstance instance, UnrankedScientificName parent) throws IndexBuilderException {
        RankType acceptedRank = instance.getAccepted() != null ? instance.getAccepted().getRank() : null;
        TaxonConcept found = parent.findRankedConcept(((TaxonConcept)instance.getContainer()).getKey(), acceptedRank, this.taxonomy);
        if (found != null) {
            return found.getRank();
        }
        if (instance.getProvider().getUnrankedStrategy().isInferRank()) {
            try {
                PhraseNameParser parser = new PhraseNameParser();
                ParsedName pn = parser.parse(instance.getScientificName(), acceptedRank == null ? null : acceptedRank.getCbRank());
                if (pn.getRank() != null) {
                    return RankType.getForCBRank((Rank)pn.getRank());
                }
            }
            catch (UnparsableException unparsableException) {
                // empty catch block
            }
            return acceptedRank;
        }
        return null;
    }

    @Override
    public void reallocateSecondaryConcepts(ScientificName scientificName, Taxonomy taxonomy) throws IndexBuilderException {
        TaxonConcept principal = (TaxonConcept)scientificName.getPrincipal();
        if (principal != null) {
            ConceptResolutionPriority pp = principal.getRepresentative().getProvider().getConceptResolutionPriority();
            for (TaxonConcept tc : scientificName.getConcepts()) {
                ConceptResolutionPriority tp = tc.getRepresentative().getProvider().getConceptResolutionPriority();
                if (pp.compareTo(tp) >= 0) continue;
                this.taxonomy.report(IssueType.NOTE, "taxonConcept.reallocated.secondary", principal, Arrays.asList(tc));
                principal.reallocate(tc, taxonomy, "taxonConcept.reallocated.secondary.provenance");
            }
        }
    }

    @Override
    public void resolveDistribution(TaxonConcept concept, TaxonResolution resolution, Taxonomy taxonomy) throws IndexBuilderException {
        for (TaxonConceptInstance used : resolution.getUsed()) {
            if (used.getDistribution() == null) {
                resolution.addDistribution(used, null);
                continue;
            }
            List<Distribution> distribution = used.getDistribution();
            for (TaxonConceptInstance child : resolution.getChildren(used)) {
                List<Distribution> more = child.getDistribution();
                if (child == used || !child.isOutput() || child.getContainer() != concept || more == null) continue;
                List<Distribution> coverage = distribution;
                more = more.stream().filter(d -> !coverage.stream().anyMatch(d1 -> d1.covers((Distribution)d))).collect(Collectors.toList());
                distribution = this.mergeDistribution(distribution, more);
            }
            resolution.addDistribution(used, distribution.isEmpty() ? null : distribution);
        }
    }

    protected List<Distribution> mergeDistribution(List<Distribution> distribution, List<Distribution> more) {
        for (Distribution d : more) {
            distribution = this.mergeDistribution(distribution, d);
        }
        return distribution;
    }

    protected List<Distribution> mergeDistribution(List<Distribution> distribution, Distribution dist) {
        ArrayList<Distribution> merged = new ArrayList<Distribution>(distribution.size());
        for (Distribution d : distribution) {
            if (dist != null && dist.covers(d)) continue;
            if (dist != null && d.covers(dist)) {
                merged.add(d);
                dist = null;
                continue;
            }
            merged.add(d);
        }
        if (dist != null) {
            merged.add(dist);
        }
        return merged;
    }

    public TaxonConceptInstance lub(TaxonConceptInstance i1, TaxonConceptInstance i2) {
        while (i1 != null) {
            TaxonConceptInstance r1 = i1.getAccepted() == null ? i1 : i1.getAccepted().getRepresentative();
            TaxonConceptInstance p2 = i2;
            while (p2 != null) {
                TaxonConceptInstance taxonConceptInstance = p2 = p2.getAccepted() == null ? p2 : p2.getAccepted().getRepresentative();
                if (p2.getContainer() == r1.getContainer()) {
                    return r1;
                }
                p2 = p2.getParent() == null ? null : p2.getParent().getRepresentative();
            }
            i1 = i1.getParent() == null ? null : i1.getParent().getRepresentative();
        }
        return null;
    }

    public TaxonConceptInstance lub(Collection<TaxonConceptInstance> instances) {
        TaxonConceptInstance lub;
        Iterator<TaxonConceptInstance> i = instances.iterator();
        TaxonConceptInstance taxonConceptInstance = lub = i.hasNext() ? i.next() : null;
        while (i.hasNext() && lub != null) {
            lub = this.lub(lub, i.next());
        }
        return lub;
    }
}

