/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameAnalyser;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.NomenclaturalClassifier;
import au.org.ala.names.index.Reporter;
import au.org.ala.names.model.ALAParsedName;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.SynonymType;
import au.org.ala.names.model.TaxonFlag;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.names.util.CleanedScientificName;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.gbif.api.exception.UnparsableException;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.api.service.checklistbank.NameParser;
import org.gbif.api.vocabulary.LifeStage;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.api.vocabulary.OccurrenceStatus;
import org.gbif.api.vocabulary.Rank;
import org.gbif.checklistbank.authorship.AuthorComparator;
import org.gbif.checklistbank.utils.SciNameNormalizer;
import org.gbif.common.parsers.LifeStageParser;
import org.gbif.common.parsers.NomStatusParser;
import org.gbif.common.parsers.OccurrenceStatusParser;
import org.gbif.common.parsers.core.ParseResult;
import org.gbif.nameparser.PhraseNameParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ALANameAnalyser
extends NameAnalyser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ALANameAnalyser.class);
    private static final String DEFAULT_TAXONOMIC_TYPE_CODE_MAP = "taxonomic_type_codes.csv";
    private static final String DEFAULT_RANK_CODE_MAP = "rank_codes.csv";
    private static final String DEFAULT_NONEMCLATURAL_STATUS_CODE_MAP = "nomenclatural_status_codes.csv";
    private static final String DEFAULT_INFORMAL_PATTERN_LIST = "informal_names.csv";
    protected static final Pattern PARENTHESIS = Pattern.compile("\\s\\(\\s*\\p{Alpha}+\\s*\\)\\s");
    protected static final Pattern BRACKETED = Pattern.compile("\\s(\\[.+\\]|\\{.+\\})");
    private static final String RANK_NAMES = Arrays.stream(Rank.values()).map(Enum::name).collect(Collectors.joining("|"));
    private static final Pattern RANK_AS_NAME = Pattern.compile("(?i:" + RANK_NAMES + ")");
    private static final String RANK_MARKERS_STRICT = Arrays.stream(Rank.values()).filter(r -> r.getMarker() != null).map(r -> r.getMarker().replaceAll("\\.", "\\.")).collect(Collectors.joining("|"));
    private static final String RANK_MARKERS_LOOSE = Arrays.stream(Rank.values()).filter(r -> r.getMarker() != null).map(r -> r.getMarker().replaceAll("\\.", "\\.?")).collect(Collectors.joining("|"));
    private static final String RANK_PLACEHOLDER_MARKERS = "\\p{Alpha}\\.";
    protected static final Pattern STRICT_MARKERS = Pattern.compile("\\s+(?:" + RANK_MARKERS_STRICT + "|" + "\\p{Alpha}\\." + ")\\s+");
    protected static final Pattern LOOSE_MARKERS = Pattern.compile("\\s+(?:" + RANK_MARKERS_LOOSE + "|" + "\\p{Alpha}\\." + ")\\.?\\s+");
    protected static final Pattern UNSURE_MARKER = Pattern.compile("\\s+(?:cf|cfr|conf|aff)\\.?\\s+");
    protected static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9'\"\\- ]+");
    protected static final Pattern SPACES = Pattern.compile("\\s+");
    protected static final Pattern ESCAPES = Pattern.compile("\\\\(.)");
    protected static final Pattern ESCAPE = Pattern.compile("\\\\");
    protected static final Pattern AUTHOR_AND = Pattern.compile("\\s+and\\s+");
    protected static final Pattern YEAR_MARKER = Pattern.compile("^\\s*,\\s*\\d{4}($|\\s)");
    protected static final Pattern DOUBTFUL = Pattern.compile("((^| )(undet|indet|aff|cf)[#!?\\.]?)+(?![a-z])");
    protected static final Predicate<String> PLACEHOLDER_TEST = Pattern.compile("(?i:species inquirenda|incertae sedis|unplaced)").asPredicate();
    protected static final Predicate<String> HYBRID_TEST = Pattern.compile(" x ").asPredicate();
    protected static final Predicate<String> CULTIVAR_TEST = Pattern.compile("\\p{Upper}\\p{Lower}+\\s+(?:\\p{Lower}+\\s+)?'[\\w\\s]+'").asPredicate();
    protected static final Predicate<String> INVALID_TEST = Pattern.compile("^[^\\p{Alpha}]*$").asPredicate();
    protected static final Predicate<String> DOUBTFUL_TEST = DOUBTFUL.asPredicate();
    protected static final Predicate<String> HIGHER_SCIENTIFIC_TEST = Pattern.compile("^\\p{Upper}[\\p{Alpha}\\-]+(\\s+\\p{Alpha}[\\p{Alpha}\\-]+)?$").asPredicate();
    protected static final Predicate<String> LOWER_SCIENTIFIC_TEST = Pattern.compile("^\\p{Upper}[\\p{Alpha}\\-]+\\s+\\p{Lower}[\\p{Lower}\\-]+(\\s+\\p{Lower}[\\p{Lower}\\-]+)?$").asPredicate();
    protected static final Predicate<String> INITIAL_QUOTES_TEST = Pattern.compile("^['\"]\\s*(\\p{Upper}\\p{Lower}+)]\\s*['\"]'").asPredicate();
    private Map<String, TaxonomicType> taxonomicTypeMap;
    private Map<String, SynonymType> synonymMap;
    private Map<String, RankType> rankMap;
    private Map<String, NomenclaturalStatus> nomenclaturalStatusMap;
    private List<Pattern> informalPatterns;
    private NameParser nameParser = new PhraseNameParser();
    private NomStatusParser nomStatusParser = NomStatusParser.getInstance();
    private LifeStageParser lifeStageParser = LifeStageParser.getInstance();
    private OccurrenceStatusParser occurrenceStatusParser = OccurrenceStatusParser.getInstance();

    public ALANameAnalyser(AuthorComparator authorComparator, Reporter reporter) {
        super(authorComparator, reporter);
        this.buildTaxonomicTypeMap();
        this.buildRankMap();
        this.buildNomenclaturalStatusMap();
        this.buildInformalPatternList();
    }

    public ALANameAnalyser() {
        this(AuthorComparator.createWithAuthormap(), null);
    }

    @Override
    public NameAnalyser.AnalysisResult analyse(@Nullable NomenclaturalClassifier code, String scientificName, @Nullable String scientificNameAuthorship, RankType rankType, TaxonomicType taxonomicStatus, Set<TaxonFlag> flags, boolean loose) {
        String ac;
        int p;
        NameType nameType = NameType.INFORMAL;
        ParsedName name = null;
        ALAParsedName phraseName = null;
        scientificName = this.normalise(scientificName);
        if ((scientificNameAuthorship = this.normalise(scientificNameAuthorship)) != null && (p = scientificName.indexOf(scientificNameAuthorship)) >= 0) {
            String left = scientificName.substring(0, p);
            String right = scientificName.substring(p + scientificNameAuthorship.length());
            right = YEAR_MARKER.matcher(right).replaceFirst(" ");
            scientificName = (left + " " + right).trim();
        }
        try {
            name = this.nameParser.parse(scientificName, rankType == null || rankType == RankType.UNRANKED ? null : rankType.getCbRank());
            if (name != null) {
                if (name instanceof ALAParsedName && ((ALAParsedName)name).cleanPhrase != null) {
                    phraseName = (ALAParsedName)name;
                }
                nameType = name.getType();
                if (rankType == null && name.getRank() != null) {
                    rankType = RankType.getForCBRank((Rank)name.getRank());
                }
            }
        }
        catch (UnparsableException ex) {
            LOGGER.info("Unable to parse " + ex.getMessage());
        }
        if (UNSURE_MARKER.matcher(scientificName).find()) {
            nameType = NameType.DOUBTFUL;
        } else if (loose && scientificNameAuthorship == null && name != null && (ac = this.normalise(name.authorshipComplete())) != null && !ac.isEmpty() && !(name instanceof ALAParsedName)) {
            scientificName = name.buildName(true, true, false, true, true, false, true, false, true, false, false, false, true, true);
            scientificNameAuthorship = ac;
        }
        scientificName = PARENTHESIS.matcher(scientificName).replaceAll(" ");
        scientificName = LOOSE_MARKERS.matcher(scientificName).replaceAll(" ");
        if (phraseName != null) {
            nameType = NameType.PLACEHOLDER;
            scientificName = phraseName.getGenusOrAbove();
            if (phraseName.getRank() != null) {
                scientificName = scientificName + " " + phraseName.getRank().getMarker();
            }
            scientificName = scientificName + " " + phraseName.cleanPhrase;
            if (phraseName.cleanVoucher != null) {
                scientificName = scientificName + " " + phraseName.cleanVoucher;
            }
        }
        if (taxonomicStatus == TaxonomicType.MISCELLANEOUS_LITERATURE) {
            nameType = NameType.INFORMAL;
        } else if (PLACEHOLDER_TEST.test(scientificName) || taxonomicStatus != null && taxonomicStatus.isPlaceholder()) {
            scientificName = scientificName + " " + UUID.randomUUID().toString();
            nameType = NameType.PLACEHOLDER;
        } else if (code == NomenclaturalClassifier.VIRUS) {
            nameType = NameType.VIRUS;
        } else if (code == NomenclaturalClassifier.BACTERIAL) {
            nameType = NameType.SCIENTIFIC;
        } else if (HYBRID_TEST.test(scientificName)) {
            nameType = NameType.HYBRID;
        } else if (code == NomenclaturalClassifier.CULTIVARS || CULTIVAR_TEST.test(scientificName)) {
            nameType = NameType.CULTIVAR;
        } else if (INVALID_TEST.test(scientificName)) {
            scientificName = UUID.randomUUID().toString();
            nameType = NameType.NO_NAME;
        } else if (DOUBTFUL_TEST.test(scientificName)) {
            nameType = NameType.DOUBTFUL;
        } else if (INITIAL_QUOTES_TEST.test(scientificName)) {
            nameType = NameType.DOUBTFUL;
        } else if (rankType == null && (HIGHER_SCIENTIFIC_TEST.test(scientificName) || LOWER_SCIENTIFIC_TEST.test(scientificName))) {
            nameType = NameType.SCIENTIFIC;
        } else if (rankType != null && rankType.isHigherThan(RankType.SPECIES) && HIGHER_SCIENTIFIC_TEST.test(scientificName)) {
            nameType = NameType.SCIENTIFIC;
            scientificName = SciNameNormalizer.normalize((String)scientificName);
        } else if (LOWER_SCIENTIFIC_TEST.test(scientificName)) {
            nameType = NameType.SCIENTIFIC;
            scientificName = SciNameNormalizer.normalize((String)scientificName);
        }
        if (rankType == null) {
            rankType = RankType.UNRANKED;
        }
        if (name != null && name.isAutonym()) {
            scientificName = name.canonicalName();
            flags = flags == null ? new HashSet<TaxonFlag>() : new HashSet<TaxonFlag>(flags);
            flags.add(TaxonFlag.AUTONYM);
            scientificNameAuthorship = null;
        }
        scientificName = NON_NAME.matcher(scientificName).replaceAll(" ");
        scientificName = SPACES.matcher(scientificName).replaceAll(" ");
        scientificName = scientificName.trim().toUpperCase();
        NameKey key = new NameKey(this, code, scientificName, scientificNameAuthorship, rankType, nameType, flags);
        String mononomial = null;
        String genus = null;
        String specificEpithet = null;
        String infraspecificEpithet = null;
        String cultivarEpithet = null;
        if (name != null) {
            mononomial = name.getGenusOrAbove();
            if (mononomial != null && RANK_AS_NAME.matcher(mononomial).matches()) {
                mononomial = null;
            } else {
                String string = genus = rankType != null && !rankType.isHigherThan(RankType.GENUS) ? mononomial : null;
                if (phraseName == null) {
                    specificEpithet = name.getSpecificEpithet();
                    infraspecificEpithet = name.getInfraSpecificEpithet();
                    cultivarEpithet = name.getCultivarEpithet();
                }
            }
        }
        return new NameAnalyser.AnalysisResult(key, mononomial, genus, specificEpithet, infraspecificEpithet, cultivarEpithet);
    }

    protected <T extends Enum<T>> void loadCsv(String resource, Map<String, T> map, Class<T> clazz) {
        try {
            String[] next;
            CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(this.getClass().getResourceAsStream(resource), "UTF-8")).withSkipLines(1).build();
            while ((next = reader.readNext()) != null) {
                String label = next[0];
                String val = next[1];
                Object value = null;
                if (val != null) {
                    value = (val = val.trim()).isEmpty() ? null : Enum.valueOf(clazz, val);
                }
                map.put(label.toUpperCase().trim(), value);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to build map for " + clazz, (Throwable)ex);
        }
    }

    protected void loadPatternCsv(String resource, List<Pattern> list) {
        try {
            String[] next;
            CSVParser csvParser = new CSVParserBuilder().withSeparator(',').withQuoteChar('\"').withEscapeChar('\\').build();
            CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(this.getClass().getResourceAsStream(resource), "UTF-8")).withCSVParser((ICSVParser)csvParser).withSkipLines(1).build();
            while ((next = reader.readNext()) != null) {
                String label = next[0];
                String val = next[1];
                if (val != null) {
                    val = (val = val.trim()).isEmpty() ? null : val;
                }
                Pattern value = Pattern.compile(val);
                list.add(value);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to build pattern list", (Throwable)ex);
        }
    }

    protected void buildTaxonomicTypeMap() {
        this.taxonomicTypeMap = new HashMap<String, TaxonomicType>(64);
        for (TaxonomicType s : TaxonomicType.values()) {
            this.taxonomicTypeMap.put(s.getTerm().toUpperCase().trim(), s);
            if (s.getLabels() == null) continue;
            for (String l : s.getLabels()) {
                this.taxonomicTypeMap.put(l.toUpperCase().trim(), s);
            }
        }
        this.loadCsv(DEFAULT_TAXONOMIC_TYPE_CODE_MAP, this.taxonomicTypeMap, TaxonomicType.class);
    }

    protected void buildRankMap() {
        this.rankMap = new HashMap<String, RankType>(64);
        for (RankType r : RankType.values()) {
            this.rankMap.put(r.getRank().toUpperCase().trim(), r);
            if (r.getStrRanks() == null) continue;
            for (String label : r.getStrRanks()) {
                this.rankMap.put(label.toUpperCase().trim(), r);
            }
        }
        this.loadCsv(DEFAULT_RANK_CODE_MAP, this.rankMap, RankType.class);
    }

    protected void buildNomenclaturalStatusMap() {
        this.nomenclaturalStatusMap = new HashMap<String, NomenclaturalStatus>(64);
        this.loadCsv(DEFAULT_NONEMCLATURAL_STATUS_CODE_MAP, this.nomenclaturalStatusMap, NomenclaturalStatus.class);
    }

    protected void buildInformalPatternList() {
        this.informalPatterns = new ArrayList<Pattern>(32);
        this.loadPatternCsv(DEFAULT_INFORMAL_PATTERN_LIST, this.informalPatterns);
    }

    @Override
    public NomenclaturalClassifier canonicaliseCode(String code) {
        if (code == null) {
            return null;
        }
        NomenclaturalClassifier nc = NomenclaturalClassifier.find(code = code.toUpperCase().trim());
        if (nc == null) {
            this.report(IssueType.PROBLEM, "nomenclaturalCode.notFound", null, null, code);
        }
        return nc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaxonomicType canonicaliseTaxonomicType(String taxonomicStatus) {
        if (taxonomicStatus == null) {
            return TaxonomicType.INFERRED_UNPLACED;
        }
        if ((taxonomicStatus = taxonomicStatus.toUpperCase().trim()).isEmpty()) {
            return TaxonomicType.INFERRED_UNPLACED;
        }
        TaxonomicType type = this.taxonomicTypeMap.get(taxonomicStatus);
        if (type == null) {
            this.report(IssueType.PROBLEM, "taxonomicStatus.notFound", null, null, taxonomicStatus);
            type = TaxonomicType.INFERRED_UNPLACED;
            ALANameAnalyser aLANameAnalyser = this;
            synchronized (aLANameAnalyser) {
                this.taxonomicTypeMap.put(taxonomicStatus, type);
            }
        }
        return type;
    }

    @Override
    public TaxonFlag canonicaliseFlag(String flag) {
        if (StringUtils.isBlank((CharSequence)flag)) {
            return null;
        }
        if ((flag = flag.trim()).equalsIgnoreCase("autonym")) {
            return TaxonFlag.AUTONYM;
        }
        if (flag.equalsIgnoreCase("ambiguousNomenclaturalCode")) {
            return TaxonFlag.AMBIGUOUS_NOMENCLATURAL_CODE;
        }
        if (flag.equalsIgnoreCase("synthetic")) {
            return TaxonFlag.SYNTHETIC;
        }
        throw new IllegalArgumentException("Unrecognised flag " + flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RankType canonicaliseRank(String rank) {
        if (rank == null) {
            return RankType.UNRANKED;
        }
        if ((rank = rank.toUpperCase().trim()).isEmpty()) {
            return RankType.UNRANKED;
        }
        RankType rankType = this.rankMap.get(rank);
        if (rankType == null) {
            this.report(IssueType.PROBLEM, "rank.notFound", null, null, rank);
            rankType = RankType.UNRANKED;
            ALANameAnalyser aLANameAnalyser = this;
            synchronized (aLANameAnalyser) {
                this.rankMap.put(rank, rankType);
            }
        }
        return rankType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NomenclaturalStatus canonicaliseNomenclaturalStatus(String nomenclaturalStatus) {
        if (nomenclaturalStatus == null) {
            return null;
        }
        ParseResult parsed = this.nomStatusParser.parse(nomenclaturalStatus);
        if (parsed.isSuccessful()) {
            return (NomenclaturalStatus)parsed.getPayload();
        }
        if ((nomenclaturalStatus = nomenclaturalStatus.toUpperCase().trim()).isEmpty()) {
            return null;
        }
        NomenclaturalStatus status = this.nomenclaturalStatusMap.get(nomenclaturalStatus);
        if (status == null && !this.nomenclaturalStatusMap.containsKey(nomenclaturalStatus)) {
            this.report(IssueType.PROBLEM, "nomenclaturalStatus.notFound", null, null, nomenclaturalStatus);
            ALANameAnalyser aLANameAnalyser = this;
            synchronized (aLANameAnalyser) {
                this.nomenclaturalStatusMap.put(nomenclaturalStatus, null);
            }
        }
        return status;
    }

    @Override
    public LifeStage canonicaliseLifeStage(String lifeStage) {
        if (lifeStage == null || lifeStage.isEmpty()) {
            return null;
        }
        ParseResult result = this.lifeStageParser.parse(lifeStage);
        if (!result.isSuccessful()) {
            this.report(IssueType.VALIDATION, "taxonomy.load.lifeStage.invalid", lifeStage, "", new String[0]);
            return null;
        }
        return (LifeStage)result.getPayload();
    }

    @Override
    public OccurrenceStatus canonicaliseOccurrenceStatus(String occurrenceStatus) {
        if (occurrenceStatus == null || occurrenceStatus.isEmpty()) {
            return null;
        }
        ParseResult result = this.occurrenceStatusParser.parse(occurrenceStatus);
        if (!result.isSuccessful()) {
            this.report(IssueType.VALIDATION, "taxonomy.load.occurrenceStatus.invalid", occurrenceStatus, "", new String[0]);
            return null;
        }
        return (OccurrenceStatus)result.getPayload();
    }

    @Override
    public boolean isInformal(String name) {
        for (Pattern p : this.informalPatterns) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    protected String normalise(String name) {
        if (name == null) {
            return null;
        }
        CleanedScientificName cleaned = new CleanedScientificName(name);
        if ((name = cleaned.getBasic()).isEmpty()) {
            return null;
        }
        name = ESCAPES.matcher(name).replaceAll("$1");
        name = ESCAPE.matcher(name).replaceAll("");
        name = BRACKETED.matcher(name).replaceAll(" ");
        name = AUTHOR_AND.matcher(name).replaceAll(" & ");
        return (name = SPACES.matcher(name).replaceAll(" ")).isEmpty() ? null : name;
    }
}

