/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.util;

import au.org.ala.names.lucene.analyzer.LowerCaseKeywordAnalyzer;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameIndexEditor
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(NameIndexEditor.class);
    private static final String TAXONOMY_INDEX = "cb";
    private static final String VERNACULAR_INDEX = "vernacular";
    private static final String IDENTIFIER_INDEX = "id";
    private static final String IRMNG_INDEX = "irmng";
    private File sourceDirectory;
    private File workDirectory;
    private IndexWriter taxonomy;
    private IndexWriter vernaculer;
    private IndexWriter identifier;
    private Analyzer analyzer;

    public NameIndexEditor(File sourceDirectory, File workDirectory) throws IOException {
        this.sourceDirectory = sourceDirectory;
        this.workDirectory = workDirectory;
        this.analyzer = LowerCaseKeywordAnalyzer.newInstance();
        this.taxonomy = this.copyIndex(this.sourceDirectory, this.workDirectory, TAXONOMY_INDEX);
        this.vernaculer = this.copyIndex(this.sourceDirectory, this.workDirectory, VERNACULAR_INDEX);
        this.identifier = this.copyIndex(this.sourceDirectory, this.workDirectory, IDENTIFIER_INDEX);
    }

    public void makeEdits(File edits, boolean tabs) throws IOException, CsvValidationException {
        String[] row;
        CSVParser parser = new CSVParserBuilder().withSeparator(tabs ? (char)'\t' : ',').build();
        CSVReader reader = new CSVReaderBuilder((Reader)new FileReader(edits)).withCSVParser((ICSVParser)parser).build();
        while ((row = reader.readNext()) != null) {
            if (row[0].startsWith("#")) continue;
            String lsid = row[0];
            String action = row[1];
            if (action.equals("delete")) {
                this.deleteTaxon(lsid);
                continue;
            }
            throw new IllegalArgumentException("Unknown operation " + action);
        }
        reader.close();
    }

    protected void deleteTaxon(String lsid) throws IOException {
        logger.info("Deleting " + lsid);
        Term term = new Term("lsid", lsid);
        this.taxonomy.deleteDocuments(new Term[]{term});
        this.vernaculer.deleteDocuments(new Term[]{term});
        this.identifier.deleteDocuments(new Term[]{term});
    }

    protected IndexWriter copyIndex(File source, File dest, String index) throws IOException {
        FSDirectory d = FSDirectory.open((Path)new File(dest, index).toPath());
        IndexWriterConfig conf = new IndexWriterConfig(this.analyzer);
        conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        logger.info("Creating destination " + index + " directory  at " + d);
        IndexWriter writer = new IndexWriter((Directory)d, conf);
        FSDirectory s = FSDirectory.open((Path)new File(source, index).toPath());
        logger.info("Adding source " + index + " directory  from " + s);
        writer.addIndexes(new Directory[]{s});
        return writer;
    }

    protected void copyAndCloseIndex(File source, File dest, String index) throws IOException {
        IndexWriter writer = this.copyIndex(source, dest, index);
        writer.commit();
        writer.close();
    }

    protected void copySupportFiles(File source, File dest) throws IOException {
        List<String> names = Arrays.asList("metadata.json", "idmap.txt");
        for (String name : names) {
            File from = new File(source, name);
            File to = new File(dest, name);
            FileUtils.copyFile((File)from, (File)to, (boolean)false);
        }
    }

    @Override
    public void close() throws Exception {
        this.taxonomy.commit();
        this.taxonomy.close();
        this.report(this.workDirectory, TAXONOMY_INDEX);
        this.vernaculer.commit();
        this.vernaculer.close();
        this.report(this.workDirectory, VERNACULAR_INDEX);
        this.identifier.close();
        this.identifier.close();
        this.report(this.workDirectory, IDENTIFIER_INDEX);
    }

    public void create(File output) throws IOException {
        this.copyAndCloseIndex(this.workDirectory, output, TAXONOMY_INDEX);
        this.report(output, TAXONOMY_INDEX);
        this.copyAndCloseIndex(this.workDirectory, output, VERNACULAR_INDEX);
        this.report(output, VERNACULAR_INDEX);
        this.copyAndCloseIndex(this.workDirectory, output, IDENTIFIER_INDEX);
        this.report(output, IDENTIFIER_INDEX);
        this.copyAndCloseIndex(this.sourceDirectory, output, IRMNG_INDEX);
        this.copySupportFiles(this.sourceDirectory, output);
    }

    public void report(File dir, String index) throws IOException {
        FSDirectory d = FSDirectory.open((Path)new File(dir, index).toPath());
        DirectoryReader reader = DirectoryReader.open((Directory)d);
        logger.info("Status of " + d);
        logger.info("  Documents " + reader.numDocs());
        logger.info("  Has deletions " + reader.hasDeletions());
        logger.info("  Deleted documents " + reader.numDeletedDocs());
        reader.close();
    }

    public static void main(String[] args) {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.withDescription((String)"Be verbose when logging");
        Option v = OptionBuilder.create((char)'v');
        OptionBuilder.withLongOpt((String)"tabs");
        OptionBuilder.withDescription((String)"Use tab-separated, rather than comma separated values");
        Option t = OptionBuilder.create((char)'t');
        options.addOption(v);
        options.addOption(t);
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.getArgs().length < 2) {
                throw new IllegalArgumentException("usage: [-v] [-t] source dest edits ...");
            }
            boolean tabs = cmd.hasOption('t');
            boolean verbose = cmd.hasOption('v');
            File source = new File(cmd.getArgs()[0]);
            if (!source.exists() || !source.isDirectory()) {
                throw new IllegalArgumentException("Expecting directory for index, got  " + source);
            }
            File output = new File(cmd.getArgs()[1]);
            if (!output.exists()) {
                logger.info("Creating " + output);
                output.mkdirs();
            } else {
                if (!output.isDirectory()) {
                    throw new IllegalArgumentException("Expecting directory for output, got  " + output);
                }
                logger.info("Clearing " + output);
                FileUtils.cleanDirectory((File)output);
            }
            File work = File.createTempFile("nameindex", ".work", new File("/data/tmp"));
            work.delete();
            work.mkdirs();
            NameIndexEditor editor = new NameIndexEditor(source, work);
            for (int i = 2; i < cmd.getArgs().length; ++i) {
                editor.makeEdits(new File(cmd.getArgs()[i]), tabs);
            }
            editor.close();
            editor.create(output);
        }
        catch (ParseException ex) {
            System.err.println("Unable to parse command line: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

