/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BoostAttribute;
import org.apache.lucene.search.MaxNonCompetitiveBoostAttribute;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.LevenshteinAutomata;

public final class FuzzyTermsEnum
extends BaseTermsEnum {
    private TermsEnum actualEnum;
    private final BoostAttribute boostAtt;
    private final MaxNonCompetitiveBoostAttribute maxBoostAtt;
    private final LevenshteinAutomataAttribute dfaAtt;
    private float bottom;
    private BytesRef bottomTerm;
    private final CompiledAutomaton[] automata;
    private BytesRef queuedBottom;
    final int termLength;
    private int maxEdits;
    final Terms terms;
    final Term term;
    final int[] termText;
    final int realPrefixLength;
    final boolean transpositions;

    public FuzzyTermsEnum(Terms terms, AttributeSource atts, Term term, int maxEdits, int prefixLength, boolean transpositions) throws IOException {
        if (maxEdits < 0 || maxEdits > 2) {
            throw new IllegalArgumentException("max edits must be 0..2, inclusive; got: " + maxEdits);
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength cannot be less than 0");
        }
        this.maxEdits = maxEdits;
        this.terms = terms;
        this.term = term;
        this.termText = FuzzyTermsEnum.stringToUTF32(term.text());
        this.termLength = this.termText.length;
        this.dfaAtt = atts.addAttribute(LevenshteinAutomataAttribute.class);
        this.maxBoostAtt = atts.addAttribute(MaxNonCompetitiveBoostAttribute.class);
        this.boostAtt = this.attributes().addAttribute(BoostAttribute.class);
        this.realPrefixLength = prefixLength > this.termLength ? this.termLength : prefixLength;
        this.transpositions = transpositions;
        CompiledAutomaton[] prevAutomata = this.dfaAtt.automata();
        if (prevAutomata == null) {
            prevAutomata = new CompiledAutomaton[maxEdits + 1];
            Automaton[] automata = FuzzyTermsEnum.buildAutomata(this.termText, prefixLength, transpositions, maxEdits);
            for (int i = 0; i <= maxEdits; ++i) {
                prevAutomata[i] = new CompiledAutomaton(automata[i], true, false);
            }
            this.dfaAtt.setAutomata(prevAutomata);
        }
        this.automata = prevAutomata;
        this.bottom = this.maxBoostAtt.getMaxNonCompetitiveBoost();
        this.bottomTerm = this.maxBoostAtt.getCompetitiveTerm();
        this.bottomChanged(null);
    }

    public static Automaton buildAutomaton(String text, int prefixLength, boolean transpositions, int maxEdits) {
        int[] termText = FuzzyTermsEnum.stringToUTF32(text);
        Automaton[] automata = FuzzyTermsEnum.buildAutomata(termText, prefixLength, transpositions, maxEdits);
        return automata[automata.length - 1];
    }

    private static int[] stringToUTF32(String text) {
        int cp;
        int[] termText = new int[text.codePointCount(0, text.length())];
        int j = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(cp)) {
            termText[j++] = cp = text.codePointAt(i);
        }
        return termText;
    }

    private static Automaton[] buildAutomata(int[] termText, int prefixLength, boolean transpositions, int maxEdits) {
        if (maxEdits < 0 || maxEdits > 2) {
            throw new IllegalArgumentException("max edits must be 0..2, inclusive; got: " + maxEdits);
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength cannot be less than 0");
        }
        Automaton[] automata = new Automaton[maxEdits + 1];
        int termLength = termText.length;
        prefixLength = Math.min(prefixLength, termLength);
        String suffix = UnicodeUtil.newString(termText, prefixLength, termText.length - prefixLength);
        LevenshteinAutomata builder = new LevenshteinAutomata(suffix, transpositions);
        String prefix = UnicodeUtil.newString(termText, 0, prefixLength);
        for (int i = 0; i <= maxEdits; ++i) {
            automata[i] = builder.toAutomaton(i, prefix);
        }
        return automata;
    }

    private TermsEnum getAutomatonEnum(int editDistance, BytesRef lastTerm) throws IOException {
        assert (editDistance < this.automata.length);
        CompiledAutomaton compiled = this.automata[editDistance];
        BytesRef initialSeekTerm = lastTerm == null ? null : compiled.floor(lastTerm, new BytesRefBuilder());
        return this.terms.intersect(compiled, initialSeekTerm);
    }

    private void bottomChanged(BytesRef lastTerm) throws IOException {
        float maxBoost;
        boolean termAfter;
        int oldMaxEdits = this.maxEdits;
        boolean bl = termAfter = this.bottomTerm == null || lastTerm != null && lastTerm.compareTo(this.bottomTerm) >= 0;
        while (this.maxEdits > 0 && !(this.bottom < (maxBoost = 1.0f - (float)this.maxEdits / (float)this.termLength)) && (this.bottom != maxBoost || termAfter)) {
            --this.maxEdits;
        }
        if (oldMaxEdits != this.maxEdits || lastTerm == null) {
            this.actualEnum = this.getAutomatonEnum(this.maxEdits, lastTerm);
        }
    }

    @Override
    public BytesRef next() throws IOException {
        int ed;
        BytesRef term;
        if (this.queuedBottom != null) {
            this.bottomChanged(this.queuedBottom);
            this.queuedBottom = null;
        }
        if ((term = this.actualEnum.next()) == null) {
            return null;
        }
        for (ed = this.maxEdits; ed > 0 && this.matches(term, ed - 1); --ed) {
        }
        if (ed == 0) {
            this.boostAtt.setBoost(1.0f);
        } else {
            int codePointCount = UnicodeUtil.codePointCount(term);
            int minTermLength = Math.min(codePointCount, this.termLength);
            float similarity = 1.0f - (float)ed / (float)minTermLength;
            this.boostAtt.setBoost(similarity);
        }
        float bottom = this.maxBoostAtt.getMaxNonCompetitiveBoost();
        BytesRef bottomTerm = this.maxBoostAtt.getCompetitiveTerm();
        if (term != null && (bottom != this.bottom || bottomTerm != this.bottomTerm)) {
            this.bottom = bottom;
            this.bottomTerm = bottomTerm;
            this.queuedBottom = BytesRef.deepCopyOf(term);
        }
        return term;
    }

    private boolean matches(BytesRef termIn, int k) {
        return k == 0 ? termIn.equals(this.term.bytes()) : this.automata[k].runAutomaton.run(termIn.bytes, termIn.offset, termIn.length);
    }

    @Override
    public int docFreq() throws IOException {
        return this.actualEnum.docFreq();
    }

    @Override
    public long totalTermFreq() throws IOException {
        return this.actualEnum.totalTermFreq();
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        return this.actualEnum.postings(reuse, flags);
    }

    @Override
    public ImpactsEnum impacts(int flags) throws IOException {
        return this.actualEnum.impacts(flags);
    }

    @Override
    public void seekExact(BytesRef term, TermState state) throws IOException {
        this.actualEnum.seekExact(term, state);
    }

    @Override
    public TermState termState() throws IOException {
        return this.actualEnum.termState();
    }

    @Override
    public long ord() throws IOException {
        return this.actualEnum.ord();
    }

    @Override
    public boolean seekExact(BytesRef text) throws IOException {
        return this.actualEnum.seekExact(text);
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
        return this.actualEnum.seekCeil(text);
    }

    @Override
    public void seekExact(long ord) throws IOException {
        this.actualEnum.seekExact(ord);
    }

    @Override
    public BytesRef term() throws IOException {
        return this.actualEnum.term();
    }

    public static final class LevenshteinAutomataAttributeImpl
    extends AttributeImpl
    implements LevenshteinAutomataAttribute {
        private CompiledAutomaton[] automata;

        @Override
        public CompiledAutomaton[] automata() {
            return this.automata;
        }

        @Override
        public void setAutomata(CompiledAutomaton[] automata) {
            this.automata = automata;
        }

        @Override
        public void clear() {
            this.automata = null;
        }

        public int hashCode() {
            if (this.automata == null) {
                return 0;
            }
            return this.automata.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LevenshteinAutomataAttributeImpl)) {
                return false;
            }
            return Arrays.equals(this.automata, ((LevenshteinAutomataAttributeImpl)other).automata);
        }

        @Override
        public void copyTo(AttributeImpl _target) {
            LevenshteinAutomataAttribute target = (LevenshteinAutomataAttribute)((Object)_target);
            if (this.automata == null) {
                target.setAutomata(null);
            } else {
                target.setAutomata(this.automata);
            }
        }

        @Override
        public void reflectWith(AttributeReflector reflector) {
            reflector.reflect(LevenshteinAutomataAttribute.class, "automata", this.automata);
        }
    }

    public static interface LevenshteinAutomataAttribute
    extends Attribute {
        public CompiledAutomaton[] automata();

        public void setAutomata(CompiledAutomaton[] var1);
    }
}

