/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.commonui.util;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class WebUtils {
    protected static Logger logger = Logger.getLogger(WebUtils.class);

    public static String getHTMLPageAsXML(String url) throws Exception {
        WebClient webClient = new WebClient(BrowserVersion.FIREFOX_3);
        webClient.setJavaScriptEnabled(false);
        URL targetPageUrl = new URL(url);
        WebRequestSettings reqSettings = new WebRequestSettings(targetPageUrl);
        reqSettings.setCharset("UTF-8");
        HtmlPage currentPage = null;
        try {
            currentPage = (HtmlPage)webClient.getPage(reqSettings);
            webClient.closeAllWindows();
            currentPage.cleanUp();
            HtmlElement idMetaTagElement = currentPage.createElement("meta");
            idMetaTagElement.setAttribute("name", "ALA.Guid");
            idMetaTagElement.setAttribute("scheme", "URL");
            idMetaTagElement.setAttribute("contentMap", url);
            HtmlElement rootElement = currentPage.getDocumentElement();
            List headSection = rootElement.getByXPath("//html/head");
            HtmlHead currentHtmlHead = (HtmlHead)headSection.get(0);
            currentHtmlHead.appendChild((Node)idMetaTagElement);
            return currentPage.asXml();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static InputStream getUrlContent(String url) throws Exception {
        HttpClient httpClient = new HttpClient();
        GetMethod gm = new GetMethod(url);
        httpClient.executeMethod((HttpMethod)gm);
        return gm.getResponseBodyAsStream();
    }

    public static String getUrlContentAsString(String url) throws Exception {
        HttpClient httpClient = new HttpClient();
        GetMethod gm = new GetMethod(url);
        gm.setFollowRedirects(true);
        httpClient.executeMethod((HttpMethod)gm);
        String content = "[ERROR: external content request failed - see tomcat logs]";
        logger.debug((Object)("GET status code = " + gm.getStatusCode()));
        if (gm.getStatusCode() == 200) {
            content = gm.getResponseBodyAsString();
        }
        return content;
    }
}

