/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.commonui.headertails;

import au.org.ala.cas.util.AuthenticationCookieUtils;
import au.org.ala.commonui.headertails.GetWebContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HeaderAndTailUtil {
    protected static String bannerHtmlUrl = "http://www2.ala.org.au/commonui-bs2/banner.html";
    protected static String footerHtmlUrl = "http://www2.ala.org.au/commonui-bs2/footer.html";
    protected static String menuHtmlUrl = "http://www2.ala.org.au/commonui/menu.html";
    protected static String googleAnalyticsHtmlUrl = "http://www2.ala.org.au/commonui/analytics.html";
    protected PageContext pageContext;
    protected Boolean populateSearchBox = true;
    protected String returnUrlPath = "";
    protected String returnLogoutUrlPath = "";
    protected String logoutControllerUrlPath = "";
    protected Boolean loggedIn = false;
    protected static String headerFooterServerTag = "::headerFooterServer::";
    protected static String centralServerTag = "::centralServer::";
    protected static String casServerTag = "::casServerR::";
    protected static String loginLogoutListItemTag = "::loginLogoutListItem::";
    protected static String searchServerTag = "::searchServer::";
    protected static String searchPathTag = "::searchPath::";
    protected static String queryTag = "::query::";
    protected static String googleAnalyticsKeyTag = "::googleAnalyticsKey::";
    protected static String hideSearchFormTag = "id=\"header-search\"";
    protected static String googleAnalyticsKey = "UA-4355440-1";
    protected static String defaultHeaderFooterServer = "http://www2.ala.org.au/commonui-bs2";
    protected static String defaultCasServer = "https://auth.ala.org.au";
    protected static String defaultCentralServer = "http://www.ala.org.au";
    protected static String defaultSearchServer = "http://bie.ala.org.au";
    protected static String searchPath = "/search";
    protected static String defaultQuery = "Search the Atlas";
    protected static String hideSearchForm = "id=\"header-search\" style=\"display:none;\"";
    private static final Logger logger = Logger.getLogger(HeaderAndTailUtil.class);
    protected static Properties configProperties;

    public HeaderAndTailUtil(PageContext pageContext, String returnUrlPath, String returnLogoutUrlPath, String logoutControllerUrlPath, Boolean populateSearchBox) {
        this.pageContext = pageContext;
        this.returnUrlPath = returnUrlPath;
        this.returnLogoutUrlPath = returnLogoutUrlPath;
        this.logoutControllerUrlPath = logoutControllerUrlPath;
        this.populateSearchBox = populateSearchBox;
        this.readPropsFromContext();
    }

    public HeaderAndTailUtil(PageContext pageContext) {
        this.pageContext = pageContext;
        this.readPropsFromContext();
    }

    private String getPropertyValue(String property) {
        return configProperties.getProperty(property, this.pageContext.getServletContext().getInitParameter(property));
    }

    public void readPropsFromContext() {
        Principal principal;
        String headerFooterServer;
        String centralServer;
        String casServer;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String searchServer = this.getPropertyValue("searchServerName");
        if (StringUtils.isNotBlank((String)searchServer)) {
            defaultSearchServer = searchServer;
        }
        if (StringUtils.isNotBlank((String)(casServer = this.getPropertyValue("casServerName")))) {
            defaultCasServer = casServer;
        }
        if (StringUtils.isNotBlank((String)(centralServer = this.getPropertyValue("centralServer")))) {
            defaultCentralServer = centralServer;
        }
        if (StringUtils.isNotBlank((String)(headerFooterServer = this.getPropertyValue("headerFooterServer")))) {
            defaultHeaderFooterServer = headerFooterServer;
        }
        String query = request.getParameter("q");
        String queryAvoid = request.getParameter("xq");
        if (!this.populateSearchBox.booleanValue() || StringUtils.isNotBlank((String)queryAvoid) || StringUtils.isBlank((String)query)) {
            defaultQuery = "Search the Atlas";
        }
        if (StringUtils.isBlank((String)this.returnUrlPath)) {
            StringBuffer requestURL = request.getRequestURL();
            String queryString = request.getQueryString();
            if (queryString != null || "".equals(queryString)) {
                requestURL.append('?');
                requestURL.append(queryString.replaceAll("\\+", "%2B"));
            }
            this.returnUrlPath = requestURL.toString();
        }
        if (this.returnLogoutUrlPath == null || this.returnLogoutUrlPath.equals("")) {
            this.returnLogoutUrlPath = this.returnUrlPath;
        }
        this.loggedIn = (principal = request.getUserPrincipal()) != null ? Boolean.valueOf(true) : Boolean.valueOf(AuthenticationCookieUtils.isUserLoggedIn((HttpServletRequest)request));
    }

    public static String getHeader(boolean loggedIn, String returnUrlPath) throws Exception {
        String output = null;
        output = HeaderAndTailUtil.getHeader(loggedIn, defaultHeaderFooterServer, defaultCentralServer, defaultCasServer, defaultSearchServer, returnUrlPath, defaultQuery);
        return output;
    }

    public String getBanner() throws Exception {
        String context = "";
        if (StringUtils.isNotEmpty((String)this.logoutControllerUrlPath)) {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            context = request.getContextPath();
        }
        return HeaderAndTailUtil.getBanner(this.loggedIn, defaultHeaderFooterServer, defaultCentralServer, defaultCasServer, defaultSearchServer, this.returnUrlPath, this.returnLogoutUrlPath, context + this.logoutControllerUrlPath, defaultQuery, this.populateSearchBox);
    }

    public static String getHeader(boolean loggedIn, String headerFooterServer, String centralServer, String casServer, String searchServer, String returnUrlPath, String query) throws Exception {
        return HeaderAndTailUtil.getHeader(loggedIn, headerFooterServer, centralServer, casServer, searchServer, returnUrlPath, null, query);
    }

    public static String getHeader(boolean loggedIn, String headerFooterServer, String centralServer, String casServer, String searchServer, String returnUrlPath, String returnLogoutUrlPath, String query) throws Exception {
        String banner = HeaderAndTailUtil.getBanner(loggedIn, headerFooterServer, centralServer, casServer, searchServer, returnUrlPath, returnLogoutUrlPath, "", query, true);
        return banner;
    }

    public static String getBanner(boolean loggedIn, String headerFooterServer, String centralServer, String casServer, String searchServer, String returnUrlPath, String returnLogoutUrlPath, String logoutControllerUrlPath, String query, Boolean populateSearchBox) throws Exception {
        logger.debug((Object)("getBanner params: loggedIn=" + loggedIn + ", centralServer=" + centralServer + ", casServer=" + casServer + ", searchServer=" + searchServer + ", returnUrlPath=" + returnUrlPath + ", returnLogoutUrlPath=" + returnLogoutUrlPath + ", logoutControllerUrlPath=" + logoutControllerUrlPath + ", query=" + query + ", populateSearchBox" + populateSearchBox));
        if (StringUtils.isEmpty((String)returnLogoutUrlPath)) {
            returnLogoutUrlPath = returnUrlPath;
        }
        String loginLogoutListItem = loggedIn ? (StringUtils.isEmpty((String)logoutControllerUrlPath) ? "<a href='" + casServer + "/cas/logout?url=" + returnLogoutUrlPath + "'>Log out</a>" : "<a href='" + logoutControllerUrlPath + "?casUrl=" + casServer + "/cas/logout&appUrl=" + returnLogoutUrlPath + "'>Log out</a>") : "<a href='" + casServer + "/cas/login?service=" + returnUrlPath + "'>Log in</a>";
        String banner = GetWebContent.getInstance().getContent(bannerHtmlUrl);
        banner = banner.replaceAll(headerFooterServerTag, headerFooterServer);
        banner = banner.replaceAll(centralServerTag, centralServer);
        banner = banner.replaceAll(casServerTag, casServer);
        banner = banner.replaceAll(loginLogoutListItemTag, loginLogoutListItem);
        banner = banner.replaceAll(searchServerTag, searchServer);
        banner = banner.replaceAll(searchPathTag, searchPath);
        banner = banner.replaceAll(queryTag, query);
        if (!populateSearchBox.booleanValue()) {
            banner = banner.replaceAll(hideSearchFormTag, hideSearchForm);
        }
        return banner;
    }

    public String getMenu() throws Exception {
        return HeaderAndTailUtil.getMenu(defaultCentralServer);
    }

    public static String getMenu(String centralServer) throws Exception {
        String menu = GetWebContent.getInstance().getContent(menuHtmlUrl);
        menu = menu.replaceAll(centralServerTag, centralServer);
        return menu;
    }

    public String getFooterHtml() throws Exception {
        return HeaderAndTailUtil.getFooterHtml(defaultCentralServer, defaultHeaderFooterServer);
    }

    public String getFooterJs() throws Exception {
        return HeaderAndTailUtil.getFooterJs(defaultCentralServer);
    }

    public static String getFooterHtml(String centralServer, String headerFooterServer) throws Exception {
        String output = GetWebContent.getInstance().getContent(footerHtmlUrl);
        output = output.replaceAll(centralServerTag, centralServer);
        output = output.replaceAll(headerFooterServerTag, headerFooterServer);
        return output;
    }

    public static String getFooterJs(String centralServer) throws Exception {
        String analytics = GetWebContent.getInstance().getContent(googleAnalyticsHtmlUrl);
        analytics = analytics.replaceAll(googleAnalyticsKeyTag, googleAnalyticsKey);
        return analytics;
    }

    public static String getFooter(String centralServer, String headerFooterServer) throws Exception {
        return HeaderAndTailUtil.getFooterHtml(centralServer, headerFooterServer) + HeaderAndTailUtil.getFooterJs(centralServer);
    }

    static {
        Properties prop = new Properties();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("headerTails.properties");
        try {
            prop.load(in);
            if (prop.getProperty("include.bannerUrl") != null) {
                bannerHtmlUrl = prop.getProperty("include.bannerUrl");
            }
            if (prop.getProperty("include.footerUrl") != null) {
                footerHtmlUrl = prop.getProperty("include.footerUrl");
            }
            in.close();
        }
        catch (Exception e) {
            logger.debug((Object)("Error loading properties file: " + e), (Throwable)e);
        }
        try {
            InitialContext ctx = new InitialContext();
            String filename = (String)ctx.lookup("java:comp/env/configPropFile");
            configProperties = new Properties();
            configProperties.load(new FileInputStream(new File(filename)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configProperties == null) {
            configProperties = prop;
        }
        logger.info((Object)("The configProperties " + configProperties));
    }
}

