/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.commonui.headertails;

import au.org.ala.commonui.util.WebUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GetWebContent {
    protected static Logger logger = Logger.getLogger(GetWebContent.class);
    protected Map<String, String> contentMap = new HashMap<String, String>();
    protected Map<String, Long> lastChecked = new HashMap<String, Long>();
    protected Long cacheTimeoutInMilliseconds = 1800000L;

    private GetWebContent() {
        if (InnerLoader.INSTANCE != null) {
            throw new IllegalStateException("Already instantiated");
        }
    }

    private Boolean isCacheCurrent(String url) {
        Boolean isCurrent = false;
        Long now = System.currentTimeMillis();
        if (this.lastChecked.containsKey(url) && now - this.lastChecked.get(url) < this.cacheTimeoutInMilliseconds) {
            isCurrent = true;
        }
        logger.debug((Object)("isCacheCurrent = " + isCurrent + " - cache key is " + this.lastChecked.containsKey(url)));
        return isCurrent;
    }

    protected String getContent(String url) throws Exception {
        if (url == null) {
            return null;
        }
        String content = this.contentMap.get(url);
        if (StringUtils.isBlank((String)content) || !this.isCacheCurrent(url).booleanValue()) {
            logger.debug((Object)("Updating cache for " + url + " at: " + System.currentTimeMillis()));
            content = WebUtils.getUrlContentAsString(url);
            if (content == null) {
                content = "[ERROR: Menu content not found]";
            }
            this.contentMap.put(url, content);
            this.lastChecked.put(url, System.currentTimeMillis());
        }
        return content;
    }

    public static GetWebContent getInstance() {
        return InnerLoader.INSTANCE;
    }

    private static class InnerLoader {
        private static final GetWebContent INSTANCE = new GetWebContent();

        private InnerLoader() {
        }
    }
}

