/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.vocab;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.util.Stemmer$;
import au.org.ala.biocache.vocab.DwC$;
import au.org.ala.biocache.vocab.Term;
import au.org.ala.biocache.vocab.Vocab;
import au.org.ala.biocache.vocab.Vocab$;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Source;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.NonLocalReturnControl;

public abstract class Vocab$class {
    public static List getStringList(Vocab $this) {
        return JavaConversions$.MODULE$.seqAsJavaList((Seq)((TraversableOnce)$this.all().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Term t) {
                return t.canonical();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static Function1 memoizeFnc(Vocab $this, Function1 f) {
        Map cache = Map$.MODULE$.empty();
        return new Serializable($this, cache, f){
            public static final long serialVersionUID = 0L;
            public final Map cache$1;
            public final Function1 f$1;

            public final V apply(K k) {
                return (V)this.cache$1.getOrElse(k, (Function0)new Serializable(this, k){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Vocab$.anonfun.memoizeFnc.1 $outer;
                    private final Object k$1;

                    public final V apply() {
                        this.$outer.cache$1.update(this.k$1, this.$outer.f$1.apply(this.k$1));
                        return (V)this.$outer.cache$1.apply(this.k$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.k$1 = k$1;
                    }
                });
            }
            {
                this.cache$1 = cache$1;
                this.f$1 = f$1;
            }
        };
    }

    public static Option matchTerm(Vocab $this, String string2Match) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            None$ none$;
            Object object = new Object();
            try {
                if (string2Match != null) {
                    String stringToUse = string2Match.replaceAll($this.regexNorm(), "").toLowerCase();
                    String stemmed = Stemmer$.MODULE$.stem(stringToUse);
                    $this.all().foreach((Function1)new Serializable($this, stringToUse, stemmed, object){
                        public static final long serialVersionUID = 0L;
                        private final String stringToUse$1;
                        private final String stemmed$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(Term term) {
                            if (term.canonical().equalsIgnoreCase(this.stringToUse$1)) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)term));
                            }
                            if (Predef$.MODULE$.refArrayOps((Object[])term.variants()).contains((Object)this.stringToUse$1) || Predef$.MODULE$.refArrayOps((Object[])term.variants()).contains((Object)this.stemmed$1)) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)term));
                            }
                        }
                        {
                            this.stringToUse$1 = stringToUse$1;
                            this.stemmed$1 = stemmed$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                }
                none$ = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                none$ = (Option)nonLocalReturnControl2.value();
            }
            return none$;
        }
        throw nonLocalReturnControl2;
    }

    public static Option matchRegex(Vocab $this, String string2Match) {
        if (string2Match == null) {
            return None$.MODULE$;
        }
        return $this.all().find((Function1)new Serializable($this, string2Match){
            public static final long serialVersionUID = 0L;
            private final String string2Match$1;

            public final boolean apply(Term term) {
                return Pattern.compile(term.variants()[0], 2).asPredicate().test(this.string2Match$1);
            }
            {
                this.string2Match$1 = string2Match$1;
            }
        });
    }

    public static Option matchRegexCached(Vocab $this, String string2Match) {
        return (Option)$this.memoizeFnc(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Vocab $outer;

            public final Option<Term> apply(String string2Match) {
                return this.$outer.matchRegex(string2Match);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).apply((Object)string2Match);
    }

    public static Seq retrieveCanonicals(Vocab $this, Seq terms) {
        return (Seq)terms.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String ch) {
                Option<Term> option;
                block4: {
                    String string;
                    block3: {
                        block2: {
                            option = DwC$.MODULE$.matchTerm(ch);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Term term = (Term)some.x();
                            string = term.canonical();
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Term> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        string = ch;
                    }
                    return string;
                }
                throw new MatchError(option);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq retrieveCanonicalsOrNothing(Vocab $this, Seq terms) {
        return (Seq)terms.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String ch) {
                Option<Term> option;
                block4: {
                    String string;
                    block3: {
                        block2: {
                            option = DwC$.MODULE$.matchTerm(ch);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Term term = (Term)some.x();
                            string = term.canonical();
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Term> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        string = "";
                    }
                    return string;
                }
                throw new MatchError(option);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static IndexedSeq loadVocabFromVerticalFile(Vocab $this, String filePath) {
        scala.collection.immutable.Map map = ((TraversableOnce)Vocab$class.getSource($this, filePath).getLines().toList().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Vocab $outer;

            public final Tuple2<String, String> apply(String row) {
                String[] values = row.split("\t");
                String variant = ((String)Predef$.MODULE$.refArrayOps((Object[])values).head()).replaceAll(this.$outer.regexNorm(), "").toLowerCase();
                String canonical = (String)Predef$.MODULE$.refArrayOps((Object[])values).last();
                return new Tuple2((Object)variant, (Object)canonical);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        scala.collection.immutable.Map grouped = map.groupBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String v;
                    String string = v = (String)tuple2._2();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        });
        return ((TraversableOnce)grouped.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Term apply(Tuple2<String, scala.collection.immutable.Map<String, String>> x0$2) {
                Tuple2<String, scala.collection.immutable.Map<String, String>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String canonical = (String)tuple2._1();
                    scala.collection.immutable.Map valueMap = (scala.collection.immutable.Map)tuple2._2();
                    Iterable variants = valueMap.keys();
                    Term term = new Term(canonical, (String[])variants.toArray(ClassTag$.MODULE$.apply(String.class)));
                    return term;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toIndexedSeq();
    }

    public static IndexedSeq loadVocabFromFile(Vocab $this, String filePath) {
        return ((TraversableOnce)Vocab$class.getSource($this, filePath).getLines().toList().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Vocab $outer;

            public final Term apply(String row) {
                String[] values = row.split("\t");
                String[] variants = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])values).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Vocab$.anonfun.loadVocabFromFile.1 $outer;

                    public final String apply(String x) {
                        return x.replaceAll(this.$outer.au$org$ala$biocache$vocab$Vocab$$anonfun$$$outer().regexNorm(), "").toLowerCase();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x) {
                        String string = x;
                        String string2 = "";
                        return string != null ? !string.equals(string2) : string2 != null;
                    }
                });
                return new Term((String)Predef$.MODULE$.refArrayOps((Object[])values).head(), variants);
            }

            public /* synthetic */ Vocab au$org$ala$biocache$vocab$Vocab$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).toIndexedSeq();
    }

    public static IndexedSeq loadRegexFromFile(Vocab $this, String filePath) {
        return ((TraversableOnce)Vocab$class.getSource($this, filePath).getLines().toList().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Term apply(String row) {
                String[] values = row.split("\t");
                return new Term((String)Predef$.MODULE$.refArrayOps((Object[])values).head(), (String[])Predef$.MODULE$.refArrayOps((Object[])values).tail());
            }
        }, List$.MODULE$.canBuildFrom())).toIndexedSeq();
    }

    private static Source getSource(Vocab $this, String filePath) {
        BufferedSource bufferedSource;
        File overrideFile = new File(new StringBuilder().append((Object)Config$.MODULE$.vocabDirectory()).append((Object)filePath).toString());
        if (overrideFile.exists()) {
            $this.logger().info(new StringBuilder().append((Object)"Reading vocab file: ").append((Object)overrideFile.getAbsolutePath()).toString());
            bufferedSource = Source$.MODULE$.fromFile(overrideFile, "utf-8");
        } else {
            $this.logger().info(new StringBuilder().append((Object)"Reading internal vocab file: ").append((Object)filePath).toString());
            bufferedSource = Source$.MODULE$.fromURL($this.getClass().getResource(filePath), "utf-8");
        }
        return bufferedSource;
    }

    public static Set retrieveAll(Vocab $this) {
        Method[] methods = $this.getClass().getMethods();
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])methods).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Method method) {
                Class<?> clazz = method.getReturnType();
                Class<Term> clazz2 = Term.class;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Vocab $outer;

            public final Term apply(Method method) {
                return (Term)method.invoke((Object)this.$outer, new Object[0]);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Term.class)))).toSet();
    }

    public static void $init$(Vocab $this) {
        $this.au$org$ala$biocache$vocab$Vocab$_setter_$logger_$eq(LoggerFactory.getLogger((String)"Vocab"));
        $this.au$org$ala$biocache$vocab$Vocab$_setter_$regexNorm_$eq("[^a-zA-Z0-9]+");
    }
}

