/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.load.Loader;
import au.org.ala.biocache.parser.DateParser$;
import au.org.ala.biocache.util.OptionParser;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class Loader$
implements Tool {
    public static final Loader$ MODULE$;
    private final Logger logger;

    static {
        new Loader$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public String cmd() {
        return "load";
    }

    @Override
    public String desc() {
        return "Load a data resource";
    }

    @Override
    public void main(String[] args) {
        ObjectRef dataResourceUid = new ObjectRef((Object)"");
        BooleanRef forceLoad = new BooleanRef(false);
        BooleanRef testLoad = new BooleanRef(false);
        BooleanRef loadAll = new BooleanRef(false);
        BooleanRef removeNullFields = new BooleanRef(false);
        BooleanRef loadMissingOnly = new BooleanRef(false);
        ObjectRef lastUpdated = new ObjectRef((Object)None$.MODULE$);
        ObjectRef localFilePath = new ObjectRef((Object)None$.MODULE$);
        BooleanRef logRowKeys = new BooleanRef(true);
        boolean testFile = false;
        BooleanRef bypassConnParamLookup = new BooleanRef(false);
        IntRef loadingThreads = new IntRef(1);
        OptionParser parser = new OptionParser(dataResourceUid, forceLoad, testLoad, loadAll, removeNullFields, loadMissingOnly, lastUpdated, localFilePath, bypassConnParamLookup, loadingThreads){
            {
                this.arg("data-resource-uid", "The data resource to load. Supports a comma separated list. Specify 'all' to load all", (Function1<String, BoxedUnit>)new Serializable(this, dataResourceUid$1, loadAll$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dataResourceUid$1;
                    private final BooleanRef loadAll$1;

                    public final void apply(String v) {
                        String string = v;
                        String string2 = "all";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            this.loadAll$1.elem = true;
                        } else {
                            this.dataResourceUid$1.elem = v;
                        }
                    }
                    {
                        this.dataResourceUid$1 = dataResourceUid$1;
                        this.loadAll$1 = loadAll$1;
                    }
                });
                this.opt("fl", "force-load", "Force the (re)load of media", (Function0<BoxedUnit>)new Serializable(this, forceLoad$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef forceLoad$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.forceLoad$1.elem = true;
                    }
                    {
                        this.forceLoad$1 = forceLoad$1;
                    }
                });
                this.opt("tl", "test-load", "Test the (re)load of media", (Function0<BoxedUnit>)new Serializable(this, testLoad$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef testLoad$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.testLoad$1.elem = true;
                    }
                    {
                        this.testLoad$1 = testLoad$1;
                    }
                });
                this.opt("rnf", "remove-null-fields", "Remove the null/Empty fields currently exist in the atlas", (Function0<BoxedUnit>)new Serializable(this, removeNullFields$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef removeNullFields$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.removeNullFields$1.elem = true;
                    }
                    {
                        this.removeNullFields$1 = removeNullFields$1;
                    }
                });
                this.opt("lu", "lastUpdated", "(FlickerLoader only) A limit to load last updated in yyyy-MM-dd format", (Function1<String, BoxedUnit>)new Serializable(this, lastUpdated$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef lastUpdated$1;

                    public final void apply(String v) {
                        this.lastUpdated$1.elem = DateParser$.MODULE$.parseStringToDate(v);
                    }
                    {
                        this.lastUpdated$1 = lastUpdated$1;
                    }
                });
                this.opt("l", "local", "(DwCALoader only) skip the download and use local file", (Function1<String, BoxedUnit>)new Serializable(this, localFilePath$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef localFilePath$1;

                    public final void apply(String v) {
                        this.localFilePath$1.elem = new Some((Object)v);
                    }
                    {
                        this.localFilePath$1 = localFilePath$1;
                    }
                });
                this.booleanOpt("b", "bypassConnParamLookup", "(DwCALoader only) bypass connection parameter lookup in the registry (collectory)", (Function1<Object, BoxedUnit>)new Serializable(this, bypassConnParamLookup$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef bypassConnParamLookup$1;

                    public final void apply(boolean v) {
                        this.bypassConnParamLookup$1.elem = v;
                    }
                    {
                        this.bypassConnParamLookup$1 = bypassConnParamLookup$1;
                    }
                });
                this.opt("lmo", "load-missing-only", "Load missing records only", (Function0<BoxedUnit>)new Serializable(this, loadMissingOnly$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef loadMissingOnly$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.loadMissingOnly$1.elem = true;
                    }
                    {
                        this.loadMissingOnly$1 = loadMissingOnly$1;
                    }
                });
                this.intOpt("t", "number-of-threads", new StringBuilder().append((Object)"Number of loading threads to use. Default is ").append((Object)BoxesRunTime.boxToInteger((int)loadingThreads$1.elem)).append((Object)". DWCA Loading only").toString(), (Function1<Object, BoxedUnit>)new Serializable(this, loadingThreads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef loadingThreads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.loadingThreads$1.elem = v;
                    }
                    {
                        this.loadingThreads$1 = loadingThreads$1;
                    }
                });
            }
        };
        Config$.MODULE$.indexDAO().init();
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            if (loadAll.elem) {
                Loader l = new Loader();
                l.resourceList().foreach((Function1)new Serializable(forceLoad, testLoad, removeNullFields, loadMissingOnly, localFilePath, logRowKeys, bypassConnParamLookup, loadingThreads, l){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef forceLoad$1;
                    private final BooleanRef testLoad$1;
                    private final BooleanRef removeNullFields$1;
                    private final BooleanRef loadMissingOnly$1;
                    private final ObjectRef localFilePath$1;
                    private final BooleanRef logRowKeys$1;
                    private final BooleanRef bypassConnParamLookup$1;
                    private final IntRef loadingThreads$1;
                    private final Loader l$1;

                    public final void apply(Map<String, String> resource) {
                        String uid = (String)resource.getOrElse((Object)"uid", (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        });
                        String name = (String)resource.getOrElse((Object)"name", (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        });
                        Loader$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading resource ", ", uid: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, uid})));
                        String string = uid;
                        String string2 = "";
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            try {
                                this.l$1.load(uid, this.testLoad$1.elem, this.forceLoad$1.elem, this.removeNullFields$1.elem, (Option<Date>)None$.MODULE$, (Option<String>)((Option)this.localFilePath$1.elem), this.bypassConnParamLookup$1.elem, this.logRowKeys$1.elem, this.loadMissingOnly$1.elem, this.loadingThreads$1.elem);
                            }
                            catch (Exception exception) {
                                Loader$.MODULE$.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load data resource with ", ". Exception message: ", ".getMessage"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uid, exception})), (Throwable)exception);
                            }
                        }
                    }
                    {
                        this.forceLoad$1 = forceLoad$1;
                        this.testLoad$1 = testLoad$1;
                        this.removeNullFields$1 = removeNullFields$1;
                        this.loadMissingOnly$1 = loadMissingOnly$1;
                        this.localFilePath$1 = localFilePath$1;
                        this.logRowKeys$1 = logRowKeys$1;
                        this.bypassConnParamLookup$1 = bypassConnParamLookup$1;
                        this.loadingThreads$1 = loadingThreads$1;
                        this.l$1 = l$1;
                    }
                });
            } else {
                long start = System.currentTimeMillis();
                this.logger().info(new StringBuilder().append((Object)"Starting to load resource: ").append((Object)((String)dataResourceUid.elem)).toString());
                String[] listOfResources = (String[])Predef$.MODULE$.refArrayOps((Object[])((String)dataResourceUid.elem).split(",")).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String uid) {
                        return uid.trim();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                Loader l = new Loader();
                Predef$.MODULE$.refArrayOps((Object[])listOfResources).foreach((Function1)new Serializable(forceLoad, testLoad, removeNullFields, loadMissingOnly, localFilePath, logRowKeys, bypassConnParamLookup, loadingThreads, l){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef forceLoad$1;
                    private final BooleanRef testLoad$1;
                    private final BooleanRef removeNullFields$1;
                    private final BooleanRef loadMissingOnly$1;
                    private final ObjectRef localFilePath$1;
                    private final BooleanRef logRowKeys$1;
                    private final BooleanRef bypassConnParamLookup$1;
                    private final IntRef loadingThreads$1;
                    private final Loader l$2;

                    public final void apply(String x$1) {
                        this.l$2.load(x$1, this.testLoad$1.elem, this.forceLoad$1.elem, this.removeNullFields$1.elem, (Option<Date>)None$.MODULE$, (Option<String>)((Option)this.localFilePath$1.elem), this.bypassConnParamLookup$1.elem, this.logRowKeys$1.elem, this.loadMissingOnly$1.elem, this.loadingThreads$1.elem);
                    }
                    {
                        this.forceLoad$1 = forceLoad$1;
                        this.testLoad$1 = testLoad$1;
                        this.removeNullFields$1 = removeNullFields$1;
                        this.loadMissingOnly$1 = loadMissingOnly$1;
                        this.localFilePath$1 = localFilePath$1;
                        this.logRowKeys$1 = logRowKeys$1;
                        this.bypassConnParamLookup$1 = bypassConnParamLookup$1;
                        this.loadingThreads$1 = loadingThreads$1;
                        this.l$2 = l$2;
                    }
                });
                long finish = System.currentTimeMillis();
                this.logger().info(new StringBuilder().append((Object)"Completed loading resource: ").append((Object)((String)dataResourceUid.elem)).append((Object)". Completed in ").append((Object)BoxesRunTime.boxToFloat((float)((float)((double)(finish - start) / 1000.0)))).append((Object)"seconds (").append((Object)BoxesRunTime.boxToFloat((float)((float)((double)(finish - start) / 60000.0)))).append((Object)" minutes)").toString());
            }
        }
    }

    private Loader$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"Loader");
    }
}

