/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.util.FileHelper$;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.security.MessageDigest;
import java.util.zip.GZIPInputStream;
import net.lingala.zip4j.core.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u00015\u0011!BR5mK\"+G\u000e]3s\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003!\u0011\u0017n\\2bG\",'BA\u0004\t\u0003\r\tG.\u0019\u0006\u0003\u0013)\t1a\u001c:h\u0015\u0005Y\u0011AA1v\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012\u0001\u00024jY\u0016\u0004\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\u0005%|'\"A\u000e\u0002\t)\fg/Y\u0005\u0003;a\u0011AAR5mK\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\"!I\u0012\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000bUq\u0002\u0019\u0001\f\t\u000f\u0015\u0002!\u0019!C\u0001M\u00051An\\4hKJ,\u0012a\n\t\u0003Q1j\u0011!\u000b\u0006\u0003U-\nQa\u001d7gi)T\u0011!C\u0005\u0003[%\u0012a\u0001T8hO\u0016\u0014\bBB\u0018\u0001A\u0003%q%A\u0004m_\u001e<WM\u001d\u0011\t\u000bE\u0002A\u0011\u0001\u001a\u0002\r\u0005\u0004\b/\u001a8e)\t\u0019d\u0007\u0005\u0002\u0010i%\u0011Q\u0007\u0005\u0002\u0005+:LG\u000fC\u00038a\u0001\u0007\u0011%A\u0003bM&dW\rC\u0003:\u0001\u0011\u0005!(A\u0003xe&$X\r\u0006\u00024w!)A\b\u000fa\u0001{\u0005!A/\u001a=u!\tq\u0014I\u0004\u0002\u0010\u007f%\u0011\u0001\tE\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002A!!)Q\t\u0001C\u0001\r\u0006Yam\u001c:fC\u000eDG*\u001b8f)\t\u0019t\tC\u0003I\t\u0002\u0007\u0011*\u0001\u0003qe>\u001c\u0007\u0003B\bK{MJ!a\u0013\t\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"B'\u0001\t\u0003q\u0015!\u00033fY\u0016$X-\u00117m+\u0005\u0019\u0004\"\u0002)\u0001\t\u0003\t\u0016aC3yiJ\f7\r^${SB,\u0012A\u0006\u0005\u0006'\u0002!\t!U\u0001\u000bKb$(/Y2u5&\u0004\b\"B+\u0001\t\u00031\u0016!\u0003:fC\u0012\f5oQ*W)\u0015\u0019t\u000b\u00180n\u0011\u0015AF\u000b1\u0001Z\u0003%\u0019X\r]1sCR|'\u000f\u0005\u0002\u00105&\u00111\f\u0005\u0002\u0005\u0007\"\f'\u000fC\u0003^)\u0002\u0007\u0011,A\u0005rk>$Xm\u00195be\")q\f\u0016a\u0001A\u00069\u0001O]8d\u0011\u0012\u0014\b\u0003B\bKC\u0006\u00042A\u00196>\u001d\t\u0019\u0007N\u0004\u0002eO6\tQM\u0003\u0002g\u0019\u00051AH]8pizJ\u0011!E\u0005\u0003SB\tq\u0001]1dW\u0006<W-\u0003\u0002lY\n\u00191+Z9\u000b\u0005%\u0004\u0002\"\u00028U\u0001\u0004y\u0017\u0001\u0002:fC\u0012\u0004Ra\u00049bCNJ!!\u001d\t\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\"B:\u0001\t\u0003!\u0018\u0001C:iCFB\u0015m\u001d5\u0015\u0003u:QA\u001e\u0002\t\u0002]\f!BR5mK\"+G\u000e]3s!\t\u0011\u0003PB\u0003\u0002\u0005!\u0005\u0011p\u0005\u0002y\u001d!)q\u0004\u001fC\u0001wR\tq\u000fC\u0003~q\u0012\ra0A\u0006gS2,'\u0007[3ma\u0016\u0014HCA\u0011\u0000\u0011\u0015)B\u00101\u0001\u0017\u0011\u001d\t\u0019\u0001\u001fC\u0001\u0003\u000b\tA!\\1j]R\u00191'a\u0002\t\u0011\u0005%\u0011\u0011\u0001a\u0001\u0003\u0017\tA!\u0019:hgB!q\"!\u0004>\u0013\r\ty\u0001\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f")
public class FileHelper {
    private final File file;
    private final Logger logger;

    public static void main(String[] stringArray) {
        FileHelper$.MODULE$.main(stringArray);
    }

    public static FileHelper file2helper(File file) {
        return FileHelper$.MODULE$.file2helper(file);
    }

    public Logger logger() {
        return this.logger;
    }

    public void append(FileHelper afile) {
        FileWriter writer = new FileWriter(this.file, true);
        afile.foreachLine((Function1<String, BoxedUnit>)new Serializable(this, writer){
            public static final long serialVersionUID = 0L;
            private final FileWriter writer$1;

            public final void apply(String line) {
                this.writer$1.write(new StringBuilder().append((Object)line).append((Object)"\n").toString());
            }
            {
                this.writer$1 = writer$1;
            }
        });
        writer.flush();
        writer.close();
    }

    public void write(String text) {
        FileWriter fw = new FileWriter(this.file);
        try {
            fw.write(text);
            return;
        }
        finally {
            fw.close();
        }
    }

    public void foreachLine(Function1<String, BoxedUnit> proc) {
        BufferedReader br = new BufferedReader(new FileReader(this.file));
        try {
            while (br.ready()) {
                proc.apply((Object)br.readLine());
            }
        }
        catch (Exception exception) {
            this.logger().error(exception.getMessage(), (Throwable)exception);
        }
        finally {
            br.close();
        }
    }

    public void deleteAll() {
        this.au$org$ala$biocache$util$FileHelper$$deleteFile$1(this.file);
    }

    /*
     * WARNING - void declaration
     */
    public File extractGzip() {
        void var3_3;
        int maxBuffer = 8000;
        String basename = this.file.getName().substring(0, this.file.getName().lastIndexOf("."));
        File todir = new File(this.file.getParentFile(), basename);
        GZIPInputStream in = new GZIPInputStream((InputStream)new FileInputStream(this.file), maxBuffer);
        FileOutputStream out = new FileOutputStream(todir);
        try {
            byte[] buffer = new byte[maxBuffer];
            this.read$1(in, out, buffer);
        }
        catch (Throwable throwable) {
            void var5_5;
            void var4_4;
            var4_4.close();
            var5_5.flush();
            var5_5.close();
            throw throwable;
        }
        in.close();
        out.flush();
        out.close();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public File extractZip() {
        void var2_2;
        String basename = this.file.getName().substring(0, this.file.getName().lastIndexOf("."));
        File todir = new File(this.file.getParentFile(), basename);
        ZipFile zipFile = new ZipFile(this.file);
        zipFile.extractAll(todir.getAbsolutePath());
        return var2_2;
    }

    public void readAsCSV(char separator, char quotechar, Function1<Seq<String>, Seq<String>> procHdr, Function2<Seq<String>, Seq<String>, BoxedUnit> read) {
        CSVReader reader = new CSVReader((Reader)new FileReader(this.file), separator, quotechar);
        String[] rawColumnHdrs = reader.readNext();
        Seq columnHdrs = (Seq)procHdr.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])rawColumnHdrs));
        String[] currentLine = reader.readNext();
        while (true) {
            if (currentLine == null) break;
            read.apply((Object)columnHdrs, (Object)Predef$.MODULE$.wrapRefArray((Object[])currentLine));
            currentLine = reader.readNext();
        }
    }

    public String sha1Hash() {
        String string;
        FileInputStream is;
        if (this.file.exists() && this.file.length() != 0L) {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[4096];
            is = new FileInputStream(this.file);
            int n = is.read(buffer);
            while (n > 0) {
                sha1.update(buffer, 0, n);
                n = is.read(buffer);
            }
            StringBuilder sb = new StringBuilder();
            Predef$.MODULE$.byteArrayOps(sha1.digest()).foreach((Function1)new Serializable(this, sb){
                public static final long serialVersionUID = 0L;
                private final StringBuilder sb$1;

                public final StringBuilder apply(byte b) {
                    return this.sb$1.append(String.format("%02x", BoxesRunTime.boxToByte((byte)b)));
                }
                {
                    this.sb$1 = sb$1;
                }
            });
            string = sb.toString();
        } else {
            string = "";
        }
        return string;
        finally {
            is.close();
        }
    }

    public final void au$org$ala$biocache$util$FileHelper$$deleteFile$1(File dfile) {
        if (dfile.isDirectory()) {
            File[] subfiles = dfile.listFiles();
            if (subfiles != null) {
                Predef$.MODULE$.refArrayOps((Object[])subfiles).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileHelper $outer;

                    public final void apply(File f) {
                        this.$outer.au$org$ala$biocache$util$FileHelper$$deleteFile$1(f);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
        dfile.delete();
    }

    private final void read$1(GZIPInputStream in$1, FileOutputStream out$1, byte[] buffer$1) {
        int byteCount;
        while ((byteCount = in$1.read(buffer$1)) >= 0) {
            out$1.write(buffer$1, 0, byteCount);
        }
    }

    public FileHelper(File file) {
        this.file = file;
        this.logger = LoggerFactory.getLogger((String)"FileHelper");
    }
}

