/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import au.org.ala.biocache.vocab.Term;
import au.org.ala.biocache.vocab.TypeStatus$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u001b\t\u0019B+\u001f9f'R\fG/^:Qe>\u001cWm]:pe*\u00111\u0001B\u0001\naJ|7-Z:t_JT!!\u0002\u0004\u0002\u0011\tLwnY1dQ\u0016T!a\u0002\u0005\u0002\u0007\u0005d\u0017M\u0003\u0002\n\u0015\u0005\u0019qN]4\u000b\u0003-\t!!Y;\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\u0005Qe>\u001cWm]:pe\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u0003+\u0001Aq!\b\u0001C\u0002\u0013\u0005a$\u0001\u0004m_\u001e<WM]\u000b\u0002?A\u0011\u0001\u0005J\u0007\u0002C)\u0011!eI\u0001\u0006g24GG\u001b\u0006\u0002\u0013%\u0011Q%\t\u0002\u0007\u0019><w-\u001a:\t\r\u001d\u0002\u0001\u0015!\u0003 \u0003\u001dawnZ4fe\u0002Bq!\u000b\u0001C\u0002\u0013\u0005!&\u0001\u0007X\u001fJ#u\fU!U)\u0016\u0013f*F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\t\u0001\u0004#\u0001\u0003vi&d\u0017B\u0001\u001a.\u0005\u0015\u0011VmZ3y\u0011\u0019!\u0004\u0001)A\u0005W\u0005iqk\u0014*E?B\u000bE\u000bV#S\u001d\u0002BQA\u000e\u0001\u0005\u0002]\nq\u0001\u001d:pG\u0016\u001c8\u000fF\u00039\u0003*{\u0015\u000bE\u0002\u0010smJ!A\u000f\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005qzT\"A\u001f\u000b\u0005y\"\u0011!B7pI\u0016d\u0017B\u0001!>\u0005A\tV/\u00197jif\f5o]3si&|g\u000eC\u0003Ck\u0001\u00071)\u0001\u0003hk&$\u0007C\u0001#H\u001d\tyQ)\u0003\u0002G!\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1\u0005\u0003C\u0003Lk\u0001\u0007A*A\u0002sC^\u0004\"\u0001P'\n\u00059k$A\u0003$vY2\u0014VmY8sI\")\u0001+\u000ea\u0001\u0019\u0006I\u0001O]8dKN\u001cX\r\u001a\u0005\b%V\u0002\n\u00111\u0001T\u00035a\u0017m\u001d;Qe>\u001cWm]:fIB\u0019q\u0002\u0016'\n\u0005U\u0003\"AB(qi&|g\u000eC\u0003X\u0001\u0011\u0005\u0001,\u0001\u0003tW&\u0004H#\u0002\u001dZ5nc\u0006\"\u0002\"W\u0001\u0004\u0019\u0005\"B&W\u0001\u0004a\u0005\"\u0002)W\u0001\u0004a\u0005b\u0002*W!\u0003\u0005\ra\u0015\u0005\u0006=\u0002!\taX\u0001\bO\u0016$h*Y7f+\u0005\u0001\u0007CA1g\u001b\u0005\u0011'BA2e\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\fAA[1wC&\u0011\u0001J\u0019\u0005\bQ\u0002\t\n\u0011\"\u0011j\u0003E\u0001(o\\2fgN$C-\u001a4bk2$H\u0005N\u000b\u0002U*\u00121k[\u0016\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001d\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002t]\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fU\u0004\u0011\u0013!C!S\u0006q1o[5qI\u0011,g-Y;mi\u0012\"\u0004")
public class TypeStatusProcessor
implements Processor {
    private final Logger logger;
    private final Regex WORD_PATTERN;

    public Logger logger() {
        return this.logger;
    }

    public Regex WORD_PATTERN() {
        return this.WORD_PATTERN;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        QualityAssertion[] qualityAssertionArray;
        if (raw.identification().typeStatus() == null || raw.identification().typeStatus().isEmpty()) {
            qualityAssertionArray = (QualityAssertion[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(QualityAssertion.class));
        } else {
            List typeStatuses = (List)this.WORD_PATTERN().findAllIn((CharSequence)raw.identification().typeStatus()).toList().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Option<Term> apply(String word) {
                    return TypeStatus$.MODULE$.matchTerm(word);
                }
            }, List$.MODULE$.canBuildFrom());
            List list = (List)((SeqLike)((TraversableLike)typeStatuses.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Option<Term> x$1) {
                    return x$1.nonEmpty();
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Option<Term> ts) {
                    return ((Term)ts.get()).canonical();
                }
            }, List$.MODULE$.canBuildFrom())).distinct();
            if (list.isEmpty()) {
                qualityAssertionArray = (QualityAssertion[])((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNISED_TYPESTATUS(), "Unrecognised type status")});
            } else {
                processed.identification().typeStatus_$eq(list.mkString("|"));
                qualityAssertionArray = (QualityAssertion[])((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNISED_TYPESTATUS(), AssertionStatus$.MODULE$.PASSED())});
            }
        }
        return qualityAssertionArray;
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    @Override
    public QualityAssertion[] skip(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        ArrayBuffer assertions = new ArrayBuffer();
        if (lastProcessed.isDefined()) {
            assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])((FullRecord)lastProcessed.get()).findAssertions(new int[]{AssertionCodes$.MODULE$.UNRECOGNISED_TYPESTATUS().code()})));
            processed.identification().typeStatus_$eq(((FullRecord)lastProcessed.get()).identification().typeStatus());
        }
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> skip$default$4() {
        return None$.MODULE$;
    }

    @Override
    public String getName() {
        return "type";
    }

    public TypeStatusProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"TypeStatusProcessor");
        this.WORD_PATTERN = new StringOps(Predef$.MODULE$.augmentString("[\\p{L}]{4,}")).r();
    }
}

