/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Processed$;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.Version;
import au.org.ala.biocache.model.Versions$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processors$;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.time.DateFormatUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u00015\u0011qBU3d_J$\u0007K]8dKN\u001cxN\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u000b\u0005\u00151\u0011\u0001\u00032j_\u000e\f7\r[3\u000b\u0005\u001dA\u0011aA1mC*\u0011\u0011BC\u0001\u0004_J<'\"A\u0006\u0002\u0005\u0005,8\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\u0002m\ta\u0001\\8hO\u0016\u0014X#\u0001\u000f\u0011\u0005u\tS\"\u0001\u0010\u000b\u0005}\u0001\u0013!B:mMRR'\"A\u0005\n\u0005\tr\"A\u0002'pO\u001e,'\u000f\u0003\u0004%\u0001\u0001\u0006I\u0001H\u0001\bY><w-\u001a:!\u0011\u001d1\u0003A1A\u0005\u0002\u001d\n1\u0002\u001d:pG\u0016\u001c8\u000fV5nKV\t\u0001\u0006\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005!A.\u00198h\u0015\u0005i\u0013\u0001\u00026bm\u0006L!a\f\u0016\u0003\rM#(/\u001b8h\u0011\u0019\t\u0004\u0001)A\u0005Q\u0005a\u0001O]8dKN\u001cH+[7fA!91\u0007\u0001b\u0001\n\u0003!\u0014A\u00033va2L7-\u0019;fgV\tQ\u0007E\u00027w!j\u0011a\u000e\u0006\u0003qe\n\u0011\"[7nkR\f'\r\\3\u000b\u0005i\u0002\u0012AC2pY2,7\r^5p]&\u0011Ah\u000e\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004?\u0001\u0001\u0006I!N\u0001\fIV\u0004H.[2bi\u0016\u001c\b\u0005C\u0004A\u0001\t\u0007I\u0011A!\u0002\u001dA\u0014xnY3tgRKW.\u001b8hgV\t!\t\u0005\u0003D\u0011*\u0003V\"\u0001#\u000b\u0005\u00153\u0015AC2p]\u000e,(O]3oi*\u0011q\tL\u0001\u0005kRLG.\u0003\u0002J\t\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005-seBA\bM\u0013\ti\u0005#\u0001\u0004Qe\u0016$WMZ\u0005\u0003_=S!!\u0014\t\u0011\u0005E#V\"\u0001*\u000b\u0005M#\u0015AB1u_6L7-\u0003\u0002V%\nQ\u0011\t^8nS\u000eduN\\4\t\r]\u0003\u0001\u0015!\u0003C\u0003=\u0001(o\\2fgN$\u0016.\\5oON\u0004\u0003\"B-\u0001\t\u0003\t\u0015!E4fiB\u0013xnY3tgRKW.\u001b8hg\")1\f\u0001C\u00019\u0006i\u0001O]8dKN\u001c(+Z2pe\u0012$b!X2l[J$\b\u0003B&_\u0015\u0002L!aX(\u0003\u00075\u000b\u0007\u000f\u0005\u0002*C&\u0011!M\u000b\u0002\u0007\u001f\nTWm\u0019;\t\u000b\u0011T\u0006\u0019A3\u0002\u0007I\fw\u000f\u0005\u0002gS6\tqM\u0003\u0002i\t\u0005)Qn\u001c3fY&\u0011!n\u001a\u0002\u000b\rVdGNU3d_J$\u0007\"\u00027[\u0001\u0004)\u0017\u0001E2veJ,g\u000e\u001e)s_\u000e,7o]3e\u0011\u001dq'\f%AA\u0002=\fQAY1uG\"\u0004\"a\u00049\n\u0005E\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\bgj\u0003\n\u00111\u0001p\u0003%1\u0017N]:u\u0019>\fG\rC\u0004v5B\u0005\t\u0019\u0001<\u0002\u0015A\u0014xnY3tg>\u00148\u000fE\u0002\u0010o*K!\u0001\u001f\t\u0003\r=\u0003H/[8o\u0011\u0015Q\b\u0001\"\u0001|\u0003E9(/\u001b;f!J|7-Z:t\u0005\u0006$8\r\u001b\u000b\u0003y~\u0004\"aD?\n\u0005y\u0004\"\u0001B+oSRDaA\\=A\u0002\u0005\u0005\u0001#BA\u0002\u0003'if\u0002BA\u0003\u0003\u001fqA!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017a\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\r\t\t\u0002E\u0001\ba\u0006\u001c7.Y4f\u0013\ra\u0014Q\u0003\u0006\u0004\u0003#\u0001\u0002BB.\u0001\t\u0003\tI\u0002\u0006\u0003\u0002\u001c\u0005=\u0002CB\b\u0002\u001e\u0015\f\t#C\u0002\u0002 A\u0011a\u0001V;qY\u0016\u0014\u0004#B&_\u0015\u0006\r\u0002#B\b\u0002&\u0005%\u0012bAA\u0014!\t)\u0011I\u001d:bsB\u0019a-a\u000b\n\u0007\u00055rM\u0001\tRk\u0006d\u0017\u000e^=BgN,'\u000f^5p]\"1A-a\u0006A\u0002\u0015Dq!a\r\u0001\t\u0003\t)$\u0001\fqe>\u001cWm]:SK\u000e|'\u000fZ!oIV\u0003H-\u0019;f)\ra\u0018q\u0007\u0005\u0007I\u0006E\u0002\u0019A3\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u0005I\u0011\r\u001a3SK\u000e|'\u000f\u001a\u000b\u0006\u0015\u0006}\u00121\t\u0005\b\u0003\u0003\nI\u00041\u0001K\u0003=!\u0017\r^1SKN|WO]2f+&$\u0007\u0002CA#\u0003s\u0001\r!a\u0012\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0003L=*S\u0005\"CA&\u0001E\u0005I\u0011AA'\u0003]\u0001(o\\2fgN\u0014VmY8sI\u0012\"WMZ1vYR$3'\u0006\u0002\u0002P)\u001aq.!\u0015,\u0005\u0005M\u0003\u0003BA+\u0003?j!!a\u0016\u000b\t\u0005e\u00131L\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0018\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\n9FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\u001a\u0001#\u0003%\t!!\u0014\u0002/A\u0014xnY3tgJ+7m\u001c:eI\u0011,g-Y;mi\u0012\"\u0004\"CA5\u0001E\u0005I\u0011AA6\u0003]\u0001(o\\2fgN\u0014VmY8sI\u0012\"WMZ1vYR$S'\u0006\u0002\u0002n)\u001aa/!\u0015")
public class RecordProcessor {
    private final Logger logger = LoggerFactory.getLogger(RecordProcessor.class);
    private final String processTime = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final List<String> duplicates;
    private final ConcurrentHashMap<String, AtomicLong> processTimings;

    public Logger logger() {
        return this.logger;
    }

    public String processTime() {
        return this.processTime;
    }

    public List<String> duplicates() {
        return this.duplicates;
    }

    public ConcurrentHashMap<String, AtomicLong> processTimings() {
        return this.processTimings;
    }

    public ConcurrentHashMap<String, AtomicLong> getProcessTimings() {
        return this.processTimings();
    }

    public scala.collection.immutable.Map<String, Object> processRecord(FullRecord raw, FullRecord currentProcessed, boolean batch, boolean firstLoad, Option<String> processors) {
        scala.collection.immutable.Map map;
        None$ objectMapper = this.logger().isTraceEnabled() ? new Some((Object)new ObjectMapper()) : None$.MODULE$;
        try {
            String guid = raw.rowKey();
            OccurrenceDAO occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
            FullRecord processed = raw.createNewProcessedRecord();
            ObjectRef assertions = new ObjectRef((Object)new HashMap());
            Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, currentProcessed, firstLoad, processors, (Option)objectMapper, guid, processed, assertions){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RecordProcessor $outer;
                private final FullRecord raw$2;
                private final FullRecord currentProcessed$1;
                private final boolean firstLoad$1;
                private final Option processors$1;
                private final Option objectMapper$1;
                private final String guid$1;
                private final FullRecord processed$1;
                private final ObjectRef assertions$1;

                public final void apply(Processor processor) {
                    if (!this.firstLoad$1 || !processor.getName().equals("offline")) {
                        long start = System.nanoTime();
                        try {
                            if (this.processors$1.isEmpty() || ((String)this.processors$1.get()).contains(processor.getName())) {
                                ((HashMap)this.assertions$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.guid$1, this.raw$2, this.processed$1, (Option<FullRecord>)new Some((Object)this.currentProcessed$1))));
                                if (this.$outer.logger().isTraceEnabled()) {
                                    this.$outer.logger().trace(new StringBuilder().append((Object)"Processing completed for '").append((Object)processor.getName()).append((Object)"' for record ").append((Object)this.guid$1).toString());
                                    this.$outer.logger().trace(((ObjectMapper)this.objectMapper$1.get()).writeValueAsString((Object)this.processed$1));
                                }
                            } else {
                                ((HashMap)this.assertions$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.skip(this.guid$1, this.raw$2, this.processed$1, (Option<FullRecord>)new Some((Object)this.currentProcessed$1))));
                                if (this.$outer.logger().isTraceEnabled()) {
                                    this.$outer.logger().trace(new StringBuilder().append((Object)"Processing skipped for '").append((Object)processor.getName()).append((Object)"' for record ").append((Object)this.guid$1).toString());
                                }
                            }
                        }
                        catch (Exception exception) {
                            this.$outer.logger().warn(new StringBuilder().append((Object)"Non-fatal error processing record: ").append((Object)this.raw$2.rowKey()).append((Object)", processorName: ").append((Object)processor.getName()).append((Object)", error: ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
                        }
                        finally {
                            this.$outer.processTimings().getOrDefault(processor.getName(), new AtomicLong(0L)).addAndGet(System.nanoTime() - start);
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.raw$2 = raw$2;
                    this.currentProcessed$1 = currentProcessed$1;
                    this.firstLoad$1 = firstLoad$1;
                    this.processors$1 = processors$1;
                    this.objectMapper$1 = objectMapper$1;
                    this.guid$1 = guid$1;
                    this.processed$1 = processed$1;
                    this.assertions$1 = assertions$1;
                }
            });
            processed.lastModifiedTime_$eq(this.processTime());
            Some systemAssertions = new Some((Object)((HashMap)assertions.elem).toMap(Predef$.MODULE$.conforms()));
            if (batch) {
                map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rowKey"), (Object)guid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"oldRecord"), (Object)currentProcessed), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"newRecord"), (Object)processed), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"assertions"), (Object)systemAssertions), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)Processed$.MODULE$)}));
            } else {
                long startPersist = System.nanoTime();
                occurrenceDAO.updateOccurrence(guid, currentProcessed, processed, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
                this.processTimings().getOrDefault("persist", new AtomicLong(0L)).addAndGet(System.nanoTime() - startPersist);
                map = null;
            }
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Error processing record: ").append((Object)raw.rowKey()).append((Object)", ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
            map = null;
        }
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeProcessBatch(List<scala.collection.immutable.Map<String, Object>> batch) {
        OccurrenceDAO occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
        int retries = 0;
        boolean processedOK = false;
        if (processedOK) return;
        if (retries >= 6) return;
        {
            occurrenceDAO.updateOccurrenceBatch(batch);
            return;
        }
    }

    public Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> processRecord(FullRecord raw) {
        FullRecord processed = raw.createNewProcessedRecord();
        HashMap assertions = new HashMap();
        Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, processed, assertions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordProcessor $outer;
            private final FullRecord raw$1;
            private final FullRecord processed$2;
            private final HashMap assertions$2;

            public final void apply(Processor processor) {
                if (this.$outer.logger().isDebugEnabled()) {
                    this.$outer.logger().debug(new StringBuilder().append((Object)"Running processor ").append((Object)processor.getName()).toString());
                }
                this.assertions$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.raw$1.rowKey(), this.raw$1, this.processed$2, processor.process$default$4())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.raw$1 = raw$1;
                this.processed$2 = processed$2;
                this.assertions$2 = assertions$2;
            }
        });
        processed.lastModifiedTime_$eq(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'"));
        return new Tuple2((Object)processed, (Object)assertions.toMap(Predef$.MODULE$.conforms()));
    }

    public boolean processRecord$default$3() {
        return false;
    }

    public boolean processRecord$default$4() {
        return false;
    }

    public Option<String> processRecord$default$5() {
        return None$.MODULE$;
    }

    public void processRecordAndUpdate(FullRecord raw) {
        Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> tuple2 = this.processRecord(raw);
        if (tuple2 != null) {
            Tuple2 tuple22;
            FullRecord processed = (FullRecord)tuple2._1();
            scala.collection.immutable.Map assertions = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)processed, (Object)assertions);
            FullRecord processed2 = (FullRecord)tuple23._1();
            scala.collection.immutable.Map assertions2 = (scala.collection.immutable.Map)tuple23._2();
            Some systemAssertions = new Some((Object)assertions2);
            processed2.lastModifiedTime_$eq(this.processTime());
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), processed2, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public String addRecord(String dataResourceUid, scala.collection.immutable.Map<String, String> properties) {
        void var3_3;
        String uuid = UUID.randomUUID().toString();
        FullRecord raw = FullRecordMapper$.MODULE$.createFullRecord(uuid, (Map<String, String>)properties, (Version)Versions$.MODULE$.RAW());
        raw.attribution().dataResourceUid_$eq(dataResourceUid);
        Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)None$.MODULE$, Versions$.MODULE$.RAW());
        boolean downloaded = Config$.MODULE$.occurrenceDAO().downloadMedia(raw);
        if (downloaded) {
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)None$.MODULE$, Versions$.MODULE$.RAW());
        }
        return var3_3;
    }

    public RecordProcessor() {
        this.logger().info(new StringBuilder().append((Object)"RecordProcessor is instantiated. processTime:").append((Object)this.processTime()).toString());
        this.duplicates = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"D", "D1", "D2"}));
        this.processTimings = new ConcurrentHashMap();
    }
}

