/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.load.MediaStore;
import au.org.ala.biocache.load.MediaStore$class;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Multimedia;
import au.org.ala.biocache.util.HttpUtil$;
import au.org.ala.biocache.util.Json$;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minidev.json.JSONArray;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class RemoteMediaStore$
implements MediaStore {
    public static final RemoteMediaStore$ MODULE$;
    private final Logger logger;
    private PoolingHttpClientConnectionManager cm;
    private CloseableHttpClient client;
    private final Regex imageParser;
    private final Regex soundParser;
    private final Regex videoParser;
    private final String[] imageExtension;
    private final String[] soundExtension;
    private final String[] videoExtension;
    private volatile byte bitmap$0;

    static {
        new RemoteMediaStore$();
    }

    private Regex imageParser$lzycompute() {
        RemoteMediaStore$ remoteMediaStore$ = this;
        synchronized (remoteMediaStore$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.imageParser = MediaStore$class.imageParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.imageParser;
        }
    }

    @Override
    public Regex imageParser() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.imageParser$lzycompute() : this.imageParser;
    }

    private Regex soundParser$lzycompute() {
        RemoteMediaStore$ remoteMediaStore$ = this;
        synchronized (remoteMediaStore$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.soundParser = MediaStore$class.soundParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.soundParser;
        }
    }

    @Override
    public Regex soundParser() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.soundParser$lzycompute() : this.soundParser;
    }

    private Regex videoParser$lzycompute() {
        RemoteMediaStore$ remoteMediaStore$ = this;
        synchronized (remoteMediaStore$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.videoParser = MediaStore$class.videoParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.videoParser;
        }
    }

    @Override
    public Regex videoParser() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.videoParser$lzycompute() : this.videoParser;
    }

    @Override
    public String[] imageExtension() {
        return this.imageExtension;
    }

    @Override
    public String[] soundExtension() {
        return this.soundExtension;
    }

    @Override
    public String[] videoExtension() {
        return this.videoExtension;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$logger_$eq(Logger x$1) {
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$imageExtension_$eq(String[] x$1) {
        this.imageExtension = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$soundExtension_$eq(String[] x$1) {
        this.soundExtension = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$videoExtension_$eq(String[] x$1) {
        this.videoExtension = x$1;
    }

    @Override
    public boolean isValidImageURL(String url) {
        return MediaStore$class.isValidImageURL(this, url);
    }

    @Override
    public boolean isValidSoundURL(String url) {
        return MediaStore$class.isValidSoundURL(this, url);
    }

    @Override
    public boolean isValidVideoURL(String url) {
        return MediaStore$class.isValidVideoURL(this, url);
    }

    @Override
    public boolean isValidImage(String filename) {
        return MediaStore$class.isValidImage(this, filename);
    }

    @Override
    public boolean isValidSound(String filename) {
        return MediaStore$class.isValidSound(this, filename);
    }

    @Override
    public boolean isValidVideo(String filename) {
        return MediaStore$class.isValidVideo(this, filename);
    }

    @Override
    public boolean isMediaFile(File file) {
        return MediaStore$class.isMediaFile(this, file);
    }

    @Override
    public boolean endsWithOneOf(String[] acceptedExtensions, String url) {
        return MediaStore$class.endsWithOneOf(this, acceptedExtensions, url);
    }

    @Override
    public String extractSimpleFileName(String urlToMedia) {
        return MediaStore$class.extractSimpleFileName(this, urlToMedia);
    }

    @Override
    public String extractFileName(String urlToMedia) {
        return MediaStore$class.extractFileName(this, urlToMedia);
    }

    @Override
    public boolean isAccessible(String urlString) {
        return MediaStore$class.isAccessible(this, urlString);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    public PoolingHttpClientConnectionManager cm() {
        return this.cm;
    }

    public void cm_$eq(PoolingHttpClientConnectionManager x$1) {
        this.cm = x$1;
    }

    public CloseableHttpClient client() {
        return this.client;
    }

    public void client_$eq(CloseableHttpClient x$1) {
        this.client = x$1;
    }

    public CloseableHttpClient getClient() {
        if (this.cm() == null) {
            this.cm_$eq(new PoolingHttpClientConnectionManager());
            this.cm().setMaxTotal(Config$.MODULE$.remoteMediaConnectionPoolSize());
            this.cm().setDefaultMaxPerRoute(Config$.MODULE$.remoteMediaConnectionMaxPerRoute());
            this.client_$eq(HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.cm()).build());
        }
        return this.client();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public java.util.Map<String, String> getImageFormats(String imageId) {
        void var2_2;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("thumb", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)imageId).toString());
        map.put("small", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)imageId).toString());
        map.put("large", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnailLarge?imageId=").append((Object)imageId).toString());
        map.put("raw", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImage?imageId=").append((Object)imageId).toString());
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Tuple3<Object, String, String> alreadyStored(String uuid, String resourceUID, String urlToMedia) {
        Tuple3 tuple3;
        Tuple2 tuple22;
        Tuple2<Object, String> tuple2;
        String jsonToPost = Json$.MODULE$.toJSON((scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"filenames"), (Object)new String[]{this.constructFileID(resourceUID, uuid, urlToMedia)})}))));
        if (this.logger().isDebugEnabled()) {
            this.logger().debug(jsonToPost);
        }
        if ((tuple2 = HttpUtil$.MODULE$.postBody(new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/findImagesByOriginalFilename").toString(), "application/json", jsonToPost)) == null) throw new MatchError(tuple2);
        int code = tuple2._1$mcI$sp();
        String body = (String)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)code), (Object)body);
        int code2 = tuple23._1$mcI$sp();
        String body2 = (String)tuple23._2();
        if (code2 != 200) {
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"", (Object)"");
            return tuple3;
        }
        try {
            JsonPath jsonPath = JsonPath.compile((String)"$..imageId", (Filter[])new Filter[0]);
            JSONArray idArray = (JSONArray)jsonPath.read(body2);
            if (idArray.isEmpty()) {
                tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"", (Object)"");
                return tuple3;
            }
            if (idArray.size() == 0) {
                tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"", (Object)"");
                return tuple3;
            }
            Object imageId = idArray.get(0);
            this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Image ", " already stored here: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{urlToMedia}))).append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/image/proxyImage?imageId=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{imageId}))).toString());
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)this.extractFileName(urlToMedia), (Object)imageId.toString());
            return tuple3;
        }
        catch (Exception exception) {
            this.logger().debug(exception.getMessage(), (Throwable)exception);
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"", (Object)"");
        }
        return tuple3;
    }

    public String constructFileID(String resourceUID, String uuid, String urlToMedia) {
        return new StringBuilder().append((Object)resourceUID).append((Object)"||").append((Object)uuid).append((Object)"||").append((Object)this.extractFileName(urlToMedia)).toString();
    }

    @Override
    public Option<Tuple2<String, String>> save(String uuid, String resourceUID, String urlToMedia, Option<Multimedia> media) {
        if (urlToMedia.startsWith(Config$.MODULE$.remoteMediaStoreUrl())) {
            this.logger().info(new StringBuilder().append((Object)"Remote media store host recognised: ").append((Object)urlToMedia).toString());
            URI uri = new URI(urlToMedia);
            ObjectRef imageId = new ObjectRef((Object)new Some((Object)""));
            if (urlToMedia.contains("/image/proxy")) {
                List params = URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8);
                JavaConversions$.MODULE$.asScalaBuffer(params).foreach((Function1)new Serializable(imageId){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef imageId$1;

                    public final void apply(NameValuePair param) {
                        String string = param.getName().toLowerCase();
                        String string2 = "imageid";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            String originalUUID = param.getValue().toLowerCase();
                            UUID testUUID = UUID.fromString(originalUUID);
                            String reformedString = testUUID.toString().toLowerCase();
                            String string3 = originalUUID;
                            String string4 = reformedString;
                            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                this.imageId$1.elem = new Some((Object)originalUUID);
                            }
                        }
                    }
                    {
                        this.imageId$1 = imageId$1;
                    }
                });
            } else if (urlToMedia.contains("/store/")) {
                Predef$.MODULE$.refArrayOps((Object[])uri.getPath().split("/")).foreach((Function1)new Serializable(imageId){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef imageId$1;

                    public final void apply(String pathSegment) {
                        if (pathSegment.length() > 10) {
                            try {
                                String originalUUID = pathSegment.toLowerCase();
                                UUID testUUID = UUID.fromString(originalUUID);
                                String reformedString = testUUID.toString().toLowerCase();
                                String string = originalUUID;
                                String string2 = reformedString;
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    this.imageId$1.elem = new Some((Object)originalUUID);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    {
                        this.imageId$1 = imageId$1;
                    }
                });
            }
            if (((Some)imageId.elem).isEmpty() || ((String)((Some)imageId.elem).get()).isEmpty()) {
                this.logger().info("Did not recognise URL pattern for remote media store: {}", new Object[]{urlToMedia});
                return None$.MODULE$;
            }
            java.util.Map<String, Object> metadata = this.getMetadata((String)((Some)imageId.elem).get());
            return new Some((Object)new Tuple2((Object)metadata.getOrDefault("originalFileName", "").toString(), ((Some)imageId.elem).get()));
        }
        Option<String> imageId = this.uploadImageFromUrl(uuid, resourceUID, urlToMedia, media);
        return imageId.isDefined() ? new Some((Object)new Tuple2((Object)this.extractFileName(urlToMedia), imageId.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }))) : None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public java.util.Map<String, Object> getMetadata(String uuid) {
        void var3_3;
        String url = new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/image/").append((Object)uuid).append((Object)".json").toString();
        java.util.Map<String, Object> result = Json$.MODULE$.toJavaMap(HttpUtil$.MODULE$.get(url));
        return var3_3;
    }

    /*
     * Loose catch block
     */
    private Option<File> downloadToTmpFile(String resourceUID, String uuid, String urlToMedia) {
        None$ none$;
        block10: {
            try {
                FileOutputStream out;
                InputStream in;
                String urlStr;
                block9: {
                    File tmpFile = new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)File.separator).append((Object)this.constructFileID(resourceUID, uuid, urlToMedia)).toString());
                    urlStr = urlToMedia.replaceAll(" ", "%20");
                    URL url = new URL(urlStr);
                    in = url.openStream();
                    out = new FileOutputStream(tmpFile);
                    byte[] buffer = new byte[1024];
                    int numRead = 0;
                    while ((numRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, numRead);
                        out.flush();
                    }
                    out.close();
                    if (tmpFile.getTotalSpace() <= 0L) break block9;
                    this.logger().debug(new StringBuilder().append((Object)"Temp file created: ").append((Object)tmpFile.getAbsolutePath()).append((Object)", file size: ").append((Object)BoxesRunTime.boxToLong((long)tmpFile.getTotalSpace())).toString());
                    none$ = new Some((Object)tmpFile);
                    break block10;
                }
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failure to download image from  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{urlStr})));
                none$ = None$.MODULE$;
                break block10;
                {
                    catch (Throwable throwable) {
                        out.close();
                        throw throwable;
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (Exception exception) {
                this.logger().error(new StringBuilder().append((Object)"Problem downloading media. URL:").append((Object)urlToMedia).toString());
                this.logger().debug(exception.getMessage(), (Throwable)exception);
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private void updateMetadata(String imageId, Multimedia media) {
        long start = System.currentTimeMillis();
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating the metadata for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{imageId})));
        HttpEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addPart("metadata", (ContentBody)new StringBody(Json$.MODULE$.toJSON(media.metadata()), ContentType.APPLICATION_JSON)).build();
        HttpPost httpPost = new HttpPost(new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/updateMetadata/").append((Object)imageId).toString());
        httpPost.setEntity(entity);
        CloseableHttpResponse response2 = this.getClient().execute((HttpUriRequest)httpPost);
        try {
            StatusLine status = response2.getStatusLine();
            return;
        }
        finally {
            response2.close();
        }
    }

    private Option<String> uploadImageFromUrl(String uuid, String resourceUID, String urlToMedia, Option<Multimedia> media) {
        None$ none$;
        block16: {
            Option option;
            CloseableHttpResponse response2;
            block15: {
                block14: {
                    Some some;
                    MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                    builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                    scala.collection.mutable.Map metadata = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"occurrenceId"), (Object)uuid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataResourceUid"), (Object)resourceUID), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"originalFileName"), (Object)this.extractFileName(urlToMedia)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"fullOriginalUrl"), (Object)urlToMedia)}));
                    Object object = media.isDefined() ? metadata.$plus$plus$eq(((Multimedia)media.get()).metadata()) : BoxedUnit.UNIT;
                    builder.addPart("imageUrl", (ContentBody)new StringBody(urlToMedia));
                    builder.addPart("metadata", (ContentBody)new StringBody(Json$.MODULE$.toJSON(metadata), ContentType.APPLICATION_JSON));
                    HttpEntity entity = builder.build();
                    HttpPost httpPost = new HttpPost(new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/uploadImage").toString());
                    httpPost.setEntity(entity);
                    httpPost.setHeader("apiKey", Config$.MODULE$.mediaStoreApiKey());
                    response2 = this.getClient().execute((HttpUriRequest)httpPost);
                    StatusLine result = response2.getStatusLine();
                    HttpEntity entity2 = response2.getEntity();
                    if (entity2 == null) {
                        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image from URL. Response content was empty indicating a failure"})).s((Seq)Nil$.MODULE$));
                        none$ = None$.MODULE$;
                        break block14;
                    }
                    InputStream content = entity2.getContent();
                    if (content == null) {
                        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image from URL. Response entity was null indicating a failure"})).s((Seq)Nil$.MODULE$));
                        none$ = None$.MODULE$;
                        break block14;
                    }
                    BufferedSource bufferedSource = Source$.MODULE$.fromInputStream(content, Codec$.MODULE$.fallbackSystemCodec());
                    String responseBody = Source$.MODULE$.fromInputStream(response2.getEntity().getContent(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
                    if (this.logger().isDebugEnabled()) {
                        this.logger().debug(new StringBuilder().append((Object)"Image service response code: ").append((Object)BoxesRunTime.boxToInteger((int)result.getStatusCode())).toString());
                    }
                    Map<String, Object> map = Json$.MODULE$.toMap(responseBody);
                    if (this.logger().isDebugEnabled()) {
                        this.logger().debug(new StringBuilder().append((Object)"Image ID: ").append(map.getOrElse((Object)"imageId", (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        })).toString());
                    }
                    if ((option = map.get((Object)"imageId")) instanceof Some) {
                        Some some2 = (Some)option;
                        Object o = some2.x();
                        some = new Some((Object)o.toString());
                    } else {
                        None$ none$2 = None$.MODULE$;
                        Option option2 = option;
                        if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block15;
                        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image from URL. Response code ", ".  Image service response body: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)result.getStatusCode()), responseBody})));
                        some = None$.MODULE$;
                    }
                    none$ = some;
                }
                response2.close();
                break block16;
            }
            try {
                throw new MatchError((Object)option);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image from URL. UnsupportedOperationException thrown"})).s((Seq)Nil$.MODULE$), (Throwable)unsupportedOperationException);
                none$ = None$.MODULE$;
                response2.close();
            }
            catch (IOException iOException) {
                try {
                    this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image from URL. IOException thrown"})).s((Seq)Nil$.MODULE$), (Throwable)iOException);
                    none$ = None$.MODULE$;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    response2.close();
                }
            }
        }
        return none$;
    }

    private Option<String> uploadImage(String uuid, String resourceUID, String urlToMedia, File fileToUpload, Option<Multimedia> media) {
        block4: {
            Option option;
            block7: {
                Some some;
                block6: {
                    String responseBody;
                    StatusLine result;
                    block5: {
                        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                        if (!fileToUpload.exists()) break block4;
                        if (fileToUpload.length() == 0L) {
                            this.logger().error(new StringBuilder().append((Object)"File to upload is empty. ").append((Object)fileToUpload.getAbsolutePath()).toString());
                            return None$.MODULE$;
                        }
                        this.logger().debug(new StringBuilder().append((Object)"File to upload: ").append((Object)fileToUpload.getAbsolutePath()).append((Object)", size:").append((Object)BoxesRunTime.boxToLong((long)fileToUpload.length())).toString());
                        scala.collection.mutable.Map metadata = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"occurrenceId"), (Object)uuid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataResourceUid"), (Object)resourceUID), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"originalFileName"), (Object)this.extractFileName(urlToMedia)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"fullOriginalUrl"), (Object)urlToMedia)}));
                        Object object = media.isDefined() ? metadata.$plus$plus$eq(((Multimedia)media.get()).metadata()) : BoxedUnit.UNIT;
                        builder.addPart("image", (ContentBody)new FileBody(fileToUpload, ContentType.create((String)"image/jpeg"), fileToUpload.getName()));
                        builder.addPart("metadata", (ContentBody)new StringBody(Json$.MODULE$.toJSON(metadata)));
                        HttpEntity entity = builder.build();
                        HttpPost httpPost = new HttpPost(new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/uploadImage").toString());
                        httpPost.setEntity(entity);
                        httpPost.setHeader("apiKey", "d75f5560-a4eb-4b5f-9178-5f049a8ec85e");
                        CloseableHttpResponse response2 = this.getClient().execute((HttpUriRequest)httpPost);
                        result = response2.getStatusLine();
                        responseBody = Source$.MODULE$.fromInputStream(response2.getEntity().getContent(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
                        this.logger().debug(new StringBuilder().append((Object)"Image service response code: ").append((Object)BoxesRunTime.boxToInteger((int)result.getStatusCode())).toString());
                        Map<String, Object> map = Json$.MODULE$.toMap(responseBody);
                        this.logger().debug(new StringBuilder().append((Object)"Image ID: ").append(map.getOrElse((Object)"imageId", (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        })).toString());
                        option = map.get((Object)"imageId");
                        if (!(option instanceof Some)) break block5;
                        Some some2 = (Some)option;
                        Object o = some2.x();
                        some = new Some((Object)o.toString());
                        break block6;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                    this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image with multipart upload. Response code ", ".getStatusCode.  Image service response body: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result, responseBody})));
                    some = None$.MODULE$;
                }
                return some;
            }
            throw new MatchError((Object)option);
        }
        this.logger().error(new StringBuilder().append((Object)"File to upload does not exist or can not be read. ").append((Object)fileToUpload.getAbsolutePath()).toString());
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public java.util.Map<String, String> getSoundFormats(String mediaID) {
        void var2_2;
        HashMap<String, String> formats2 = new HashMap<String, String>();
        formats2.put("audio/mpeg", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImage?imageId=").append((Object)mediaID).toString());
        return var2_2;
    }

    @Override
    public void convertPathsToUrls(FullRecord fullRecord, String baseUrlPath) {
        if (fullRecord.occurrence().images() != null) {
            fullRecord.occurrence().images_$eq((String[])Predef$.MODULE$.refArrayOps((Object[])fullRecord.occurrence().images()).map((Function1)new Serializable(baseUrlPath){
                public static final long serialVersionUID = 0L;
                private final String baseUrlPath$2;

                public final String apply(String x) {
                    return RemoteMediaStore$.MODULE$.convertPathToUrl(x, this.baseUrlPath$2);
                }
                {
                    this.baseUrlPath$2 = baseUrlPath$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
    }

    @Override
    public String convertPathToUrl(String str, String baseUrlPath) {
        return new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)str).toString();
    }

    @Override
    public String convertPathToUrl(String str) {
        return new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)str).toString();
    }

    private RemoteMediaStore$() {
        MODULE$ = this;
        MediaStore$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"RemoteMediaStore");
        this.cm = null;
        this.client = null;
    }
}

