/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index;

import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class IndexMergeTool$
implements Tool {
    public static final IndexMergeTool$ MODULE$;
    private final Logger logger;

    static {
        new IndexMergeTool$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "index-merge";
    }

    @Override
    public String desc() {
        return "Merge indexes ";
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public void main(String[] args) {
        DoubleRef ramBuffer;
        BooleanRef deleteSources;
        IntRef mergeSegments;
        BooleanRef forceMerge;
        ObjectRef mergeDir = new ObjectRef((Object)"");
        ObjectRef directoriesToMerge = new ObjectRef((Object)((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        OptionParser parser = new OptionParser(mergeDir, directoriesToMerge, forceMerge = new BooleanRef(true), mergeSegments = new IntRef(1), deleteSources = new BooleanRef(false), ramBuffer = new DoubleRef(4096.0)){
            {
                this.arg("<merge-dr>", "The output path for the merged index", (Function1<String, BoxedUnit>)new Serializable(this, mergeDir$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef mergeDir$1;

                    public final void apply(String v) {
                        this.mergeDir$1.elem = v;
                    }
                    {
                        this.mergeDir$1 = mergeDir$1;
                    }
                });
                this.arg("<to-merge>", "Pipe separated list of directories to merge", (Function1<String, BoxedUnit>)new Serializable(this, directoriesToMerge$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef directoriesToMerge$1;

                    public final void apply(String v) {
                        this.directoriesToMerge$1.elem = (String[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(v)).split('|')).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x) {
                                return x.trim();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                    }
                    {
                        this.directoriesToMerge$1 = directoriesToMerge$1;
                    }
                });
                this.opt("sk", "skipMerge", "Skip merge of segments.", (Function0<BoxedUnit>)new Serializable(this, forceMerge$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef forceMerge$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.forceMerge$1.elem = false;
                    }
                    {
                        this.forceMerge$1 = forceMerge$1;
                    }
                });
                this.intOpt("ms", "max-segments", new StringBuilder().append((Object)"Max merge segments. Default ").append((Object)BoxesRunTime.boxToInteger((int)mergeSegments$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, mergeSegments$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef mergeSegments$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.mergeSegments$1.elem = v;
                    }
                    {
                        this.mergeSegments$1 = mergeSegments$1;
                    }
                });
                this.doubleOpt("ram", "ram-buffer", new StringBuilder().append((Object)"RAM buffer size. Default ").append((Object)BoxesRunTime.boxToDouble((double)ramBuffer$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, ramBuffer$1){
                    public static final long serialVersionUID = 0L;
                    private final DoubleRef ramBuffer$1;

                    public final void apply(double v) {
                        this.apply$mcVD$sp(v);
                    }

                    public void apply$mcVD$sp(double v) {
                        this.ramBuffer$1.elem = v;
                    }
                    {
                        this.ramBuffer$1 = ramBuffer$1;
                    }
                });
                this.opt("ds", "delete-sources", new StringBuilder().append((Object)"Delete sources if successful. Defaults to ").append((Object)BoxesRunTime.boxToBoolean((boolean)deleteSources$1.elem)).toString(), (Function0<BoxedUnit>)new Serializable(this, deleteSources$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef deleteSources$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.deleteSources$1.elem = true;
                    }
                    {
                        this.deleteSources$1 = deleteSources$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            this.merge((String)mergeDir.elem, (String[])directoriesToMerge.elem, forceMerge.elem, mergeSegments.elem, deleteSources.elem, ramBuffer.elem);
        }
    }

    public void merge(String mergeDir, String[] directoriesToMerge, boolean forceMerge, int mergeSegments, boolean deleteSources, double rambuffer) {
        long start = System.currentTimeMillis();
        this.logger().info(new StringBuilder().append((Object)"Merging to directory:  ").append((Object)mergeDir).toString());
        Predef$.MODULE$.refArrayOps((Object[])directoriesToMerge).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String x) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Directory included in merge: ").append((Object)x).toString());
            }
        });
        File mergeDirFile = new File(mergeDir);
        if (mergeDirFile.exists()) {
            Predef$.MODULE$.refArrayOps((Object[])mergeDirFile.listFiles()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(File f) {
                    FileUtils.forceDelete((File)f);
                }
            });
        } else {
            FileUtils.forceMkdir((File)mergeDirFile);
        }
        FSDirectory mergedIndex = FSDirectory.open((Path)mergeDirFile.toPath());
        IndexWriterConfig writerConfig = new IndexWriterConfig(null).setOpenMode(IndexWriterConfig.OpenMode.CREATE).setRAMBufferSizeMB(rambuffer);
        writerConfig.setMergeScheduler((MergeScheduler)new ConcurrentMergeScheduler());
        ((ConcurrentMergeScheduler)writerConfig.getMergeScheduler()).setMaxMergesAndThreads(mergeSegments, mergeSegments);
        IndexWriter writer = new IndexWriter((Directory)mergedIndex, writerConfig);
        FSDirectory[] indexes = (FSDirectory[])Predef$.MODULE$.refArrayOps((Object[])directoriesToMerge).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FSDirectory apply(String dir) {
                return FSDirectory.open((Path)new File(dir).toPath());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FSDirectory.class)));
        this.logger().info("Adding indexes...");
        writer.addIndexes((Directory[])indexes);
        if (forceMerge) {
            this.logger().info("Full merge...");
            writer.forceMerge(mergeSegments);
        } else {
            this.logger().info("Skipping merge...");
        }
        writer.close();
        long finish = System.currentTimeMillis();
        this.logger().info(new StringBuilder().append((Object)"Merge complete:  ").append((Object)mergeDir).append((Object)". Time taken: ").append((Object)BoxesRunTime.boxToLong((long)((finish - start) / 1000L / 60L))).append((Object)" minutes").toString());
        if (deleteSources) {
            this.logger().info("Deleting source directories");
            Predef$.MODULE$.refArrayOps((Object[])directoriesToMerge).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String dir) {
                    FileUtils.forceDelete((File)new File(dir));
                }
            });
            this.logger().info("Deleted source directories");
        }
    }

    public double merge$default$6() {
        return 4096.0;
    }

    private IndexMergeTool$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"IndexMergeTool");
    }
}

