/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.outliers;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.outliers.JackKnife$;
import au.org.ala.biocache.outliers.JackKnifeStats;
import au.org.ala.biocache.outliers.RecordJackKnifeStats;
import au.org.ala.biocache.outliers.ReverseJacknifeProcessor$;
import au.org.ala.biocache.outliers.ReverseJacknifeProcessor$$anonfun$au$org$ala$biocache$outliers$ReverseJacknifeProcessor$;
import au.org.ala.biocache.outliers.ReverseJacknifeProcessor$$anonfun$performJacknife$1$;
import au.org.ala.biocache.outliers.SampledRecord;
import au.org.ala.biocache.outliers.Timings;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.vocab.AssertionCodes$;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.minidev.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class ReverseJacknifeProcessor$
implements Tool {
    public static final ReverseJacknifeProcessor$ MODULE$;
    private final Logger logger;
    private final List<String> mandatoryHeaders;

    static {
        new ReverseJacknifeProcessor$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "jacknife";
    }

    @Override
    public String desc() {
        return "Run jacknife processing";
    }

    public Logger logger() {
        return this.logger;
    }

    public List<String> mandatoryHeaders() {
        return this.mandatoryHeaders;
    }

    @Override
    public void main(String[] args) {
        IntRef threads;
        IntRef taxonRankThreshold;
        BooleanRef persistResults;
        ObjectRef fullDumpFilePath = new ObjectRef((Object)"");
        ObjectRef headerForDumpFile = new ObjectRef((Object)((List)this.mandatoryHeaders().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Config$.MODULE$.outlierLayerIDs()), List$.MODULE$.canBuildFrom())));
        OptionParser parser = new OptionParser(fullDumpFilePath, headerForDumpFile, persistResults = new BooleanRef(true), taxonRankThreshold = new IntRef(7000), threads = new IntRef(1)){
            {
                this.arg("full-dump-file", new StringBuilder().append((Object)"Filepath to full extract of data. This is a dump file with the following columns: ").append((Object)((List)headerForDumpFile$1.elem).mkString(",")).append((Object)". This can be generated using an sorted export from the database once the ").append((Object)"data has been loaded, processed and sampled.").toString(), (Function1<String, BoxedUnit>)new Serializable(this, fullDumpFilePath$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef fullDumpFilePath$1;

                    public final void apply(String v) {
                        this.fullDumpFilePath$1.elem = v;
                    }
                    {
                        this.fullDumpFilePath$1 = fullDumpFilePath$1;
                    }
                });
                this.intOpt("taxonRankThreshold", "The minimum taxon rank threshold to use. The default is 7000 = species.", (Function1<Object, BoxedUnit>)new Serializable(this, taxonRankThreshold$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef taxonRankThreshold$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.taxonRankThreshold$1.elem = v;
                    }
                    {
                        this.taxonRankThreshold$1 = taxonRankThreshold$1;
                    }
                });
                this.intOpt("t", "threads", "The minimum taxon rank threshold to use. The default is 7000 = species.", (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
                this.opt("test", "Run jacknife but dont persist results  to the database", (Function0<BoxedUnit>)new Serializable(this, persistResults$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef persistResults$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.persistResults$1.elem = false;
                    }
                    {
                        this.persistResults$1 = persistResults$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            String string = (String)fullDumpFilePath.elem;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                parser.showUsage();
            } else if (new File((String)fullDumpFilePath.elem).exists()) {
                this.runOutlierTestingForDumpFile((String)fullDumpFilePath.elem, (List<String>)((List)headerForDumpFile.elem), persistResults.elem, taxonRankThreshold.elem, threads.elem);
                this.logger().info("Finished.");
                Config$.MODULE$.persistenceManager().shutdown();
            } else {
                this.logger().error(new StringBuilder().append((Object)"Dump file ").append((Object)((String)fullDumpFilePath.elem)).append((Object)" not available.").toString());
                parser.showUsage();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void runOutlierTestingForDumpFile(String dumpFilePath, List<String> columnHeaders, boolean persistResults, int rankThreshold, int threads) {
        void var7_7;
        List headers;
        CSVReader reader = new CSVReader((Reader)new FileReader(dumpFilePath), '\t', '|');
        List list = headers = columnHeaders.isEmpty() ? Predef$.MODULE$.refArrayOps((Object[])reader.readNext()).toList() : columnHeaders;
        if (this.mandatoryHeaders().forall((Function1)new Serializable(headers){
            public static final long serialVersionUID = 0L;
            private final List headers$1;

            public final boolean apply(String x$1) {
                return this.headers$1.contains((Object)x$1);
            }
            {
                this.headers$1 = headers$1;
            }
        })) {
            Tuple4<String, Object, Seq<String[]>, String[]> tuple4;
            List variables = (List)headers.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$2) {
                    return x$2.startsWith("el");
                }
            });
            BooleanRef finished = new BooleanRef(false);
            String nextTaxonConceptID = "";
            boolean nextTaxonRankID = false;
            Timings timings = new Timings();
            String[] lastLine = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            int latitudeIdx = headers.indexOf((Object)"decimalLatitude");
            int longitudeIdx = headers.indexOf((Object)"decimalLongitude");
            int taxonIDIdx = headers.indexOf((Object)"taxonConceptID");
            int taxonRankIDIdx = headers.indexOf((Object)"taxonRankID");
            int uuidIdx = headers.indexOf((Object)"rowkey");
            int rowKeyIdx = headers.indexOf((Object)"rowkey");
            ArrayBlockingQueue queue = new ArrayBlockingQueue(30);
            ExecutorService executorService = Executors.newFixedThreadPool(threads);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1)new Serializable(persistResults, rankThreshold, headers, variables, finished, timings, latitudeIdx, longitudeIdx, uuidIdx, rowKeyIdx, queue, executorService){
                public static final long serialVersionUID = 0L;
                public final boolean persistResults$2;
                public final int rankThreshold$1;
                public final List headers$1;
                public final List variables$1;
                public final BooleanRef finished$1;
                public final Timings timings$1;
                public final int latitudeIdx$1;
                public final int longitudeIdx$1;
                public final int uuidIdx$1;
                public final int rowKeyIdx$1;
                public final ArrayBlockingQueue queue$1;
                private final ExecutorService executorService$1;

                public final Future<?> apply(int idx) {
                    return this.executorService$1.submit(new Runnable(this){
                        private final /* synthetic */ anonfun.runOutlierTestingForDumpFile.2 $outer;

                        public void run() {
                            while (!this.$outer.finished$1.elem || this.$outer.queue$1.size() > 0) {
                                if (this.$outer.queue$1.size() > 0) {
                                    Tuple3 tuple3 = (Tuple3)this.$outer.queue$1.take();
                                    if (tuple3 != null) {
                                        Tuple3 tuple32;
                                        String taxonConceptID = (String)tuple3._1();
                                        int taxonRankID = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                        Seq lines = (Seq)tuple3._3();
                                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)taxonConceptID, (Object)BoxesRunTime.boxToInteger((int)taxonRankID), (Object)lines);
                                        String taxonConceptID2 = (String)tuple33._1();
                                        int taxonRankID2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
                                        Seq lines2 = (Seq)tuple33._3();
                                        ReverseJacknifeProcessor$.MODULE$.au$org$ala$biocache$outliers$ReverseJacknifeProcessor$$processDataForTaxon((Seq<String>)this.$outer.headers$1, this.$outer.persistResults$2, this.$outer.rankThreshold$1, (List<String>)this.$outer.variables$1, this.$outer.timings$1, this.$outer.latitudeIdx$1, this.$outer.longitudeIdx$1, this.$outer.uuidIdx$1, this.$outer.rowKeyIdx$1, taxonConceptID2, taxonRankID2, (Seq<String[]>)lines2);
                                        continue;
                                    }
                                    throw new MatchError((Object)tuple3);
                                }
                                Thread.sleep(1000L);
                            }
                            return;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.persistResults$2 = persistResults$2;
                    this.rankThreshold$1 = rankThreshold$1;
                    this.headers$1 = headers$1;
                    this.variables$1 = variables$1;
                    this.finished$1 = finished$1;
                    this.timings$1 = timings$1;
                    this.latitudeIdx$1 = latitudeIdx$1;
                    this.longitudeIdx$1 = longitudeIdx$1;
                    this.uuidIdx$1 = uuidIdx$1;
                    this.rowKeyIdx$1 = rowKeyIdx$1;
                    this.queue$1 = queue$1;
                    this.executorService$1 = executorService$1;
                }
            });
            while (true) {
                void var20_20;
                Tuple4 tuple42;
                String[] stringArray;
                void var17_17;
                int n;
                void var16_16;
                String string;
                void var6_6;
                if (finished.elem) {
                    executorService.shutdown();
                    executorService.awaitTermination(5L, TimeUnit.MINUTES);
                    this.logger().info("Finished paging.");
                    return;
                }
                tuple4 = this.readAllForTaxon((CSVReader)var6_6, string, (int)var16_16, n, (int)var17_17, stringArray);
                if (tuple4 == null) break;
                String taxonConceptID = (String)tuple4._1();
                int taxonRankID = BoxesRunTime.unboxToInt((Object)tuple4._2());
                Seq lines = (Seq)tuple4._3();
                String[] nextLine = (String[])tuple4._4();
                Tuple4 tuple43 = tuple42 = new Tuple4((Object)taxonConceptID, (Object)BoxesRunTime.boxToInteger((int)taxonRankID), (Object)lines, (Object)nextLine);
                String taxonConceptID2 = (String)tuple43._1();
                int taxonRankID2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
                Seq lines2 = (Seq)tuple43._3();
                String[] nextLine2 = (String[])tuple43._4();
                var20_20.put(new Tuple3((Object)taxonConceptID2, (Object)BoxesRunTime.boxToInteger((int)taxonRankID2), (Object)lines2));
                if (nextLine2 == null) {
                    var9_9.elem = true;
                    continue;
                }
                stringArray = nextLine2;
                string = nextLine2[var16_16];
                String string2 = nextLine2[var17_17];
                String string3 = "";
                n = !(string2 != null ? !string2.equals(string3) : string3 != null) ? 0 : new StringOps(Predef$.MODULE$.augmentString(nextLine2[var17_17])).toInt();
            }
            throw new MatchError(tuple4);
        }
        throw new RuntimeException(new StringBuilder().append((Object)"Missing mandatory headers ").append((Object)this.mandatoryHeaders().mkString(",")).append((Object)", Got: ").append((Object)var7_7.mkString(",")).toString());
    }

    public List<String> runOutlierTestingForDumpFile$default$2() {
        return Nil$.MODULE$;
    }

    public boolean runOutlierTestingForDumpFile$default$3() {
        return false;
    }

    public void au$org$ala$biocache$outliers$ReverseJacknifeProcessor$$processDataForTaxon(Seq<String> headers, boolean persistResults, int rankThreshold, List<String> variables, Timings timings, int latitudeIdx, int longitudeIdx, int uuidIdx, int rowKeyIdx, String taxonConceptID, int taxonRankID, Seq<String[]> lines) {
        if (StringUtils.isNotBlank((String)taxonConceptID) && taxonRankID >= rankThreshold) {
            this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaxonID: ", ", RankID: ", ", Records: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taxonConceptID, BoxesRunTime.boxToInteger((int)taxonRankID)}))).append((Object)BoxesRunTime.boxToInteger((int)lines.size())).toString());
            this.logger().debug(Predef$.MODULE$.refArrayOps((Object[])lines.head()).mkString(","));
            ListBuffer resultsBuffer = new ListBuffer();
            ListBuffer recordIds = new ListBuffer();
            BooleanRef loadedIds = new BooleanRef(false);
            variables.foreach((Function1)new Serializable(headers, timings, latitudeIdx, longitudeIdx, uuidIdx, rowKeyIdx, lines, resultsBuffer, recordIds, loadedIds){
                public static final long serialVersionUID = 0L;
                private final Seq headers$2;
                private final Timings timings$2;
                public final int latitudeIdx$2;
                public final int longitudeIdx$2;
                public final int uuidIdx$2;
                public final int rowKeyIdx$2;
                private final Seq lines$1;
                private final ListBuffer resultsBuffer$1;
                public final ListBuffer recordIds$1;
                public final BooleanRef loadedIds$1;

                public final void apply(String variable) {
                    int variableIdx = this.headers$2.indexOf((Object)variable);
                    ListBuffer pointBuffer = new ListBuffer();
                    this.lines$1.foreach((Function1)new Serializable(this, variableIdx, pointBuffer){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$au$org$ala$biocache$outliers$ReverseJacknifeProcessor$$processDataForTaxon$1 $outer;
                        private final int variableIdx$1;
                        private final ListBuffer pointBuffer$1;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final Object apply(String[] line) {
                            BoxedUnit boxedUnit;
                            String longitude;
                            String latitude;
                            String variableValue;
                            block3: {
                                block2: {
                                    variableValue = line[this.variableIdx$1];
                                    latitude = line[this.$outer.latitudeIdx$2];
                                    longitude = line[this.$outer.longitudeIdx$2];
                                    Object object = this.$outer.loadedIds$1.elem ? BoxedUnit.UNIT : this.$outer.recordIds$1.$plus$eq((Object)line[this.$outer.rowKeyIdx$2]);
                                    String string = variableValue;
                                    String string2 = "";
                                    if (!(string == null ? string2 != null : !string.equals(string2)) || variableValue == null) break block2;
                                    String string3 = latitude;
                                    String string4 = "";
                                    if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block2;
                                    String string5 = longitude;
                                    String string6 = "";
                                    if (string5 != null ? !string5.equals(string6) : string6 != null) break block3;
                                }
                                boxedUnit = BoxedUnit.UNIT;
                                return boxedUnit;
                            }
                            String cellId = new StringBuilder().append(new StringOps(Predef$.MODULE$.augmentString(latitude)).toFloat()).append((Object)"|").append((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(longitude)).toFloat())).toString();
                            boxedUnit = this.pointBuffer$1.$plus$eq((Object)new SampledRecord(line[this.$outer.uuidIdx$2], new StringOps(Predef$.MODULE$.augmentString(variableValue)).toFloat(), cellId, (Option<String>)new Some((Object)line[this.$outer.rowKeyIdx$2])));
                            return boxedUnit;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.variableIdx$1 = variableIdx$1;
                            this.pointBuffer$1 = pointBuffer$1;
                        }
                    });
                    Tuple2<Seq<SampledRecord>, Option<JackKnifeStats>> tuple2 = ReverseJacknifeProcessor$.MODULE$.performJacknife((Seq<SampledRecord>)pointBuffer);
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        Seq recordsIDs = (Seq)tuple2._1();
                        Option stats = (Option)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)recordsIDs, (Object)stats);
                        Seq recordsIDs2 = (Seq)tuple23._1();
                        Option stats2 = (Option)tuple23._2();
                        Object object = stats2.isEmpty() ? BoxedUnit.UNIT : this.resultsBuffer$1.$plus$eq((Object)new Tuple3((Object)variable, (Object)recordsIDs2, stats2.get()));
                        this.timings$2.checkpoint(new StringBuilder().append((Object)"jacknife with ").append((Object)variable).toString());
                        if (ReverseJacknifeProcessor$.MODULE$.logger().isDebugEnabled()) {
                            ReverseJacknifeProcessor$.MODULE$.logger().debug(new StringOps(Predef$.MODULE$.augmentString(">>> For layer: %s we've detected: %d outliers out of %d records tested.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{variable, BoxesRunTime.boxToInteger((int)recordsIDs2.length()), BoxesRunTime.boxToInteger((int)this.lines$1.size())})));
                        }
                        if (recordsIDs2.length() > this.lines$1.size()) {
                            if (ReverseJacknifeProcessor$.MODULE$.logger().isDebugEnabled()) {
                                ReverseJacknifeProcessor$.MODULE$.logger().debug(new StringOps(Predef$.MODULE$.augmentString(">>> records: %d, distinct values: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)recordsIDs2.length()), BoxesRunTime.boxToInteger((int)recordsIDs2.toSet().size())})));
                            }
                            throw new RuntimeException("Error in processing");
                        }
                        this.loadedIds$1.elem = true;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.headers$2 = headers$2;
                    this.timings$2 = timings$2;
                    this.latitudeIdx$2 = latitudeIdx$2;
                    this.longitudeIdx$2 = longitudeIdx$2;
                    this.uuidIdx$2 = uuidIdx$2;
                    this.rowKeyIdx$2 = rowKeyIdx$2;
                    this.lines$1 = lines$1;
                    this.resultsBuffer$1 = resultsBuffer$1;
                    this.recordIds$1 = recordIds$1;
                    this.loadedIds$1 = loadedIds$1;
                }
            });
            Set passedRecords = resultsBuffer.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$) : (Set)recordIds.toSet().diff((GenSet)((TraversableForwarder)((TraversableLike)((TraversableForwarder)resultsBuffer.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<SampledRecord> apply(Tuple3<String, Seq<SampledRecord>, JackKnifeStats> x$6) {
                    return (Seq)x$6._2();
                }
            }, ListBuffer$.MODULE$.canBuildFrom())).foldLeft((Object)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ListBuffer<SampledRecord> apply(ListBuffer<SampledRecord> x$7, Seq<SampledRecord> x$8) {
                    return (ListBuffer)x$7.$plus$plus(x$8);
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(SampledRecord v) {
                    return (String)v.rowKey().getOrElse((Function0)new Serializable(this, v){
                        public static final long serialVersionUID = 0L;
                        private final SampledRecord v$1;

                        public final String apply() {
                            return this.v$1.id();
                        }
                        {
                            this.v$1 = v$1;
                        }
                    });
                }
            }, ListBuffer$.MODULE$.canBuildFrom())).toSet());
            this.logger().debug(new StringBuilder().append((Object)"The records that passed: ").append((Object)BoxesRunTime.boxToInteger((int)passedRecords.size())).append((Object)", total: ").append((Object)BoxesRunTime.boxToInteger((int)recordIds.size())).toString());
            if (persistResults) {
                this.storeResultsWithStats(taxonConceptID, (Seq<Tuple3<String, Seq<SampledRecord>, JackKnifeStats>>)resultsBuffer, (Set<String>)passedRecords, "species_guid");
            }
        }
    }

    public Tuple4<String, Object, Seq<String[]>, String[]> readAllForTaxon(CSVReader reader, String taxonConceptID, int taxonConceptIDIdx, int taxonRankID, int taxonRankIDIdx, String[] lastLine) {
        String[] currentLine = reader.readNext();
        String string = taxonConceptID;
        String string2 = "";
        String idForBatch = !(string != null ? !string.equals(string2) : string2 != null) ? currentLine[taxonConceptIDIdx] : taxonConceptID;
        int rankIdForBatch = StringUtils.isNotBlank((String)currentLine[taxonRankIDIdx]) ? new StringOps(Predef$.MODULE$.augmentString(currentLine[taxonRankIDIdx])).toInt() : 0;
        this.logger().debug(new StringBuilder().append((Object)"###### Running for:").append((Object)idForBatch).toString());
        ListBuffer buffer = new ListBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])lastLine).isEmpty() ? BoxedUnit.UNIT : buffer.$plus$eq((Object)lastLine);
        while (true) {
            if (currentLine == null) break;
            String string3 = currentLine[taxonConceptIDIdx];
            String string4 = idForBatch;
            if (string3 != null ? !string3.equals(string4) : string4 != null) break;
            buffer.$plus$eq((Object)currentLine);
            currentLine = reader.readNext();
        }
        return new Tuple4((Object)idForBatch, (Object)BoxesRunTime.boxToInteger((int)rankIdForBatch), (Object)buffer, (Object)currentLine);
    }

    public String[] readAllForTaxon$default$6() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    public void storeResultsWithStats(String taxonID, Seq<Tuple3<String, Seq<SampledRecord>, JackKnifeStats>> results, Set<String> passed, String field) {
        String[] stringArray;
        Option<String> option;
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        Map jackKnifeStatsMap = ((TraversableOnce)results.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, JackKnifeStats> apply(Tuple3<String, Seq<SampledRecord>, JackKnifeStats> x) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x._1()), x._3());
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Config$.MODULE$.persistenceManager().put(taxonID, "outliers", "jackKnifeStats", mapper.writeValueAsString((Object)jackKnifeStatsMap), true, false);
        Seq variableResults = (Seq)results.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<SampledRecord>> apply(Tuple3<String, Seq<SampledRecord>, JackKnifeStats> x) {
                return new Tuple2(x._1(), x._2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<Tuple2<SampledRecord, String>> record2OutlierLayer = this.invertLayer2Record((Seq<Tuple2<String, Seq<SampledRecord>>>)variableResults);
        try {
            option = Config$.MODULE$.persistenceManager().get(taxonID, "outliers", "jackKnifeOutliers");
        }
        catch (Exception exception) {
            option = None$.MODULE$;
        }
        Option<String> previous = option;
        Object object = previous.isEmpty() ? BoxedUnit.UNIT : Config$.MODULE$.persistenceManager().put(taxonID, "outliers", "previous", (String)previous.get(), true, false);
        Config$.MODULE$.persistenceManager().put(taxonID, "outliers", "jackKnifeOutliers", mapper.writeValueAsString((Object)variableResults), true, false);
        Seq recordStats = (Seq)record2OutlierLayer.map((Function1)new Serializable(jackKnifeStatsMap){
            public static final long serialVersionUID = 0L;
            private final Map jackKnifeStatsMap$1;

            public final RecordJackKnifeStats apply(Tuple2<SampledRecord, String> x) {
                Tuple2 tuple2 = new Tuple2(x._1(), x._2());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    SampledRecord sampledRecord = (SampledRecord)tuple2._1();
                    String layerId = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)sampledRecord, (Object)layerId);
                    SampledRecord sampledRecord2 = (SampledRecord)tuple23._1();
                    String layerId2 = (String)tuple23._2();
                    JackKnifeStats jackKnifeStats = (JackKnifeStats)this.jackKnifeStatsMap$1.get((Object)layerId2).get();
                    return new RecordJackKnifeStats(sampledRecord2.id(), layerId2, sampledRecord2.value(), jackKnifeStats.sampleSize(), jackKnifeStats.min(), jackKnifeStats.max(), jackKnifeStats.mean(), jackKnifeStats.stdDev(), jackKnifeStats.range(), jackKnifeStats.threshold(), jackKnifeStats.outlierValues());
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.jackKnifeStatsMap$1 = jackKnifeStatsMap$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        recordStats.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(RecordJackKnifeStats x$10) {
                return x$10.uuid();
            }
        }).foreach((Function1)new Serializable(mapper){
            public static final long serialVersionUID = 0L;
            private final ObjectMapper mapper$1;

            public final Object apply(Tuple2<String, Seq<RecordJackKnifeStats>> x) {
                Object object;
                String rowKey = (String)x._1();
                if (rowKey.isEmpty()) {
                    ReverseJacknifeProcessor$.MODULE$.logger().debug(new StringBuilder().append((Object)"Row key lookup failed for : ").append(x._1()).toString());
                    object = BoxedUnit.UNIT;
                } else {
                    List layerIds = ((TraversableOnce)((TraversableLike)x._2()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(RecordJackKnifeStats x$11) {
                            return x$11.layerId();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toList();
                    Config$.MODULE$.persistenceManager().put(rowKey, "occ", new StringBuilder().append((Object)"outlierForLayers").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString(), this.mapper$1.writeValueAsString((Object)layerIds), true, false);
                    Config$.MODULE$.occurrenceDAO().addSystemAssertion(rowKey, QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DETECTED_OUTLIER(), new StringBuilder().append((Object)"Outlier for ").append((Object)BoxesRunTime.boxToInteger((int)((SeqLike)x._2()).size())).append((Object)" layers").toString()), Config$.MODULE$.occurrenceDAO().addSystemAssertion$default$3(), Config$.MODULE$.occurrenceDAO().addSystemAssertion$default$4());
                    object = Config$.MODULE$.persistenceManager().put((String)x._1(), "occ_outliers", "jackKnife", this.mapper$1.writeValueAsString(x._2()), true, false);
                }
                return object;
            }
            {
                this.mapper$1 = mapper$1;
            }
        });
        if (previous.isDefined()) {
            JsonPath jsonPath = JsonPath.compile((String)"$..id", (Filter[])new Filter[0]);
            JSONArray idArray = (JSONArray)jsonPath.read((String)previous.get());
            stringArray = (String[])idArray.toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        } else {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        }
        String[] previousIDs = stringArray;
        this.logger().debug(new StringBuilder().append((Object)"previousIDs: ").append((Object)previousIDs).toString());
        String[] currentIDs = (String[])((TraversableOnce)record2OutlierLayer.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<SampledRecord, String> x0$1) {
                Tuple2<SampledRecord, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    SampledRecord sampledRecord = (SampledRecord)tuple2._1();
                    String string = sampledRecord.id();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        String[] newIDs = (String[])Predef$.MODULE$.refArrayOps((Object[])previousIDs).diff((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])currentIDs));
        this.logger().debug(new StringBuilder().append((Object)"previous : ").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])previousIDs).size())).append((Object)" current ").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])currentIDs).size())).append((Object)" new : ").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])newIDs).size())).toString());
        this.logger().debug(new StringBuilder().append((Object)"[WARNING] Number of old IDs not marked as outliers anymore: ").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])newIDs).size())).toString());
        Predef$.MODULE$.refArrayOps((Object[])newIDs).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String recordID) {
                ReverseJacknifeProcessor$.MODULE$.logger().debug(new StringBuilder().append((Object)"Record ").append((Object)recordID).append((Object)" is no longer an outlier").toString());
                Option<String> rowKey = Config$.MODULE$.occurrenceDAO().getRowKeyFromUuid(recordID);
                if (!rowKey.isEmpty()) {
                    Config$.MODULE$.persistenceManager().deleteColumns((String)rowKey.get(), "occ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"outlierForLayers").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString()}));
                    Config$.MODULE$.occurrenceDAO().addSystemAssertion((String)rowKey.get(), QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DETECTED_OUTLIER(), 1), true, Config$.MODULE$.occurrenceDAO().addSystemAssertion$default$4());
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Tuple2<SampledRecord, String>> invertLayer2Record(Seq<Tuple2<String, Seq<SampledRecord>>> layer2Record) {
        void var2_2;
        ListBuffer record2Layer = new ListBuffer();
        layer2Record.foreach((Function1)new Serializable(record2Layer){
            public static final long serialVersionUID = 0L;
            public final ListBuffer record2Layer$1;

            public final void apply(Tuple2<String, Seq<SampledRecord>> layer2Record) {
                Tuple2<String, Seq<SampledRecord>> tuple2 = layer2Record;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String layerId = (String)tuple2._1();
                    Seq records = (Seq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)layerId, (Object)records);
                    String layerId2 = (String)tuple23._1();
                    Seq records2 = (Seq)tuple23._2();
                    records2.foreach((Function1)new Serializable(this, layerId2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.invertLayer2Record.1 $outer;
                        private final String layerId$1;

                        public final void apply(SampledRecord r) {
                            this.$outer.record2Layer$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)r, (Object)this.layerId$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.layerId$1 = layerId$1;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.record2Layer$1 = record2Layer$1;
            }
        });
        return var2_2;
    }

    public Tuple2<Seq<SampledRecord>, Option<JackKnifeStats>> performJacknife(Seq<SampledRecord> points) {
        Option<JackKnifeStats> option;
        block4: {
            Tuple2 tuple2;
            block3: {
                block2: {
                    Map pointsGroupedByCell = points.groupBy((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(SampledRecord p) {
                            return p.cellId();
                        }
                    });
                    Map cellToValue = ((Map)pointsGroupedByCell.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, Object> apply(Tuple2<String, Seq<SampledRecord>> g) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(g._1()), (Object)BoxesRunTime.boxToFloat((float)((SampledRecord)((IterableLike)g._2()).head()).value()));
                        }
                    }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                    Map valuesToCells = ((Map)cellToValue.groupBy((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final float apply(Tuple2<String, Object> x) {
                            return BoxesRunTime.unboxToFloat((Object)x._2());
                        }
                    }).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Set<String>> apply(Tuple2<Object, Map<String, Object>> x) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x._1()), (Object)((MapLike)x._2()).keys().toSet());
                        }
                    }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                    Seq valuesToTest = ((TraversableOnce)cellToValue.values().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final float apply(float y) {
                            return this.apply$mcFF$sp(y);
                        }

                        public float apply$mcFF$sp(float y) {
                            return y;
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq();
                    option = JackKnife$.MODULE$.jackknife((Seq<Object>)valuesToTest, JackKnife$.MODULE$.jackknife$default$2());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    JackKnifeStats stats = (JackKnifeStats)some.x();
                    ListBuffer outliers = new ListBuffer();
                    Predef$.MODULE$.floatArrayOps(stats.outlierValues()).foreach((Function1)new Serializable(pointsGroupedByCell, valuesToCells, outliers){
                        public static final long serialVersionUID = 0L;
                        public final Map pointsGroupedByCell$1;
                        private final Map valuesToCells$1;
                        public final ListBuffer outliers$1;

                        public final void apply(float x) {
                            this.apply$mcVF$sp(x);
                        }

                        public void apply$mcVF$sp(float x) {
                            Set cellIds = (Set)this.valuesToCells$1.getOrElse((Object)BoxesRunTime.boxToFloat((float)x), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Set<String> apply() {
                                    return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                                }
                            });
                            cellIds.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.performJacknife.1 $outer;

                                public final void apply(String cellId) {
                                    Seq points = (Seq)this.$outer.pointsGroupedByCell$1.get((Object)cellId).get();
                                    points.foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$performJacknife$1$$anonfun$apply$mcVF$sp$1 $outer;

                                        public final ListBuffer<SampledRecord> apply(SampledRecord point) {
                                            return this.$outer.au$org$ala$biocache$outliers$ReverseJacknifeProcessor$$anonfun$$anonfun$$$outer().outliers$1.$plus$eq((Object)point);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ anonfun.performJacknife.1 au$org$ala$biocache$outliers$ReverseJacknifeProcessor$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.pointsGroupedByCell$1 = pointsGroupedByCell$1;
                            this.valuesToCells$1 = valuesToCells$1;
                            this.outliers$1 = outliers$1;
                        }
                    });
                    tuple2 = new Tuple2(outliers.distinct(), (Object)new Some((Object)stats));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<JackKnifeStats> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                tuple2 = new Tuple2((Object)Nil$.MODULE$, (Object)None$.MODULE$);
            }
            return tuple2;
        }
        throw new MatchError(option);
    }

    private ReverseJacknifeProcessor$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"ReverseJacknifeProcessor");
        this.mandatoryHeaders = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"taxonConceptID", "taxonRankID", "rowkey", "decimalLatitude", "decimalLongitude"}));
    }
}

