/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import com.sun.media.jai.codec.FileSeekableStream;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u001b\t\u0011B\u000b[;nE:\f\u0017\u000e\\1cY\u0016LU.Y4f\u0015\t\u0019A!\u0001\u0003m_\u0006$'BA\u0003\u0007\u0003!\u0011\u0017n\\2bG\",'BA\u0004\t\u0003\r\tG.\u0019\u0006\u0003\u0013)\t1a\u001c:h\u0015\u0005Y\u0011AA1v\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012!C5nC\u001e,g)\u001b7f!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0002j_*\t1$\u0001\u0003kCZ\f\u0017BA\u000f\u0019\u0005\u00111\u0015\u000e\\3\t\u000b}\u0001A\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\t\t3\u0005\u0005\u0002#\u00015\t!\u0001C\u0003\u0016=\u0001\u0007a\u0003C\u0004&\u0001\t\u0007IQ\u0001\u0014\u0002\r1|wmZ3s+\u00059\u0003C\u0001\u0015-\u001b\u0005I#B\u0001\u0016,\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0011BA\u0017*\u0005\u0019aunZ4fe\"1q\u0006\u0001Q\u0001\u000e\u001d\nq\u0001\\8hO\u0016\u0014\b\u0005C\u00042\u0001\t\u0007IQ\u0001\u001a\u0002\u0007\u0019\u001c8/F\u00014!\t!t(D\u00016\u0015\t1t'A\u0003d_\u0012,7M\u0003\u00029s\u0005\u0019!.Y5\u000b\u0005iZ\u0014!B7fI&\f'B\u0001\u001f>\u0003\r\u0019XO\u001c\u0006\u0002}\u0005\u00191m\\7\n\u0005\u0001+$A\u0005$jY\u0016\u001cV-Z6bE2,7\u000b\u001e:fC6DaA\u0011\u0001!\u0002\u001b\u0019\u0014\u0001\u00024tg\u0002Bq\u0001\u0012\u0001C\u0002\u0013\u0015Q)A\u0007pe&<\u0017N\\1m\u00136\fw-Z\u000b\u0002\rB\u0011q\tT\u0007\u0002\u0011*\u0011\u0001(\u0013\u0006\u0003u)S\u0011aS\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u001b\"\u0013!BU3oI\u0016\u0014X\rZ(q\u0011\u0019y\u0005\u0001)A\u0007\r\u0006qqN]5hS:\fG.S7bO\u0016\u0004\u0003\"B)\u0001\t\u0003\u0011\u0016\u0001F<sSR,G\u000b[;nE:\f\u0017\u000e\u001c+p\r&dW\rF\u0002T-b\u0003\"a\u0004+\n\u0005U\u0003\"\u0001B+oSRDQa\u0016)A\u0002Y\t\u0001C\\3x)\",XN\u00198bS24\u0015\u000e\\3\t\u000be\u0003\u0006\u0019\u0001.\u0002\u0015\u0015$w-\u001a'f]\u001e$\b\u000e\u0005\u0002\u00107&\u0011A\f\u0005\u0002\u0006\r2|\u0017\r\u001e")
public class ThumbnailableImage {
    private final File imageFile;
    private final Logger logger;
    private final FileSeekableStream fss;
    private final RenderedOp originalImage;

    public final Logger logger() {
        return this.logger;
    }

    public final FileSeekableStream fss() {
        return this.fss;
    }

    public final RenderedOp originalImage() {
        return this.originalImage;
    }

    public void writeThumbnailToFile(File newThumbnailFile, float edgeLength) {
        try {
            int height = this.originalImage().getHeight();
            int width = this.originalImage().getWidth();
            RenderedOp renderedImage = (RenderedOp)this.originalImage().createSnapshot();
            if ((float)height < edgeLength && (float)width < edgeLength) {
                FileUtils.copyFile((File)this.imageFile, (File)newThumbnailFile);
            } else {
                int denom = height > width ? height : width;
                float modifier = edgeLength / (float)denom;
                int w = (int)((float)width * modifier);
                int h = (int)((float)height * modifier);
                Image i = renderedImage.getAsBufferedImage().getScaledInstance(w, h, 4);
                BufferedImage bufferedImage = new BufferedImage(w, h, 1);
                Graphics2D g = bufferedImage.createGraphics();
                g.drawImage(i, null, null);
                g.dispose();
                i.flush();
                RenderedOp modifiedImage = JAI.create((String)"awtImage", (Object)bufferedImage);
                FileOutputStream fOut = new FileOutputStream(newThumbnailFile);
                ImageIO.write((RenderedImage)modifiedImage, "jpg", fOut);
                fOut.flush();
                fOut.close();
            }
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Unable to generate thumbnail for ").append((Object)this.imageFile.getAbsoluteFile()).toString(), (Throwable)exception);
        }
    }

    public ThumbnailableImage(File imageFile) {
        this.imageFile = imageFile;
        this.logger = LoggerFactory.getLogger((String)"ThumbnailableImage");
        this.fss = new FileSeekableStream(imageFile);
        this.originalImage = JAI.create((String)"stream", (Object)this.fss());
    }
}

