/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.parser;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.parser.EventDate;
import au.org.ala.biocache.parser.ISODateRange$;
import au.org.ala.biocache.parser.ISODateTimeRange$;
import au.org.ala.biocache.parser.ISODayDateRange$;
import au.org.ala.biocache.parser.ISODayMonthRange$;
import au.org.ala.biocache.parser.ISOMonthDate$;
import au.org.ala.biocache.parser.ISOMonthDateRange$;
import au.org.ala.biocache.parser.ISOMonthYearDateRange$;
import au.org.ala.biocache.parser.ISOSingleDate$;
import au.org.ala.biocache.parser.ISOSingleYear$;
import au.org.ala.biocache.parser.ISOVerboseDateTime$;
import au.org.ala.biocache.parser.ISOVerboseDateTimeRange$;
import au.org.ala.biocache.parser.ISOWithMonthNameDate$;
import au.org.ala.biocache.parser.ISOYearRange$;
import au.org.ala.biocache.parser.NonISODateRange$;
import au.org.ala.biocache.parser.NonISOSingleDate$;
import au.org.ala.biocache.parser.NonISOTruncatedYearDate$;
import au.org.ala.biocache.util.DateUtil$;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class DateParser$ {
    public static final DateParser$ MODULE$;
    private final Logger logger;
    private final Cache<Tuple4<String, Object, Object, Object>, DateTimeFormatter> dateFormatCache;
    private final DateTimeFormatter YEAR_TO_LOCAL_DATE;
    private final DateTimeFormatter YEAR_MONTH_TO_LOCAL_DATE;
    private final DateTimeFormatter MONTH_TO_LOCAL_DATE;
    private final DateTimeFormatter DAY_TO_LOCAL_DATE;
    private final DateTimeFormatter MONTH_DAY_TO_LOCAL_DATE;
    private final DateTimeFormatter YEAR_MONTH;
    private final DateTimeFormatter YEAR;
    private final DateTimeFormatter MONTH;
    private final DateTimeFormatter DAY;
    private final DateTimeFormatter SHORT_MONTH_HYPHEN_DAY;
    private final DateTimeFormatter OFFSET_DATE_OPTIONAL_TIME;
    private final DateTimeFormatter NON_ISO_OFFSET_DATE_OPTIONAL_TIME;

    static {
        new DateParser$();
    }

    public final Logger logger() {
        return this.logger;
    }

    public Cache<Tuple4<String, Object, Object, Object>, DateTimeFormatter> dateFormatCache() {
        return this.dateFormatCache;
    }

    public Option<Date> fromLocalDate(Option<LocalDate> toConvert) {
        Option<LocalDate> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = toConvert;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    LocalDate toConvert2 = (LocalDate)some.x();
                    none$ = new Some((Object)Date.from(toConvert2.atStartOfDay(ZoneId.of("UTC")).toInstant()));
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<LocalDate> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public Option<Date> fromLocalDateTime(Option<LocalDateTime> toConvert) {
        Option<LocalDateTime> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = toConvert;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    LocalDateTime toConvert2 = (LocalDateTime)some.x();
                    none$ = new Some((Object)Date.from(toConvert2.atZone(ZoneId.of("UTC")).toInstant()));
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<LocalDateTime> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public Option<Date> fromOffsetDateTime(Option<OffsetDateTime> toConvert) {
        Option<OffsetDateTime> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = toConvert;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    OffsetDateTime toConvert2 = (OffsetDateTime)some.x();
                    none$ = new Some((Object)Date.from(toConvert2.atZoneSameInstant(ZoneId.of("UTC")).toInstant()));
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<OffsetDateTime> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public Option<Date> fromZonedDateTime(Option<ZonedDateTime> toConvert) {
        Option<ZonedDateTime> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = toConvert;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ZonedDateTime toConvert2 = (ZonedDateTime)some.x();
                    none$ = new Some((Object)Date.from(toConvert2.withZoneSameInstant(ZoneId.of("UTC")).toInstant()));
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<ZonedDateTime> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public boolean localDateMatches(String dateValue, DateTimeFormatter inputFormat) {
        boolean bl;
        try {
            LocalDate.parse(dateValue, inputFormat);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean localDateTimeMatches(String dateValue, DateTimeFormatter inputFormat) {
        boolean bl;
        try {
            LocalDateTime.parse(dateValue, inputFormat);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean offsetDateTimeMatches(String dateValue, DateTimeFormatter inputFormat) {
        boolean bl;
        try {
            OffsetDateTime.parse(dateValue, inputFormat);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean zonedDateTimeMatches(String dateValue, DateTimeFormatter inputFormat) {
        boolean bl;
        try {
            ZonedDateTime.parse(dateValue, inputFormat);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean dateMatches(String dateValue, DateTimeFormatter inputFormat) {
        boolean bl;
        try {
            inputFormat.parse(dateValue);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public DateTimeFormatter newDateFormat(String formatPattern, boolean defaultYear, boolean defaultMonth, boolean defaultDay, boolean appendOffsetParser) {
        Tuple4 cacheKey = new Tuple4((Object)formatPattern, (Object)BoxesRunTime.boxToBoolean((boolean)defaultMonth), (Object)BoxesRunTime.boxToBoolean((boolean)defaultDay), (Object)BoxesRunTime.boxToBoolean((boolean)appendOffsetParser));
        return (DateTimeFormatter)this.dateFormatCache().get((Object)cacheKey, (Callable)new Callable<DateTimeFormatter>(formatPattern, defaultYear, defaultMonth, defaultDay, appendOffsetParser){
            private final String formatPattern$1;
            private final boolean defaultYear$1;
            private final boolean defaultMonth$1;
            private final boolean defaultDay$1;
            private final boolean appendOffsetParser$1;

            public DateTimeFormatter call() {
                DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(this.formatPattern$1);
                if (this.appendOffsetParser$1) {
                    builder = DateParser$.MODULE$.appendOffsetParsing(builder);
                }
                if (this.defaultYear$1) {
                    builder = builder.parseDefaulting(ChronoField.YEAR, 1L);
                }
                if (this.defaultMonth$1) {
                    builder = builder.parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L);
                }
                if (this.defaultDay$1) {
                    builder = builder.parseDefaulting(ChronoField.DAY_OF_MONTH, 1L);
                }
                return builder.toFormatter(Locale.US).withResolverStyle(ResolverStyle.STRICT);
            }
            {
                this.formatPattern$1 = formatPattern$1;
                this.defaultYear$1 = defaultYear$1;
                this.defaultMonth$1 = defaultMonth$1;
                this.defaultDay$1 = defaultDay$1;
                this.appendOffsetParser$1 = appendOffsetParser$1;
            }
        });
    }

    public boolean newDateFormat$default$2() {
        return false;
    }

    public boolean newDateFormat$default$3() {
        return false;
    }

    public boolean newDateFormat$default$4() {
        return false;
    }

    public boolean newDateFormat$default$5() {
        return false;
    }

    public DateTimeFormatter newTwoDigitYearDateFormat(String formatPatternStart, String formatPatternEnd, int twoDigitYearCutoff, boolean defaultMonth, boolean defaultDay, boolean appendOffsetParser) {
        Tuple4 cacheKey = new Tuple4((Object)new StringBuilder().append((Object)formatPatternStart).append((Object)"[uuuu][uu]").append((Object)formatPatternEnd).toString(), (Object)BoxesRunTime.boxToBoolean((boolean)defaultMonth), (Object)BoxesRunTime.boxToBoolean((boolean)defaultDay), (Object)BoxesRunTime.boxToBoolean((boolean)appendOffsetParser));
        return (DateTimeFormatter)this.dateFormatCache().get((Object)cacheKey, (Callable)new Callable<DateTimeFormatter>(formatPatternStart, formatPatternEnd, twoDigitYearCutoff, defaultMonth, defaultDay, appendOffsetParser){
            private final String formatPatternStart$1;
            private final String formatPatternEnd$1;
            private final int twoDigitYearCutoff$1;
            private final boolean defaultMonth$2;
            private final boolean defaultDay$2;
            private final boolean appendOffsetParser$2;

            public DateTimeFormatter call() {
                DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().parseCaseInsensitive();
                if (!this.formatPatternStart$1.isEmpty()) {
                    builder = builder.appendPattern(this.formatPatternStart$1);
                }
                builder = builder.optionalStart().appendPattern("uuuu").optionalEnd().optionalStart().appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, this.twoDigitYearCutoff$1).optionalEnd();
                if (!this.formatPatternEnd$1.isEmpty()) {
                    builder = builder.appendPattern(this.formatPatternEnd$1);
                }
                if (this.appendOffsetParser$2) {
                    builder = DateParser$.MODULE$.appendOffsetParsing(builder);
                }
                if (this.defaultMonth$2) {
                    builder = builder.parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L);
                }
                if (this.defaultDay$2) {
                    builder = builder.parseDefaulting(ChronoField.DAY_OF_MONTH, 1L);
                }
                return builder.toFormatter(Locale.US).withResolverStyle(ResolverStyle.STRICT);
            }
            {
                this.formatPatternStart$1 = formatPatternStart$1;
                this.formatPatternEnd$1 = formatPatternEnd$1;
                this.twoDigitYearCutoff$1 = twoDigitYearCutoff$1;
                this.defaultMonth$2 = defaultMonth$2;
                this.defaultDay$2 = defaultDay$2;
                this.appendOffsetParser$2 = appendOffsetParser$2;
            }
        });
    }

    public int newTwoDigitYearDateFormat$default$3() {
        return 1920;
    }

    public boolean newTwoDigitYearDateFormat$default$4() {
        return false;
    }

    public boolean newTwoDigitYearDateFormat$default$5() {
        return false;
    }

    public boolean newTwoDigitYearDateFormat$default$6() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public DateTimeFormatterBuilder appendDateParsing(DateTimeFormatterBuilder formatter, boolean optional) {
        void var3_3;
        DateTimeFormatterBuilder resultFormatter = formatter;
        if (optional) {
            resultFormatter = resultFormatter.optionalStart();
        }
        resultFormatter = resultFormatter.append(DateTimeFormatter.ISO_LOCAL_DATE);
        if (optional) {
            resultFormatter = resultFormatter.optionalEnd();
        }
        return var3_3;
    }

    public boolean appendDateParsing$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public DateTimeFormatterBuilder appendTimeParsing(DateTimeFormatterBuilder formatter, boolean optional) {
        void var3_3;
        DateTimeFormatterBuilder resultFormatter = formatter;
        if (optional) {
            resultFormatter = resultFormatter.optionalStart();
        }
        resultFormatter = resultFormatter.append(DateTimeFormatter.ISO_LOCAL_TIME);
        if (optional) {
            resultFormatter = resultFormatter.optionalEnd();
        }
        return var3_3;
    }

    public boolean appendTimeParsing$default$2() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public DateTimeFormatterBuilder appendOffsetParsing(DateTimeFormatterBuilder formatter) {
        void var2_2;
        DateTimeFormatterBuilder resultFormatter = formatter.optionalStart().appendOffset("+HH:MM", "+00:00").optionalEnd().optionalStart().appendOffset("+HHMM", "+0000").optionalEnd().optionalStart().appendOffset("+HH", "Z").optionalEnd();
        return var2_2;
    }

    public DateTimeFormatter YEAR_TO_LOCAL_DATE() {
        return this.YEAR_TO_LOCAL_DATE;
    }

    public DateTimeFormatter YEAR_MONTH_TO_LOCAL_DATE() {
        return this.YEAR_MONTH_TO_LOCAL_DATE;
    }

    public DateTimeFormatter MONTH_TO_LOCAL_DATE() {
        return this.MONTH_TO_LOCAL_DATE;
    }

    public DateTimeFormatter DAY_TO_LOCAL_DATE() {
        return this.DAY_TO_LOCAL_DATE;
    }

    public DateTimeFormatter MONTH_DAY_TO_LOCAL_DATE() {
        return this.MONTH_DAY_TO_LOCAL_DATE;
    }

    public DateTimeFormatter YEAR_MONTH() {
        return this.YEAR_MONTH;
    }

    public DateTimeFormatter YEAR() {
        return this.YEAR;
    }

    public DateTimeFormatter MONTH() {
        return this.MONTH;
    }

    public DateTimeFormatter DAY() {
        return this.DAY;
    }

    public DateTimeFormatter SHORT_MONTH_HYPHEN_DAY() {
        return this.SHORT_MONTH_HYPHEN_DAY;
    }

    public DateTimeFormatter OFFSET_DATE_OPTIONAL_TIME() {
        return this.OFFSET_DATE_OPTIONAL_TIME;
    }

    public DateTimeFormatter NON_ISO_OFFSET_DATE_OPTIONAL_TIME() {
        return this.NON_ISO_OFFSET_DATE_OPTIONAL_TIME;
    }

    public Option<EventDate> parseDate(String dateStr, Option<Object> maxYear, Option<Object> minYear) {
        Option<EventDate> option;
        block6: {
            Option<EventDate> option2;
            block5: {
                String dateStrNormalised;
                block4: {
                    Option<EventDate> secondAttempt;
                    if (dateStr == null) {
                        return None$.MODULE$;
                    }
                    String x = dateStr.trim();
                    dateStrNormalised = x.startsWith("/") || x.startsWith("-") ? x.substring(1) : x;
                    Option<EventDate> eventDateWithOption = this.parseISODate(dateStrNormalised);
                    option = eventDateWithOption;
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    EventDate eventDate = (EventDate)some.x();
                    option2 = this.isValid(eventDate) ? eventDateWithOption : (!(secondAttempt = this.parseNonISODate(dateStrNormalised)).isEmpty() && this.isValid((EventDate)secondAttempt.get()) ? secondAttempt : this.parseNonISOTruncatedYearDate(dateStrNormalised));
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option<EventDate> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block6;
                Option<EventDate> secondAttempt = this.parseNonISODate(dateStrNormalised);
                option2 = !secondAttempt.isEmpty() && this.isValid((EventDate)secondAttempt.get()) ? secondAttempt : this.parseNonISOTruncatedYearDate(dateStrNormalised);
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public Option<Object> parseDate$default$2() {
        return None$.MODULE$;
    }

    public Option<Object> parseDate$default$3() {
        return None$.MODULE$;
    }

    public Option<Date> parseStringToDate(String date) {
        Object object;
        try {
            String string = date;
            String string2 = "";
            object = !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : (this.localDateMatches(date, DateTimeFormatter.ISO_LOCAL_DATE) ? this.fromLocalDate((Option<LocalDate>)new Some((Object)LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE))) : (this.localDateTimeMatches(date, DateTimeFormatter.ISO_LOCAL_DATE_TIME) ? this.fromZonedDateTime((Option<ZonedDateTime>)new Some((Object)ZonedDateTime.parse(new StringBuilder().append((Object)date).append((Object)"Z").toString(), DateTimeFormatter.ISO_DATE_TIME))) : (this.localDateTimeMatches(date, this.NON_ISO_OFFSET_DATE_OPTIONAL_TIME()) ? this.fromZonedDateTime((Option<ZonedDateTime>)new Some((Object)ZonedDateTime.parse(new StringBuilder().append((Object)date).append((Object)"Z").toString(), this.NON_ISO_OFFSET_DATE_OPTIONAL_TIME()))) : (this.zonedDateTimeMatches(date, DateTimeFormatter.ISO_DATE_TIME) ? this.fromZonedDateTime((Option<ZonedDateTime>)new Some((Object)ZonedDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME))) : (this.offsetDateTimeMatches(date, this.OFFSET_DATE_OPTIONAL_TIME()) ? this.fromOffsetDateTime((Option<OffsetDateTime>)new Some((Object)OffsetDateTime.parse(date, this.OFFSET_DATE_OPTIONAL_TIME()))) : (this.offsetDateTimeMatches(date, this.NON_ISO_OFFSET_DATE_OPTIONAL_TIME()) ? this.fromOffsetDateTime((Option<OffsetDateTime>)new Some((Object)OffsetDateTime.parse(date, this.NON_ISO_OFFSET_DATE_OPTIONAL_TIME()))) : None$.MODULE$))))));
        }
        catch (Exception exception) {
            object = None$.MODULE$;
        }
        return object;
    }

    public Option<EventDate> parseISODate(String date) {
        Some some;
        String string = date;
        Option<EventDate> option = ISOSingleYear$.MODULE$.unapply(string);
        if (option.isEmpty()) {
            Option<EventDate> option2 = ISOMonthDate$.MODULE$.unapply(string);
            if (option2.isEmpty()) {
                Option<EventDate> option3 = ISOSingleDate$.MODULE$.unapply(string);
                if (option3.isEmpty()) {
                    Option<EventDate> option4 = ISOWithMonthNameDate$.MODULE$.unapply(string);
                    if (option4.isEmpty()) {
                        Option<EventDate> option5 = ISODateRange$.MODULE$.unapply(string);
                        if (option5.isEmpty()) {
                            Option<EventDate> option6 = ISODayDateRange$.MODULE$.unapply(string);
                            if (option6.isEmpty()) {
                                Option<EventDate> option7 = ISODayMonthRange$.MODULE$.unapply(string);
                                if (option7.isEmpty()) {
                                    Option<EventDate> option8 = ISOMonthYearDateRange$.MODULE$.unapply(string);
                                    if (option8.isEmpty()) {
                                        Option<EventDate> option9 = ISOMonthDateRange$.MODULE$.unapply(string);
                                        if (option9.isEmpty()) {
                                            Option<EventDate> option10 = ISOYearRange$.MODULE$.unapply(string);
                                            if (option10.isEmpty()) {
                                                Option<EventDate> option11 = ISODateTimeRange$.MODULE$.unapply(string);
                                                if (option11.isEmpty()) {
                                                    Option<EventDate> option12 = ISOVerboseDateTimeRange$.MODULE$.unapply(string);
                                                    if (option12.isEmpty()) {
                                                        Option<EventDate> option13 = ISOVerboseDateTime$.MODULE$.unapply(string);
                                                        if (option13.isEmpty()) {
                                                            some = None$.MODULE$;
                                                        } else {
                                                            EventDate date2 = (EventDate)option13.get();
                                                            some = new Some((Object)date2);
                                                        }
                                                    } else {
                                                        EventDate date3 = (EventDate)option12.get();
                                                        some = new Some((Object)date3);
                                                    }
                                                } else {
                                                    EventDate date4 = (EventDate)option11.get();
                                                    some = new Some((Object)date4);
                                                }
                                            } else {
                                                EventDate date5 = (EventDate)option10.get();
                                                some = new Some((Object)date5);
                                            }
                                        } else {
                                            EventDate date6 = (EventDate)option9.get();
                                            some = new Some((Object)date6);
                                        }
                                    } else {
                                        EventDate date7 = (EventDate)option8.get();
                                        some = new Some((Object)date7);
                                    }
                                } else {
                                    EventDate date8 = (EventDate)option7.get();
                                    some = new Some((Object)date8);
                                }
                            } else {
                                EventDate date9 = (EventDate)option6.get();
                                some = new Some((Object)date9);
                            }
                        } else {
                            EventDate date10 = (EventDate)option5.get();
                            some = new Some((Object)date10);
                        }
                    } else {
                        EventDate date11 = (EventDate)option4.get();
                        some = new Some((Object)date11);
                    }
                } else {
                    EventDate date12 = (EventDate)option3.get();
                    some = new Some((Object)date12);
                }
            } else {
                EventDate date13 = (EventDate)option2.get();
                some = new Some((Object)date13);
            }
        } else {
            EventDate date14 = (EventDate)option.get();
            some = new Some((Object)date14);
        }
        return some;
    }

    public Option<EventDate> parseNonISODate(String date) {
        None$ none$;
        String string = date;
        Option<EventDate> option = NonISOSingleDate$.MODULE$.unapply(string);
        if (option.isEmpty()) {
            Option<EventDate> option2 = NonISODateRange$.MODULE$.unapply(string);
            if (option2.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                EventDate date2 = (EventDate)option2.get();
                none$ = new Some((Object)date2);
            }
        } else {
            EventDate date3 = (EventDate)option.get();
            none$ = new Some((Object)date3);
        }
        return none$;
    }

    public Option<EventDate> parseNonISOTruncatedYearDate(String date) {
        None$ none$;
        String string = date;
        Option<EventDate> option = NonISOTruncatedYearDate$.MODULE$.unapply(string);
        if (option.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            EventDate date2 = (EventDate)option.get();
            none$ = new Some((Object)date2);
        }
        return none$;
    }

    public boolean isValid(EventDate eventDate) {
        boolean bl;
        try {
            int endYear;
            int startYear;
            int year;
            int year2;
            int currentYear = DateUtil$.MODULE$.getCurrentYear();
            if (eventDate.startYear() != null && (year2 = new StringOps(Predef$.MODULE$.augmentString(eventDate.startYear())).toInt()) > currentYear) {
                return false;
            }
            if (eventDate.endYear() != null && (year = new StringOps(Predef$.MODULE$.augmentString(eventDate.endYear())).toInt()) < 1600) {
                return false;
            }
            if (eventDate.startYear() != null && eventDate.endYear() != null && (startYear = new StringOps(Predef$.MODULE$.augmentString(eventDate.startYear())).toInt()) > (endYear = new StringOps(Predef$.MODULE$.augmentString(eventDate.endYear())).toInt())) {
                return false;
            }
            bl = true;
        }
        catch (Exception exception) {
            this.logger().debug(new StringBuilder().append((Object)"Exception thrown parsing date: ").append((Object)eventDate).toString(), (Throwable)exception);
            bl = false;
        }
        return bl;
    }

    public Option<LocalDate> parseByFormat(String str, DateTimeFormatter[] parsedFormats2) {
        None$ none$;
        Option matchedFormat = Predef$.MODULE$.refArrayOps((Object[])parsedFormats2).find((Function1)new Serializable(str){
            public static final long serialVersionUID = 0L;
            private final String str$1;

            public final boolean apply(DateTimeFormatter nextFormatter) {
                return DateParser$.MODULE$.dateMatches(this.str$1, nextFormatter);
            }
            {
                this.str$1 = str$1;
            }
        });
        if (matchedFormat.isDefined()) {
            LocalDate nextParsedDate = LocalDate.parse(str, (DateTimeFormatter)matchedFormat.get());
            none$ = new Some((Object)nextParsedDate);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LocalDate> parseISOOrFormats(String str, DateTimeFormatter[] parsedFormats2) {
        void var3_3;
        Option<LocalDate> eventDateParsed = this.localDateMatches(str, DateTimeFormatter.ISO_LOCAL_DATE) ? new Option<LocalDate>((Object)LocalDate.parse(str, DateTimeFormatter.ISO_LOCAL_DATE)) : (this.localDateTimeMatches(str, DateTimeFormatter.ISO_LOCAL_DATE_TIME) ? new Some((Object)LocalDateTime.parse(str, DateTimeFormatter.ISO_LOCAL_DATE_TIME).toLocalDate()) : (this.localDateMatches(str, DateTimeFormatter.ISO_DATE) ? new Some((Object)LocalDate.parse(str, DateTimeFormatter.ISO_DATE)) : (this.localDateMatches(str, DateTimeFormatter.ISO_OFFSET_DATE) ? new Some((Object)LocalDate.parse(str, DateTimeFormatter.ISO_OFFSET_DATE)) : (this.offsetDateTimeMatches(str, DateTimeFormatter.ISO_OFFSET_DATE_TIME) ? new Some((Object)OffsetDateTime.parse(str, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toLocalDate()) : (this.zonedDateTimeMatches(str, DateTimeFormatter.ISO_ZONED_DATE_TIME) ? new Some((Object)ZonedDateTime.parse(str, DateTimeFormatter.ISO_ZONED_DATE_TIME).toLocalDate()) : (this.offsetDateTimeMatches(str, this.OFFSET_DATE_OPTIONAL_TIME()) ? new Some((Object)OffsetDateTime.parse(str, this.OFFSET_DATE_OPTIONAL_TIME()).toLocalDate()) : this.parseByFormat(str, parsedFormats2)))))));
        return var3_3;
    }

    private DateParser$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"DateParser");
        this.dateFormatCache = CacheBuilder.newBuilder().maximumSize((long)Config$.MODULE$.dateFormatCacheSize()).build();
        this.YEAR_TO_LOCAL_DATE = this.newDateFormat("uuuu", false, true, true, this.newDateFormat$default$5());
        this.YEAR_MONTH_TO_LOCAL_DATE = this.newDateFormat("uuuu-MM", false, false, true, this.newDateFormat$default$5());
        this.MONTH_TO_LOCAL_DATE = this.newDateFormat("MM", true, false, true, this.newDateFormat$default$5());
        this.DAY_TO_LOCAL_DATE = this.newDateFormat("dd", true, true, false, this.newDateFormat$default$5());
        this.MONTH_DAY_TO_LOCAL_DATE = this.newDateFormat("MM-dd", true, false, false, this.newDateFormat$default$5());
        this.YEAR_MONTH = this.newDateFormat("uuuu-MM", this.newDateFormat$default$2(), this.newDateFormat$default$3(), this.newDateFormat$default$4(), this.newDateFormat$default$5());
        this.YEAR = this.newDateFormat("uuuu", this.newDateFormat$default$2(), this.newDateFormat$default$3(), this.newDateFormat$default$4(), this.newDateFormat$default$5());
        this.MONTH = this.newDateFormat("MM", this.newDateFormat$default$2(), this.newDateFormat$default$3(), this.newDateFormat$default$4(), this.newDateFormat$default$5());
        this.DAY = this.newDateFormat("dd", this.newDateFormat$default$2(), this.newDateFormat$default$3(), this.newDateFormat$default$4(), this.newDateFormat$default$5());
        this.SHORT_MONTH_HYPHEN_DAY = this.newDateFormat("M-d", true, false, false, this.newDateFormat$default$5());
        DateTimeFormatterBuilder result = new DateTimeFormatterBuilder().parseCaseInsensitive();
        result = this.appendDateParsing(result, false);
        result = result.optionalStart().appendLiteral('T').optionalEnd();
        result = this.appendTimeParsing(result, true);
        result = this.appendOffsetParsing(result);
        this.OFFSET_DATE_OPTIONAL_TIME = result.toFormatter(Locale.US).withResolverStyle(ResolverStyle.STRICT);
        DateTimeFormatterBuilder result2 = new DateTimeFormatterBuilder().parseCaseInsensitive();
        result2 = this.appendDateParsing(result2, false);
        result2 = result2.optionalStart().appendLiteral(' ').optionalEnd();
        result2 = this.appendTimeParsing(result2, true);
        result2 = this.appendOffsetParsing(result2);
        this.NON_ISO_OFFSET_DATE_OPTIONAL_TIME = result2.toFormatter(Locale.US).withResolverStyle(ResolverStyle.STRICT);
    }
}

