/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.load.BVPLoader;
import au.org.ala.biocache.load.BVPLoader$;
import au.org.ala.biocache.load.IngestTool$;
import au.org.ala.biocache.util.OptionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class BVPLoader$
implements Tool {
    public static final BVPLoader$ MODULE$;
    private final Logger logger;
    private final Function2<Object, Object, String> au$org$ala$biocache$load$BVPLoader$$DEFAULT_CITATION;
    private final String DEFAULT_LICENSE_TYPE;
    private final String DEFAULT_LICENSE_VERSION;

    static {
        new BVPLoader$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public Function2<Object, Object, String> au$org$ala$biocache$load$BVPLoader$$DEFAULT_CITATION() {
        return this.au$org$ala$biocache$load$BVPLoader$$DEFAULT_CITATION;
    }

    public String DEFAULT_LICENSE_TYPE() {
        return this.DEFAULT_LICENSE_TYPE;
    }

    public String DEFAULT_LICENSE_VERSION() {
        return this.DEFAULT_LICENSE_VERSION;
    }

    @Override
    public String cmd() {
        return "volunteer-ingest";
    }

    @Override
    public String desc() {
        return "Harvests data from the volunteer portal";
    }

    @Override
    public void main(String[] args) {
        BooleanRef ingestResources = new BooleanRef(false);
        BooleanRef syncOnly = new BooleanRef(false);
        BooleanRef debugOnly = new BooleanRef(false);
        BooleanRef skipLoading = new BooleanRef(false);
        BooleanRef skipSampling = new BooleanRef(false);
        BooleanRef skipProcessing = new BooleanRef(false);
        BooleanRef skipIndexing = new BooleanRef(false);
        BooleanRef dryRun = new BooleanRef(false);
        ObjectRef startAt = new ObjectRef((Object)"");
        IntRef threads = new IntRef(4);
        OptionParser parser = new OptionParser(ingestResources, syncOnly, debugOnly, skipLoading, skipSampling, skipProcessing, skipIndexing, dryRun, startAt, threads){
            {
                this.opt("debug", "Display the list of expeditions. For debug purposes.", (Function0<BoxedUnit>)new Serializable(this, debugOnly$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef debugOnly$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.debugOnly$1.elem = true;
                    }
                    {
                        this.debugOnly$1 = debugOnly$1;
                    }
                });
                this.opt("sync-only", "synchronise the list of data resources. Dont ingest.", (Function0<BoxedUnit>)new Serializable(this, syncOnly$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef syncOnly$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.syncOnly$1.elem = true;
                    }
                    {
                        this.syncOnly$1 = syncOnly$1;
                    }
                });
                this.opt("skip-loading", "Ingest but don't load.", (Function0<BoxedUnit>)new Serializable(this, skipLoading$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipLoading$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipLoading$1.elem = true;
                    }
                    {
                        this.skipLoading$1 = skipLoading$1;
                    }
                });
                this.opt("skip-sampling", "Ingest but don't sample.", (Function0<BoxedUnit>)new Serializable(this, skipSampling$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipSampling$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipSampling$1.elem = true;
                    }
                    {
                        this.skipSampling$1 = skipSampling$1;
                    }
                });
                this.opt("skip-processing", "Ingest but don't process.", (Function0<BoxedUnit>)new Serializable(this, skipProcessing$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipProcessing$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipProcessing$1.elem = true;
                    }
                    {
                        this.skipProcessing$1 = skipProcessing$1;
                    }
                });
                this.opt("skip-indexing", "Ingest but don't indexing.", (Function0<BoxedUnit>)new Serializable(this, skipIndexing$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipIndexing$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipIndexing$1.elem = true;
                    }
                    {
                        this.skipIndexing$1 = skipIndexing$1;
                    }
                });
                this.opt("i", "ingest", "flag to indicate all resources should be loaded", (Function0<BoxedUnit>)new Serializable(this, ingestResources$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef ingestResources$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.ingestResources$1.elem = true;
                    }
                    {
                        this.ingestResources$1 = ingestResources$1;
                    }
                });
                this.opt("sa", "start-at-uid", "Start ingesting resources at the supplied UID", (Function1<String, BoxedUnit>)new Serializable(this, startAt$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef startAt$1;

                    public final void apply(String v) {
                        this.startAt$1.elem = v;
                    }
                    {
                        this.startAt$1 = startAt$1;
                    }
                });
                this.intOpt("t", "threads", "Number of threads to index from", (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
                this.opt("dr", "dry-run", "Dry run", (Function0<BoxedUnit>)new Serializable(this, dryRun$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef dryRun$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.dryRun$1.elem = true;
                    }
                    {
                        this.dryRun$1 = dryRun$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            BVPLoader b = new BVPLoader();
            if (debugOnly.elem) {
                b.displayList();
            } else {
                Seq drsToIngest;
                Seq seq;
                Seq drsList = b.retrieveList(dryRun.elem);
                this.logger().info(new StringBuilder().append((Object)"Number of resources to harvest: ").append((Object)BoxesRunTime.boxToInteger((int)drsList.size())).toString());
                if (this.logger().isDebugEnabled()) {
                    drsList.foreach((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(String dr) {
                            BVPLoader$.MODULE$.logger().debug(new StringBuilder().append((Object)"Will harvest: ").append((Object)dr).toString());
                        }
                    });
                }
                String string = (String)startAt.elem;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    seq = drsList;
                } else {
                    int idx = drsList.indexOf((Object)((String)startAt.elem));
                    seq = drsToIngest = idx > 0 ? (Seq)drsList.drop(idx) : drsList;
                }
                if (ingestResources.elem && !syncOnly.elem && !dryRun.elem) {
                    drsToIngest.foreach((Function1)new Serializable(skipLoading, skipSampling, skipProcessing, skipIndexing, threads){
                        public static final long serialVersionUID = 0L;
                        private final BooleanRef skipLoading$1;
                        private final BooleanRef skipSampling$1;
                        private final BooleanRef skipProcessing$1;
                        private final BooleanRef skipIndexing$1;
                        private final IntRef threads$1;

                        public final void apply(String drUid) {
                            try {
                                String x$3 = drUid;
                                int x$4 = this.threads$1.elem;
                                boolean x$5 = this.skipLoading$1.elem;
                                boolean x$6 = this.skipSampling$1.elem;
                                boolean x$7 = this.skipProcessing$1.elem;
                                boolean x$8 = this.skipIndexing$1.elem;
                                IngestTool$.MODULE$.ingestResource(x$3, x$4, x$8, x$5, x$7, x$6);
                            }
                            catch (Exception exception) {
                                BVPLoader$.MODULE$.logger().error(exception.getMessage(), (Throwable)exception);
                            }
                        }
                        {
                            this.skipLoading$1 = skipLoading$1;
                            this.skipSampling$1 = skipSampling$1;
                            this.skipProcessing$1 = skipProcessing$1;
                            this.skipIndexing$1 = skipIndexing$1;
                            this.threads$1 = threads$1;
                        }
                    });
                }
            }
        }
    }

    private BVPLoader$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"BVPLoader");
        this.au$org$ala$biocache$load$BVPLoader$$DEFAULT_CITATION = new anonfun.10();
        this.DEFAULT_LICENSE_TYPE = "Creative Commons Attribution Australia";
        this.DEFAULT_LICENSE_VERSION = "3.0";
    }
}

